=begin
/****************************************************************************
** $Id: dclock_lib.rb,v 1.1.1.2 2000/11/14 17:04:55 horie Exp $
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end

class DigitalClock < QLCDNumber
#//
#// Constructs a DigitalClock widget with a parent and a name.
#//
@showingColon
@normalTimer
@showDateTimer

def initialize( parent = nil, name = "" )
    super( parent, name )

    @showingColon = false
    setFrameStyle( QFrame::Panel | QFrame::Raised )
    setLineWidth( 2 )				#// set frame line width
    showTime()					#// display the current time
    @normalTimer = startTimer( 500 )		#// 1/2 second timer events
    @showDateTimer = -1				#// not showing date
    catchEvent
end


#//
#// Handles timer events for the digital clock widget.
#// There are two different timers one timer for updating the clock
#// and another one for switching back from date mode to time mode.
#//

def timerEvent( e )
    if ( e.timerId() == @showDateTimer )	#// stop showing date
	stopDate()
    else 					#// normal timer
	if ( @showDateTimer == -1 )		#// not showing date
	    showTime()
             end
    end
end

#//
#// Enters date mode when the left mouse button is pressed.
#//

def mousePressEvent( e )
    QApplication::qApp.processEvents()
    if ( e.button() == Qt::LeftButton )		#// left button pressed
	showDate()
    end
end


#//
#// Shows the current date in the internal lcd widget.
#// Fires a timer to stop showing the date.
#//

def showDate()

    if ( @showDateTimer != -1 )			#// already showing date
	return
    end
    date = QDate::currentDate()
#    QString s
#    s.sprintf( "%2d %2d", date.month(), date.day() )
    s = "#{date.month()} #{date.day()}"
    displayQString( s )				#// sets the LCD number/text
    showDateTimer = startTimer( 4000 )		#// keep self state for 2 secs
end

#//
#// Stops showing the date.
#//

def stopDate()

    killTimer( showDateTimer )
    showDateTimer = -1
    showTime()
end

#//
#// Shows the current time in the internal lcd widget.
#//

def showTime()

    @showingColon = !@showingColon		#// toggle/blink colon
    s = QTime::currentTime().toString().left(8).to_str
    if ( !@showingColon )
	s[2] = ' '
             #s[5] = ' '
    end
    if ( s[0] == '0' )
	s[0] = ' '
    end
    display( s )				#// set LCD number/text
end
end
