=begin
/****************************************************************************
** $Id: dclock_sub.rb,v 1.1.1.1 2000/09/19 07:56:09 horie Exp $
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#//
#// Constructs a DigitalClock widget with a parent and a name.
#//

class DigitalClock <  QLCDNumber
def initialize d,parent=nil,name=""
    super
    @showingColon = false
    setFrameStyle( QFrame::Panel | QFrame::Raised )
    setLineWidth( 2 )				#// set frame line width
    setNumDigits(8)
    showTime					#// display the current time
    @normalTimer = startTimer( 500 );		#// 1/2 second timer events
    @showDateTimer = -1;
    @quit = RSignal.new("")
    catchEvent				#// not showing date
end

def quit_signal
  @quit
end

#//
#// Handles timer events for the digital clock widget.
#// There are two different timers; one timer for updating the clock
#// and another one for switching back from date mode to time mode.
#//

def timerEvent e

    if ( e.timerId == @showDateTimer )	#// stop showing date
	stopDate
    else
       if ( @showDateTimer == -1 )     #// normal timer
	showTime
       end
    end
end

#//
#// Enters date mode when the left mouse button is pressed.
#//

def mousePressEvent e

    if ( e.button == LeftButton )		#// left button pressed
	showDate
    end
    if ( e.button == RightButton)
        @quit.send
    end
end

#//
#// Shows the current date in the internal lcd widget.
#// Fires a timer to stop showing the date.
#//

def showDate

    if ( @showDateTimer != -1 )			#// already showing date
	return
    end
    d = QDate::currentDate();
    displayText( d.year.to_s + d.month.to_s.rjust(2) + d.day.to_s.rjust(2))				#// sets the LCD number/text
    @showDateTimer = startTimer( 2000 );		#// keep this state for 2 secs
end

#//
#// Stops showing the date.
#//

def stopDate

    killTimer( @showDateTimer );
    @showDateTimer = -1;
    showTime
end

#//
#// Shows the current time in the internal lcd widget.
#//

def showTime

    @showingColon = !@showingColon;		#// toggle/blink colon
#//    QString s = QTime::currentTime().toString().left(5);
    s = QTime::currentTime
    if (@showingColon )
       col = ":"
    else
       col = " "
    end
    str = s.hour.to_s.rjust(2) + ":" + s.minute.to_s.rjust(2) + col + s.second.to_s.rjust(2)
    display( str );				#// set LCD number/text
end
end
