=begin
/****************************************************************************
** $Id: aclock_lib.rb,v 1.2 2001/01/23 01:12:07 horie Exp $
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#//
#// Constructs an analog clock widget that uses an internal QTimer.
#//

class AnalogClock < QWidget
def initialize (parent=nil, name = "")
    super( parent, name )

    @time = QTime::currentTime()		#// get current time
    @internalTimer = QTimer.new( self )	#// create internal timer
    Qt2::connect( @internalTimer, QSIGNAL("timeout()"), self, "timeout" )
    @internalTimer.start( 500 )		#// emit signal every 5 seconds
    @paint = QPainter.new
    catchEvent
end


#//
#// The QTimer::timeout() signal is received by self slot.
#//

def timeout()
    new_time = QTime::currentTime()	#// get the current time
    if ( new_time.second() != @time.second() )	#// minute has changed
        if(autoMask())
             updateMask()
        else
             repaintAll
        end
    end
end


def paintEvent( e )
    if ( autoMask() )
	return
    end
#    paint = QPainter.new(self)
    @paint.begin(self)
    @paint.setBrushQColor( colorGroup().foreground() )
    drawClock( @paint )
    @paint.end
end

#// If the clock is transparent, we use updateMask()
#// instead of paintEvent()

def updateMask()	#// paint clock mask
    bm = QBitmap.new( size() )
    bm.fill( Qt::color0 )			#//transparent

#    paint = QPainter.new
    @paint.begin( bm, self )
    @paint.setBrush( Qt::color1 )		#// use non-transparent color
    @paint.setPen( Qt::color1 )

    drawClock( @paint )

    @paint.end()
    setMask( bm )

end

#//
#// The clock is painted using a 1000x1000 square coordinate system, in
#// the a centered square, as big as possible.  The painter's pen and
#// brush colors are used.
#//
def drawClock( paint )

    paint.save()
    
    paint.setWindow( -500,-500, 1000,1000 )

    v = paint.viewport()
    d = QMIN( v.width(), v.height() )
    paint.setViewport( v.left() + (v.width()-d)/2,
			v.top() + (v.height()-d)/2, d, d )

    @time = QTime::currentTime()
    pts = QPointArray.new

    paint.save()
    paint.rotate( 30*(@time.hour()%12-3) + @time.minute()/2 )
#    pts.setPoints( 4, -20,0,  0,-20, 300,0, 0,20 )
    pts.resize(4)
    pts.setPoint(0,-20,0)
    pts.setPoint(1,0,-20)
    pts.setPoint(2,300,0)
    pts.setPoint(3,0,20)
    paint.drawPolygon( pts )
    paint.restore()

    paint.save()
    paint.rotate( (@time.minute()-15)*6 )
#    pts.setPoints( 4, -10,0, 0,-10, 400,0, 0,10 )
    pts.resize(4)
    pts.setPoint(0,-10,0)
    pts.setPoint(1,0,-10)
    pts.setPoint(2,400,0)
    pts.setPoint(3,0,10)

    paint.drawPolygon( pts )
    paint.restore()

   paint.save()
   paint.rotate((@time.second() -15)*6 )
   #paint.setPenQColor(Qt::color1)
   paint.drawLine(0,0,400,0)
   paint.restore()
#print "#{@time.second()}\n"

    for i in 0..11 #( int i=0 i<12 i++ )
	paint.drawLine( 440,0, 460,0 )
	paint.rotate( 30 )
    end

    paint.restore()
end


def setAutoMask( b)

    if (b)
	setBackgroundMode( PaletteForeground )
    else
	setBackgroundMode( PaletteBackground )
    end
    super(b)
end

end
