=begin
/****************************************************************************
** $Id: widgets.rb,v 1.3 2001/01/23 01:12:08 horie Exp $
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
require "qt2"
include Qt2
require "aclock_lib.rb"
require "dclock_lib.rb"

#include <qpixmap.h>
#include <qlayout.h>
#include <QApplication::qApplication.h>
#include <qkeycode.h>

#// Standard Qt widgets

#include <qtoolbar.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlcdnumber.h>
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qtooltip.h>
#include <qspinbox.h>
#include <qstatusbar.h>
#include <qwhatsself.h>
#include <qtoolbutton.h>
#include <qvbox.h>
#include <qtabbar.h>
#include <qtabwidget.h>
#include <qwidgetstack.h>
#include <qprogressbar.h>
#include <qsplitter.h>
#include <qlistview.h>
#include <qheader.h>
#include <qtextview.h>
#include <qfiledialog.h>
#include <qaccel.h>
#include <qmetaobject.h>

#include "widgets.h"


#// Some sample widgets

#include "../aclock/aclock.h"
#include "../dclock/dclock.h"


MOVIEFILENAME = "trolltech.gif"

#include "../application/fileopen.xpm"
#include "../application/filesave.xpm"
#include "../application/fileprint.xpm"
class MyListView  < QListView
   attr_reader :mySelectionChanged, :selectionChanged, :clicked
   def initialize ( parent = 0, name = "" )
      super(parent, name)
      @mySelectionChanged = RSignal.new("Object")
      @selectionChanged = RSignal.new("Object")
      @clicked = RSignal.new("Object")
      @selector = 0
      connect(self,QSIGNAL("selectionChanged()"),"slot_selectionChanged")
      connect(self,QSIGNAL("clicked(QListViewItem*)"),"slot_clicked")
      #catchEvent  <- if you want to trap event for MyListView, install eventfilter to QApplication!
      @eventfilter = QR2EventFilter.new(self)
      QApplication::qApp.installEventFilter(@eventfilter)
   end
   def contentsMousePressEvent(  e )
	@selected = selectedItem();
	#QListView::contentsMousePressEvent( e );
   end
   def contentsMouseReleaseEvent(  e )
	#QListView::contentsMouseReleaseEvent( e );
     if(selectedItem() and @selected)	
        if ( selectedItem().itemPos() != @selected.itemPos() )
	    @mySelectionChanged.sendWith( selectedItem().itemPos() )
	    #@mySelectionChanged.send
        end
     end
   end
   def slot_selectionChanged
      item = selectedItem()
      @selectionChanged.sendWith(item.itemPos())
   end
   def slot_clicked item
      #item = selectedItem()    
      @clicked.sendWith(item.itemPos()) unless item.nil?
   end
end

class MyWhatsThis < QRWhatsThis

def initialize(lb)
  super
end
def setQWidget(lb)
   @listbox = lb
end
def text(  p)
	i = @listbox.itemAt( p )
	if (  !(i.pixmap().nil?) )
	   return "Isn't that a <em>wonderful</em> pixmap? <br>" +
		"Imagine, you could even decorate a" +
		" <b>red</b> pushbutton with it! :-)"
	else
             return "This is QListBox";
             end
end

end


class MyMenuItem < QRCustomMenuItem

    def initialize
      super
   #    @string = s
   #   @font = f
   #catchEvent
   end
   def setStringFont(s,f)
      @string = s
      @font = f
      self
   end

    def  paint( p, cg, act, enabled, x, y, w, h )
    
	p.setFont ( @font )
	p.drawText( x, y, w, h, AlignLeft | AlignVCenter | ShowPrefix | DontClip, @string )
    end

    def sizeHint()
    
	return QFontMetrics.new( @font ).size( AlignLeft | AlignVCenter | ShowPrefix | DontClip,  @string )
    end
end

#//
#// Construct the WidgetView with children
#//


class WidgetView < QMainWindow

def initialize (parent = nil, name = "")
  super
 fileopen = QPixmap.new( "fileopen.xpm")
 filesave = QPixmap.new("filesave.xpm")
 fileprint = QPixmap.new("fileprint.xpm")
    #QColor col

    #// Set the window caption/title
    setCaption( "Qt Widgets Demo Application" )

    #// create a toolbar
    @tools = QToolBar.new( self, "toolbar" )
    @nullString = QString::null

    #// put something in it
    openIcon = QPixmap.new( fileopen )
    toolb = QToolButton.new( openIcon, "toolbutton 1",
					   @nullString, self, "open",
					   @tools, "open file" )
    QWhatsThis::add( toolb, ("This is a <b>QToolButton</b>. It lives in a QToolBar. "  +
                                  "This particular button doesn't do anything useful.") )
    @saveIcon = QPixmap.new( filesave )
    @toolb1 = QToolButton.new( @saveIcon, "toolbutton 2", @nullString,
			     self, "dummy",
			     @tools, "save file" )
    QWhatsThis::add( @toolb1, "This is also a <b>QToolButton</b>." )

    printIcon = QPixmap.new( fileprint )
    toolb = QToolButton.new( printIcon, "toolbutton 3", @nullString,
			     self, "dummy",
			     @tools, "print file" )
    QWhatsThis::add( toolb, "This is the third <b>QToolButton</b>.")

    toolb = QWhatsThis::whatsThisButton( @tools )
    QWhatsThis::add( toolb, ("This is a <b>What's This</b> button " +
		     "It enables the user to ask for help " +
		     "about widgets on the screen.") )


    #// Install an application-global event filter
    #qApp.installEventFilter( self )

    #//make a central widget to contain the other widgets
    @central = QWidget.new( self )
    setCentralWidget( @central )

    #// Create a layout to position the widgets
    topLayout = QHBoxLayout.new( @central, 10 )

    #// Create a grid layout to hold most of the widgets
    grid = QGridLayout.new( nil, 3 ) #//3 wide and autodetect number of rows
    topLayout.addLayout( grid, 1 )

    #// Create an easter egg
    QToolTip::add( menuBar(), QRect.new( 0, 0, 2, 2 ), "easter egg" )

    popup = QPopupMenu.new( self )
    menuBar().insertItem( "&File", popup )
    id = popup.insertItem( "&New" )
    popup.setItemEnabled( id, FALSE )
    id = popup.insertItem( openIcon, "&Open", self, "open" )

    popup.insertSeparator()
    popup.insertItem( "&Quit", QApplication::qApp, "quit", CTRL+Key_Q )


    @textStylePopup = popup = QPopupMenu.new( self )
    menuBar().insertItem( "&Edit", @textStylePopup )

    @plainStyleID = id = popup.insertItem( "&Plain" )
    popup.setAccel( CTRL+Key_T, @plainStyleID )

    popup.insertSeparator()
    f = font()
    f.setBold( true )
    @mi1 = MyMenuItem.new
    @mi1.setStringFont("&Bold",f)
    id = popup.insertItem( @mi1 ,-1)
    popup.setAccel( CTRL+Key_B, id )
    f = font()
    f.setItalic( TRUE )
    id = popup.insertItem( @mi2 = MyMenuItem.new().setStringFont( "&Italic", f ) )
    popup.setItemChecked( id, TRUE )
    popup.setAccel( CTRL+Key_I, id )
    f = font()
    f.setUnderline( TRUE )
    id = popup.insertItem( @mi3 = MyMenuItem.new.setStringFont( "&Underline", f ) )
    popup.setAccel( CTRL+Key_U, id )
    f = font()
    f.setStrikeOut( TRUE )
    id = popup.insertItem( @mi4 = MyMenuItem.new.setStringFont( "&Strike", f ) )
    Qt2::connect( @textStylePopup, QSIGNAL("activated(int)"),
    	     self, "popupSelected" )

    #// Create an analog and a digital clock
    @aclock = AnalogClock.new( @central )
    @aclock.setAutoMask( true )
    @dclock = DigitalClock.new( 8,@central )
    @dclock.setMaximumWidth(200)
    grid.addWidget( @aclock, 0, 2 )
    grid.addWidget( @dclock, 1, 2 )

    #// Give the dclock widget a blue palette
    col = QColor.new(  0xaa, 0xbe, 0xff ,  QColor::Rgb)
    #col.setRgb( 0xaa, 0xbe, 0xff )
    @dclock.setPalette( QPalette.new( col ) )

    #// make tool tips for both of them
    QToolTip::add( @aclock, "custom widget: analog clock" )
    QToolTip::add( @dclock, "custom widget: digital clock" )

    #// Create a push button.
    pb = QPushButton.new( "&Push button 1", @central, "button1" )  #// create button 1
    grid.addWidget( pb, 0, 0, AlignVCenter )
    Qt2::connect( pb, QSIGNAL("clicked()"), self, "button1Clicked" )
    QToolTip::add( pb, "push button 1" )
    QWhatsThis::add( pb, ("This is a <b>QPushButton</b>.<br>" +
		     "Click it and watch...<br>" +
		     "The wonders of modern technology."))

    pm = QPixmap.new(nil)
    pix = pm.load("qt.bmp")		#// load pixmap for button 2
    if ( !pix )
	QMessageBox::information( 0, "Qt Widgets Example",
				  ("Could not load the file \"qt.bmp\", which\n"  +
				  "contains an icon used...\n\n" +
				  "The text \"line 42\" will be substituted."),
				  QMessageBox::Ok + QMessageBox::Default )
    end

    #// Create a label containing a QMovie
    @movie = QRMovie.new( MOVIEFILENAME )
    @movielabel = QLabel.new( "",@central, "label0" )
    @movie.connectStatus(self, "movieStatus")
    @movie.connectUpdate(self, "movieUpdate")
    @movielabel.setFrameStyle( QFrame::Box | QFrame::Plain )
    @movielabel.setMovie( @movie )
    @movielabel.setFixedSize( 128+@movielabel.frameWidth()*2,
			      64+@movielabel.frameWidth()*2 )
    grid.addWidget( @movielabel, 0, 1, AlignCenter )
    QToolTip::add( @movielabel, "movie" )
    QWhatsThis::add( @movielabel, "This is a <b>QLabel</b>  that contains a QMovie." )

    #// Create a group of check boxes
#    @bg = QButtonGroup.new( 1,RVertical, "", @central, "checkGroup" )
    @bg = QButtonGroup.new( @central, "checkGroup" )
    @bg.setTitle( "Check Boxes" )
    grid.addWidget( @bg, 1, 0 )

    #// Create a layout for the check boxes
    vbox = QVBoxLayout.new(@bg,10)

    vbox.addSpacing( @bg.fontMetrics().height() )
    @cb = []
    @cb[0] = QCheckBox.new("", @bg )
    @cb[0].setText( "&Read" )
    vbox.addWidget( @cb[0] )
    @cb[1] = QCheckBox.new("", @bg )
    @cb[1].setText( "&Write" )
    vbox.addWidget( @cb[1] )
    @cb[2] = QCheckBox.new("", @bg )
    @cb[2].setText( "&Execute" )
    vbox.addWidget( @cb[2] )

    Qt2::connect( @bg, QSIGNAL("clicked(int)"), self, "checkBoxClicked")

    QToolTip::add( @cb[0], "check box 1" )
    QToolTip::add( @cb[1], "check box 2" )
    QToolTip::add( @cb[2], "check box 3" )

    #// Create a group of radio buttons
    #QRadioButton *rb
#    @bg = QButtonGroup.new(1,RVertical,"", @central, "radioGroup" )
    @bg = QButtonGroup.new(@central,"radioBroup")

    @bg.setTitle( "Radio buttons" )

    grid.addWidget( @bg, 1, 1 )

    #// Create a layout for the radio buttons
    vbox = QVBoxLayout.new(@bg,10)

    vbox.addSpacing( @bg.fontMetrics().height() )
    rb = QRadioButton.new("", @bg )
    rb.setText( "&AM" )
    rb.setChecked( true )
    vbox.addWidget(rb)
    QToolTip::add( rb, "radio button 1" )
    rb = QRadioButton.new("", @bg )
    rb.setText( "F&M" )
    vbox.addWidget(rb)
    QToolTip::add( rb, "radio button 2" )
    rb = QRadioButton.new("", @bg )
    rb.setText( "&Short Wave" )
    vbox.addWidget(rb)

    Qt2::connect( @bg, QSIGNAL("clicked(int)"),self, "radioButtonClicked" )
    QToolTip::add( rb, "radio button 3" )

    #// Create a list box
    @lb = QListBox.new( @central, "listBox" )
    for i in 0..100 #( int i=0 i<100 i++ ) 		// fill list box
	#str = QString.new
	#str.sprintf( "line %d", i )
        str = "line #{i}"
	if ( i == 42 && pix )
	    @lb.insertItem( pm )
	else
	    @lb.insertItem( str )
             end
    end
    grid.addMultiCellWidget( @lb, 2, 4, 0, 0 )
    Qt2::connect( @lb, QSIGNAL("selected(int)"), self, "listBoxItemSelected" )
    QToolTip::add( @lb, "list box" )
    @myw = MyWhatsThis.new(@lb)
    @myw.setQWidget( @lb )

    vbox = QVBoxLayout.new(8)
    grid.addLayout( vbox, 2, 1 )

    #// Create a slider
    sb = QSlider.new( 0, 300, 30, 100, QSlider::Horizontal,
			       @central, "Slider" )
    sb.setTickmarks( QSlider::Below )
    sb.setTickInterval( 10 )
    sb.setFocusPolicy( QWidget::TabFocus )
    vbox.addWidget( sb )

    Qt2::connect( sb, QSIGNAL("valueChanged(int)"), self, "sliderValueChanged")
    QToolTip::add( sb, "slider" )
    QWhatsThis::add( sb, ("This is a <b>QSlider</b>. "  +
		     "The tick marks are optional." +
		     " This slider controls the speed of the movie.") )

    #// Create a combo box
    combo = QComboBox.new( false, @central, "comboBox" )
    combo.insertItem( "darkBlue" )
    combo.insertItem( "darkRed" )
    combo.insertItem( "darkGreen" )
    combo.insertItem( "blue" )
    combo.insertItem( "red" )
    vbox.addWidget( combo )
    Qt2::connect( combo, QSIGNAL("activated(int)"), self, "comboBoxItemActivated")
    QToolTip::add( combo, "read-only combo box" )

    #// Create an editable combo box
    edCombo = QComboBox.new( true, @central, "edComboBox" )
    edCombo.insertItem( "Permutable" )
    edCombo.insertItem( "Malleable" )
    edCombo.insertItem( "Adaptable" )
    edCombo.insertItem( "Alterable" )
    edCombo.insertItem( "Inconstant" )
    vbox.addWidget( edCombo )
    Qt2::connect( edCombo, QSIGNAL("activated(const QString&)"),
	     self, "edComboBoxItemActivated" )
    QToolTip::add( edCombo, "editable combo box" )

    edCombo.setAutoCompletion( true )

    vbox = QVBoxLayout.new(8)
    grid.addLayout( vbox, 2, 2 )


    #// Create a spin box
    spin = QSpinBox.new( 0, 10, 1, @central, "spin" )
    spin.setSuffix(" mm")
    spin.setSpecialValueText( "Auto" )
    Qt2::connect( spin, QSIGNAL( "valueChanged(const QString&)" ),
	     self, "spinBoxValueChanged" )
    QToolTip::add( spin, "spin box" )
    QWhatsThis::add( spin, ("This is a <b>QSpinBox</b>. " +
		     "You can chose values in a given range " +
		     "either by using the arrow buttons " +
		     "or by typing them in." ))
    vbox.addWidget( spin )

    vbox.addStretch( 1 )

    #// Create a tabwidget that switches between multi line edits
    @tabs = QTabWidget.new( @central )
    #//@tabs.setTabPosition( QTabWidget::Bottom )
    @tabs.setMargin( 4 )
    grid.addMultiCellWidget( @tabs, 3, 3, 1, 2 )
    mle = QMultiLineEdit.new( @tabs, "multiLineEdit" )
    @edit = mle
    mle.setWordWrap( QMultiLineEdit::WidgetWidth )
    mle.setText(("This is a QMultiLineEdit widget, " +
	         "useful for small multi-line "  +
		 "input fields."))
    QToolTip::add( mle, "multi line editor" )

    @tabs.addTab( mle, "F&irst")

    mle = QMultiLineEdit.new( @tabs, "multiLineEdit" )
    mleText = "This is another QMultiLineEdit widget."
#if 1
    mleText = QString.new("\n")
    mleText.append( QString.new( "Japanese: "))
    mleText.append(QString.new(QChar.new(0x6a38))) #// Kanji
    mleText.append(QString.new("\n"))
    mleText.append(QString.new("Russian:"))
    mleText.append(QString.new(QChar.new(0x042e))) #// Cyrillic
    mleText.append(QString.new("\n"))
    mleText.append(QString.new("Norwegian:"))
    mleText.append(QString.new(QChar.new(0x00d8))) #// Norwegian
    mleText.append(QString.new("\n"))
    mleText.append(QString.new("Unicode (black square):"))
    mleText.append(QString.new(QChar.new(0x25A0))) #// BLACK SQUARE
    mleText.append(QString.new("\n"))
#endif
    mle.setText( mleText )
    QToolTip::add( mle, "second multi line editor" )
    @tabs.addTab( mle, "Se&cond")


    #// Create a single line edit
    le = QLineEdit.new( "",@central, "lineEdit" )


    grid.addMultiCellWidget( le, 4, 4, 1, 2 )
    Qt2::connect( le, QSIGNAL("textChanged(const QString&)"),
	     self,"lineEditTextChanged")
    QToolTip::add( le, "single line editor" )
    QWhatsThis::add( le, ("This is a <b>QLineEdit</b>, you can enter a single line of text in it. " +
		      "It also it accepts text drops." ))

    grid.setRowStretch(0,0)
    grid.setRowStretch(1,0)
    grid.setRowStretch(2,0)
    grid.setRowStretch(3,1)
    grid.setRowStretch(4,0)

    grid.setColStretch(0,1)
    grid.setColStretch(1,1)
    grid.setColStretch(2,1)


    split = QSplitter.new( Vertical, @central, "splitter" )
    split.setOpaqueResize( true )
    topLayout.addWidget( split, 1 )
    @lv = MyListView.new( split )
    
    Qt2::connect(@lv, QSIGNAL("selectionChanged()" ), self, "selectionChanged" )
    Qt2::connect(@lv.selectionChanged, self, "selectionChanged" )
    Qt2::connect(@lv.clicked, self,  "clicked" )
    Qt2::connect(@lv.mySelectionChanged, self, "mySelectionChanged")
    @lv.addColumn( "One" )
    @lv.addColumn( "Two" )
    @lv.setAllColumnsShowFocus( TRUE )

    lvi=  QListViewItem.new(@lv, "Text", "Text" )
    lvi=  QListViewItem.new( @lv, "Text", "Other Text" )
    lvi=  QListViewItem.new( @lv, "Text", "More Text" )
    lvi=  QListViewItem.new( @lv, "Text", "Extra Text" )
    lvi.setOpen(true)
    QListViewItem.new( lvi, "SubText", "Additional Text" )
    lvi=  QListViewItem.new( lvi, "SubText", "Side Text" )
    lvi=  QListViewItem.new( lvi, "SubSubText", "Complimentary Text" )

    QToolTip::add( @lv, "list view" )
    QWhatsThis::add( @lv, "This is a <b>QListView</b>, you can display hierarchical structures of multiple-column data in it." )

    @lv1 = QListView.new( split )
    @lv1.addColumn( "Choices" )
    QCheckListItem.new( @lv1, "Onion", QCheckListItem::CheckBox )
    QCheckListItem.new( @lv1, "Artichoke", QCheckListItem::CheckBox )
    QCheckListItem.new( @lv1, "Pepper", QCheckListItem::CheckBox )
    QCheckListItem.new( @lv1, "Habaneros", QCheckListItem::CheckBox )
    QCheckListItem.new( @lv1, "Pineapple", QCheckListItem::CheckBox )
    QCheckListItem.new( @lv1, "Ham", QCheckListItem::CheckBox )
    QCheckListItem.new( @lv1, "Pepperoni", QCheckListItem::CheckBox )
    QCheckListItem.new( @lv1, "Garlic", QCheckListItem::CheckBox )


    lit = QCheckListItem.new( @lv1, "Cheese" )
    lit.setOpen( true )
    QCheckListItem.new( lit, "Cheddar", QCheckListItem::RadioButton )
    QCheckListItem.new( lit, "Mozarella", QCheckListItem::RadioButton )
    QCheckListItem.new( lit, "Jarlsberg", QCheckListItem::RadioButton )

    QToolTip::add( @lv1, "list view" )
    QWhatsThis::add( @lv1, "This is also a <b>QListView</b>, with interactive items." )

     qmlv =  QTextView.new( ("<hr><h1>QTextView</h1>" +
		      "<p>Qt supports formatted rich text, such " +
		      "as the heading above, <em>emphasized</em> and " +
		      "<b>bold</b> text, via an XML subset.</p> " +
		      "<p>Style sheets are supported.</p>"),
 				  "", split )
    qmlv.setFont(QFont.new("Charter",11))
    qmlv.setFrameStyle( QFrame::WinPanel | QFrame::Sunken )

    #// Create an label and a message in the status bar
    #// The message is updated when buttons are clicked etc.
    @msg = QLabel.new("", statusBar(), "message" )
    @msg.setAlignment( AlignCenter )
    boldfont = QFont.new("Helvetica")
    boldfont.setWeight(QFont::Bold)
    @msg.setFont( boldfont )
    statusBar().addWidget( @msg, 4 )
    QToolTip::add( @msg, "Message area" )

    @a = QAccel.new( self )
    @a.connectItem(  @a.insertItem( Key_F9 ), self, "showProperties" )


    @prog = QProgressBar.new(100, statusBar(), "progress" )
    @prog.setTotalSteps( 100 )
    @progress = 64
    @prog.setProgress( @progress )
    statusBar().addWidget( @prog , 1 )
    QWhatsThis::add( @prog, ("This is a <b>QProgressBar</b> " +
		     "You can use it to show that a lengthy " +
		     " process is progressing. " +
		     "In self program, nothing much seems to happen." ))



    statusBar().message( "Welcome to Qt", 2000 )
end


def setStatus(text)

    @msg.setText(text)
end

def button1Clicked()

    @msg.setText( "The push button was clicked" )
    @prog.setProgress( @progress += 1 )
end


def movieUpdate( qrect )

    #// Uncomment self to test animated icons on your window manager
    setIcon( @movie.framePixmap() )
end

def movieStatus( s )

      case ( s )
      when QMovie::SourceEmpty
	@movielabel.setText("Could not load\n" + MOVIEFILENAME )
	@movielabel.setAlignment( AlignCenter )
	@movielabel.setBackgroundColor( backgroundColor() )

      else
	if ( @movielabel.movie() )	 	#// for flicker-free animation:
	    @movielabel.setBackgroundMode( NoBackground )
             end
    end
end


def popupSelected( selectedId )

    if ( selectedId == @plainStyleID )
	for i in 0..@textStylePopup.count() 
        #( int i = 0 i < int(textStylePopup.count()) i++ )
	    id = @textStylePopup.idAt( i )
	    @textStylePopup.setItemChecked( id, false)
	end
    else
	@textStylePopup.setItemChecked( selectedId, true )
    end
end

def checkBoxClicked(  id )

    str = tr("Check box %1 clicked : ").arg(id)
    chk = "---"
    if ( @cb[0].isChecked() )
	chk[0] = 'r'
   end
    if ( @cb[1].isChecked() )
	chk[1] = 'w'
   end
    if ( @cb[2].isChecked() )
	chk[2] = 'x'
   end
    #str += chk
    str.append(chk)
    @msg.setText( str )
end

def edComboBoxItemActivated( text)

    str = tr("Editable Combo Box set to ")
    #str += text
    str.append(text)
    @msg.setText( str )
end


def radioButtonClicked( id )

    @msg.setText( tr("Radio button #%1 clicked").arg(id) )
end


def listBoxItemSelected(  index )

    @msg.setText( tr("List box item %1 selected").arg(index) )
end


def sliderValueChanged(  value )

    @msg.setText( tr("Movie set to %1% of normal speed").arg(value) )
    @movie.setSpeed( value )
end


def comboBoxItemActivated(  index )

    @msg.setText( tr("Combo box item %1 activated").arg(index) )
    case ( index )
    #default:
    when 0
	QApplication::setWinStyleHighlightColor( Qt::darkBlue )
    when 1
	QApplication::setWinStyleHighlightColor( Qt::darkRed )
    when 2
	QApplication::setWinStyleHighlightColor( Qt::darkGreen )
    when 3
	QApplication::setWinStyleHighlightColor( Qt::blue )
    when 4
	QApplication::setWinStyleHighlightColor( Qt::red )
    else
             QApplication::setWinStyleHighlightColor( Qt::darkBlue )
    end
end

def lineEditTextChanged( newText )

    str = QString.new( "Line edit text: ")
    str.append(newText)
    #str += newText
    if ( newText.length() == 1 ) 
	#u = QString.new("")
	#u.sprintf(" (U%02x%02x)", newText[0].row(), newText[0].cell() )
	str.append("#{newText[0]}")
    end
    @msg.setText( str )
end


def spinBoxValueChanged( valueText )

    str=QString.new( "Spin box value: " )
    #str += valueText
    str.append(valueText)
    @msg.setText( str )
end

#//
#// All application events are passed through self event filter.
#// We're using it to display some information about a clicked
#// widget (right mouse button + CTRL).
#//
=begin
bool WidgetView::eventFilter( QObject *obj, QEvent *event )

    static bool identify_now = TRUE
    if ( event.type() == QEvent::MouseButtonPress && identify_now ) 
	QMouseEvent *e = (QMouseEvent*)event
	if ( e.button() == QMouseEvent::RightButton &&
	     (e.state() & QMouseEvent::ControlButton) != 0 )
	    QString str = "The clicked widget is a\n"
	    str += obj.className()
	    str += "\nThe widget's name is\n"
	    if ( obj.name() )
		str += obj.name()
	    else
		str += "<no name>"
	    identify_now = FALSE		// don't do it in message box
	    QMessageBox::message( "Identify Widget", str,
				  QString::null, (QWidget*)obj )
	    identify_now = TRUE		// allow it again
	end
    end
    return QMainWindow::eventFilter( obj, event ) // don't eat event

end
=end

def open()

    QFileDialog::getOpenFileName( QString::null, "Textfiles (*.txt)", self )
end


def dummy()

    QMessageBox::information( self, "Sorry", "This function is not implemented" ,1)
end

#def selectionChanged()

#    qDebug("selectionChanged")
#end

def selectionChanged( item = nil)

    #qDebug("selectionChanged %p", item )
    printf( "selectionChanged %s\n", item )
end

def clicked( item )

    #qDebug("clicked %p", item )
    printf("clicked %s\n",item)
end

def mySelectionChanged( item )

    #qDebug("mySelectionChanged %p\n", item )
    printf("mySelectionChanged %s\n", item )
end

def showProperties()

    if ( !QApplication::qApp.focusWidget() )
	return
    end
    properties = QApplication::qApp.focusWidget().metaObject().propertyNames( TRUE )
    printf(" ")
    printf("Properties for class '%s'", QApplication::qApp.focusWidget().className() )
    for i in 0..properties.count() #( int i = 0 i < (int) properties.count() i++ )
	p = QApplication::qApp.focusWidget().metaObject().property( properties.at(i), true )
	s = "readwrite"
	if (!p.writeable() )
	    s = "read-only"
             end
	printf("%d: %s  ( %s, %s )", (i += 1) , p.name(), s, p.type() )
    end
end

end

=begin
****************************************************************************
** $Id: widgets.rb,v 1.3 2001/01/23 01:12:08 horie Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include <qapplication.h>
#include "widgets.h"
#include <qmotifstyle.h>
#include <qcdestyle.h>
#include <qwindowsstyle.h>
#include <qplatinumstyle.h>
#include <qsgistyle.h>

class MyWidgetView  < WidgetView

def initialize (parent = nil, name = "")
   super
   @s = 0
end
def  button1Clicked()
GC.start
	@s +=1;
	case (@s % 5)
	when 0
	    QApplication::setStyle(QMotifStyle.new);
	when 1
	    QApplication::setStyle(QCDEStyle.new);
	when 2
	    QApplication::setStyle(QWindowsStyle.new);
	when 3
	    QApplication::setStyle(QPlatinumStyle.new);
	when 4
	    QApplication::setStyle(QSGIStyle.new);
	end
	#WidgetView::button1Clicked();
             super
end
end;


#
# Create and display our WidgetView.
#

#int main( int argc, char **argv )

    QApplication::setColorSpec( QApplication::CustomColor );
    a= QApplication.new( [$0]+ARGV );
    QApplication::setStyle( QWindowsStyle.new );

    w = MyWidgetView.new;
    a.setMainWidget( w );
    w.show();
    translator = QTranslator.new(nil)
    translator.load("qt-2.2.3.eucJP.qm")
    a.installTranslator(translator)
    a.exec
