/****************************************************************************
** $Id: qaction.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QAction class
**
** Created : 000000
**
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

//#ifndef QACTION_H
//#define QACTION_H

//#ifndef QT_H
//#include <qobject.h>
//#include <qiconset.h>
//#include <qstring.h>
//#endif // QT_H

//#ifndef QT_NO_ACTION

class QActionPrivate;
class QActionGroupPrivate;
class QStatusBar;

class QAction : public QObject
{
/*
		Q_OBJECT
		Q_PROPERTY( bool toggleAction READ isToggleAction WRITE setToggleAction)
		Q_PROPERTY( bool on READ isOn WRITE setOn )
		Q_PROPERTY( bool enabled READ isEnabled WRITE setEnabled )
		Q_PROPERTY( QIconSet iconSet READ iconSet WRITE setIconSet )
		Q_PROPERTY( QString text READ text WRITE setText )
		Q_PROPERTY( QString menuText READ menuText WRITE setMenuText )
		Q_PROPERTY( QString toolTip READ toolTip WRITE setToolTip )
		Q_PROPERTY( QString statusTip READ statusTip WRITE setStatusTip )
		Q_PROPERTY( QString whatsThis READ whatsThis WRITE setWhatsThis )
		Q_PROPERTY( int accel READ accel WRITE setAccel )
*/
public:
		%extend {

		QAction(VALUE varg0 = Qnil, VALUE varg1 = Qnil, VALUE varg2 = Qnil, VALUE varg3 = Qnil,
								 VALUE varg4 = Qnil, VALUE varg5 = Qnil, VALUE varg6 = Qnil)
		{
		//QAction( QObject* parent = 0, const char* name = 0, bool toggle = FALSE  );
			 if(varg0 == Qnil) {
				 return new QAction();
			 } else if(rb_obj_is_kind_of(varg0, cQObject) || TYPE(varg0) == T_NIL) {
					QObject* parent=0;
					char * name = 0;
					bool toggle = FALSE;
					parent =(QObject *)Get_QObject(varg0);
					if(varg1 != Qnil) name = STR2CSTR(varg1);
					if(varg2 != Qnil) {
						 if(varg2 == Qtrue) toggle = TRUE;
						 else toggle = FALSE;
					 }
					 return new QAction(parent, name, toggle);
			 } else if(rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_STRING || TYPE(varg0) == T_NIL) {
			//QAction( const QString& text, const QIconSet& icon, const QString& menuText, int accel,
			//	     QObject* parent, const char* name = 0, bool toggle = FALSE );
				 if(rb_obj_is_kind_of(varg1,cQPixmap) || rb_obj_is_kind_of(varg1,cQIconSet) || TYPE(varg1) == T_NIL) {
				 QString *qtext;
				 char * text;
				 bool pixmap = FALSE;
				 QIconSet * icon;
				 QPixmap * picon;
				 QString *qmenuText;
				 char * menuText;
				 int accel;
				 QObject* parent;
				 char* name = 0;
				 bool toggle = FALSE;
				 if(rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_NIL) {
						qtext = (QString*)Get_QString(varg0);
						text = (char *)qtext;
				 } else {
						text = STR2CSTR(varg0);
				 }
				 if(rb_obj_is_kind_of(varg1,cQIconSet) || TYPE(varg1) == T_NIL) {
						icon = (QIconSet*)Get_QIconSet(varg1);
				 } else {
						picon = (QPixmap*)Get_QPixmap(varg1);
						pixmap = TRUE;
				 }
				 if(rb_obj_is_kind_of(varg2,cQString) || TYPE(varg2) == T_NIL) {
						qmenuText = (QString*)Get_QString(varg2);
						menuText = (char *)qmenuText;
				 } else {
						menuText = STR2CSTR(varg2);
				 }
				 accel = NUM2INT(varg3);
				 parent = (QObject*)Get_QObject(varg4);
				 if(varg5 != Qnil) name = STR2CSTR(varg5);
				 if(varg6 != Qnil) {
						 if(varg6 == Qtrue) toggle = TRUE;
						 else toggle = FALSE;
				 }
				 if(pixmap) {
						return new QAction(text, *picon, menuText, accel, parent, name, toggle);
				 } else {
						return new QAction(text, *icon, menuText, accel, parent, name, toggle);
				 }
				 } else if (rb_obj_is_kind_of(varg1, cQString) || TYPE(varg1) == T_STRING || TYPE(varg1) == T_NIL) {
				//QAction( const QString& text, const QString& menuText, int accel, QObject* parent,
				//	     const char* name = 0, bool toggle = FALSE );
				char * text;
				QString * qtext;
				char * menuText;
				QString * qmenuText;
				int accel;
				QObject* parent;
				char* name = 0;
				bool toggle = FALSE;
				if(rb_obj_is_kind_of(varg0, cQString) || TYPE(varg0) == T_NIL) {
						qtext = (QString*)Get_QString(varg0);
						text = (char *)qtext;
				} else {
						text = STR2CSTR(varg0);
				}
				if(rb_obj_is_kind_of(varg1, cQString) || TYPE(varg0) == T_NIL) {
					 qmenuText = (QString*)Get_QString(varg1);
					 menuText = (char *)qmenuText;
				} else {
					 menuText = STR2CSTR(varg1);
				}
				accel = NUM2INT(varg2);
				parent = (QObject*)Get_QObject(varg3);
				if(varg4 != Qnil) name = STR2CSTR(varg4);
				if(varg5 != Qnil) {
						if(varg5 == Qtrue) toggle = TRUE;
						 else toggle = FALSE;
				}
				return new QAction(text, menuText, accel, parent, name, toggle);
				} else {
		 rb_raise(rb_eArgError, "Type error in QAction constructor");
		 return 0;
				}
		 } else {
		 rb_raise(rb_eArgError, "Type error in QAction constructor");
		 return 0;
		 }
		}
	}
	
		//~QAction();

		virtual void setIconSet( const QIconSet& );
		QIconSet iconSet() const;
		virtual void setText( const QString& );
		QString text() const;
		virtual void setMenuText( const QString& );
		QString menuText() const;
		virtual void setToolTip( const QString& );
		QString toolTip() const;
		virtual void setStatusTip( const QString& );
		QString statusTip() const;
		virtual void setWhatsThis( const QString& );
		QString whatsThis() const;
		virtual void setAccel( int key );
		int accel() const;
		virtual void setToggleAction( bool );
		bool isToggleAction() const;
		virtual void setOn( bool );
		bool isOn() const;
		bool isEnabled() const;
		virtual bool addTo( QWidget* );
		virtual bool removeFrom( QWidget* );

//public slots:
		virtual void setEnabled( bool );
/*
signals:
		void activated();
		void toggled( bool );

private slots:
		void internalActivation();
		void toolButtonToggled( bool );
		void objectDestroyed();
		void menuStatusText( int id );
		void showStatusText( const QString& );
		void clearStatusText();

private:
		void init();

		QActionPrivate* d;
*/
};

class QActionGroup : public QAction
{
/*
		Q_OBJECT
		Q_PROPERTY( bool exclusive READ isExclusive WRITE setExclusive )
*/
public:
		QActionGroup( QWidget* parent, const char* name = 0, bool exclusive = TRUE );
		~QActionGroup();
		void setExclusive( bool );
		bool isExclusive() const;
		void insert( QAction* );
		bool addTo( QWidget* );
		bool removeFrom( QWidget* );
		void setEnabled( bool );
/*
signals:
		void selected( QAction* );

private slots:
		void childToggled( bool );
		void childDestroyed();

private:
		QActionGroupPrivate* d;
*/
};

//#endif

//#endif
