/****************************************************************************
** $Id: qbitmap.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QBitmap class
**
** Created : 941020
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QBITMAP_H
//#define QBITMAP_H

//#ifndef QT_H
//#include "qpixmap.h"
//#endif // QT_H


class QBitmap : public QPixmap
{
public:
//    QBitmap();
//    QBitmap( int w, int h,  bool clear = FALSE,
//	     QPixmap::Optimization = QPixmap::DefaultOptim );
//    QBitmap( const QSize &, bool clear = FALSE,
//	     QPixmap::Optimization = QPixmap::DefaultOptim );
//    QBitmap( int w, int h,  const uchar *bits, bool isXbitmap=FALSE );
//    QBitmap( const QSize &, const uchar *bits, bool isXbitmap=FALSE );
//    QBitmap( const QBitmap & );
//    QBitmap( const QString &fileName, const char *format=0 );
	 %extend {
			QBitmap(VALUE arg1 = Qnil, VALUE arg2 = Qnil, VALUE arg3 = Qnil,
							VALUE arg4 = Qnil)
			{
			 if(arg1 == Qnil) return new QBitmap();
			 else if(TYPE(arg1) == T_STRING) {
					char* format=0;
					if(arg2 !=0 ) format = STR2CSTR(arg2);
					return new QBitmap(STR2CSTR(arg1),format);
			 } else if(rb_obj_is_kind_of(arg1,cQBitmap) || TYPE(arg1) == T_NIL) {
					QBitmap * qbm;
					qbm = (QBitmap*)Get_QBitmap(arg1);
					return new QBitmap(*qbm);   
			 } else if((TYPE(arg1) == T_FIXNUM) && (TYPE(arg2) == T_FIXNUM)) {
					int carg1,carg2;
					carg1 = FIX2INT(arg1);
					carg2 = FIX2INT(arg2);
					if((arg3 == Qnil) || (arg3 == Qtrue) || (arg3 == Qfalse)) {
						 bool carg3;
						 QPixmap::Optimization carg4 = QPixmap::DefaultOptim;
						 if( (arg3 == Qnil) || (arg3 == Qfalse) )
								carg3 = false;
						 else
								carg3 = true;
						 if(arg4 != Qnil) carg4 = (QPixmap::Optimization)NUM2INT(arg4);
						 return new QBitmap(carg1,carg2,carg3,carg4);
					} else {
						 if(TYPE(arg3) != T_ARRAY)
												rb_raise(rb_eArgError,"Type mismatch in QBitmap constructor");
						 bool carg4 = FALSE;
						 int a_size = RARRAY(arg3)->len;
						 unsigned char* carg3 = ALLOC_N(unsigned char,a_size);
						 for(int i = 0; i< a_size;i++) {
								carg3[i] = (unsigned char)NUM2INT(RARRAY(arg3)->ptr[i]);
						 }
						if((arg4 == Qnil) || (arg4 == Qfalse))
								carg4 = false;
						 else
								carg4 = true;
						 return new QBitmap(carg1,carg2,carg3,carg4);
					}
			 
			 } else if (rb_obj_is_kind_of(arg1,cQSize) || TYPE(arg1) == T_NIL) {
					QSize* carg1;
					carg1 = (QSize*)Get_QSize(arg1);
					if((arg2 == Qnil) || (arg2 == Qtrue) || (arg2 == Qfalse)) {
						 bool carg2;
						 QPixmap::Optimization carg3 = QPixmap::DefaultOptim;
						 if( (arg2 == Qnil) || (arg2 == Qfalse) )
								carg2 = false;
						 else
								carg2 = true;
						 if(arg3 != Qnil) carg3 = (QPixmap::Optimization)NUM2INT(arg4);
						 return new QBitmap(*carg1,carg2,carg3);
			 }
			 }
			 rb_raise(rb_eArgError,"Type mismatch in QBitmap constructor");
			 
			 }
		};
 
//    QBitmap &operator=( const QBitmap & );
//    QBitmap &operator=( const QPixmap & );
//    QBitmap &operator=( const QImage  & );

		QBitmap  xForm( const QWMatrix & ) const;
};


//#endif // QBITMAP_H
