/****************************************************************************
** $Id: qbuttongroup.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QButtonGroup class
**
** Created : 950130
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

//#ifndef QBUTTONGROUP_H
//#define QBUTTONGROUP_H

//#ifndef QT_H
//#include "qgroupbox.h"
//#endif // QT_H

//#ifndef QT_NO_COMPLEXWIDGETS


class QButton;
class QButtonList;


class QButtonGroup : public QGroupBox
{
		//Q_OBJECT
		//Q_PROPERTY( bool exclusive READ isExclusive WRITE setExclusive )
		//Q_PROPERTY( bool radioButtonExclusive READ isRadioButtonExclusive WRITE setRadioButtonExclusive )
	
public:

		%extend {
		 QButtonGroup(VALUE varg0=Qnil, VALUE varg1=Qnil, VALUE varg2=Qnil, VALUE varg3=Qnil, VALUE varg4 = Qnil) 
		 {
				if(varg0 == Qnil) {
					 return new QButtonGroup();
				} else if(rb_obj_is_kind_of(varg0,cQWidget) || TYPE(varg0) == T_NIL) {
					 QWidget* parent;
					 char* name=0;
					 parent = (QWidget*)Get_QWidget(varg0);
					 if(varg1 != Qnil) name = STR2CSTR(varg1);
					 return new QButtonGroup(parent,name);
				} else if(TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString)|| TYPE(varg0) == T_NIL ) {
					 QString* title;
					 QWidget* parent;
					 char* name;
					 title = (QString*)Get_QString(varg0);
					 if(varg1 != Qnil) parent = (QWidget*)Get_QWidget(varg1);
					 if(varg2 != Qnil) name = STR2CSTR(varg2);
					 return new QButtonGroup((const QString)(*title), parent, name);
				} else if(TYPE(varg0) == T_FIXNUM && 
							 (varg2 ==Qnil || rb_obj_is_kind_of(varg2,cQWidget) || TYPE(varg2) == T_NIL)) {
					 int columns = NUM2INT(varg0);
					 Qt::Orientation ori;
					 QWidget* parent=0;
					 char* name=0;
					 ori = (Qt::Orientation)NUM2INT(varg1);
					 if(varg2 != Qnil) parent = (QWidget*)Get_QWidget(varg2);
					 if(varg3 != Qnil) name = STR2CSTR(varg3); 
					 return new QButtonGroup(columns,ori,parent,name);
				} else if(TYPE(varg0) == T_FIXNUM) {
					 int columns = NUM2INT(varg0);
					 Qt::Orientation ori;
					 QString* title;
					 QWidget* parent=0;
					 char* name=0;                   
					 ori = (Qt::Orientation)NUM2INT(varg1);
					 title = (QString*)Get_QString(varg2);
					 if(varg3 != Qnil) parent = (QWidget*)Get_QWidget(varg3);
					 if(varg4 != Qnil) name = STR2CSTR(varg4); 
					 return new QButtonGroup(columns, ori, (const QString)(*title), parent, (const char*)name);
				} else {
					 rb_raise(rb_eArgError,"Type Error in QButtonGroup constuctor");
				}
		 }
	 };


		//QButtonGroup( QWidget *parent=0, const char *name=0 );
		//QButtonGroup( const QString &title,
//		  QWidget *parent=0, const char* name=0 );
//    QButtonGroup( int columns, Orientation o,
//		  QWidget *parent=0, const char *name=0 );
//    QButtonGroup( int columns, Orientation o, const QString &title,
//		  QWidget *parent=0, const char* name=0 );
	 //~QButtonGroup();

		bool	isExclusive() const;
		bool	isRadioButtonExclusive() const { return radio_excl; }
		virtual void setExclusive( bool );
		virtual void setRadioButtonExclusive( bool );

public:
		int		insert( QButton *, int id=-1 );
		void	remove( QButton * );
		QButton    *find( int id ) const;
		int		id( QButton * ) const;
		int		count() const;

		virtual void setButton( int id );

		virtual void moveFocus( int );

		QButton    *selected();

//signals:
//    void	pressed( int id );
//    void	released( int id );
//    void	clicked( int id );
/*
protected slots:
		void	buttonPressed();
		void	buttonReleased();
		void	buttonClicked();
		void	buttonToggled( bool on );

private:
		void	init();
		bool	excl_grp;
		bool	radio_excl;
		QButtonList *buttons;

private:	// Disabled copy constructor and operator=
//#if defined(Q_DISABLE_COPY)
		QButtonGroup( const QButtonGroup & );
		QButtonGroup &operator=( const QButtonGroup & );
//#endif
*/
};


//#endif // QT_NO_COMPLEXWIDGETS

//#endif // QBUTTONGROUP_H
