/****************************************************************************
** $Id: qcolor.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QColor class
**
** Created : 940112
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QCOLOR_H
#define QCOLOR_H

#ifndef QT_H
#include "qwindowdefs.h"
#endif // QT_H

const QRgb  RGB_DIRTY	= 0x80000000;		// flags unset color
const QRgb  RGB_INVALID = 0x40000000;		// flags invalid color
const QRgb  RGB_DIRECT	= 0x20000000;		// flags directly set pixel
const QRgb  RGB_MASK	= 0x00ffffff;		// masks RGB values


 int qRed( QRgb rgb );		// get red part of RGB
//{ return (int)((rgb >> 16) & 0xff); }

 int qGreen( QRgb rgb );		// get green part of RGB
//{ return (int)((rgb >> 8) & 0xff); }

 int qBlue( QRgb rgb );		// get blue part of RGB
//{ return (int)(rgb & 0xff); }

 int qAlpha( QRgb rgb );		// get alpha part of RGBA
//{ return (int)((rgb >> 24) & 0xff); }

 QRgb qRgb( int r, int g, int b );// set RGB value
//{ return (0xff << 24) | ((r & 0xff) << 16) | ((g & 0xff) << 8) | (b & 0xff); }

 QRgb qRgba( int r, int g, int b, int a );// set RGBA value
//{ return ((a & 0xff) << 24) | ((r & 0xff) << 16) | ((g & 0xff) << 8) | (b & 0xff); }

 int qGray( int r, int g, int b );// convert R,G,B to gray 0..255
//{ return (r*11+g*16+b*5)/32; }

 %name(qGrayQRgb)  int qGray( QRgb rgb );		// convert RGB to gray 0..255
//{ return qGray( qRed(rgb), qGreen(rgb), qBlue(rgb) ); }
/*
 %native(qGray) 
		int qGray(VALUE varg0, VALUE varg1=Qnil,VALUE varg2=Qnil)    
		 {
				if(varg1 == Qnil) {
					 QRgb *rgb;
					 rgb = (QRgb*)Get_QRgb(varg0);
					 return self->qGray(*rgb);
				} else {
					 int r,g,b;
					 r = NUM2INT(varg0);
					 g = NUM2INT(varg1);
					 b = NUM2INT(varg2);
					 return self->qGray(r,g,b);
				}
		 };
*/  

class QColor
{
public:
		enum Spec { Rgb, Hsv };
%extend {
	 QColor(VALUE varg0=Qnil, VALUE varg1=Qnil, VALUE varg2=Qnil,
			VALUE varg3=Qnil) {
				 if(varg0 == Qnil) {
						return new QColor();
				 } else if (TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString)) {
						QString* name;
						name = (QString*)Get_QString(varg0);
						return new QColor(*name);
				 } else if(TYPE(varg0) == T_FIXNUM && 
									 TYPE(varg1) == T_FIXNUM &&
									 TYPE(varg2) == T_FIXNUM &&
									 varg3 == Qnil) {
						int r,g,b;
						r = NUM2INT(varg0);
						g = NUM2INT(varg1);
						b = NUM2INT(varg2);
						return new QColor(r,g,b);
				 } else if(TYPE(varg0) == T_FIXNUM && 
									 TYPE(varg1) == T_FIXNUM &&
									 TYPE(varg2) == T_FIXNUM &&
									 TYPE(varg3) == T_FIXNUM )         
				 {
						int x,y,z;
						int spec;
						x = NUM2INT(varg0);
						y = NUM2INT(varg1);
						z = NUM2INT(varg2);
						spec = NUM2INT(varg3);
						return new QColor(x,y,z,(QColor::Spec)spec);
				 } else {
						rb_raise(rb_eArgError,"Error in QColor constructor");
				 }
			}
	 }
//    QColor();
//    QColor( int r, int g, int b );
//    QColor( int x, int y, int z, Spec );
//    QColor( QRgb rgb, uint pixel=0xffffffff);
//    QColor( const QString& name );
//    QColor( const char *name );
//    QColor( const QColor & );
//    QColor &operator=( const QColor & );

		bool   isValid() const;
		bool   isDirty() const;

		QString name() const;
		void   setNamedColor( const QString& name );

//    void   rgb( int *OUTPUT, int *OUTPUT, int *OUTPUT ) const;
		//RENAME %name(rgbQRgb) QRgb   rgb()    const;
		%extend {
			 VALUE rgb(VALUE varg0=Qnil,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					if(varg0 == Qnil) {
						 QRgb* result;
						 VALUE vresult;
						 result = new QRgb(self->rgb());
						 CHECK_PTR(result);
						 vresult = Wrap_QRgb(cQRgb,result);
						 return vresult;
					} else {
						 int r,g,b;
						 self->rgb(&r,&g,&b);
						 VALUE vresult;
						 output_helper(vresult,INT2NUM(r));
						 output_helper(vresult,INT2NUM(g));
						 output_helper(vresult,INT2NUM(b));
						 return vresult;
					}
			 }
		}   
			 
//    void   setRgb( int r, int g, int b );
		//RENAME %name(setRgbQRgb) void   setRgb( QRgb rgb );
		%extend {
			 void setRgb(VALUE varg0, VALUE varg1=Qnil, VALUE varg2=Qnil) {
						if(varg1 == Qnil) {
							 QRgb *rgb;
							 rgb = (QRgb*)Get_QRgb(varg0);
							 self->setRgb(*rgb);
						} else {
							 int r,g,b;
							 r = NUM2INT(varg0);
							 g = NUM2INT(varg1);
							 b = NUM2INT(varg2);
							 self->setRgb(r,g,b);
						}
				 }
			
			}
	 
		int	   red()    const;
		int	   green()  const;
		int	   blue()   const;

		void   hsv( int *OUTPUT, int *OUTPUT, int *OUTPUT ) const;
		void   getHsv( int &OUTPUT, int &OUTPUT, int &OUTPUT ) const;
		void   setHsv( int h, int s, int v );

		QColor light( int f = 150 ) const;
		QColor dark( int f = 200 )	const;

//    bool   operator==( const QColor &c ) const;
//    bool   operator!=( const QColor &c ) const;

		static bool lazyAlloc();
		static void setLazyAlloc( bool );
		uint   alloc();
		uint   pixel()  const;

		static int  maxColors();
		static int  numBitPlanes();

		static int  enterAllocContext();
		static void leaveAllocContext();
		static int  currentAllocContext();
		static void destroyAllocContext( int );

#if defined(_WS_WIN_)
		static HPALETTE hPal(); //  { return hpal; }
		static uint	realizePal( QWidget * );
#endif

%name(initialize_Qt)		static void initialize();
		static void cleanup();
/*
private:
		void   setSystemNamedColor( const QString& name );
		static void initGlobalColors();
		static QColor* globalColors();
		static bool color_init;
		static bool globals_init;
		static bool lazy_alloc;
#if defined(_WS_WIN_)
		static HPALETTE hpal;
#endif
		uint   pix;
		QRgb   rgbVal;
*/
};



#endif // QCOLOR_H
