/**********************************************************************
** $Id: qcombobox.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QComboBox class
**
** Created : 950426
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

//#ifndef QCOMBOBOX_H
//#define QCOMBOBOX_H

//#ifndef QT_H
//#include "qwidget.h"
//#endif // QT_H

//#ifndef QT_NO_COMBOBOX


struct QComboData;
class QStrList;
class QStringList;
class QLineEdit;
class QValidator;
class QListBox;


class QComboBox : public QWidget
{
/*
		Q_OBJECT
		Q_ENUMS( Policy )
		Q_PROPERTY( bool editable READ editable WRITE setEditable )
		Q_PROPERTY( int count READ count )
		Q_PROPERTY( QString currentText READ currentText )
		Q_PROPERTY( int currentItem READ currentItem WRITE setCurrentItem )
		Q_PROPERTY( bool autoResize READ autoResize WRITE setAutoResize )
		Q_PROPERTY( int sizeLimit READ sizeLimit WRITE setSizeLimit )
		Q_PROPERTY( int maxCount READ maxCount WRITE setMaxCount )
		Q_PROPERTY( Policy insertionPolicy READ insertionPolicy WRITE setInsertionPolicy )
		Q_PROPERTY( bool autoCompletion READ autoCompletion WRITE setAutoCompletion )
		Q_PROPERTY( bool duplicatesEnabled READ duplicatesEnabled WRITE setDuplicatesEnabled )
*/
public:
	 %extend {
			QComboBox(VALUE varg0=Qnil, VALUE varg1=Qnil, VALUE varg2=Qnil)
			{
				 if(varg0 == Qnil) {
						return new QComboBox();
				 } else if(rb_obj_is_kind_of(varg0,cQWidget)|| TYPE(varg0) == T_NIL) {
						QWidget* parent;
						char* name=0;
						parent = (QWidget*)Get_QWidget(varg0);
						if(varg1 != Qnil) name = STR2CSTR(varg1);
						return new QComboBox(parent,name);
				 } else if(TYPE(varg0) == T_TRUE || TYPE(varg0) == T_FALSE) {
						bool rw;
						QWidget* parent=0;
						char* name=0;
						rw = (varg0 == Qtrue) ? TRUE:FALSE;
						if(varg1 != Qnil) parent = (QWidget*)Get_QWidget(varg1);
						if(varg2 != Qnil) name = STR2CSTR(varg2);
						return new QComboBox(rw,parent,name);
				 } else {
						rb_raise(rb_eArgError,"Error in QComboBox constructor");
				 }
			}
	 }; 
				 
//    QComboBox( QWidget *parent=0, const char *name=0 );
//    QComboBox( bool rw, QWidget *parent=0, const char *name=0 );
//   ~QComboBox();

		int		count() const;

		void	insertStringList( const QStringList &, int index=-1 );
		//void	insertStrList( const QStrList &, int index=-1 );
		//void	insertStrList( const QStrList *, int index=-1 );
		//RENAME %name(insertStrListArray) void	insertStrList( const char **, int numStrings=-1, int index=-1);
		%extend {
			 void insertStrList(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQStrList)) {
						 QStrList* qslist;
						 int index = -1;
						 qslist = (QStrList*)Get_QStrList(varg0);
						 if(varg1 != Qnil)
								 index = NUM2INT(varg1);
						 self->insertStrList(*qslist,index);
					} else if(TYPE(varg0) == T_ARRAY ) {
						 int a_size = RARRAY(varg0)->len;
						 int numStrings = -1;
						 int index = -1;
						 char** ar_str = ALLOC_N(char *,a_size);
						 for(int i=0; i<a_size;i++) {
								 ar_str[i] = STR2CSTR(RARRAY(varg0)->ptr[i]);
						 }
						 if(varg1 != Qnil)
								 numStrings = NUM2INT(varg1);
						 if(varg2 != Qnil)
								 index = NUM2INT(varg2);
						 self->insertStrList((const char**)ar_str,numStrings,index);
					} else {
						 rb_raise(rb_eArgError,"Error in insertStrList argments");
					}
			 }
		}

//    void	insertItem( const QString &text, int index=-1 );
		//RENAME %name(insertItemQPixmap) void	insertItem( const QPixmap &pixmap, int index=-1 );
		//RENAME %name(insertItemQPixmapQString) void	insertItem( const QPixmap &pixmap, const QString &text, int index=-1 );
		%extend {
			 void insertItem(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQPixmap)) {
							QPixmap* pixmap;
							pixmap =(QPixmap*)Get_QPixmap(varg0);
							if(varg1 == Qnil || TYPE(varg1) == T_FIXNUM) {
								 int index=-1;
								 if(varg1 != Qnil)
										 index = NUM2INT(varg1);
								 self->insertItem(*pixmap,index);
								 return;
							} else {
								 QString* qstr;
								 int index=-1;
								 qstr = (QString*)Get_QString(varg1);
								 if(varg2 != Qnil)
										 index = NUM2INT(varg2);
								 self->insertItem(*pixmap,*qstr,index);
								 return;
							}
					 } else {
							QString* qstr;
							int index=-1;
							qstr = (QString*)Get_QString(varg0);
							if(varg1 != Qnil)
									index = NUM2INT(varg1);
							self->insertItem(*qstr,index);
							return;
					 }
				}
		 }   
		void	removeItem( int index );
		void	clear();

		QString currentText() const;
		QString text( int index ) const;
		const QPixmap *pixmap( int index ) const;

//    void	changeItem( const QString &text, int index );
		//RENAME %name(changeItemQPixmap) void	changeItem( const QPixmap &pixmap, int index );
		//RENAME %name(changeItemQPixmapQString) void	changeItem( const QPixmap &pixmap, const QString &text, int index );
		%extend {
			 void changeItem(VALUE varg0,VALUE varg1,VALUE varg2=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQPixmap)) {
							QPixmap* pixmap;
							pixmap = (QPixmap*)Get_QPixmap(varg0);
							if(TYPE(varg1) == T_FIXNUM) {
								 int index;
								 index = NUM2INT(varg1);
								 self->changeItem(*pixmap,index);
								 return;
							} else {
								 QString* qstr;
								 int index;
								 qstr = (QString*)Get_QString(varg1);
								 index = NUM2INT(varg2);
								 self->changeItem(*pixmap,*qstr,index);
								 return;
							}
					 } else {
							QString* qstr;
							int index;
							qstr = (QString*)Get_QString(varg0);
							index = NUM2INT(varg1);
							self->changeItem(*qstr,index);
							return;
					 }
				}
		 }   


		int		currentItem() const;
		virtual void	setCurrentItem( int index );

		bool	autoResize()	const;
		virtual void	setAutoResize( bool );
		QSize	sizeHint() const;
		virtual QSizePolicy sizePolicy() const;

		virtual void	setBackgroundColor( const QColor & );
		virtual void	setPalette( const QPalette & );
		virtual void	setFont( const QFont & );
		virtual void	setEnabled( bool );

		virtual void	setSizeLimit( int );
		int		sizeLimit() const;

		virtual void	setMaxCount( int );
		int		maxCount() const;

		enum Policy { NoInsertion, AtTop, AtCurrent, AtBottom,
		  AfterCurrent, BeforeCurrent };

		virtual void	setInsertionPolicy( Policy policy );
		Policy 	insertionPolicy() const;

		virtual void	setValidator( const QValidator * );
		const QValidator * validator() const;

		virtual void	setListBox( QListBox * );
		QListBox * 	listBox() const;

		QLineEdit*	lineEdit() const;

		virtual void	setAutoCompletion( bool );
		bool	autoCompletion() const;

		bool	eventFilter( QObject *object, QEvent *event );

		void 	setDuplicatesEnabled( bool enable );
		bool 	duplicatesEnabled() const;
		
		bool 	editable() const;
		void 	setEditable( bool );

public: // slots:
		void	clearValidator();
		void	clearEdit();
		virtual void	setEditText( const QString &);
/*
signals:
		void	activated( int index );
		void	highlighted( int index );
		void	activated( const QString &);
		void	highlighted( const QString &);
		void	textChanged( const QString &);

private slots:
		void	internalActivate( int );
		void	internalHighlight( int );
		void	internalClickTimeout();
		void	returnPressed();

protected:
		void	paintEvent( QPaintEvent * );
		void	resizeEvent( QResizeEvent * );
		void	mousePressEvent( QMouseEvent * );
		void	mouseMoveEvent( QMouseEvent * );
		void	mouseReleaseEvent( QMouseEvent * );
		void	mouseDoubleClickEvent( QMouseEvent * );
		void	keyPressEvent( QKeyEvent *e );
		void	focusInEvent( QFocusEvent *e );
		void	styleChange( QStyle& );

		void	popup(); ////#//#//#//# virtual in 3.0
		void	updateMask();

private:
		void	setUpListBox();
		void	setUpLineEdit();
		void	popDownListBox();
		void	reIndex();
		void	currentChanged();
		QRect	arrowRect() const;
		bool	getMetrics( int *dist, int *buttonW, int *buttonH ) const;

		QComboData	*d;

private:	// Disabled copy constructor and operator=
//#if defined(Q_DISABLE_COPY)
		QComboBox( const QComboBox & );
		QComboBox &operator=( const QComboBox & );
//#endif
*/
};


//#endif // QT_NO_COMBOBOX

//#endif // QCOMBOBOX_H
