/****************************************************************************
** $Id: qcstring.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of the extended char array operations,
** and QByteArray and QCString classes
**
** Created : 920609
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QCSTRING_H
//#define QCSTRING_H

//#ifndef QT_H
//#include "qarray.h"
////#endif // QT_H

//#include <string.h>

//#if defined(_OS_SUN_) && defined(_CC_GNU_)
//#include <strings.h>
//#endif
/*****************************************************************************
	QByteArray class
 *****************************************************************************/

//#if defined(Q_TEMPLATEDLL)
//template class Q_EXPORT QArray<char>;
//#endif
//typedef QArray<char> QByteArray;
//class QByteArray {};


/*****************************************************************************
	QByteArray stream functions
 *****************************************************************************/

//Q_EXPORT QDataStream &operator<<( QDataStream &, const QByteArray & );
//Q_EXPORT QDataStream &operator>>( QDataStream &, QByteArray & );



/*****************************************************************************
	QCString class
 *****************************************************************************/

class QRegExp;

class QCString : public QByteArray	// C string class
{
public:
%extend {
		QCString(VALUE varg0=Qnil,VALUE varg1=Qnil) {
				 if(varg0==Qnil) {
						 return new QCString();
				 } else if (TYPE(varg0) == T_FIXNUM) {
						 int size;
						 size = NUM2INT(varg0);
						 return new QCString(size);
				 } else if(rb_obj_is_kind_of(varg0,cQCString)) {
						 QCString* qcstr;
						 qcstr = (QCString*)Get_QCString(varg0);
						 return new QCString(*qcstr);
				} else if(TYPE(varg0) == T_STRING) {
						char* str;
						str = STR2CSTR(varg0);
						if(varg1 == Qnil) {
								return new QCString(str);
						} else {
								uint maxlen;
								maxlen = NUM2INT(varg1);
								return new QCString(str,maxlen);
						}
				} else {
						rb_raise(rb_eArgError,"Error in QCString constuctor");
				}
		}
}
//    QCString();// {}				// make null string
//    QCString( int size );			// allocate size incl. \0
//    QCString( const QCString &s );// : QByteArray( s ) {}
//    QCString( const char *str );		// deep copy
//    QCString( const char *str, uint maxlen );	// deep copy, max length

//    QCString    &operator=( const QCString &s );// shallow copy
//    QCString    &operator=( const char *str );	// deep copy
%extend {
	const char* to_str() {
			if(!(self->isNull())) return (const char*)(*self);
			else return "";
	};

}

		bool	isNull()	const;
		bool	isEmpty()	const;
		uint	length()	const;
		bool	resize( uint newlen );
		bool	truncate( uint pos );
		bool	fill( char c, int len = -1 );

		QCString	copy()	const;

//    QCString    &sprintf( const char* format,...);

//    int	find( char c, int index=0, bool cs=TRUE ) const;
		
		//RENAME %name(findCStr) int	find( const char *str, int index=0, bool cs=TRUE ) const;

		//RENAME %name(findQRegExp) int find( const QRegExp &, int index=0 ) const;

		%extend {
			 int find(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					 if(TYPE(varg0) == T_STRING) {
							char* cstr;
							int index=0;
							bool cs=TRUE;
							cstr = STR2CSTR(varg0);
							if(varg1 != Qnil)
									index = NUM2INT(varg1);
							if(varg2 != Qnil) 
									cs = (varg2 == Qtrue) ? TRUE:FALSE;
							return self->find(cstr,index,cs);
					 } else {
							QRegExp* reg;
							reg = (QRegExp*)Get_QRegExp(varg0);
							int index=0;
							if(varg1 != Qnil)
								 index = NUM2INT(varg1);
							return self->find(*reg,index);
					 }
				}
		 }  
					
//    int	findRev( char c, int index=-1, bool cs=TRUE) const;

//     %name(findRevCStr) int findRev( const char *str, int index=-1, bool cs=TRUE) const;

		//RENAME %name(findRevQRegExp) int findRev( const QRegExp &, int index=-1 ) const;
		%extend {
			 int findRev(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					 if(TYPE(varg0) == T_STRING) {
							char* cstr;
							int index=-1;
							bool cs=TRUE;
							cstr = STR2CSTR(varg0);
							if(varg1 != Qnil)
									index = NUM2INT(varg1);
							if(varg2 != Qnil) 
									cs = (varg2 == Qtrue) ? TRUE:FALSE;
							return self->findRev(cstr,index,cs);
					 } else {
							QRegExp* reg;
							reg = (QRegExp*)Get_QRegExp(varg0);
							int index=-1; 
							if(varg1 != Qnil)
								 index = NUM2INT(varg1);
							return self->findRev(*reg,index);
					 }
				}
		 }  



//    int	contains( char c, bool cs=TRUE ) const;

//    %name(containsCStr) int contains( const char *str, bool cs=TRUE ) const;

		//RENAME %name(containsQRegExp) int contains( const QRegExp & ) const;
		%extend {
			 int contains(VALUE varg0,VALUE varg1=Qnil) {
					 if(TYPE(varg0) == T_STRING) {
							char* cstr;
							bool cs=TRUE;
							cstr = STR2CSTR(varg0);
							if(varg1 != Qnil) 
									cs = (varg1 == Qtrue) ? TRUE:FALSE;
							return self->contains(cstr,cs);
					 } else {
							QRegExp* reg;
							reg = (QRegExp*)Get_QRegExp(varg0);
							return self->contains(*reg);
					 }
				}
		 }  


		QCString	left( uint len )  const;
		QCString	right( uint len ) const;
		QCString	mid( uint index, uint len=0xffffffff) const;

		QCString	leftJustify( uint width, char fill=' ', bool trunc=FALSE)const;
		QCString	rightJustify( uint width, char fill=' ',bool trunc=FALSE)const;

		QCString	lower() const;
		QCString	upper() const;

		QCString	stripWhiteSpace()	const;
		QCString	simplifyWhiteSpace()	const;

		QCString    &insert( uint index, const char * );
		%name(insertChar) QCString    &insert( uint index, char );
		QCString    &append( const char * );
		QCString    &prepend( const char * );
		QCString    &remove( uint index, uint len );
//    QCString    &replace( uint index, uint len, const char * );
		//RENAME %name(replaceQRegExp) QCString    &replace( const QRegExp &, const char * );
		%extend {
				QCString & replace(VALUE varg0,VALUE varg1,VALUE varg2=Qnil) {
					 if(varg2 != Qnil) {
							uint index;
							uint len;
							char* str;
							index = NUM2UINT(varg0);
							len = NUM2UINT(varg1);
							str = STR2CSTR(varg2);
							return self->replace(index,len,str);
					 } else {
							QRegExp *reg;
							char* str;
							reg = (QRegExp*)Get_QRegExp(varg0);
							str = STR2CSTR(varg1);
							return self->replace(*reg,str);
					 }
				}
		 }
	
		short	toShort( bool *OUTPUT=0 )	const;
		ushort	toUShort( bool *OUTPUT=0 )	const;
		int		toInt( bool *OUTPUT=0 )	const;
		uint	toUInt( bool *OUTPUT=0 )	const;
		long	toLong( bool *OUTPUT=0 )	const;
		ulong	toULong( bool *OUTPUT=0 )	const;
		float	toFloat( bool *OUTPUT=0 )	const;
		double	toDouble( bool *OUTPUT=0 )	const;

		QCString    &setStr( const char *s );
//    QCString    &setNum( short );
//    QCString    &setNum( ushort );
//    QCString    &setNum( int );
//    QCString    &setNum( uint );
//    QCString    &setNum( long );
//    QCString    &setNum( ulong );
//    QCString    &setNum( float, char f='g', int prec=6 );
		//RENAME %name(setNumDouble) QCString    &setNum( double, char f='g', int prec=6 );
		%extend {
			 QCString & setNum(VALUE varg0) {
					if(TYPE(varg0) == T_FIXNUM) {
						 int inum;
						 inum = NUM2INT(varg0);
						 return self->setNum(inum);
					} else if(TYPE(varg0) == T_FLOAT) {
						 double dbl;
						 dbl = NUM2DBL(varg0);
						 return self->setNum(dbl);
					} else {
						 rb_raise(rb_eArgError,"Error in setNum argments");
					}
			 }
		}
 
						 
		bool	setExpand( uint index, char c );

//		operator const char *() const;
//    QCString    &operator+=( const char *str );
//    QCString    &operator+=( char c );
};


/*****************************************************************************
	QCString stream functions
 *****************************************************************************/

//Q_EXPORT QDataStream &operator<<( QDataStream &, const QCString & );
//Q_EXPORT QDataStream &operator>>( QDataStream &, QCString & );


/*****************************************************************************
	QCString inline functions
 *****************************************************************************/

//#endif // QCSTRING_H
