/****************************************************************************
** $Id: qdialog.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QDialog class
**
** Created : 950502
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QDIALOG_H
//#define QDIALOG_H

//#ifndef QT_H
//#include "qwidget.h"
//#endif // QT_H

//#if 0
//Q_OBJECT
//#endif

class QPushButton;

class QDialog : public QWidget			// dialog widget
{
///friend class QPushButton;
//    Q_OBJECT
public:
		QDialog( QWidget *parent=0, const char *name=0, bool modal=FALSE,
	     WFlags f=0 );
	 ~QDialog();
		//Q_PROPERTY( bool sizeGripEnabled READ isSizeGripEnabled WRITE setSizeGripEna
//bled )
		bool isSizeGripEnabled();
		void setSizeGripEnabled(bool);

		enum DialogCode { Rejected, Accepted };

		int		exec();
		int		result()  const { return rescode; }

		void	show();
		void	hide();
		//void	move( int x, int y );
		//RENAME %name(moveQPoint) void	move( const QPoint &p );
		%extend {
			 void move(VALUE varg0, VALUE varg1=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint* arg0;
						 arg0 = (QPoint*)Get_QPoint(varg0);
						 self->move(*arg0);
						 return;
					} else {
						 int x,y;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 self->move(x,y);
						 return;
					}
			 }
		}     
		
		//void	resize( int w, int h );
		//RENAME %name(resizeQSize) void	resize( const QSize & );
		%extend {
			 void resize(VALUE varg0, VALUE varg1=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQSize)) {
						 QSize* arg0;
						 arg0 = (QSize*)Get_QSize(varg0);
						 self->resize(*arg0);
						 return;
					} else {
						 int w,h;
						 w = NUM2INT(varg0);
						 h = NUM2INT(varg1);
						 self->resize(w,h);
						 return;
					}
			 } 
	 }    
	 
		//void	setGeometry( int x, int y, int w, int h );
		//RENAME %name(setGeometryQRect) void	setGeometry( const QRect & );
		%extend {
			 void setGeometry(VALUE varg0, VALUE varg1=Qnil,
						 VALUE varg2=Qnil, VALUE varg3=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQRect)) {
						 QRect* arg0;
						 arg0 = (QRect*)Get_QRect(varg0);
						 self->setGeometry(*arg0);
						 return;
					} else if(TYPE(varg0) == T_FIXNUM &&
										TYPE(varg1) == T_FIXNUM &&
										TYPE(varg2) == T_FIXNUM &&
										TYPE(varg3) == T_FIXNUM )                    
					{
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 self->setGeometry(x,y,w,h);
						 return;
					} else {
						 rb_raise(rb_eArgError,"Error in setGeometry argments");
					}
		} 
}    
/*
protected slots:
		virtual void done( int );
		virtual void accept();
		virtual void reject();

protected:
		void	setResult( int r )	{ rescode = r; }
		void	keyPressEvent( QKeyEvent * );
		void	closeEvent( QCloseEvent * );
private:
		virtual void	setDefault( QPushButton * ); // ## remove virtual 3.0
		void		hideDefault();
		int		rescode;
		uint	did_move   : 1;
		uint	did_resize : 1;
		uint 	in_loop: 1;
		QPushButton* mainDef;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QDialog( const QDialog & );
		QDialog &operator=( const QDialog & );
#endif
*/
};


//#endif // QDIALOG_H
