/****************************************************************************
** $Id: qdir.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QDir class
**
** Created : 950427
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QDIR_H
//#define QDIR_H

//#ifndef QT_H
//#include "qstrlist.h"
//#include "qfileinfo.h"
//#endif // QT_H

typedef QList<QFileInfo> QFileInfoList;
typedef QListIterator<QFileInfo> QFileInfoListIterator;
class QStringList;


class QDir
{
public:
		enum FilterSpec { Dirs	    = 0x001,
		      Files	    = 0x002,
		      Drives	    = 0x004,
		      NoSymLinks    = 0x008,
		      All	    = 0x007,
		       TypeMask	    = 0x00F,

		      Readable	    = 0x010,
		      Writable	    = 0x020,
		      Executable    = 0x040,
		       RWEMask	    = 0x070,

		      Modified	    = 0x080,
		      Hidden	    = 0x100,
		      System	    = 0x200,
		       AccessMask    = 0x3F0,

		      DefaultFilter = -1 };

		enum SortSpec   { Name	    = 0x00,
		      Time	    = 0x01,
		      Size	    = 0x02,
		      Unsorted	    = 0x03,
		       SortByMask    = 0x03,

		      DirsFirst	    = 0x04,
		      Reversed	    = 0x08,
		      IgnoreCase    = 0x10,
		      DefaultSort   = -1 };

//    QDir();
		QDir( const QString &path, const QString &nameFilter = QString::null,
	  int sortSpec = QDir::Name | QDir::IgnoreCase, int filterSpec = All );
//    QDir( const QDir & );

		virtual ~QDir();

//    QDir       &operator=( const QDir & );
//    QDir       &operator=( const QString &path );

		virtual void setPath( const QString &path );
		virtual QString path()		const;
		virtual QString absPath()	const;
		virtual QString canonicalPath()	const;

		virtual QString dirName() const;
		virtual QString filePath( const QString &fileName,
			      bool acceptAbsPath = TRUE ) const;
		virtual QString absFilePath( const QString &fileName,
				 bool acceptAbsPath = TRUE ) const;

		static QString convertSeparators( const QString &pathName );

		virtual bool cd( const QString &dirName, bool acceptAbsPath = TRUE );
		virtual bool cdUp();

		QString	nameFilter() const;
		virtual void setNameFilter( const QString &nameFilter );
		FilterSpec filter() const;
		virtual void setFilter( int filterSpec );
		SortSpec sorting() const;
		virtual void setSorting( int sortSpec );

		bool	matchAllDirs() const;
		virtual void setMatchAllDirs( bool );

		uint count() const;
//    QString	operator[]( int ) const;
       %extend {
		QString __getitem__(int index) {
		  return (*self)[index];
		}
		QString __setitem__(int index, QString qstr) {
		  return (*self)[index] = qstr;
		}
	}
		
//    virtual QStrList encodedEntryList( int filterSpec = DefaultFilter,
//				       int sortSpec   = DefaultSort  ) const;
		//RENAME %name(encodedEntryListQString) virtual QStrList encodedEntryList( const QString &nameFilter,
		//RENAME				       int filterSpec = DefaultFilter,
		//RENAME   				       int sortSpec   = DefaultSort   ) const;
		%extend {
			 QStrList encodedEntryList(VALUE varg0=Qnil,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					int filterSpec = QDir::DefaultFilter;
					int sortSpec = QDir::DefaultSort;
					if(varg0 == Qnil || TYPE(varg0) == T_FIXNUM) {
							if(varg0 != Qnil)
									filterSpec = NUM2INT(varg0);
							if(varg1 != Qnil)
									sortSpec = NUM2INT(varg1);
							return self->encodedEntryList(filterSpec,sortSpec);
					} else {
						 QString *qstr;
						 qstr = (QString*)Get_QString(varg0);
							if(varg1 != Qnil)
									filterSpec = NUM2INT(varg1);
							if(varg2 != Qnil)
									sortSpec = NUM2INT(varg2);
							return self->encodedEntryList(*qstr,filterSpec,sortSpec);
					}
			 }
		}
	 	       
				       
//    virtual QStringList entryList( int filterSpec = DefaultFilter,
//				   int sortSpec   = DefaultSort  ) const;
		//RENAME %name(entryListQString) virtual QStringList entryList( const QString &nameFilter,
		//RENAME				   int filterSpec = DefaultFilter,
		//RENAME				   int sortSpec   = DefaultSort   ) const;
		%extend {
			 QStringList entryList(VALUE varg0=Qnil,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					int filterSpec = QDir::DefaultFilter;
					int sortSpec = QDir::DefaultSort;
					if(varg0 == Qnil || TYPE(varg0) == T_FIXNUM) {
							if(varg0 != Qnil)
									filterSpec = NUM2INT(varg0);
							if(varg1 != Qnil)
									sortSpec = NUM2INT(varg1);
							return self->entryList(filterSpec,sortSpec);
					} else {
						 QString *qstr;
						 qstr = (QString*)Get_QString(varg0);
							if(varg1 != Qnil)
									filterSpec = NUM2INT(varg1);
							if(varg2 != Qnil)
									sortSpec = NUM2INT(varg2);
							return self->entryList(*qstr,filterSpec,sortSpec);
					}
			 }
		}



//    virtual const QFileInfoList *entryInfoList( int filterSpec = DefaultFilter,
//						int sortSpec = DefaultSort ) const;
		//RENAME %name(entryInfoListQString) virtual const QFileInfoList *entryInfoList( const QString &nameFilter,
		//RENAME						int filterSpec = DefaultFilter,
		//RENAME						int sortSpec = DefaultSort ) const;
		%extend {
			 const QFileInfoList* entryInfoList(VALUE varg0=Qnil,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					int filterSpec = QDir::DefaultFilter;
					int sortSpec = QDir::DefaultSort;
					if(varg0 == Qnil || TYPE(varg0) == T_FIXNUM) {
							if(varg0 != Qnil)
									filterSpec = NUM2INT(varg0);
							if(varg1 != Qnil)
									sortSpec = NUM2INT(varg1);
							return self->entryInfoList(filterSpec,sortSpec);
					} else {
						 QString *qstr;
						 qstr = (QString*)Get_QString(varg0);
							if(varg1 != Qnil)
									filterSpec = NUM2INT(varg1);
							if(varg2 != Qnil)
									sortSpec = NUM2INT(varg2);
							return self->entryInfoList(*qstr,filterSpec,sortSpec);
					}
			 }
		}


		static const QFileInfoList *drives();

		virtual bool mkdir( const QString &dirName,
			bool acceptAbsPath = TRUE ) const;
		virtual bool rmdir( const QString &dirName,
			bool acceptAbsPath = TRUE ) const;

		virtual bool isReadable() const;
//    virtual bool exists()   const;
		virtual bool isRoot()   const;

		virtual bool isRelative() const;
		virtual void convertToAbs();

//    virtual bool operator==( const QDir & ) const;
//    virtual bool operator!=( const QDir & ) const;

		virtual bool remove( const QString &fileName,
			 bool acceptAbsPath = TRUE );
		virtual bool rename( const QString &name, const QString &newName,
			 bool acceptAbsPaths = TRUE  );
		//RENAME %name(existsQString) virtual bool exists( const QString &name,
		//RENAME			 bool acceptAbsPath = TRUE );
		%extend {
			 bool exists(VALUE varg0=Qnil,VALUE varg1=Qnil) {
					if(varg0 == Qnil) {
						 return self->exists();
					} else {
						 QString *qstr;
						 bool acceptAbsPath=TRUE;
						 qstr = (QString*)Get_QString(varg0);
						 if(varg1 != Qnil)
								 acceptAbsPath= (varg1 == Qtrue) ? TRUE:FALSE;
						 return self->exists(*qstr,acceptAbsPath);
					}
			 }
		}

		static char separator();

		static bool setCurrent( const QString &path );
		static QDir current();
		static QDir home();
		static QDir root();
		static QString currentDirPath();
		static QString homeDirPath();
		static QString rootDirPath();

		//RENAME %name(matchQStringList) static bool match( const QStringList &filters, const QString &fileName );

//    static bool match( const QString &filter, const QString &fileName );
		%extend {
			 static bool match(VALUE varg0,VALUE varg1) {
					QString* filename;
					if(rb_obj_is_kind_of(varg0,cQStringList)) {
						 QStringList* filters;
						 filters = (QStringList*)Get_QStringList(varg0);
						 filename = (QString*)Get_QString(varg1);
						 return QDir::match(*filters,*filename);
					} else {
						 QString* filter;
						 filter = (QString*)Get_QString(varg0);
						 filename = (QString*)Get_QString(varg1);
						 return QDir::match(*filter,*filename);
					}
			 }
		}
 

		static QString cleanDirPath( const QString &dirPath );
		static bool isRelativePath( const QString &path );
/*
private:
		void init();
		virtual bool readDirEntries( const QString &nameFilter,
				 int FilterSpec, int SortSpec  );

		static void slashify ( QString &);

		QString	dPath;
		QStringList   *fList;
		QFileInfoList *fiList;
		QString	nameFilt;
		FilterSpec	filtS;
		SortSpec	sortS;
		uint	dirty	: 1;
		uint	allDirs : 1;
*/
};

//#endif // QDIR_H
