/****************************************************************************
** $Id: qt/src/kernel/qdragobject.h   2.2.3   edited 2000-10-26 $
**
** Definition of QDragObject
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

//#ifndef QDRAGOBJECT_H
//#define QDRAGOBJECT_H

struct QDragData;
struct QStoredDragData;
class QWidget;

//#ifndef QT_H
//#include "qobject.h"
//#include "qimage.h"
//#include "qstrlist.h"
//#include "qcolor.h"
//#endif // QT_H

#ifndef QT_NO_MIME

class QDragObject: public QObject { 
//public QObject, public QMimeSource {
		//Q_OBJECT
public:
//    QDragObject( QWidget * dragSource = 0, const char * name = 0 );
//    virtual ~QDragObject();

#ifndef QT_NO_DRAGANDDROP
		bool drag();
		bool dragMove();
		void dragCopy();

//    virtual void setPixmap(QPixmap);
//RENAME    %name(setPixmapWithHotspot) virtual void setPixmap(QPixmap, QPoint hotspot);
		%extend {
			 void setPixmap(QPixmap pixmap,VALUE varg1=Qnil) {
					if(varg1 == Qnil) {
						 self->setPixmap(pixmap);
					} else {
						 QPoint* qp;
						 qp = (QPoint *)Get_QPoint(varg1);
						 self->setPixmap(pixmap,*qp);
					}
			 }
		}
		QPixmap pixmap() const;
		QPoint pixmapHotSpot() const;
#endif

		QWidget * source();
		static QWidget * target();

		static void setTarget(QWidget*);

#ifndef QT_NO_DRAGANDDROP
		enum DragMode { DragDefault, DragCopy, DragMove, DragCopyOrMove };
/*
protected:
		virtual bool drag(DragMode);

private:
		QDragData * d;
*/
#endif
//QMimeSource methods
public:
		virtual const char* format( int n = 0 ); // const = 0;
		virtual bool provides( const char* ); // const;
		virtual QByteArray encodedData( const char* ); // const = 0;
};

class QStoredDrag: public QDragObject {
		//Q_OBJECT
		QStoredDragData * d;

public:
		QStoredDrag( const char * mimeType,
		 QWidget * dragSource = 0, const char * name = 0 );
		//~QStoredDrag();

		virtual void setEncodedData( const QByteArray & );

		const char * format(int i) const;
		virtual QByteArray encodedData(const char*) const;
};

class QTextDragPrivate;

class QTextDrag: public QDragObject {
		//Q_OBJECT
		QTextDragPrivate* d;
public:
%extend {
		QTextDrag(VALUE varg0=0,VALUE varg1=0,VALUE varg2=0,VALUE varg3=0)
		{
				if(varg0 == 0) {
						return new QTextDrag();
				} else if(TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString))  {
						QString* qstr;
						QWidget* dragSource=0;
						char* name=0;
						qstr = (QString *)Get_QString(varg0);
						if(varg1 != 0) dragSource = (QWidget *)Get_QWidget(varg1);
						if(varg2 != 0) name = STR2CSTR(varg2);
						return new QTextDrag(*qstr,dragSource,name);
			 } else if(rb_obj_is_kind_of(varg0,cQWidget)) {
						QWidget* dragSource;
						char* name=0;
						dragSource = (QWidget *)Get_QWidget(varg0);
						if(name != 0) name = STR2CSTR(varg1);
						return new QTextDrag(dragSource,name);
			 } else {
						rb_raise(rb_eArgError,"Error in QTextDrag constructor");
			 }
	 }
	 };

		//QTextDrag( const QString &,
		//	       QWidget * dragSource = 0, const char * name = 0 );
		//QTextDrag( QWidget * dragSource = 0, const char * name = 0 );
		//~QTextDrag();

		virtual void setText( const QString &);
		virtual void setSubtype( const QCString &);

		const char * format(int i) const;
		virtual QByteArray encodedData(const char*) const;

		static bool canDecode( const QMimeSource* e );
//    static bool decode( const QMimeSource* e, QString& s );
//    %name(decodeWithSubtype) static bool decode( const QMimeSource* e, QString& s, QCString& subtype );
		%extend {
			 static VALUE decode(const QMimeSource* e, QString & s, VALUE varg2=Qnil) {
					VALUE vresult;
					bool bresult;
					if(varg2 == Qnil) {
						 bresult = QTextDrag::decode(e,s);
						 output_helper(vresult, (bresult ? Qtrue:Qfalse));
						 output_helper(vresult, Data_Wrap_Struct(cQString.klass,0,0,&s));
						 return vresult;
					} else {
						 QCString* qcs;
						 qcs = (QCString *)Get_QCString(varg2);
						 bresult = QTextDrag::decode(e,s,*qcs);
						 output_helper(vresult, (bresult ? Qtrue:Qfalse));
						 output_helper(vresult, Data_Wrap_Struct(cQString.klass,0,0,&s));
						 return vresult;
					}
			 }
		}
 
};

class QImageDragData;

class QImageDrag: public QDragObject {
		//Q_OBJECT
		QImage img;
		QStrList ofmts;
		QImageDragData* d;

public:
%extend {
		QImageDrag(VALUE varg0=0,VALUE varg1=0,VALUE varg2=0,VALUE varg3=0)
		{
				if(varg0 == 0) {
						return new QImageDrag();
				} else if(rb_obj_is_kind_of(varg0,cQImage))  {
						QImage* qimg;
						QWidget* dragSource=0;
						char* name=0;
						qimg = (QImage *)Get_QImage(varg0);
						if(varg1 != 0) dragSource = (QWidget *)Get_QWidget(varg1);
						if(varg2 != 0) name = STR2CSTR(varg2);
						return new QImageDrag(*qimg,dragSource,name);
			 } else if(rb_obj_is_kind_of(varg0,cQWidget)) {
						QWidget* dragSource;
						char* name=0;
						dragSource = (QWidget *)Get_QWidget(varg0);
						if(name != 0) name = STR2CSTR(varg1);
						return new QImageDrag(dragSource,name);
			 } else {
						rb_raise(rb_eArgError,"Error in QImageDrag constructor");
			 }
	 }
	 };


		//QImageDrag( QImage image,
	 //		QWidget * dragSource = 0, const char * name = 0 );
		//QImageDrag( QWidget * dragSource = 0, const char * name = 0 );
		//~QImageDrag();

		virtual void setImage( QImage image );

		const char * format(int i) const;
		virtual QByteArray encodedData(const char*) const;

		static bool canDecode( const QMimeSource* e );
//    static bool decode( const QMimeSource* e, QImage& i );
//RENAME    %name(decodeQPixmap) static bool decode( const QMimeSource* e, QPixmap& i );
		%extend {
			 static VALUE decode(const QMimeSource* e, VALUE varg1=Qnil) {
					bool bresult;
					VALUE vresult;
					if(rb_obj_is_kind_of(varg1,cQImage)) {
						 QImage* qi;
						 #qi = (QImage *)Get_QImage(varg1);
						 qi = new QImage();
						 bresult = QImageDrag::decode(e,*qi);
						 output_helper(vresult, bresult ? Qtrue:Qfalse);
						 output_helper(vresult, Wrap_QImage(cQImage,qi));
						 return vresult;
					} else {
						 QPixmap* qp;
						 #qp = (QPixmap *)Get_QPixmap(varg1);
						 qp = new QPixmap();
						 bresult = QImageDrag::decode(e,*qp);
						 output_helper(vresult, bresult ? Qtrue:Qfalse);
						 output_helper(vresult, Wrap_QPixmap(cQPixmap,qp));
						 return vresult;
					}
			 }
		}
};


class QUriDrag: public QStoredDrag {
		//Q_OBJECT

public:

%extend {
		QUriDrag(VALUE varg0=0,VALUE varg1=0,VALUE varg2=0,VALUE varg3=0)
		{
				if(varg0 == 0) {
						return new QUriDrag();
				} else if(rb_obj_is_kind_of(varg0,cQStrList))  {
						QStrList* qslst;
						QWidget* dragSource=0;
						char* name=0;
						qslst = (QStrList *)Get_QStrList(varg0);
						if(varg1 != 0) dragSource = (QWidget *)Get_QWidget(varg1);
						if(varg2 != 0) name = STR2CSTR(varg2);
						return new QUriDrag(*qslst,dragSource,name);
			 } else if(rb_obj_is_kind_of(varg0,cQWidget)) {
						QWidget* dragSource;
						char* name=0;
						dragSource = (QWidget *)Get_QWidget(varg0);
						if(name != 0) name = STR2CSTR(varg1);
						return new QUriDrag(dragSource,name);
			 } else {
						rb_raise(rb_eArgError,"Error in QUriDrag constructor");
			 }
	 }
	 };

		//QUriDrag( QStrList uris,
		//		QWidget * dragSource = 0, const char * name = 0 );
		//QUriDrag( QWidget * dragSource = 0, const char * name = 0 );
		//~QUriDrag();

		void setFilenames( QStringList fnames );
		void setUnicodeUris( QStringList uuris );
		virtual void setUris( QStrList uris );

		static QString uriToLocalFile(const char*);
		static QCString localFileToUri(const QString&);
		static QString uriToUnicodeUri(const char*);
		static QCString unicodeUriToUri(const QString&);
		static bool canDecode( const QMimeSource* e );
		static bool decode( const QMimeSource* e, QStrList& OUTPUT );
		static bool decodeToUnicodeUris( const QMimeSource* e, QStringList& OUTPUT );
		static bool decodeLocalFiles( const QMimeSource* e, QStringList& OUTPUT );
};

class QColorDrag : public QStoredDrag
{
		//Q_OBJECT
		QColor color;

public:

%extend {
		QColorDrag(VALUE varg0=0,VALUE varg1=0,VALUE varg2=0,VALUE varg3=0)
		{
				if(varg0 == 0) {
						return new QColorDrag();
				} else if(rb_obj_is_kind_of(varg0,cQColor))  {
						QColor* qcol;
						QWidget* dragSource=0;
						char* name=0;
						qcol = (QColor *)Get_QColor(varg0);
						if(varg1 != 0) dragSource = (QWidget *)Get_QWidget(varg1);
						if(varg2 != 0) name = STR2CSTR(varg2);
						return new QColorDrag(*qcol,dragSource,name);
			 } else if(rb_obj_is_kind_of(varg0,cQWidget)) {
						QWidget* dragSource;
						char* name=0;
						dragSource = (QWidget *)Get_QWidget(varg0);
						if(name != 0) name = STR2CSTR(varg1);
						return new QColorDrag(dragSource,name);
			 } else {
						rb_raise(rb_eArgError,"Error in QColorDrag constructor");
			 }
	 }
	 };


		//QColorDrag( const QColor &col, QWidget *dragsource = 0, const char *name = 0 );
		//QColorDrag( QWidget * dragSource = 0, const char * name = 0 );
		void setColor( const QColor &col );

		static bool canDecode( QMimeSource * );
		static bool decode( QMimeSource *, QColor &OUTPUT );
};

//#ifndef QT_NO_COMPAT
typedef QUriDrag QUrlDrag;
//#endif

#ifndef QT_NO_DRAGANDDROP

// QDragManager is not part of the public API.  It is defined in a
// header file simply so different .cpp files can implement different
// member functions.
//

class QDragManager: public QObject {
		//Q_OBJECT

private:
		QDragManager();
		~QDragManager();
		// only //friend classes can use QDragManager.
		//friend class QDragObject;
		//friend class QDragMoveEvent;
		//friend class QDropEvent;

		bool eventFilter( QObject *, QEvent * );
		void timerEvent( QTimerEvent* );

		bool drag( QDragObject *, QDragObject::DragMode );

		void cancel( bool deleteSource = TRUE );
		void move( const QPoint & );
		void drop();
		void updatePixmap();

private:
		QDragObject * object;
		void updateMode( ButtonState newstate );
		void updateCursor();

		QWidget * dragSource;
		QWidget * dropWidget;
		bool beingCancelled;
		bool restoreCursor;
		bool willDrop;

		QPixmap *pm_cursor;
		int n_cursor;
};

#endif

#endif // QT_NO_MIME

//#endif // QDRAGOBJECT_H
