/****************************************************************************
** $Id: qheader.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QHeader widget class (table header)
**
** Created : 961105
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QHEADER_H
//#define QHEADER_H

//#ifndef QT_H
//#include "qwidget.h"
//#include "qstring.h"
//#include "qiconset.h"
//#endif // QT_H

struct QHeaderData;

class  QHeader : public QWidget
{
/*   
		Q_OBJECT
		Q_PROPERTY( Orientation orientation READ orientation WRITE setOrientation )
		Q_PROPERTY( bool tracking READ tracking WRITE setTracking )
		Q_PROPERTY( int count READ count )
		Q_PROPERTY( int offset READ offset WRITE setOffset )
		Q_PROPERTY( bool moving READ isMovingEnabled WRITE setMovingEnabled )
*/
public:
//    QHeader( QWidget *parent=0, const char *name=0 );
		QHeader( int, QWidget *parent=0, const char *name=0 );
//    ~QHeader();

//    int		addLabel( const QString &, int size = -1 );
		//RENAME %name(addLabelQIconset) int		addLabel( const QIconSet&, const QString &, int size = -1 );
		%extend {
			 int addLabel(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					QString* qstr;
					int size=-1;
					if(rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_STRING) {
						 qstr = (QString *)Get_QString(varg0);
						 if(varg1 != Qnil)
								 size = NUM2INT(varg1);
						 return self->addLabel(*qstr,size);
					} else {
						 QIconSet* qiset;
						 qiset = (QIconSet *)Get_QIconSet(varg0);
						 qstr = (QString *)Get_QString(varg1);
						 if(varg2 != Qnil)
								 size = NUM2INT(varg2);
						 return self->addLabel(*qiset,*qstr,size);
					}
			 }
		}

		void 	removeLabel( int section );
//    virtual void setLabel( int, const QString &, int size = -1 );
//RENAME     %name(setLabelQIconSet) virtual void setLabel( int, const QIconSet&, const QString &, int size = -1 );
		%extend {
			 void setLabel(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					int cint;
					cint = NUM2INT(varg0);
					QString* qstr;
					int size=-1;
					if(rb_obj_is_kind_of(varg1,cQString) || TYPE(varg1) == T_STRING) {
						 qstr = (QString *)Get_QString(varg1);
						 if(varg2 != Qnil)
								 size = NUM2INT(varg2);
						 self->setLabel(cint,*qstr,size);
					} else if(rb_obj_is_kind_of(varg1,cQPixmap)) {
						 QPixmap* pixmap;
						 pixmap = (QPixmap *)Get_QPixmap(varg1);
						 qstr = (QString *)Get_QString(varg2);
						 if(varg3 != Qnil)
								 size = NUM2INT(varg3);
						 self->setLabel(cint,*pixmap,*qstr,size); 
					} else {            
						 QIconSet* qiset;
						 qiset = (QIconSet *)Get_QIconSet(varg1);
						 qstr = (QString *)Get_QString(varg2);
						 if(varg3 != Qnil)
								 size = NUM2INT(varg3);
						 self->setLabel(cint,*qiset,*qstr,size);
					}
			 }
		}
			 

		QString 	label( int section ) const;
		QIconSet* 	iconSet( int section ) const;

		virtual void setOrientation( Orientation );
		Orientation orientation() const;
		virtual void setTracking( bool enable );
		bool	tracking() const;

		virtual void setClickEnabled( bool, int section = -1 );
		virtual void setResizeEnabled( bool, int section = -1 );
		virtual void setMovingEnabled( bool );
		bool isClickEnabled( int section = -1 ) const;
		bool isResizeEnabled( int section = -1 ) const;
		bool isMovingEnabled() const;

		void 	resizeSection( int section, int s );
		int		sectionSize( int section ) const;
		int		sectionPos( int section ) const;
		int		sectionAt( int pos ) const;
		int		count() const;

		virtual void setCellSize( int , int ); // obsolete, do not use
		int		cellSize( int ) const; // obsolete, do not use
		int		cellPos( int ) const; // obsolete, do not use
		int		cellAt( int ) const; // obsolete, do not use

		int 	offset() const;

		QSize	sizeHint() const;
		QSizePolicy sizePolicy() const;

		int		mapToSection( int index ) const;
		int		mapToIndex( int section ) const;
		int		mapToLogical( int ) const; // obsolete, do not use
		int		mapToActual( int ) const; // obsolete, do not use

		void 	moveSection( int section, int toIndex );
		virtual void moveCell( int, int); // obsolete, do not use

		void 	setSortIndicator( int section, bool increasing = TRUE );

//public slots:
		virtual void setOffset( int pos );
/*
signals:
		void	clicked( int section );
		void	pressed( int section );
		void	released( int section );
		void	sizeChange( int section, int oldSize, int newSize );
		void	indexChange( int section, int fromIndex, int toIndex );
		void	sectionClicked( int ); // obsolete, do not use
		void	moved( int, int ); // obsolete, do not use

protected:
		void	paintEvent( QPaintEvent * );
		QRect	sRect( int index );

		void	paintSection( QPainter *p, int index, QRect fr); // ### const QRect& ## virtual 3.0
		void	paintSectionLabel( QPainter* p, int index, const QRect& fr ); //## virtual 3.0

		void	mousePressEvent( QMouseEvent * );
		void	mouseReleaseEvent( QMouseEvent * );
		void	mouseMoveEvent( QMouseEvent * );

private:
		void	init( int );

		void	paintRect( int p, int s );
		void	markLine( int idx );
		void	unMarkLine( int idx );
		int		pPos( int i ) const;
		int		pSize( int i ) const;
		int		pHeight( int i ) const;
		void	setPHeight( int i, int h );
		int 	findLine( int );

		void	handleColumnResize(int, int, bool);

		int		offs;
		int		handleIdx;
		int		oldHIdxSize;
		int		moveToIdx;
		enum State { Idle, Sliding, Pressed, Moving, Blocked };
		State	state;
		QCOORD	clickPos;
		bool	trackingIsOn;
		int       cachedIdx; // not used
		int	cachedPos; // not used
		Orientation orient;

		QHeaderData *d;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QHeader( const QHeader & );
		QHeader &operator=( const QHeader & );
#endif
*/
};


//#endif //QHEADER_H
