/****************************************************************************
** $Id: qiconset.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QIconSet class
**
** Created : 980318
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QICONSET_H
//#define QICONSET_H

//#ifndef QT_H
//#include "qpixmap.h"
//#endif // QT_H


struct QIconSetPrivate;


class QIconSet
{
public:
		enum Size { Automatic, Small, Large };

		enum Mode { Normal, Disabled, Active };

//    QIconSet();
		QIconSet( const QPixmap & qp, Size size = Automatic );
//    QIconSet( const QIconSet & );
		virtual ~QIconSet();

		void reset( const QPixmap &, Size );

		//RENAME %name(setPixmapQPixmap) virtual void setPixmap( const QPixmap &, Size, Mode mod = Normal );
//    virtual void setPixmap( const QString &, Size, Mode mod = Normal );
		%extend {
			 void setPixmap(VALUE varg0, Size size, Mode mod = Normal) {
					if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						 QPixmap* pixmap;
						 pixmap = (QPixmap *)Get_QPixmap(varg0);
						 self->setPixmap(*pixmap,size,mod);
					} else {
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg0);
						 self->setPixmap(*qstr,size,mod);
					}
			 }
		}

		//RENAME %name(pixmapSizeMode) QPixmap pixmap( Size, Mode ) const;
		//RENAME %name(pixmapSize) QPixmap pixmap( Size s, bool enabled ) const;
//    QPixmap pixmap() const;

		%extend {
			 QPixmap pixmap(VALUE varg0=Qnil,VALUE varg1=Qnil) {
			 if(varg0 == Qnil) {
					return self->pixmap();
			 } else if((varg1 == Qtrue) || (varg1 == Qfalse)) {
					QIconSet::Size s;
					bool enabled;
					s = (QIconSet::Size)NUM2INT(varg0);
					enabled = (varg1 == Qtrue) ? TRUE:FALSE;
					return self->pixmap(s,enabled);
			 } else {
					QIconSet::Size s;
					QIconSet::Mode m;
					s = (QIconSet::Size)NUM2INT(varg0);
					m = (QIconSet::Mode)NUM2INT(varg1);
					return self->pixmap(s,m);
			 }
			}
		}

		bool isGenerated( Size, Mode ) const;

		bool isNull() const;
		
		void detach();

//    QIconSet &operator=( const QIconSet & );
/*
private:
		QIconSetPrivate * d;
*/
};


//#endif
