/****************************************************************************
** $Id: qt/src/kernel/qimage.h   2.3.1   edited 2001-01-26 $
**
** Definition of QImage and QImageIO classes
**
** Created : 950207
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QIMAGE_H
#define QIMAGE_H

#ifndef QT_H
#include "qpixmap.h"
#include "qstrlist.h"
#include "qstringlist.h"
#endif // QT_H

class QImageDataMisc; // internal
#ifndef QT_NO_IMAGE_TEXT
class QImageTextKeyLang {
public:
		QImageTextKeyLang(const char* k, const char* l) : key(k), lang(l) { }
		//QImageTextKeyLang() { }

		QCString key;
		QCString lang;

		//int operator < (const QImageTextKeyLang& other) const
//	{ return key < other.key || key==other.key && lang < other.lang; }
		//int operator == (const QImageTextKeyLang& other) const
	//{ return key==other.key && lang==other.lang; }
};
#endif //QT_NO_IMAGE_TEXT


class QImage
{
public:
		enum Endian { IgnoreEndian, BigEndian, LittleEndian };

		%extend{
			 QImage(VALUE varg0 = Qnil, VALUE varg1 = Qnil, VALUE varg2 = Qnil, 
					 VALUE varg3 = Qnil, VALUE varg4 = Qnil, VALUE varg5 = Qnil, VALUE varg6 = Qnil)
			 {          
					if(varg0 == Qnil) {
						 return new QImage();
					} else if(TYPE(varg0) == T_ARRAY && varg1 == Qnil) {
							int a_size = RARRAY(varg0)->len;             
							char** cstr = ALLOC_N(char * ,a_size);
							for(int i=0;i<a_size;i++) {
								 cstr[i] = STR2CSTR(RARRAY(varg0)->ptr[i]);
							}
							return new QImage(( const char** ) cstr );
					 } else if(rb_obj_is_kind_of(varg0,cQByteArray)) {
							QByteArray* qbary;
							qbary = (QByteArray *)Get_QByteArray(varg0);
							QImage *result;
							result = new QImage();
							CHECK_PTR(result);
							result->loadFromData(*qbary);
							return result;
					 } else if(TYPE(varg0) == T_FIXNUM && TYPE(varg1) == T_FIXNUM
										 && TYPE(varg2) == T_FIXNUM) {
							int width;
							int height;
							int depth;
							int numColors=0;
							QImage::Endian bitOrder = QImage::IgnoreEndian;
							width = NUM2INT(varg0);
							height = NUM2INT(varg1);
							depth = NUM2INT(varg2);
							if(varg3 != Qnil) numColors = NUM2INT(varg3);
							if(varg4 != Qnil) bitOrder = (QImage::Endian)NUM2INT(varg4);
							return new QImage(width,height,depth,numColors,bitOrder);
					} else if (rb_obj_is_kind_of(varg0,cQSize) &&
								TYPE(varg1) == T_FIXNUM) {
							QSize *qsize;
							int depth;
							int numColors=0;
							QImage::Endian bitOrder=QImage::IgnoreEndian;
							qsize = (QSize *)Get_QSize(varg0);
							depth = NUM2INT(varg1);
							if(varg2 != Qnil) numColors = NUM2INT(varg2);
							if(varg3 != Qnil) bitOrder = (QImage::Endian)NUM2INT(varg3);
							return new QImage(*qsize,depth,numColors,bitOrder);
					 } else if ((rb_obj_is_kind_of(varg0,cQString) ||
								 TYPE(varg0) == T_STRING)) {
							QString* fileName;
							char* format=0;
							fileName = (QString *)Get_QString(varg0);
							if(varg1 != Qnil) format = STR2CSTR(varg1);
							return new QImage(*fileName,format);
					 } else if (rb_obj_is_kind_of(varg0,cQImage)) {
							QImage* qimage;
							qimage = (QImage *)Get_QImage(varg0);
							return new QImage(*qimage);
					 } else if (TYPE(varg0) == T_ARRAY && TYPE(varg1) == T_FIXNUM &&
								 TYPE(varg2) == T_FIXNUM && TYPE(varg3) == T_FIXNUM &&  
								 TYPE(varg4) == T_FIXNUM && TYPE(varg5) == T_FIXNUM &&
								 TYPE(varg6) == T_FIXNUM) {
							unsigned char* data;
							int w,h,depth;
							QRgb* colortable;
							int numColors;
							QImage::Endian bitOrder;
							int a_size = RARRAY(varg0)->len;
							data = ALLOC_N(unsigned char,a_size);
							for(int i = 0;i<a_size;i++) {
								 data[i] = (unsigned char)NUM2INT(RARRAY(varg0)->ptr[i]);
							}
							w = NUM2INT(varg1);
							h = NUM2INT(varg2);
							depth = NUM2INT(varg3);
							colortable = ALLOC(QRgb);
							*colortable = (QRgb)NUM2INT(varg4);
							numColors = NUM2INT(varg5);
							bitOrder = (QImage::Endian)NUM2INT(varg6);
							return new QImage(data,w,h,depth,colortable,numColors,bitOrder);
					 } else {
							rb_raise(rb_eArgError, "ArgError in QImage constructor");
					 }
				}
	 }
							
		//QImage();
		//QImage( int width, int height, int depth, int numColors=0,
//	    Endian bitOrder=IgnoreEndian );
		//QImage( const QSize&, int depth, int numColors=0,
//	    Endian bitOrder=IgnoreEndian );
//    QImage( const QString &fileName, const char* format=0 );
//    QImage( const char *xpm[] );
//    QImage( const QByteArray &data );
//    QImage( uchar* data, int w, int h, int depth,
//		QRgb* colortable, int numColors,
//		Endian bitOrder );
#ifdef _WS_QWS_
//    QImage( uchar* data, int w, int h, int depth, int pbl,
//		QRgb* colortable, int numColors,
//		Endian bitOrder );
#endif
//    QImage( const QImage & );
	 ~QImage();

//    QImage     &operator=( const QImage & );
//    QImage     &operator=( const QPixmap & );
//    bool   	operator==( const QImage & ) const;
//    bool   	operator!=( const QImage & ) const;
		void	detach();

//    QImage	copy()		const;
		//RENAME %name(copyXY) QImage	copy(int x, int y, int w, int h, int conversion_flags=0) const;
		//RENAME %name(copyQRect) QImage	copy(QRect&)	const; // constness srong - REMOVE in Qt 3.0
		//QImage	copy(const QRect&)	const;
		%extend {
			 QImage copy(VALUE varg0=Qnil, 
										int y=0, int w=0, int h=0, int conversion_flags=0 ) {
									if(varg0 == Qnil) {
										 return self->copy();
									} else if(rb_obj_is_kind_of(varg0,cQRect)) {
										 QRect* rect;
										 rect = (QRect *)Get_QRect(varg0);
										 return self->copy(*rect);
									} else {
										 int x;
										 x = NUM2INT(varg0);
										 return self->copy(x,y,w,h,conversion_flags);
									}
							 }
						}
									
											 
		bool	isNull()	const	{ return data->bits == 0; }

		int		width()		const	{ return data->w; }
		int		height()	const	{ return data->h; }
		QSize	size()		const	{ return QSize(data->w,data->h); }
		QRect	rect()		const	{ return QRect(0,0,data->w,data->h); }
		int		depth()		const	{ return data->d; }
		int		numColors()	const	{ return data->ncols; }
		Endian 	bitOrder()	const	{ return (Endian) data->bitordr; }

		QRgb	color( int i )	const;
		void	setColor( int i, QRgb c );
		void	setNumColors( int );

		bool	hasAlphaBuffer() const;
		void	setAlphaBuffer( bool );

		bool	allGray() const;
		bool        isGrayscale() const;

//    uchar      *bits()		const;
//    uchar      *scanLine( int ) const;
%extend {
	 VALUE bits() {
			VALUE vresult = Qnil;
			uchar * result;
			result = self->bits();
			vresult = rb_str_new((const char *)result,self->numBytes());
			return vresult;
	 }
}
//   uchar      *scanLine( int ) const;
%extend {
	 VALUE  scanLine(int n) {
			VALUE vresult = Qnil;
			uchar * result;
			result = self->scanLine(n);
			vresult = rb_str_new((const char *)result,self->bytesPerLine());
			return vresult;
	 }
}

		uchar     **jumpTable()	const;
		QRgb       *colorTable()	const;
		int		numBytes()	const;
		int		bytesPerLine()	const;

#ifdef _WS_QWS_
		QGfx * graphicsContext();
#endif
		
//    bool	create( int width, int height, int depth, int numColors=0,
//			Endian bitOrder=IgnoreEndian );
		//RENAME %name(createQSize) bool	create( const QSize&, int depth, int numColors=0,
		//RENAME			Endian bitOrder=IgnoreEndian );
		%extend {
				bool create(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,
										VALUE varg3=Qnil,VALUE varg4=Qnil) {
								int depth,numColors=0;
								if(rb_obj_is_kind_of(varg0,cQSize)) {
									 QSize* qsize;
									 qsize = (QSize *)Get_QSize(varg0);
									 depth = NUM2INT(varg1);
									 if(varg2 != Qnil) 
											 numColors = NUM2INT(varg2);
									 return self->create(*qsize,depth,numColors);
								} else {
									 int width,height;
									 width = NUM2INT(varg0);
									 height = NUM2INT(varg1);
									 depth = NUM2INT(varg2);
									 if(varg3 != Qnil)
											 numColors = NUM2INT(varg3);
									 return self->create(width,height,depth,numColors);
								}
						 }
					}
					
		void	reset();

		void	fill( uint pixel );
		void	invertPixels( bool invertAlpha = TRUE );

//    QImage	convertDepth( int ) const;
#ifndef QT_NO_IMAGE_TRUECOLOR
		QImage	convertDepthWithPalette( int, QRgb* p, int pc, int cf=0 ) const;
#endif
		//RENAME %name(convertDepthWithFlag) QImage	convertDepth( int, int conversion_flags ) const;
		QImage	convertBitOrder( Endian ) const;
		%extend {
			 QImage convertDepth(VALUE varg0,VALUE varg1=Qnil) {
					int ci;
					ci = NUM2INT(varg0);
					if(varg1 == Qnil) {
						 return self->convertDepth(ci);
					} else {
						 int conversion_flags;
						 conversion_flags = NUM2INT(varg1);
						 return self->convertDepth(ci,conversion_flags);
					}
			 }
		}

#ifndef QT_NO_IMAGE_SMOOTHSCALE
		QImage	smoothScale(int width, int height) const;
#endif
		QImage	createAlphaMask( int conversion_flags=0 ) const;
		QImage	createHeuristicMask( bool clipTight=TRUE ) const;

		//QImage	mirror() const;
		//RENAME %name(mirrorHV) QImage	mirror(bool horizontally, bool vertically) const;
		%extend {
			 QImage mirror(VALUE varg0=Qnil,VALUE varg1=Qnil) {
					if(varg0==Qnil) {
						 return self->mirror();
					} else {
						 bool horizontally,vertically;
						 horizontally = (varg0 == Qtrue) ? TRUE:FALSE;
						 vertically = (varg1 == Qtrue) ? TRUE:FALSE;
						 return self->mirror(horizontally,vertically);
					}
			 }
		}

		QImage	swapRGB() const;

		static Endian systemBitOrder();
		static Endian systemByteOrder();

		static const char* imageFormat( const QString &fileName );
		static QStrList inputFormats();
		static QStrList outputFormats();
#ifndef QT_NO_STRINGLIST
		static QStringList inputFormatList();
		static QStringList outputFormatList();
#endif
		bool	load( const QString &fileName, const char* format=0 );
//    bool	loadFromData( const uchar *buf, uint len,
//			      const char *format=0 );
		//RENAME %name(loadFromDataQByteArray) bool	loadFromData( QByteArray data, const char* format=0 );
		%extend {
			 bool loadFromData(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					char* format=0;
					if(rb_obj_is_kind_of(varg0,cQByteArray)) {
						 QByteArray* data;
						 if(varg1 != Qnil)
								 format = STR2CSTR(varg1);
						 return self->loadFromData(*data,format);
					} else if(TYPE(varg0) == T_ARRAY) {
						 uchar *buf;
						 uint clen;
						 int a_size = RARRAY(varg0)->len;
						 unsigned char* ar_uc = ALLOC_N(unsigned char,a_size);
						 if(varg1 == Qnil)
								clen = a_size;
						 else 
								clen = NUM2INT(varg1);
						 if(clen > a_size)
								clen = a_size;
						 for (int i = 0; i< a_size; i++) {
								ar_uc[i] = (unsigned char)NUM2INT(RARRAY(varg0)->ptr[i]);
						 }
						 buf = ar_uc;
						 if(varg2 != Qnil)
								 format = STR2CSTR(varg2);
						 return self->loadFromData(buf,clen,format);
					} else {
						 rb_raise(rb_eArgError,"Error in loadFromData argments");
					}
			 }
		} 
						 
						 

		bool	save( const QString &fileName, const char* format ) const; // //#//#//# remove 3.0
		//RENAME %name(saveWithQuality) bool	save( const QString &fileName, const char* format,
		//RENAME		      int quality ) const; // //#//#//# change to quality=-1 in 3.0

		bool	valid( int x, int y ) const;
		int		pixelIndex( int x, int y ) const;
		QRgb	pixel( int x, int y ) const;
		void	setPixel( int x, int y, uint index_or_rgb );

		// Auxiliary data
		int dotsPerMeterX() const;
		int dotsPerMeterY() const;
		void setDotsPerMeterX(int);
		void setDotsPerMeterY(int);
		QPoint offset() const;
		void setOffset(const QPoint&);
#ifndef QT_NO_IMAGE_TEXT
		QValueList<QImageTextKeyLang> textList() const;
		QStringList textLanguages() const;
		QStringList textKeys() const;
//    QString text(const char* key, const char* lang=0) const;
		//RENAME %name(textQImageTextKeyLang) QString text(const QImageTextKeyLang&) const;

		%extend {
			 QString text(VALUE varg0,VALUE varg1=Qnil) {
					if(TYPE(varg0) == T_STRING) {
						 char* key;
						 char* lang=0;
						 key = STR2CSTR(varg0);
						 if(varg1 != Qnil) 
								 lang = STR2CSTR(varg1);
						 return self->text(key,lang);
					} else if(rb_obj_is_kind_of(varg0,cQImageTextKeyLang)) {
						 QImageTextKeyLang* kl;
						 kl = (QImageTextKeyLang *)Get_QImageTextKeyLang(varg0);
						 return self->text(*kl);
					} else {
						 rb_raise(rb_eArgError,"Error in text() argments");
					}
			 }
		}
	 
		void setText(const char* key, const char* lang, const QString&);
#endif

/*
private:
		void	init();
		void	reinit();
		void	freeBits();
		static void	warningIndexRange( const char *, int );

		struct QImageData : public QShared {	// internal image data
	int	w;				// image width
	int	h;				// image height
	int	d;				// image depth
	int	ncols;				// number of colors
	int	nbytes;				// number of bytes data
	int	bitordr;			// bit order (1 bit depth)
	QRgb   *ctbl;				// color table
	uchar **bits;				// image data
	bool	alpha;				// alpha buffer
	int	dpmx;				// dots per meter X (or 0)
	int	dpmy;				// dots per meter Y (or 0)
	QPoint	offset;				// offset in pixels
//#ifndef QT_NO_IMAGE_TEXT
	QImageDataMisc* misc;			// less common stuff
//#endif
	bool    bits_mine;			// this allocated bits
	bool    ctbl_mine;			// this allocated ctbl
		} *data;
//#ifndef QT_NO_IMAGE_TEXT
		QImageDataMisc& misc() const;
//#endif
		friend Q_EXPORT void bitBlt( QImage* dst, int dx, int dy,
				 const QImage* src, int sx, int sy,
				 int sw, int sh, int conversion_flags );
*/
};


// QImage stream functions

//#ifndef QT_NO_DATASTREAM
//Q_EXPORT QDataStream &operator<<( QDataStream &, const QImage & );
//Q_EXPORT QDataStream &operator>>( QDataStream &, QImage & );
//#endif

class QIODevice;
typedef void (*image_io_handler)( QImageIO * ); // image IO handler


struct QImageIOData; ////#//#//# use instead of params in 3.0


class QImageIO
{
public:
		QImageIO();
		//QImageIO( QIODevice	 *ioDevice, const char *format );
		//QImageIO( const QString &fileName, const char* format );
	 ~QImageIO();


		const QImage &image()	const	{ return im; }
		int		status()	const	{ return iostat; }
		const char *format()	const	{ return frmt; }
		QIODevice  *ioDevice()	const	{ return iodev; }
		QString	fileName()	const	{ return fname; }
		const char *parameters()	const	{ return params; }
		QString	description()	const	{ return descr; }

		void	setImage( const QImage & );
		void	setStatus( int );
		void	setFormat( const char * );
		void	setIODevice( QIODevice * );
		void	setFileName( const QString &);
		void	setParameters( const char * );
		void	setDescription( const QString &);

		bool	read();
		bool	write();

//    static const char* imageFormat( const QString &fileName );
		//RENAME %name(imageFormatQIODevice) static const char *imageFormat( QIODevice * );
		%extend {
			 static const char* imageFormat(VALUE varg0) {
					if(rb_obj_is_kind_of(varg0,cQIODevice)) {
						 QIODevice* io;
						 io = (QIODevice *)Get_QIODevice(varg0);
						 return QImageIO::imageFormat(io);
					} else {
						 QString* fileName;
						 fileName = (QString *)Get_QString(varg0);
						 return QImageIO::imageFormat(*fileName);
					}
			 }
		}

		static QStrList inputFormats();
		static QStrList outputFormats();

//    static void defineIOHandler( const char *format,
//				 const char *header,
//				 const char *flags,
//				 image_io_handler read_image,
//				 image_io_handler write_image );

/*
private:
		QImage	im;				// image
		int		iostat;				// IO status
		QCString	frmt;				// image format
		QIODevice  *iodev;				// IO device
		QString	fname;				// file name
		char       *params;				// image parameters ////#//#//# change to QImageIOData *d in 3.0
		QString     descr;				// image description

private:	// Disabled copy constructor and operator=
//#if defined(Q_DISABLE_COPY)
		QImageIO( const QImageIO & );
		QImageIO &operator=( const QImageIO & );
//#endif
*/
};


%name(bitBltQImage) void bitBlt( QImage* dst, int dx, int dy, const QImage* src,
		      int sx=0, int sy=0, int sw=-1, int sh=-1,
		      int conversion_flags=0 );



#endif // QIMAGE_H
