/**********************************************************************
** $Id: qlabel.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QLabel widget class
**
** Created : 941215
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QLABEL_H
//#define QLABEL_H

//#ifndef QT_H
//#include "qframe.h"
//#endif // QT_H

class QSimpleRichText;
class QLabelPrivate;

class QLabel : public QFrame
{
/*   
		Q_OBJECT
		Q_PROPERTY( QString text READ text WRITE setText )
		Q_PROPERTY( QPixmap pixmap READ pixmap WRITE setPixmap )
		Q_PROPERTY( TextFormat textFormat READ textFormat WRITE setTextFormat )
		Q_PROPERTY( Alignment alignment READ alignment WRITE setAlignment )
		Q_PROPERTY( int indent READ indent WRITE setIndent )
		Q_PROPERTY( bool autoResize READ autoResize WRITE setAutoResize )
*/	
public:
	 %extend {
			QLabel( VALUE varg0, VALUE varg1=Qnil, VALUE varg2=Qnil,
							VALUE varg3=Qnil, VALUE varg4=Qnil) {
				 if(rb_obj_is_kind_of(varg0, cQWidget) || TYPE(varg0) == T_NIL) {
						if(varg2 ==Qnil || TYPE(varg2) == T_FIXNUM) {
							 QWidget* parent;
							 char * name=0;
							 WFlags f=0;
							 parent = (QWidget *)Get_QWidget(varg0);
							 if(varg1 !=Qnil) name = STR2CSTR(varg1);
							 if(varg2 !=Qnil) f = (WFlags)NUM2INT(varg2);
							 return new QLabel(parent, name, f);
						} else if(rb_obj_is_kind_of(varg2,cQWidget)|| TYPE(varg2) == T_NIL) {
							 QWidget* buddy;
							 QString* text;
							 QWidget* parent;
							 char* name=0;
							 WFlags f=0;
							 buddy = (QWidget *)Get_QWidget(varg0);
							 text = (QString *)Get_QString(varg1);
							 parent = (QWidget *)Get_QWidget(varg2);
							 if(varg3 !=Qnil) name=STR2CSTR(varg3);
							 if(varg4 !=Qnil) f = (WFlags)NUM2INT(varg4);
							 return new QLabel(buddy,*text,parent,name,f);
						} else {
							 rb_raise(rb_eArgError,"Error in QLabel constructor");
						}
				 } else if(TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString)|| TYPE(varg0) == T_NIL) {
						QString* text;
						QWidget* parent;
						char* name=0;
						WFlags f=0;
						text = (QString *)Get_QString(varg0);
						parent = (QWidget *)Get_QWidget(varg1);
						if(varg2 !=Qnil) name = STR2CSTR(varg2);
						if(varg3 !=Qnil) f = (WFlags)NUM2INT(varg3);
						return new QLabel(*text,parent,name,f);
				 } else {
						rb_raise(rb_eArgError,"Error in QLabel constructor");
				 }
			}
	 };
	 
							 
//    QLabel( QWidget *parent, const char *name=0, WFlags f=0 );
//    QLabel( const QString &text, QWidget *parent, const char *name=0,
//	    WFlags f=0 );
//    QLabel( QWidget * buddy, const QString &,
//	    QWidget * parent, const char * name=0, WFlags f=0 );
//   ~QLabel();

		QString	 text()		const	{ return ltext; }
		QPixmap     *pixmap()	const	{ return lpixmap; }
		QMovie      *movie()		const;

		TextFormat textFormat() const;
		void 	 setTextFormat( TextFormat );

		int		 alignment() const	{ return align; }
		virtual void setAlignment( int );
		int		 indent() const		{ return extraMargin; }
		void 	 setIndent( int );

		bool 	 autoResize() const	{ return autoresize; }
		virtual void setAutoResize( bool );
//#ifndef QT_NO_IMAGE_SMOOTHSCALE
		bool 	hasScaledContents() const;
		void 	setScaledContents( bool );
//#endif
		QSize	 sizeHint() const;
		QSize	 minimumSizeHint() const;
		QSizePolicy  sizePolicy() const;

		virtual void setBuddy( QWidget * );
		QWidget     *buddy() const;

		void	 setAutoMask(bool);

		int		 heightForWidth(int) const;

//public slots:
		virtual void setText( const QString &);
		virtual void setPixmap( const QPixmap & );
		virtual void setMovie( const QMovie & );
//    virtual void setNum( int );
//    %name(setNumDouble) virtual void setNum( double );
		%extend {
			 void setNum(VALUE varg0) {
					if(TYPE(varg0) == T_FLOAT) {
						 double dbl;
						 dbl = NUM2DBL(varg0);
						 self->setNum(dbl);
					} else if(TYPE(varg0) == T_FIXNUM) {
						 int i;
						 i = NUM2INT(varg0);
						 self->setNum(i);
					} else {
						 rb_raise(rb_eArgError,"Error in setNum argments");
					}
			 }
		}
		void	 clear();
/*
protected:
		void	 drawContents( QPainter * );
		void	 drawContentsMask( QPainter * );
		void	 fontChange( const QFont & );

private slots:
		void	 acceleratorSlot();
		void	 buddyDied();
		void	 movieUpdated(const QRect&);
		void	 movieResized(const QSize&);

private:
		void	init();
		void	clearContents();
		void	updateLabel( QSize oldSizeHint );
		QSize	sizeForWidth( int w ) const;
		QString	ltext;
		QPixmap    *lpixmap;
		QMovie *	lmovie;
		QWidget *	lbuddy;
		ushort	align;
		short	extraMargin;
		uint	autoresize:1;
		TextFormat textformat;
		QSimpleRichText* doc;
		QAccel *	accel;
		QLabelPrivate* d;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QLabel( const QLabel & );
		QLabel &operator=( const QLabel & );
#endif
*/
};


//#endif // QLABEL_H
