/****************************************************************************
** $Id: qt/src/tools/qlist.h   2.3.1   edited 2001-01-26 $
**
** Definition of QList template/macro class
**
** Created : 920701
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QLIST_H
#define QLIST_H

#ifndef QT_H
#include "qglist.h"
#endif // QT_H

class QCollection {};
class QGList : public QCollection {};
class QList : public QGList {};
typedef QList<VALUE> QListRObj;
//typedef QList<QObject> QList_QObject;
typedef QListIterator<QObject> QListIterator_QObject;

#ifndef QT_NO_TOOLBAR
typedef QList<QToolBar> QList_QToolBar;
#endif


//template<class type>
//class QList : public QGList
class QListRObj : public QList
{
public:
//    QList()
			QListRObj();	//			{}
//    QList( const QList<type> &l ) : QGList(l) {}
//   ~QList()				{ clear(); }
		 ~QListRObj();
//    QList<type> &operator=(const QList<type> &l)
//			{ return (QList<type>&)QGList::operator=(l); }
//    bool operator==( const QList<type> &list ) const
//    { return QGList::operator==( list ); }
		uint  count()   const		{ return QGList::count(); }
		bool  isEmpty() const		{ return QGList::count() == 0; }
//    bool  insert( uint i, const type *d){ return QGList::insertAt(i,(QCollection::Item)d); }
		bool insert( uint i, const VALUE * d);
//    void  inSort( const type *d )	{ QGList::inSort((QCollection::Item)d); }
		void inSort( const VALUE * d );
//    void  prepend( const type *d )	{ QGList::insertAt(0,(QCollection::Item)d); }
		void prepend(const VALUE *d);
//    void  append( const type *d )	{ QGList::append((QCollection::Item)d); }
		void append(const VALUE* d);
		bool  remove( uint i )		{ return QGList::removeAt(i); }
		%name(removeAll) bool  remove()			{ return QGList::remove((QCollection::Item)0); }
//    bool  remove( const type *d )	{ return QGList::remove((QCollection::Item)d); }
//    %name(removeRObj) bool  remove( const VALUE* d);
//    bool  removeRef( const type *d )	{ return QGList::removeRef((QCollection::Item)d); }
		bool  removeRef( const VALUE *d);
		void  removeNode( QLNode *n )	{ QGList::removeNode(n); }
		bool  removeFirst()			{ return QGList::removeFirst(); }
		bool  removeLast()			{ return QGList::removeLast(); }
//    type *take( uint i )		{ return (type *)QGList::takeAt(i); }
//    type *take()			{ return (type *)QGList::take(); }
//    type *takeNode( QLNode *n )		{ return (type *)QGList::takeNode(n); }
		VALUE *take( uint i );
		void  clear()			{ QGList::clear(); }
		void  sort()			{ QGList::sort(); }
//    int	  find( const type *d )		{ return QGList::find((QCollection::Item)d); }
		int find(const VALUE *d);
//    int	  findNext( const type *d )	{ return QGList::find((QCollection::Item)d,FALSE); }
		int findNext(const VALUE *d);
//    int	  findRef( const type *d )	{ return QGList::findRef((QCollection::Item)d); }
		int findRef(const VALUE *d);
//    int	  findNextRef( const type *d ){ return QGList::findRef((QCollection::Item)d,FALSE);}
		int findNextRef(const VALUE *d);
//    uint  contains( const type *d ) const { return QGList::contains((QCollection::Item)d); }
		uint contains(const VALUE *d) const;
//    uint  containsRef( const type *d ) const
//					{ return QGList::containsRef((QCollection::Item)d); }
		uint containsRef( const VALUE *d) const;
//    type *at( uint i )			{ return (type *)QGList::at(i); }
		VALUE *at(uint i);
//    int	  at() const			{ return QGList::at(); }
//    type *current()  const		{ return (type *)QGList::get(); }
		VALUE* current() const;
		QLNode *currentNode()  const	{ return QGList::currentNode(); }
//    type *getFirst() const		{ return (type *)QGList::cfirst(); }
//    type *getLast()  const		{ return (type *)QGList::clast(); }
//    type *first()			{ return (type *)QGList::first(); }
//    type *last()			{ return (type *)QGList::last(); }
//    type *next()			{ return (type *)QGList::next(); }
//    type *prev()			{ return (type *)QGList::prev(); }
		VALUE *getFirst() const;
		VALUE *getLast() const;
		VALUE *first();
		VALUE *last();
		VALUE *next();
		VALUE *prev();
		void  toVector( QGVector *vec )const{ QGList::toVector(vec); }
private:
		void  deleteItem( QCollection::Item d );
};
/*
#if defined(Q_DELETING_VOID_UNDEFINED)
template<> inline void QList<void>::deleteItem( QCollection::Item )
{
}
#endif

template<class type> inline void QList<type>::deleteItem( QCollection::Item d )
{
		if ( del_item ) delete (type *)d;
}


template<class type> class QListIterator : public QGListIterator
{
public:
		QListIterator(const QList<type> &l) :QGListIterator((QGList &)l) {}
	 ~QListIterator()	      {}
		uint  count()   const     { return list->count(); }
		bool  isEmpty() const     { return list->count() == 0; }
		bool  atFirst() const     { return QGListIterator::atFirst(); }
		bool  atLast()  const     { return QGListIterator::atLast(); }
		type *toFirst()	      { return (type *)QGListIterator::toFirst(); }
		type *toLast()	      { return (type *)QGListIterator::toLast(); }
		operator type *() const   { return (type *)QGListIterator::get(); }
		type *operator*()         { return (type *)QGListIterator::get(); }

		// No good, since QList<char> (ie. QStrList fails...
		//
		// MSVC++ gives warning
		// Sunpro C++ 4.1 gives error
		//    type *operator->()        { return (type *)QGListIterator::get(); }

		type *current()   const   { return (type *)QGListIterator::get(); }
		type *operator()()	      { return (type *)QGListIterator::operator()();}
		type *operator++()	      { return (type *)QGListIterator::operator++(); }
		type *operator+=(uint j)  { return (type *)QGListIterator::operator+=(j);}
		type *operator--()	      { return (type *)QGListIterator::operator--(); }
		type *operator-=(uint j)  { return (type *)QGListIterator::operator-=(j);}
		QListIterator<type>& operator=(const QListIterator<type>&it)
			      { QGListIterator::operator=(it); return *this; }
};
*/
class QWidgetList : public QList {
public:
			QWidgetList();	
		 ~QWidgetList();
		uint  count()   const;	
		bool  isEmpty() const;	
		bool insert( uint i, const QWidget * d);
		void inSort( const QWidget * d );
		void prepend(const QWidget  *d);
		void append(const QWidget * d);
		bool  remove( uint i );		
		%name(removeAll) bool  remove();
		%name(removeQWidget) bool  remove( const QWidget * d);
		bool  removeRef( const QWidget *d);
		void  removeNode( QLNode *n );
		bool  removeFirst();	
		bool  removeLast();	
		QWidget *take( uint i );
		void  clear();	
		void  sort();
		int find(const QWidget *d);
		int findNext(const QWidget *d);
		int findRef(const QWidget *d);
		int findNextRef(const QWidget *d);
		uint contains(const QWidget *d) const;
		uint containsRef( const QWidget *d) const;
		QWidget *at(uint i);
		QWidget* current() const;
		QLNode *currentNode()  const;	
		QWidget *getFirst() const;
		QWidget *getLast() const;
		QWidget *first();
		QWidget *last();
		QWidget *next();
		QWidget *prev();
		void  toVector( QGVector *vec ) const; 
};
class QFileInfoList :public QList {
public:
		 QFileInfoList();	
		 ~QFileInfoList();
		uint  count()   const;	
		bool  isEmpty() const;	
		bool insert( uint i, const QFileInfo * d);
		void inSort( const QFileInfo * d );
		void prepend(const QFileInfo  *d);
		void append(const QFileInfo * d);
		bool  remove( uint i );		
		%name(removeAll) bool  remove();
		%name(removeQFileInfo) bool  remove( const QFileInfo * d);
		bool  removeRef( const QFileInfo *d);
		void  removeNode( QLNode *n );
		bool  removeFirst();	
		bool  removeLast();	
		QFileInfo *take( uint i );
		void  clear();	
		void  sort();
		int find(const QFileInfo *d);
		int findNext(const QFileInfo *d);
		int findRef(const QFileInfo *d);
		int findNextRef(const QFileInfo *d);
		uint contains(const QFileInfo *d) const;
		uint containsRef( const QFileInfo *d) const;
		QFileInfo *at(uint i);
		QFileInfo * current() const;
		QLNode *currentNode()  const;	
		QFileInfo *getFirst() const;
		QFileInfo *getLast() const;
		QFileInfo *first();
		QFileInfo *last();
		QFileInfo *next();
		QFileInfo *prev();
		void  toVector( QGVector *vec ) const;    
	 };

class QList_QObject : public QList {
public:
		 QList_QObject();	
		 ~QList_QObject();
		uint  count()   const;	
		bool  isEmpty() const;	
		bool insert( uint i, const QObject * d);
		void inSort( const QObject * d );
		void prepend(const QObject  *d);
		void append(const QObject * d);
		bool  remove( uint i );		
		%name(removeAll) bool  remove();
		%name(removeQObject) bool  remove( const QObject * d);
		bool  removeRef( const QObject *d);
		void  removeNode( QLNode *n );
		bool  removeFirst();	
		bool  removeLast();	
		QObject *take( uint i );
		void  clear();	
		void  sort();
		int find(const QObject *d);
		int findNext(const QObject *d);
		int findRef(const QObject *d);
		int findNextRef(const QObject *d);
		uint contains(const QObject *d) const;
		uint containsRef( const QObject *d) const;
		QObject *at(uint i);
		QObject * current() const;
		QLNode *currentNode()  const;	
		QObject *getFirst() const;
		QObject *getLast() const;
		QObject *first();
		QObject *last();
		QObject *next();
		QObject *prev();
		void  toVector( QGVector *vec ) const;    
	 };
	 
#ifndef QT_NO_TOOLBAR

class QList_QToolBar : public QList {
public:   
		 QList_QToolBar();	
		 ~QList_QToolBar();
		uint  count()   const;	
		bool  isEmpty() const;	
		bool insert( uint i, const QToolBar * d);
		void inSort( const QToolBar * d );
		void prepend(const QToolBar  *d);
		void append(const QToolBar * d);
		bool  remove( uint i );
		%name(removeAll) bool  remove();
		%name(removeQToolBar) bool  remove( const QToolBar * d);
		bool  removeRef( const QToolBar *d);
		void  removeNode( QLNode *n );
		bool  removeFirst();	
		bool  removeLast();	
		QToolBar *take( uint i );
		void  clear();	
		void  sort();
		int find(const QToolBar *d);
		int findNext(const QToolBar *d);
		int findRef(const QToolBar *d);
		int findNextRef(const QToolBar *d);
		uint contains(const QToolBar *d) const;
		uint containsRef( const QToolBar *d) const;
		QToolBar *at(uint i);
		QToolBar * current() const;
		QLNode *currentNode()  const;	
		QToolBar *getFirst() const;
		QToolBar *getLast() const;
		QToolBar *first();
		QToolBar *last();
		QToolBar *next();
		QToolBar *prev();
		void  toVector( QGVector *vec ) const;    
	 };
#endif
	 
	 class QMenuItemList : public QList {};

#endif // QLIST_H
