/****************************************************************************
** $Id: qlistview.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QListView widget class
**
** Created : 970809
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QLISTVIEW_H
//#define QLISTVIEW_H

class QPixmap;
class QFont;
class QHeader;
class QIconSet;

class QListView;
struct QListViewPrivate;
class QListViewItemIterator;

//#ifndef QT_H
//#include "qscrollview.h"
//#endif // QT_H


class QListViewItem: public Qt
{
//    friend class QListViewItemIterator;
//#if defined(_CC_MSVC_)
//    friend class QListViewItem;
//#endif

public:
//    QListViewItem( QListView * parent );
//    QListViewItem( QListViewItem * parent );
//    QListViewItem( QListView * parent, QListViewItem * after );
//    QListViewItem( QListViewItem * parent, QListViewItem * after );

	 %extend {
	 QListViewItem(VALUE vparent, VALUE vafter=Qnil ,
			VALUE str1=Qnil, VALUE str2=Qnil, VALUE str3=Qnil, VALUE str4=Qnil,
			VALUE str5=Qnil, VALUE str6=Qnil, VALUE str7=Qnil, VALUE str8=Qnil) {
			QListView* listview1=0;
			QListViewItem* listviewitem1=0;
			QListViewItem* listviewitem2=0;
			QString qnull = QString::null;
			QString* cstr0=&qnull;
			QString* cstr1=&qnull;
			QString* cstr2=&qnull;
			QString* cstr3=&qnull;
			QString* cstr4=&qnull;
			QString* cstr5=&qnull;
			QString* cstr6=&qnull;
			QString* cstr7=&qnull;
			QString* cstr8=&qnull;
			bool have_str0=false;
			bool have_str1=false;
			if( rb_obj_is_kind_of(vparent,cQListView)) {
				 listview1 = (QListView *)Get_QListView(vparent);
			} else {
				 listviewitem1 = (QListViewItem *)Get_QListViewItem(vparent);
			}
			if( rb_obj_is_kind_of(vafter,cQListViewItem)) {
				 listviewitem2 = (QListViewItem *)Get_QListViewItem(vafter);
			} else {
				 if(vafter != Qnil) 
						cstr0 = (QString *)Get_QString(vafter);
			}
			if (TYPE(str1) == T_STRING || rb_obj_is_kind_of(str1,cQString))
				 cstr1 = (QString *)Get_QString(str1);
			if (TYPE(str2) == T_STRING || rb_obj_is_kind_of(str2,cQString))
				 cstr2 = (QString *)Get_QString(str2);
			if (TYPE(str3) == T_STRING || rb_obj_is_kind_of(str3,cQString))
				 cstr3 = (QString *)Get_QString(str3);
			if (TYPE(str4) == T_STRING || rb_obj_is_kind_of(str4,cQString))
				 cstr4 = (QString *)Get_QString(str4);
			if (TYPE(str5) == T_STRING || rb_obj_is_kind_of(str5,cQString))
				 cstr5 = (QString *)Get_QString(str5);
			if (TYPE(str6) == T_STRING || rb_obj_is_kind_of(str6,cQString))
				 cstr6 = (QString *)Get_QString(str6);
			if (TYPE(str7) == T_STRING || rb_obj_is_kind_of(str7,cQString))
				 cstr7 = (QString *)Get_QString(str7);
			if (TYPE(str8) == T_STRING || rb_obj_is_kind_of(str8,cQString))
				 cstr8 = (QString *)Get_QString(str8);
			
			if(listview1 != 0) {
				 if(listviewitem2 != 0) {
						return new QListViewItem(listview1,listviewitem2,
						*cstr1,*cstr2,*cstr3,*cstr4,*cstr5,*cstr6,*cstr7,*cstr8);
				 } else {
						return new QListViewItem(listview1,*cstr0,
						*cstr1,*cstr2,*cstr3,*cstr4,*cstr5,*cstr6,*cstr7);
				 }
			} else {
				 if(listviewitem2 != 0) {
						return new QListViewItem(listviewitem1,listviewitem2,
						*cstr1,*cstr2,*cstr3,*cstr4,*cstr5,*cstr6,*cstr7,*cstr8);
				 } else {
						return new QListViewItem(listviewitem1,*cstr0,
						*cstr1,*cstr2,*cstr3,*cstr4,*cstr5,*cstr6,*cstr7);
				 }
			}
				 rb_raise(rb_eArgError, "Argment Errror in QListViewItem constructor.");   
	 }
							 

}


/*
		QListViewItem( QListView * parent,
		   QString,     QString = QString::null,
		   QString = QString::null, QString = QString::null,
		   QString = QString::null, QString = QString::null,
		   QString = QString::null, QString = QString::null );
		QListViewItem( QListViewItem * parent,
		   QString,     QString = QString::null,
		   QString = QString::null, QString = QString::null,
		   QString = QString::null, QString = QString::null,
		   QString = QString::null, QString = QString::null );

		QListViewItem( QListView * parent, QListViewItem * after,
		   QString,     QString = QString::null,
		   QString = QString::null, QString = QString::null,
		   QString = QString::null, QString = QString::null,
		   QString = QString::null, QString = QString::null );
		QListViewItem( QListViewItem * parent, QListViewItem * after,
		   QString,     QString = QString::null,
		   QString = QString::null, QString = QString::null,
		   QString = QString::null, QString = QString::null,
		   QString = QString::null, QString = QString::null );
*/		   
//    virtual ~QListViewItem();

		virtual void insertItem( QListViewItem * );
		virtual void takeItem( QListViewItem * );
		virtual void removeItem( QListViewItem * ); //obsolete, use takeItem instead

		int height() const;
		virtual void invalidateHeight();
		int totalHeight() const;
		virtual int width( const QFontMetrics&,
		       const QListView*, int column) const;
		void widthChanged(int column=-1) const;
		int depth() const;

		virtual void setText( int, const QString &);
		virtual QString text( int ) const;

		virtual void setPixmap( int, const QPixmap & );
		virtual const QPixmap * pixmap( int ) const;

		virtual QString key( int, bool ) const;
		virtual void sortChildItems( int, bool );

		int childCount() const { return nChildren; }

		bool isOpen() const { return open; }
		virtual void setOpen( bool );
		virtual void setup();

		virtual void setSelected( bool );
		bool isSelected() const { return selected; }

		virtual void paintCell( QPainter *, const QColorGroup & cg,
			    int column, int width, int alignment );
		virtual void paintBranches( QPainter * p, const QColorGroup & cg,
				int w, int y, int h, GUIStyle s );
		virtual void paintFocus( QPainter *, const QColorGroup & cg,
			     const QRect & r );

		QListViewItem * firstChild() const;
		QListViewItem * nextSibling() const { return siblingItem; }
		QListViewItem * parent() const;

		QListViewItem * itemAbove();
		QListViewItem * itemBelow();

		int itemPos() const;

		QListView *listView() const;

		virtual void setSelectable( bool enable );
		bool isSelectable() const { return selectable; }

		virtual void setExpandable( bool );
		bool isExpandable() const { return expandable; }

		void repaint() const;

		void sort(); // ######## make virtual in next major release
/*
protected:
		virtual void enforceSortOrder() const;
		virtual void setHeight( int );
		virtual void activate();

		bool activatedPos( QPoint & );
private:
		void init();
		void moveToJustAfter( QListViewItem * );
		int ownHeight;
		int maybeTotalHeight;
		int nChildren;

		uint lsc: 14;
		uint lso: 1;
		uint open : 1;
		uint selected : 1;
		uint selectable: 1;
		uint configured: 1;
		uint expandable: 1;
		uint is_root: 1;

		QListViewItem * parentItem;
		QListViewItem * siblingItem;
		QListViewItem * childItem;

		void * columns;

		friend class QListView;
*/
};


class QListView: public QScrollView
{
//    friend class QListViewItemIterator;
//    friend class QListViewItem;
/*
		Q_OBJECT
		Q_ENUMS( SelectionMode )
		Q_PROPERTY( int columns READ columns )
		Q_PROPERTY( bool multiSelection READ isMultiSelection WRITE setMultiSelection )
		Q_PROPERTY( SelectionMode selectionMode READ selectionMode WRITE setSelectionMode )
		Q_PROPERTY( int childCount READ childCount )
		Q_PROPERTY( bool allColumnsShowFocus READ allColumnsShowFocus WRITE setAllColumnsShowFocus )
		Q_PROPERTY( int itemMargin READ itemMargin WRITE setItemMargin )
		Q_PROPERTY( bool rootIsDecorated READ rootIsDecorated WRITE setRootIsDecorated )
*/
public:
		QListView( QWidget * parent = 0, const char *name = 0 );
//    ~QListView();

		int treeStepSize() const;
		virtual void setTreeStepSize( int );

		virtual void insertItem( QListViewItem * );
		virtual void takeItem( QListViewItem * );
		virtual void removeItem( QListViewItem * ); // obsolete, use takeItem instead

		virtual void clear();

		QHeader * header() const;

//    virtual int addColumn( const QString &label, int size = -1);
		//RENAME %name(addColumnQIconSet) virtual int addColumn( const QIconSet& iconset, const QString &label, int size = -1);
		%extend {
			 int addColumn(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					int size=-1;
					if(rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_STRING) {
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg0);
						 if(varg1 != Qnil)
								 size = NUM2INT(varg1);
						 return self->addColumn(*qstr,size);
					} else if(rb_obj_is_kind_of(varg0,cQIconSet)) {
						 QIconSet* qic;
						 qic = (QIconSet *)Get_QIconSet(varg0);
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg1);
						 if(varg2 != Qnil)
								 size = NUM2INT(varg2);
						 return self->addColumn(*qic,*qstr,size);
				 } else if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						 QPixmap* qpix;
						 qpix = (QPixmap *)Get_QPixmap(varg0);
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg1);
						 if(varg2 != Qnil)
								 size = NUM2INT(varg2);
						 return self->addColumn(*qpix,*qstr,size);
								
				 } else {
						rb_raise(rb_eArgError,"Error in addColumn argments");
				 }
			}
	 }
						 
			 
		
		void removeColumn( int index ); // #### make virtual in next major release!
//    virtual void setColumnText( int column, const QString &label );
		//RENAME %name(setColumnTextQIconSet) virtual void setColumnText( int column, const QIconSet& iconset, const QString &label );
		%extend {
			 void setColumnText(VALUE varg0, VALUE varg1, VALUE varg2=Qnil) {
					int column;
					QString* label;
					if(TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString)) {
						 column = NUM2INT(varg0);
						 label = (QString *)Get_QString(varg1);
						 self->setColumnText(column,*label);
					} else if(rb_obj_is_kind_of(varg1,cQIconSet)) {
						 column = NUM2INT(varg0);
						 QIconSet *qic;
						 qic = (QIconSet *)Get_QIconSet(varg1);
						 label = (QString *)Get_QString(varg2);
						 self->setColumnText(column,*qic,*label);
					} else if(rb_obj_is_kind_of(varg1,cQPixmap)) {
						 QPixmap *qpix;
						 column = NUM2INT(varg0);
						 qpix = (QPixmap *)Get_QPixmap(varg1);
						 label = (QString *)Get_QString(varg2);
						 self->setColumnText(column,*qpix,*label);
					} else {
						 rb_raise(rb_eArgError,"Error in setColumnText argments");
					}
			 }
		}

		QString columnText( int column ) const;
		virtual void setColumnWidth( int column, int width );
		int columnWidth( int column ) const;
		enum WidthMode { Manual, Maximum };
		virtual void setColumnWidthMode( int column, WidthMode );
		WidthMode columnWidthMode( int column ) const;
		int columns() const;

		virtual void setColumnAlignment( int, int );
		int columnAlignment( int ) const;

		void show();

		QListViewItem * itemAt( const QPoint & screenPos ) const;
		QRect itemRect( const QListViewItem * ) const;
		int itemPos( const QListViewItem * );

		void ensureItemVisible( const QListViewItem * );

		void repaintItem( const QListViewItem * ) const;

		virtual void setMultiSelection( bool enable );
		bool isMultiSelection() const;

		enum SelectionMode { Single, Multi, Extended, NoSelection  };
		void setSelectionMode( SelectionMode mode );
		SelectionMode selectionMode() const;

		virtual void clearSelection();
		virtual void setSelected( QListViewItem *, bool );
		bool isSelected( const QListViewItem * ) const;
		QListViewItem * selectedItem() const;
		virtual void setOpen( QListViewItem *, bool );
		bool isOpen( const QListViewItem * ) const;

		virtual void setCurrentItem( QListViewItem * );
		QListViewItem * currentItem() const;

		QListViewItem * firstChild() const;

		int childCount() const;

		virtual void setAllColumnsShowFocus( bool );
		bool allColumnsShowFocus() const;

		virtual void setItemMargin( int );
		int itemMargin() const;

		virtual void setRootIsDecorated( bool );
		bool rootIsDecorated() const;

		virtual void setSorting( int column, bool increasing = TRUE );
		void sort(); // #### make virtual in next major release

		virtual void setFont( const QFont & );
		virtual void setPalette( const QPalette & );

		bool eventFilter( QObject * o, QEvent * );

		QSize sizeHint() const;
		QSize minimumSizeHint() const;

		void setShowSortIndicator( bool show );
		bool showSortIndicator() const;
/*
public slots:
		void invertSelection(); // ###### make virtual
		void selectAll( bool select ); // make virtual
		void triggerUpdate();
		void setContentsPos( int x, int y );

signals:
		void selectionChanged();
		void selectionChanged( QListViewItem * );
		void currentChanged( QListViewItem * );
		void clicked( QListViewItem * );
		void clicked( QListViewItem *, const QPoint &, int );
		void pressed( QListViewItem * );
		void pressed( QListViewItem *, const QPoint &, int );

		void doubleClicked( QListViewItem * );
		void returnPressed( QListViewItem * );
		void rightButtonClicked( QListViewItem *, const QPoint&, int );
		void rightButtonPressed( QListViewItem *, const QPoint&, int );
		void mouseButtonPressed( int, QListViewItem *, const QPoint& , int );
		void mouseButtonClicked( int, QListViewItem *,  const QPoint&, int );

		void onItem( QListViewItem *item );
		void onViewport();

		void expanded( QListViewItem *item );
		void collapsed( QListViewItem *item );

protected:
		void contentsMousePressEvent( QMouseEvent * e );
		void contentsMouseReleaseEvent( QMouseEvent * e );
		void contentsMouseMoveEvent( QMouseEvent * e );
		void contentsMouseDoubleClickEvent( QMouseEvent * e );

		void focusInEvent( QFocusEvent * e );
		void focusOutEvent( QFocusEvent * e );

		void keyPressEvent( QKeyEvent *e );

		void resizeEvent( QResizeEvent *e );

		void showEvent( QShowEvent * );

		void drawContentsOffset( QPainter *, int ox, int oy,
			     int cx, int cy, int cw, int ch );

		virtual void paintEmptyArea( QPainter *, const QRect & );
		void enabledChange( bool );
		void styleChange( QStyle& );

protected slots:
		void updateContents();
		void doAutoScroll();

private slots:
		void changeSortColumn( int );
		void updateDirtyItems();
		void makeVisible();
		void handleSizeChange( int, int, int );

private:
		void updateGeometries();
		void buildDrawableList() const;
		void reconfigureItems();
		void widthChanged(const QListViewItem*, int c);
		void handleItemChange( QListViewItem *old, bool shift, bool control );
		void selectRange( QListViewItem *from, QListViewItem *to, bool invert, bool includeFirst, bool clearSel = FALSE );

		QListViewPrivate * d;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QListView( const QWidget & );
		QListView &operator=( const QWidget & );
#endif
*/
};


class QCheckListItem : public QListViewItem
{
public:
		enum Type { RadioButton, CheckBox, Controller };
/*
		QCheckListItem( QCheckListItem *parent, const QString &text,
		    Type = Controller );
		QCheckListItem( QListViewItem *parent, const QString &text,
		    Type = Controller );
		QCheckListItem( QListView *parent, const QString &text,
		    Type = Controller );
		QCheckListItem( QListViewItem *parent, const QString &text,
		    const QPixmap & );
		QCheckListItem( QListView *parent, const QString &text,
		    const QPixmap & );
*/
	 %extend {
	 QCheckListItem(VALUE vparent, VALUE str,
			 VALUE vbtype = Qnil)
{
			QString* cstr=0;
			QCheckListItem::Type btype;
			bool set_type = false;
			cstr = (QString *)Get_QString(str);
			if((TYPE(vbtype) == T_FIXNUM) || (TYPE(vbtype) == T_NIL)) {
				 set_type = true;
				 if(vbtype == Qnil) btype = QCheckListItem::Controller;
				 else if (vbtype == INT2NUM(QCheckListItem::RadioButton))
						btype = QCheckListItem::RadioButton;
				 else if (vbtype == INT2NUM(QCheckListItem::CheckBox))
						btype = QCheckListItem::CheckBox;
			}

			if ( (TYPE(vparent) != T_DATA)) {
				 debug(" TYPE of vparent is %d.",TYPE(vparent));
				 debug(" TYPE of btype is %d. ",TYPE(btype));
				 rb_raise(rb_eArgError, "Qt object expected");

			} else if (rb_obj_is_kind_of(vparent, cQCheckListItem)  || TYPE(vparent) == T_NIL) {
				 QCheckListItem* temp;
				 temp = (QCheckListItem *)Get_QCheckListItem(vparent);
				 return new QCheckListItem(temp,*cstr,btype);

			} else if (rb_obj_is_kind_of(vparent, cQListView)  || TYPE(vparent) == T_NIL) {
				 QListView* temp;
				 temp = (QListView *)Get_QListView(vparent);
				 if (set_type) {
						return new QCheckListItem(temp,*cstr,btype);
				 } else {
						QPixmap* temp_qpm;
						temp_qpm = (QPixmap *)Get_QPixmap(vbtype);
						return new QCheckListItem(temp,*cstr,*temp_qpm);
				 }
			} else if (rb_obj_is_kind_of(vparent, cQListViewItem)  || TYPE(vparent) == T_NIL) {
				 QListViewItem* temp;
				 temp = (QListViewItem *)Get_QListViewItem(vparent);
				 if (set_type) {
						return new QCheckListItem(temp,*cstr,btype);
				 } else {
						QPixmap* temp_qpm;
						temp_qpm = (QPixmap *)Get_QPixmap(vbtype);
						return new QCheckListItem(temp,*cstr,*temp_qpm);
				 }
			 } else {
				 rb_raise(rb_eArgError, "QListView or QListViewItem or QCheckListViewItem is expected.");
				 return NULL;
			 }

	 }
}



		void paintCell( QPainter *,  const QColorGroup & cg,
		    int column, int width, int alignment );
		virtual void paintFocus( QPainter *, const QColorGroup & cg,
			     const QRect & r );
		int width( const QFontMetrics&, const QListView*, int column) const;
		void setup();

		virtual void setOn( bool );
		bool isOn() const { return on; }
		Type type() const { return myType; }
//    QString text() const { return QListViewItem::text( 0 ); }
		//RENAME %name(textInt) QString text( int n ) const { return QListViewItem::text( n ); }
		%extend {
			 QString text(VALUE varg0=Qnil) {
					if(varg0 == Qnil) {
						 return self->text();
					} else {
						 int n;
						 n = NUM2INT(varg0);
						 return self->text(n);
					}
			 }
		}
/*
protected:
		void paintBranches( QPainter * p, const QColorGroup & cg,
			int w, int y, int h, GUIStyle s );

		void activate();
		void turnOffChild();
		virtual void stateChange( bool );

private:
		void init();
		Type myType;
		bool on;
		QCheckListItem *exclusive;

		void *reserved;
*/
};

class QListViewItemIterator
{
//    friend struct QListViewPrivate;
//    friend class QListView;
//    friend class QListViewItem;

public:
//    QListViewItemIterator();
//    QListViewItemIterator( QListViewItem *item );
//    QListViewItemIterator( const QListViewItemIterator &it );
		QListViewItemIterator( QListView *lv );
%extend {
			QListViewItemIterator * next() {
				 (*self)++;
				 return self;
			}
			QListViewItemIterator * prev() {
				 (*self)--;
				 return self;
			}
}

//    QListViewItemIterator &operator=( const QListViewItemIterator &it );

//    ~QListViewItemIterator();

//    QListViewItemIterator &operator++();
//    const QListViewItemIterator operator++( int );
//    QListViewItemIterator &operator+=( int j );

//    QListViewItemIterator &operator--();
//    const QListViewItemIterator operator--( int );
//    QListViewItemIterator &operator-=( int j );

		QListViewItem *current() const;
/*
protected:
		QListViewItem *curr;
		QListView *listView;

private:
		void addToListView();
		void currentRemoved();
*/
};

//#endif // QLISTVIEW_H
