/****************************************************************************
** $Id: qmenudata.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QMenuData class
**
** Created : 941128
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QMENUDATA_H
//#define QMENUDATA_H

//#ifndef QT_H
//#include "qglobal.h"

// if we did not include QIconSet, we would break code due to the missing
// conversion QPixmap->QIconset
//#include "qiconset.h"

//#endif // QT_H

class QPopupMenu;
class QMenuDataData;

#if defined(INCLUDE_MENUITEM_DEF)

//#include "qstring.h"
//#include "qsignal.h"
//#include "qfont.h"

class QCustomMenuItem;
class QMenuItemData;

class QMenuItem			// internal menu item class
{
//friend class QMenuData;
public:
		QMenuItem();
//   ~QMenuItem();

		int		id()		const	; // { return ident; }
		QIconSet   *iconSet()	const	; // { return iconset_data; }
		QString	text()		const	; // { return text_data; }
		QString	whatsThis()	const	; // { return whatsthis_data; }
		QPixmap    *pixmap()	const; // { return pixmap_data; }
		QPopupMenu *popup()		const	; // { return popup_menu; }
		QWidget *widget()		const	; // { return widget_item; }
		QCustomMenuItem *custom()	const;
		int		key()		const	; // { return accel_key; }
		QSignal    *signal()	const	; // { return signal_data; }
		bool	isSeparator()	const	; // { return is_separator; }
		bool	isEnabled()	const	; // { return is_enabled; }
		bool	isChecked()	const	; // { return is_checked; }
		bool	isDirty()	const	; // { return is_dirty; }

		void	setText( const QString &text ) ; // { text_data = text; }
		void	setDirty( bool dirty )	       ; // { is_dirty = dirty; }
		void	setWhatsThis( const QString &text ) ; // { whatsthis_data = text; }
/*
private:
		int		ident;				// item identifier
		QIconSet   *iconset_data;			// icons
		QString	text_data;			// item text
		QString	whatsthis_data;			// item Whats This help text
		QPixmap    *pixmap_data;			// item pixmap
		QPopupMenu *popup_menu;			// item popup menu
		QWidget    *widget_item;				// widget menu item
		int		accel_key;			// accelerator key (state|ascii)
		QSignal    *signal_data;			// connection
		uint	is_separator : 1;		// separator flag
		uint	is_enabled   : 1;		// disabled flag
		uint	is_checked   : 1;		// checked flag
		uint	is_dirty     : 1;		// dirty (update) flag
		QMenuItemData* d;

		QMenuItemData* extra();

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QMenuItem( const QMenuItem & );
		QMenuItem &operator=( const QMenuItem & );
#endif
*/
};

//#include "qlist.h"
//typedef QList<QMenuItem>	 QMenuItemList;
//typedef QListIterator<QMenuItem> QMenuItemListIt;

#else

class QMenuItem {};
//class QPixmap;

#endif // INCLUDE_MENUITEM_TEXT



class QCustomMenuItem : public Qt
{
/*
public:
		QCustomMenuItem();
//    virtual ~QCustomMenuItem();
		virtual bool fullSpan() const;
		virtual bool isSeparator() const;
		virtual void setFont( const QFont& font );
		virtual void paint( QPainter* p, const QColorGroup& cg, bool act,
			bool enabled, int x, int y, int w, int h ) = 0;
		virtual QSize sizeHint(); = 0;
*/
};


class QMenuData			// menu data class
{
//friend class QMenuBar;
//friend class QPopupMenu;
public:
		QMenuData();
//    virtual ~QMenuData();
/* Virutual class for QPopupMenu and QMenuBar?
		
		uint	count() const;

		%extend {
		int insertItem(VALUE varg0, VALUE varg1=Qnil, VALUE varg2=Qnil,
		 VALUE varg3=Qnil, VALUE varg4=Qnil, VALUE varg5=Qnil, VALUE varg6=Qnil) {
		 char* cstr(0);
		 char* member(0);
		 QObject* qobj(0);
		 QString* qstr(0);
		 QIconSet* qiset(0);
		 QPixmap* qpixmap(0);
		 QPixmap* qpixmap2(0);
		 QWidget* qwidget(0);
		 int id(-1),index(-1),accel(0),menuid;
		 QPopupMenu* qmenu(0);
		 QCustomMenuItem* qcmenuitem(0);
//    int insertItem( const QString &text,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
		 if((TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQObject) || TYPE(varg1) == T_NIL)
				 && (TYPE(varg2) == T_STRING)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)) {
						qstr = (QString *)Get_QString(varg0);
						qobj = (QObject *)Get_QObject(varg1);
						member = STR2CSTR(varg2);
						if(varg3 != Qnil) accel = NUM2INT(varg3);
						if(varg4 != Qnil) id = NUM2INT(varg4);
						if(varg5 != Qnil) index = NUM2INT(varg5);
						menuid = self->insertItem(*qstr,qobj,member,accel,id,index);
						QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg1,member);
						return menuid;
						}
//    int insertItem( const QIconSet& icon,
//                    const QString &text,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString) || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQObject) || TYPE(varg2) == T_NIL)
				 && (TYPE(varg3) == T_STRING)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)
				 && (varg6 == Qnil || TYPE(varg6) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else{
						qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qstr = (QString *)Get_QString(varg1);
				 qobj = (QObject *)Get_QObject(varg2);
				 member = STR2CSTR(varg3);
				 if(varg4 != Qnil) accel = NUM2INT(varg4);
				 if(varg5 != Qnil) id = NUM2INT(varg5);
				 if(varg6 != Qnil) index = NUM2INT(varg6);
				 if(qpixmap != 0) menuid = self->insertItem(*qpixmap,*qstr,qobj,member,accel,id,index);
				 else menuid = self->insertItem(*qiset,*qstr,qobj,member,accel,id,index);
				 QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg2,member);
				 return menuid;
				 }
//    int insertItem( const QPixmap &pixmap,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap)  || TYPE(varg0) == T_NIL)
				 && ((rb_obj_is_kind_of(varg1,cQObject) || TYPE(varg1) == T_NIL))
				 && (TYPE(varg2) == T_STRING)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)) {
				 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 qobj = (QObject *)Get_QObject(varg1);
				 member = STR2CSTR(varg2);
				 if(varg3 != Qnil) accel = NUM2INT(varg3);
				 if(varg4 != Qnil) id = NUM2INT(varg4);
				 if(varg5 != Qnil) index = NUM2INT(varg5);
				 menuid = self->insertItem(*qpixmap,qobj,member,accel,id,index);
				 QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg1,member);
				 return menuid;
				 }
//    int insertItem( const QIconSet& icon,
//                    const QPixmap &pixmap,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPixmap)  || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQObject) || TYPE(varg2) == T_NIL)
				 && TYPE(varg3) == T_STRING
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)
				 && (varg6 == Qnil || TYPE(varg6) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
						qpixmap2 = (QPixmap *)Get_QPixmap(varg1);
				 } else {
						qiset = (QIconSet *)Get_QIconSet(varg0);
						qpixmap = (QPixmap *)Get_QPixmap(varg1);
				 }
				 qobj = (QObject *)Get_QObject(varg2);
				 member = STR2CSTR(varg3);
				 if(varg4 != Qnil) accel = NUM2INT(varg4);
				 if(varg5 != Qnil) id = NUM2INT(varg5);
				 if(varg6 != Qnil) index = NUM2INT(varg6);
				 if(qpixmap2 != 0) self->insertItem(*qpixmap,*qpixmap,qobj,member,accel,id,index);
				 menuid = self->insertItem(*qiset,*qpixmap,qobj,member,accel,id,index);
				 QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg2,member);
				 return menuid;
				 }
//    int  insertItem( const QString &text, int id=-1, int index=-1 );
			else if((TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qstr = (QString *)Get_QString(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(*qstr,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                      const QString &text, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString) || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else { 
						qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qstr = (QString *)Get_QString(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 if(qpixmap != 0) return self->insertItem(*qpixmap,*qstr,id,index);
				 else return self->insertItem(*qiset,*qstr,id,index);
				 }
//    int insertItem( const QString &text, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
		 else if((TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPopupMenu) || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 qstr = (QString *)Get_QString(varg0);
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 return self->insertItem(*qstr,qmenu,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                    const QString &text, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString) || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQPopupMenu) || TYPE(varg2) == T_NIL)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else{ 
						qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qstr = (QString *)Get_QString(varg1);
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg2);
				 if(varg3 != Qnil) id = NUM2INT(varg3);
				 if(varg4 != Qnil) index = NUM2INT(varg4);
				 if(qpixmap != 0) return self->insertItem(*qpixmap,*qstr,qmenu,id,index);
				 else return self->insertItem(*qiset,*qstr,qmenu,id,index);
				 }
//    int insertItem( const QPixmap &pixmap, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(*qpixmap,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                    const QPixmap &pixmap, int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPixmap)  || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
						qpixmap2 = (QPixmap *)Get_QPixmap(varg1);
				 } else {
						qiset = (QIconSet *)Get_QIconSet(varg0);
						qpixmap = (QPixmap *)Get_QPixmap(varg1);
				 }
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 if(qpixmap2 != 0) self->insertItem(*qpixmap,*qpixmap2,id,index);
				 else self->insertItem(*qiset,*qpixmap,id,index);
				 }
//    int insertItem( const QPixmap &pixmap, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap)  || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPopupMenu)  || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 return self->insertItem(*qpixmap,qmenu,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                    const QPixmap &pixmap, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPixmap)  || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQPopupMenu)  || TYPE(varg2) == T_NIL)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
						qpixmap2 = (QPixmap *)Get_QPixmap(varg1);
				 } else {
						qiset = (QIconSet *)Get_QIconSet(varg0);
						qpixmap = (QPixmap *)Get_QPixmap(varg1);
				 }
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg2);
				 if(varg3 != Qnil) id = NUM2INT(varg3);
				 if(varg4 != Qnil) index = NUM2INT(varg4);
				 if(qpixmap2 != 0) return self->insertItem(*qpixmap,*qpixmap2,qmenu,id,index);
				 else return self->insertItem(*qiset,*qpixmap,qmenu,id,index);
				 }

//    int insertItem( QWidget* widget, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQWidget)  || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qwidget = (QWidget *)Get_QWidget(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(qwidget,id,index);
				 }
//    int insertItem( const QIconSet& icon, QCustomMenuItem* custom, int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQCustomMenuItem)  || TYPE(varg1) == T_NIL )
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else {
						 qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qcmenuitem = (QCustomMenuItem *)Get_QCustomMenuItem(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 if(qpixmap != 0) return self->insertItem(*qpixmap,qcmenuitem,id,index);
				 else return self->insertItem(*qiset,qcmenuitem,id,index);
				 }
//    int insertItem( QCustomMenuItem* custom, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQCustomMenuItem)  || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qcmenuitem = (QCustomMenuItem *)Get_QCustomMenuItem(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(qcmenuitem,id,index);
				 }
		}
			
		}
		
/*
		%name(insertItemQObject) int		insertItem( const QString &text,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );
		%name(insertItemQIconSetQObject) int		insertItem( const QIconSet& icon,
			    const QString &text,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );
		%name(QPixmapQObject) int		insertItem( const QPixmap &pixmap,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );
		%name(QIconSetQPixmapQObject) int		insertItem( const QIconSet& icon,
			    const QPixmap &pixmap,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );




		int		insertItem( const QString &text, int id=-1, int index=-1 );
		%name(insertItemQIconSetId) int		insertItem( const QIconSet& icon,
			    const QString &text, int id=-1, int index=-1 );

		%name(insertItemQPopupMenu) int		insertItem( const QString &text, QPopupMenu *popup,
			    int id=-1, int index=-1 );
		%name(insertItemQIconSetQPopupMenu) int		insertItem( const QIconSet& icon,
			    const QString &text, QPopupMenu *popup,
			    int id=-1, int index=-1 );


		%name(insertItemQPixmapId) int		insertItem( const QPixmap &pixmap, int id=-1, int index=-1 );
		%name(insertItemQIconSetQPixmapId) int		insertItem( const QIconSet& icon,
			    const QPixmap &pixmap, int id=-1, int index=-1 );
		%name(insertItemQPixmapQPopupMenu) int		insertItem( const QPixmap &pixmap, QPopupMenu *popup,
			    int id=-1, int index=-1 );
		%name(insertItemQIconSetQPixmapQPopupMenu) int		insertItem( const QIconSet& icon,
			    const QPixmap &pixmap, QPopupMenu *popup,
			    int id=-1, int index=-1 );

		%name(insertItemQWidgetId) int		insertItem( QWidget* widget, int id=-1, int index=-1 );

		%name(insertItemQIconSetQCustomMenuItem) int		insertItem( const QIconSet& icon, QCustomMenuItem* custom, int id=-1, int index=-1 );
		%name(insertQCustomMenuItemId) int		insertItem( QCustomMenuItem* custom, int id=-1, int index=-1 );
*/

		int		insertSeparator( int index=-1 );

		void	removeItem( int id )		; // { removeItemAt(indexOf(id)); }
		void	removeItemAt( int index );
		void	clear();

		int		accel( int id )		const;
		void	setAccel( int key, int id );

		QIconSet    *iconSet( int id )	const;
		QString text( int id )		const;
		QPixmap    *pixmap( int id )	const;

		void setWhatsThis( int id, const QString& );
		QString whatsThis( int id ) const;


//    void	changeItem( int id, const QString &text );
		//RENAME %name(changeItemQPixmap) void	changeItem( int id, const QPixmap &pixmap );
		//RENAME %name(changeItemQIconSet) void	changeItem( int id, const QIconSet &icon, const QString &text );
		//RENAME %name(changeItemQIconSetQPixmap) void	changeItem( int id, const QIconSet &icon, const QPixmap &pixmap );

//    void	changeItem( const QString &text, int id ); // obsolete
//    void	changeItem( const QPixmap &pixmap, int id ); // obsolete
//    void	changeItem( const QIconSet &icon, const QString &text, int id ); // obsolete

		%extend {
			 void changeItem(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					int id;
					id = NUM2INT(varg0);
					QString* text;
					if(rb_obj_is_kind_of(varg1,cQPixmap)) {
						 QPixmap* pixmap;
						 pixmap = (QPixmap *)Get_QPixmap(varg1);
						 if(varg2 != Qnil) {
								 if(rb_obj_is_kind_of(varg2,cQPixmap)) {
										 QPixmap* pixmap2;
										 pixmap2 = (QPixmap *)Get_QPixmap(varg2);
										 self->changeItem(id,*pixmap,*pixmap2);
								 } else {             
										 text = (QString *)Get_QString(varg2);
										 self->changeItem(id,*pixmap,*text);
								 }
						 }else {
								 self->changeItem(id,*pixmap);
						 }
					} else if(rb_obj_is_kind_of(varg1,cQIconSet)) {
						 QIconSet* qic;
						 QPixmap* pixmap;
						 qic = (QIconSet *)Get_QIconSet(varg1);
						 pixmap = (QPixmap *)Get_QPixmap(varg2);
						 self->changeItem(id,*qic,*pixmap);
					} else {
						 rb_raise(rb_eArgError,"Error in changeItem argments");
					}
			 }
		}


		bool	isItemEnabled( int id ) const;
		void	setItemEnabled( int id, bool enable );

		bool	isItemChecked( int id ) const;
		void	setItemChecked( int id, bool check );

		virtual void updateItem( int id );

		int		indexOf( int id )	const;
		int		idAt( int index )	const;
		virtual void	setId( int index, int id );

		bool	connectItem( int id,
			     const QObject *receiver, const char* member );
		bool	disconnectItem( int id,
				const QObject *receiver, const char* member );

		bool	setItemParameter( int id, int param );
		int	itemParameter( int id ) const;

		QMenuItem  *findItem( int id )	const;
		//%name(findItemQMenuData) QMenuItem  *findItem( int id, QMenuData ** parent )	const;

/*
protected:
		int		   actItem;
		QMenuItemList *mitems;
		QMenuData	  *parentMenu;
		uint	   isPopupMenu	: 1;
		uint	   isMenuBar	: 1;
		uint	   badSize	: 1;
		uint	   mouseBtDn	: 1;
		uint	avoid_circularity : 1;
		uint 	actItemDown : 1;
		virtual void   menuContentsChanged();
		virtual void   menuStateChanged();
		virtual void   menuInsPopup( QPopupMenu * );
		virtual void   menuDelPopup( QPopupMenu * );

		QMenuItem * findPopup( QPopupMenu *, int *index = 0 );

private:
		int		insertAny( const QString *, const QPixmap *, QPopupMenu *,
			   const QIconSet*, int, int, QWidget* = 0, QCustomMenuItem* = 0);
		void	removePopup( QPopupMenu * );
		virtual void	setAllDirty( bool );
		void	changeItemIconSet( int id, const QIconSet &icon );

		QMenuDataData *d;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QMenuData( const QMenuData & );
		QMenuData &operator=( const QMenuData & );
#endif
*/
};


//#endif // QMENUDATA_H
