/****************************************************************************
** $Id: qmime.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of mime classes
**
** Created : 981204
**
** Copyright (C) 1998-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QMIME_H
//#define QMIME_H

//#ifndef QT_H
//#include "qwindowdefs.h"
//#endif // QT_H

class  QMimeSource {
public:
		virtual ~QMimeSource();
		virtual const char* format( int n = 0 ) const = 0;
		virtual bool provides( const char* ) const;
		virtual QByteArray encodedData( const char* ) const = 0;
};

class QMimeSourceFactoryData;
class QStringList;

class QMimeSourceFactory {
public:
		QMimeSourceFactory();
		virtual ~QMimeSourceFactory();

		static QMimeSourceFactory* defaultFactory();
		static void setDefaultFactory( QMimeSourceFactory* );

//    virtual const QMimeSource* data(const QString& abs_name) const;
		virtual QString makeAbsolute(const QString& abs_or_rel_name, const QString& context) const;
		//RENAME %name(dataQStringContext) const QMimeSource* data(const QString& abs_or_rel_name, const QString& context) const;
		%extend {
			 const QMimeSource* data(VALUE varg0,VALUE varg1=Qnil) const {
					QString* rel_name;
					rel_name = (QString *)Get_QString(varg0);
					if(varg1 == Qnil) {
						 return self->data(*rel_name);
					} else {
						 QString* context;
						 context = (QString *)Get_QString(varg1);
						 return self->data(*rel_name,*context);
					}
			 }
		}

		virtual void setText( const QString& abs_name, const QString& text );
		virtual void setImage( const QString& abs_name, const QImage& im );
		virtual void setPixmap( const QString& abs_name, const QPixmap& pm );
		virtual void setData( const QString& abs_name, QMimeSource* data );
		virtual void setFilePath( const QStringList& );
		virtual QStringList filePath() const;
		void addFilePath( const QString& );
		virtual void setExtensionType( const QString& ext, const char* mimetype );
/*
private:
		QMimeSourceFactoryData* d;
*/
};




//#endif // QMIME_H
