/****************************************************************************
** $Id: qmotifstyle.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of Motif-like style class
**
** Created : 981231
**
** Copyright (C) 1998-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QMOTIFSTYLE_H
//#define QMOTIFSTYLE_H

//#ifndef QT_H
//#include "qcommonstyle.h"
//#include "qpalette.h"
//#endif // QT_H

class QMotifStyle : public QCommonStyle
{
//    Q_OBJECT
public:
		QMotifStyle( bool useHighlightCols = FALSE);
//    virtual ~QMotifStyle();

		void setUseHighlightColors( bool );
		bool useHighlightColors() const;

		//RENAME %name(polishQPalette) void polish( QPalette&);
//    void polish( QWidget* );
		//RENAME %name(plishQApplication) void polish( QApplication*);
		%extend {
			 void polish(VALUE varg0) {
					if(rb_obj_is_kind_of(varg0,cQPalette)) {
						 QPalette* qpal;
						 qpal = (QPalette *)Get_QPalette(varg0);
						 self->polish(*qpal);
					} else if(rb_obj_is_kind_of(varg0,cQColor)) {
						 QColor* qcol;
						 qcol = (QColor *)Get_QColor(varg0);
						 QPalette* qpal;
						 qpal = new QPalette(*qcol);
						 self->polish(*qpal);
					} else if(rb_obj_is_kind_of(varg0,cQWidget)) {
						 QWidget* qwd;
						 qwd = (QWidget *)Get_QWidget(varg0);
						 self->polish(qwd);
					} else if(rb_obj_is_kind_of(varg0,cQApplication)) {
						 QApplication* qapp;
						 qapp = (QApplication *)Get_QApplication(varg0);
						 self->polish(qapp);
					} else {
						 rb_raise(rb_eArgError,"Error in polish() argmetns");
					}
			 }
		}


		void drawButton( QPainter *p, int x, int y, int w, int h,
		     const QColorGroup &g, bool sunken = FALSE,
		     const QBrush *fill = 0 );
		void drawBevelButton( QPainter *p, int x, int y, int w, int h,
			  const QColorGroup &g, bool sunken = FALSE,
			  const QBrush *fill = 0 );
		void drawFocusRect( QPainter*,
			const QRect&, const QColorGroup &, const QColor* qc =0, bool fl = FALSE );

		// "combo box"
		void drawComboButton( QPainter *p, int x, int y, int w, int h,
			  const QColorGroup &g, bool sunken = FALSE,
			  bool editable = FALSE,
			  bool enabled = TRUE,
			  const QBrush *fill = 0 );
		QRect comboButtonRect( int x, int y, int w, int h);
		QRect comboButtonFocusRect( int x, int y, int w, int h);


		void drawPushButton( QPushButton* btn, QPainter *p);

		void drawArrow( QPainter *p, ArrowType type, bool down,
		    int x, int y, int w, int h,
		    const QColorGroup &g, bool enabled, const QBrush *fill = 0 );
		QSize indicatorSize() const;
		void drawIndicator( QPainter* p, int x, int y, int w, int h,  const QColorGroup &g,
			int state, bool down = FALSE, bool enabled = TRUE );


		QSize exclusiveIndicatorSize() const;
		void drawExclusiveIndicator( QPainter* p,  int x, int y, int w, int h, const QColorGroup &g,
				 bool on, bool down = FALSE, bool enabled = TRUE );
		void drawExclusiveIndicatorMask( QPainter *p, int x, int y, int, int, bool );

		void tabbarMetrics( const QTabBar*, int&, int&, int& );
		void drawTab( QPainter*,  const QTabBar*, QTab*, bool selected );
		void drawTabMask( QPainter*,  const QTabBar*, QTab*, bool selected );

		void scrollBarMetrics( const QScrollBar*, int&, int&, int&, int&);
		void drawScrollBarControls( QPainter*,  const QScrollBar*, int sliderStart, uint controls, uint activeControl );

		int sliderLength() const;
		void drawSlider( QPainter *p,
			     int x, int y, int w, int h,
			     const QColorGroup &g,
			     Qt::Orientation, bool tickAbove, bool tickBelow);
		void drawSliderGroove( QPainter *p,
			   int x, int y, int w, int h,
			   const QColorGroup& g, QCOORD c,
			   Qt::Orientation );

		int splitterWidth() const;
		void drawSplitter( QPainter *p, int x, int y, int w, int h,
		       const QColorGroup &g, Qt::Orientation);


		void drawCheckMark( QPainter *p, int x, int y, int w, int h,
			     const QColorGroup &g,
			     bool act, bool dis );

		void polishPopupMenu( QPopupMenu* );
		int extraPopupMenuItemWidth( bool checkable, int maxpmw, QMenuItem* mi, const QFontMetrics& fm );
		int popupMenuItemHeight( bool checkable, QMenuItem* mi, const QFontMetrics& fm );
		void drawPopupMenuItem( QPainter* p, bool checkable, int maxpmw, int tab, QMenuItem* mi,
			    const QPalette& pal,
			    bool act, bool enabled, int x, int y, int w, int h);

/*
private:
		bool highlightCols;
private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QMotifStyle( const QMotifStyle & );
		QMotifStyle& operator=( const QMotifStyle & );
#endif
*/
};

//#endif
