/****************************************************************************
** $Id: qpainter.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QPainter class
**
** Created : 940112
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QPAINTER_H
//#define QPAINTER_H


//#ifndef QT_H
//#include "qpaintdevice.h"
//#include "qcolor.h"
//#include "qfontmetrics.h"
//#include "qfontinfo.h"
//#include "qregion.h"
//#include "qpen.h"
//#include "qbrush.h"
//#include "qpointarray.h"
//#include "qwmatrix.h"
//#endif // QT_H


class QTextCodec;


class QPainter : public Qt
{
public:
		 %extend {
				QPainter(VALUE w=Qnil) {
					 if (w == Qnil) {
							return new QPainter();
					 }   
					 else if ((TYPE(w) != T_DATA) && (TYPE(w) != T_NIL)) {
							rb_raise(rb_eArgError, "Qt object (DATA)or nil expected");
						 }
					 else if (TYPE(w) == T_NIL) {
							 return new QPainter();
						}
					 else if (rb_obj_is_kind_of(w,cQWidget) || TYPE(w) == T_NIL) {
									 QWidget * temp;
									 temp = (QWidget *)Get_QWidget(w);
								return new QPainter(temp);
							 }
					 else if (rb_obj_is_kind_of(w,cQPaintDevice) || TYPE(w) == T_NIL) {
									 QPaintDevice * temp;
									 temp = (QPaintDevice *)Get_QPaintDevice(w);
								return new QPainter(temp);
							 }
					 else {
						rb_raise(rb_eArgError, "QWidget or QPaintDevice object expected");
						}
				 }
			QPainter * QPainter_QWidget ( const QWidget * w) {
						return new QPainter(w);
				 }
			
			bool begin(VALUE w1, VALUE w2=Qnil) {

						if ((TYPE(w1) != T_DATA)) {
							rb_raise(rb_eArgError, "Qt object (DATA) expected");
						 }
					 else if (rb_obj_is_kind_of(w1,cQWidget)|| TYPE(w1) == T_NIL) {
									 QWidget * temp1;
									 temp1 = (QWidget *)Get_QWidget(w1);
									 if(w2 == Qnil) {
											return self->begin(temp1);
									 } else if(rb_obj_is_kind_of(w2,cQWidget) || TYPE(w2) == T_NIL) {
											QWidget * temp2;
											temp2 = (QWidget *)Get_QWidget(w2);
											return self->begin(temp1,temp2);
									 } else
									 rb_raise(rb_eArgError, "QWidget or QPaintDevice object expected");                   
							 }
					 else if (rb_obj_is_kind_of(w1,cQPaintDevice)|| TYPE(w1) == T_NIL) {
									 QPaintDevice * temp1;
									 temp1 = (QPaintDevice *)Get_QPaintDevice(w1);
									 if(w2 == Qnil) {
											return self->begin(temp1);
									 } else if(rb_obj_is_kind_of(w2,cQWidget) || TYPE(w2) == T_NIL) {
											QWidget * temp2;
											temp2 = (QWidget *)Get_QWidget(w2);
											return self->begin(temp1,temp2);
									 } else 
									 rb_raise(rb_eArgError, "QWidget or QPaintDevice object expected");
							 }
					 else {
						rb_raise(rb_eArgError, "QWidget or QPaintDevice object expected");
						}

				 } 
								
	}
//    QPainter();
//    QPainter( const QPaintDevice * );
//    QPainter( const QPaintDevice *, const QWidget * );
	 ~QPainter();

//    bool	begin( const QPaintDevice * );
//    bool	begin( const QPaintDevice *, const QWidget * );
		bool	end();
		QPaintDevice *device() const;

#ifdef _WS_QWS_
    QGfx * internalGfx();
#endif

		static void redirect( QPaintDevice *pdev, QPaintDevice *replacement );

		bool	isActive() const;

		void	flush();
		void	save();
		void	restore();

	// Drawing tools

		QFontMetrics fontMetrics()	const;
		QFontInfo	 fontInfo()	const;

		const QFont &font()		const;
		void	setFont( const QFont & );
		const QPen &pen()		const;
//    void	setPen( const QPen & );

		//RENAME %name(setPenPenStyle) void	setPen( PenStyle );

		//RENAME %name(setPenQColor) void	setPen( const QColor & );

		%extend {
			 void setPen(VALUE varg0) {
					if(rb_obj_is_kind_of(varg0,cQPen)) {
						 QPen* qpen;
						 qpen = (QPen *)Get_QPen(varg0);
						 self->setPen(*qpen);
					} else if(rb_obj_is_kind_of(varg0,cQColor)) {
						 QColor* qcol;
						 qcol = (QColor *)Get_QColor(varg0);
						 self->setPen(*qcol);
					} else if(TYPE(varg0) == T_FIXNUM) {
						 QPen::PenStyle pst;
						 pst = (QPen::PenStyle)NUM2INT(varg0);
						 self->setPen(pst);
					} else {
						 rb_raise(rb_eArgError,"Error in setPen() argments");
					}
			 }
		}

		const QBrush &brush()	const;
//    void	setBrush( const QBrush & );

		//RENAME %name(setBrushBrushStyle) void	setBrush( BrushStyle );

		//RENAME %name(setBrushQColor) void	setBrush( const QColor & );

		%extend {
			 void setBrush(VALUE varg0) {
					if(rb_obj_is_kind_of(varg0,cQBrush)) {
						 QBrush* qbr;
						 qbr = (QBrush *)Get_QBrush(varg0);
						 self->setBrush(*qbr);
					} else if(rb_obj_is_kind_of(varg0,cQColor)) {
						 QColor* qcol;
						 qcol = (QColor *)Get_QColor(varg0);
						 self->setBrush(*qcol);
					} else if(TYPE(varg0) == T_FIXNUM) {
						 QPen::BrushStyle bst;
						 bst = (QPen::BrushStyle)NUM2INT(varg0);
						 self->setBrush(bst);
					} else {
						 rb_raise(rb_eArgError,"Error in setBrush() argments");
					}
			 }
		}


		QPoint	pos() const;

	// Drawing attributes/modes

		const QColor &backgroundColor() const;
		void	setBackgroundColor( const QColor & );
		BGMode	backgroundMode() const;
		void	setBackgroundMode( BGMode );
		RasterOp	rasterOp()	const;
		void	setRasterOp( RasterOp );
		const QPoint &brushOrigin() const;
//    void	setBrushOrigin( int x, int y );

		//RENAME %name(setBrushOriginQPoint) void	setBrushOrigin( const QPoint & );
		
		%extend {
			 void setBrushOrigin(VALUE varg0,VALUE varg1=Qnil) {
					if(varg1 == Qnil) {
						 QPoint *qp;
						 qp = (QPoint *)Get_QPoint(varg0);
						 self->setBrushOrigin(*qp);
					} else {
						 int x,y;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 self->setBrushOrigin(x,y);
					}
			 }
		}

	// Scaling and transformations

//    PaintUnit unit()	       const;		// get set painter unit
//    void	setUnit( PaintUnit );		// NOT IMPLEMENTED!!!

		bool	hasViewXForm() const;
		bool	hasWorldXForm() const;

#ifndef QT_NO_TRANSFORMATIONS
		void	setViewXForm( bool );		// set xform on/off

		QRect	window()       const;		// get window

		//RENAME %name(setWindowQRect)void	setWindow( const QRect & );	// set window
//    void	setWindow( int x, int y, int w, int h );

		%extend {
			 void setWindow(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					if(varg1 == Qnil) {
						 QRect* qrect;
						 qrect = (QRect *)Get_QRect(varg0);
						 self->setWindow(*qrect);
					} else {
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 self->setWindow(x,y,w,h);
					}
			 }
		}
							

		QRect	viewport()   const;		// get viewport

		//RENAME %name(setViewportQRect) void	setViewport( const QRect & );	// set viewport

//    void	setViewport( int x, int y, int w, int h );
		%extend {
			 void setViewport(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					if(varg1 == Qnil) {
						 QRect* qrect;
						 qrect = (QRect *)Get_QRect(varg0);
						 self->setViewport(*qrect);
					} else {
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 self->setViewport(x,y,w,h);
					}
			 }
		}
							

		void	setWorldXForm( bool );		// set world xform on/off
		const QWMatrix &worldMatrix() const;	// get/set world xform matrix
		void	setWorldMatrix( const QWMatrix &, bool combine=FALSE );

		void	saveWorldMatrix();
		void	restoreWorldMatrix();


		void	scale( double sx, double sy );
		void	shear( double sh, double sv );
		void	rotate( double a );
#endif

		void	translate( double dx, double dy );
		void	resetXForm();

//    QPoint	xForm( const QPoint & ) const;	// map virtual -> device

		//RENAME %name(xFormQRect) QRect	xForm( const QRect & )	const;

		//RENAME %name(xFormQPointArray) QPointArray xForm( const QPointArray & ) const;

		//RENAME %name(xFormQPointArrayIndex) QPointArray xForm( const QPointArray &, int index, int npoints ) const;

			 
//    QPoint	xFormDev( const QPoint & ) const; // map device -> virtual

		//RENAME %name(xForDevQRect) QRect	xFormDev( const QRect & )  const;

		//RENAME %name(xForDevQPointArray) QPointArray xFormDev( const QPointArray & ) const;

		//RENAME %name(xForDevQPointArrayIndex) QPointArray xFormDev( const QPointArray &, int index, int npoints ) const;

		%extend {
			 VALUE xForm(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					VALUE vresult=Qnil;
					if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint* qp;
						 QPoint* result;
						 qp = (QPoint *)Get_QPoint(varg0);
						 result = new QPoint(self->xForm(*qp));
						 CHECK_PTR(result);
						 vresult = Wrap_QPoint(cQPoint,result);
						 return vresult;
					} else if(rb_obj_is_kind_of(varg0,cQRect)) {
						 QRect* qrect;
						 QRect* result;
						 qrect = (QRect *)Get_QRect(varg0);
						 result = new QRect(self->xForm(*qrect));
						 CHECK_PTR(result);
						 vresult = Wrap_QRect(cQRect,result);
						 return vresult;
					} else if(rb_obj_is_kind_of(varg0,cQPointArray) &&
										varg1 == Qnil) {
						 QPointArray* qary;
						 QPointArray* result;
						 qary = (QPointArray *)Get_QPointArray(varg0);
						 result = new QPointArray(self->xForm(*qary));
						 CHECK_PTR(result);
						 vresult = Wrap_QPointArray(cQPointArray,result);
						 return vresult;             
					} else if(rb_obj_is_kind_of(varg0,cQPointArray)) {
						 QPointArray* qary;
						 int index,npoints;
						 QPointArray* result;
						 qary = (QPointArray *)Get_QPointArray(varg0);
						 index = NUM2INT(varg1);
						 npoints = NUM2INT(varg2);
						 result = new QPointArray(self->xForm(*qary,index,npoints));
						 CHECK_PTR(result);
						 vresult = Wrap_QPointArray(cQPointArray,result);
						 return vresult;  
					} else {
						 rb_raise(rb_eArgError,"Error in xForm() argments");
					}
			 }
			 VALUE xFormDev(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					VALUE vresult=Qnil;
					if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint* qp;
						 QPoint* result;
						 qp = (QPoint *)Get_QPoint(varg0);
						 result = new QPoint(self->xFormDev(*qp));
						 CHECK_PTR(result);
						 vresult = Wrap_QPoint(cQPoint,result);
						 return vresult;
					} else if(rb_obj_is_kind_of(varg0,cQRect)) {
						 QRect* qrect;
						 QRect* result;
						 qrect = (QRect *)Get_QRect(varg0);
						 result = new QRect(self->xFormDev(*qrect));
						 CHECK_PTR(result);
						 vresult = Wrap_QRect(cQRect,result);
						 return vresult;
					} else if(rb_obj_is_kind_of(varg0,cQPointArray) &&
										varg1 == Qnil) {
						 QPointArray* qary;
						 QPointArray* result;
						 qary = (QPointArray *)Get_QPointArray(varg0);
						 result = new QPointArray(self->xFormDev(*qary));
						 CHECK_PTR(result);
						 vresult = Wrap_QPointArray(cQPointArray,result);
						 return vresult;             
					} else if(rb_obj_is_kind_of(varg0,cQPointArray)) {
						 QPointArray* qary;
						 int index,npoints;
						 QPointArray* result;
						 qary = (QPointArray *)Get_QPointArray(varg0);
						 index = NUM2INT(varg1);
						 npoints = NUM2INT(varg2);
						 result = new QPointArray(self->xFormDev(*qary,index,npoints));
						 CHECK_PTR(result);
						 vresult = Wrap_QPointArray(cQPointArray,result);
						 return vresult;  
					} else {
						 rb_raise(rb_eArgError,"Error in xFormDev() argments");
					}
			 }   
		}            
						 
	// Clipping

		void	setClipping( bool );		// set clipping on/off
		bool	hasClipping() const;
		const QRegion &clipRegion() const;

		//RENAME %name(setClipRectQRect) void	setClipRect( const QRect & );	// set clip rectangle

//    void	setClipRect( int x, int y, int w, int h );

		%extend {
			 void setClipRect(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					if(varg1 == Qnil) {
						 QRect* qrect;
						 qrect = (QRect *)Get_QRect(varg0);
						 self->setClipRect(*qrect);
					} else {
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 self->setClipRect(x,y,w,h);
					}
			 }
		}
							

		void	setClipRegion( const QRegion &);// set clip region

	// Graphics drawing functions

//    void	drawPoint( int x, int y );

		//RENAME %name(drawPointQPoint) void	drawPoint( const QPoint & );

		%extend {
			 void drawPoint(VALUE varg0,VALUE varg1=Qnil) {
					if(varg1 == Qnil) {
						 QPoint* qp;
						 qp = (QPoint *)Get_QPoint(varg0);
						 self->drawPoint(*qp);
					} else {
						 int x,y;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 self->drawPoint(x,y);
					}
			 }
		}

		void	drawPoints( const QPointArray& a,
			    int index=0, int npoints=-1 );
//    void	moveTo( int x, int y );

		//RENAME %name(moveToQPoint) void	moveTo( const QPoint & );

		%extend {
			 void moveTo(VALUE varg0,VALUE varg1=Qnil) {
					if(varg1 == Qnil) {
						 QPoint* qp;
						 qp = (QPoint *)Get_QPoint(varg0);
						 self->moveTo(*qp);
					} else {
						 int x,y;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 self->moveTo(x,y);
					}
			 }
		}


//    void	lineTo( int x, int y );

		//RENAME %name(lineToQPoint) void	lineTo( const QPoint & );

		%extend {
			 void lineTo(VALUE varg0,VALUE varg1=Qnil) {
					if(varg1 == Qnil) {
						 QPoint* qp;
						 qp = (QPoint *)Get_QPoint(varg0);
						 self->lineTo(*qp);
					} else {
						 int x,y;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 self->lineTo(x,y);
					}
			 }
		}


//    void	drawLine( int x1, int y1, int x2, int y2 );

		//RENAME %name(drawLineQPoint) void	drawLine( const QPoint &, const QPoint & );

		%extend {
			 void drawLine(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQPoint) &&
						 rb_obj_is_kind_of(varg1,cQPoint)) { 
						 QPoint* qp1;
						 QPoint* qp2;
						 qp1 = (QPoint *)Get_QPoint(varg0);
						 qp2 = (QPoint *)Get_QPoint(varg1);
						 self->drawLine(*qp1,*qp2);
					} else {
						 int x1,y1,x2,y2;
						 x1 = NUM2INT(varg0);
						 y1 = NUM2INT(varg1);
						 x2 = NUM2INT(varg2);
						 y2 = NUM2INT(varg3);
						 self->drawLine(x1,y1,x2,y2);
					}
			 }
		}

//    void	drawRect( int x, int y, int w, int h );

		//RENAME %name(drawRectQRect) void	drawRect( const QRect & );
		
		%extend {
			 void drawRect(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQRect)) {
						 QRect* qrect;
						 qrect = (QRect *)Get_QRect(varg0);
						 self->drawRect(*qrect);
					} else {
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 self->drawRect(x,y,w,h);
					}
			 }
		}

//    void	drawWinFocusRect( int x, int y, int w, int h );

		//RENAME %name(drawWinFocusRectQColor) void	drawWinFocusRect( int x, int y, int w, int h,
		//RENAME				  const QColor &bgColor );

		//RENAME %name(drawWinFocusRectQRect) void	drawWinFocusRect( const QRect & );

		//RENAME %name(drawWinFocusRectQRectQColor) void	drawWinFocusRect( const QRect &,
		//RENAME				  const QColor &bgColor );

		%extend {
			 void drawWinFocusRect(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil,
										 VALUE varg4=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQRect)) {
						 QRect* qrect;
						 qrect = (QRect *)Get_QRect(varg0);
						 if(varg1 == Qnil) {
								self->drawWinFocusRect(*qrect);
						 } else {
								QColor* qcol;
								qcol = (QColor *)Get_QColor(varg1);
								self->drawWinFocusRect(*qrect,*qcol);
						 }     
					} else {
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 if(varg4 == Qnil) {
								self->drawWinFocusRect(x,y,w,h);
						 } else {
								QColor* qcol;
								qcol = (QColor *)Get_QColor(varg4);
								self->drawWinFocusRect(x,y,w,h,*qcol);
						 }
					}
			 }
		}



//    void	drawRoundRect( int x, int y, int w, int h, int, int );

		//RENAME %name(drawRoundRectQRectInt) void	drawRoundRect( const QRect &, int, int );

		//RENAME %name(drawRoundRectXY) void	drawRoundRect( int x, int y, int w, int h );

		//RENAME %name(drawRoundRectQRect) void	drawRoundRect( const QRect & );

		%extend {
			 void drawRoundRect(VALUE varg0,VALUE varg1=Qnil, VALUE varg2=Qnil, VALUE varg3=Qnil,
													VALUE varg4=Qnil,VALUE varg5=Qnil) {
						if(rb_obj_is_kind_of(varg0,cQRect)) {
							 QRect* qrect;
							 qrect = (QRect *)Get_QRect(varg0);
							 if(varg1 == Qnil) {
									self->drawRoundRect(*qrect);
							 }else {
									int cint1,cint2;
									cint1 = NUM2INT(varg1);
									cint2 = NUM2INT(varg2);
									self->drawRoundRect(*qrect,cint1,cint2);
							 }
						} else {
							 int x,y,w,h,cint1,cint2;
							 x = NUM2INT(varg0);
							 y = NUM2INT(varg1);
							 w = NUM2INT(varg2);
							 h = NUM2INT(varg3);
							 if(varg4 == Qnil) {
									self->drawRoundRect(x,y,w,h);
							 }else {
									cint1 = NUM2INT(varg4);
									cint2 = NUM2INT(varg5);
									self->drawRoundRect(x,y,w,h,cint1,cint2);
							 }
						}
				 }
			}
									
							 
//    void	drawEllipse( int x, int y, int w, int h );

		//RENAME %name(drawEllipseQRect) void	drawEllipse( const QRect & );

		%extend {
			 void drawEllipse(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQRect)) {
						 QRect* qrect;
						 qrect = (QRect *)Get_QRect(varg0);
						 self->drawEllipse(*qrect);
					} else {
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 self->drawEllipse(x,y,w,h);
					}
			 }
		}


//    void	drawArc( int x, int y, int w, int h, int a, int alen );

		//RENAME %name(drawArcQRect) void	drawArc( const QRect &, int a, int alen );

		%extend {
			 void drawArc(VALUE varg0,VALUE varg1,VALUE varg2,VALUE varg3=Qnil,
										VALUE varg4=Qnil,VALUE varg5=Qnil) {
						int a,alen;
						if(rb_obj_is_kind_of(varg0,cQRect)) {
							 QRect* qrect;
							 qrect = (QRect *)Get_QRect(varg0);
							 a = NUM2INT(varg1);
							 alen = NUM2INT(varg2);
							 self->drawArc(*qrect,a,alen);
						} else {
							 int x,y,w,h;
							 x = NUM2INT(varg0);
							 y = NUM2INT(varg1);
							 w = NUM2INT(varg2);
							 h = NUM2INT(varg3);   
							 a = NUM2INT(varg4);
							 alen = NUM2INT(varg5);
							 self->drawArc(x,y,w,h,a,alen);
					 }
				}
		 }            

//    void	drawPie( int x, int y, int w, int h, int a, int alen );

		//RENAME %name(drawPieQRect) void	drawPie( const QRect &, int a, int alen );

		%extend {
			 void drawPie(VALUE varg0,VALUE varg1,VALUE varg2,VALUE varg3=Qnil,
										VALUE varg4=Qnil,VALUE varg5=Qnil) {
						int a,alen;
						if(rb_obj_is_kind_of(varg0,cQRect)) {
							 QRect* qrect;
							 qrect = (QRect *)Get_QRect(varg0);
							 a = NUM2INT(varg1);
							 alen = NUM2INT(varg2);
							 self->drawPie(*qrect,a,alen);
						} else {
							 int x,y,w,h;
							 x = NUM2INT(varg0);
							 y = NUM2INT(varg1);
							 w = NUM2INT(varg2);
							 h = NUM2INT(varg3);   
							 a = NUM2INT(varg4);
							 alen = NUM2INT(varg5);
							 self->drawPie(x,y,w,h,a,alen);
					 }
				}
		 }            


//    void	drawChord( int x, int y, int w, int h, int a, int alen );

		//RENAME %name(drawChordQRect) void	drawChord( const QRect &, int a, int alen );

		%extend {
			 void drawChord(VALUE varg0,VALUE varg1,VALUE varg2,VALUE varg3=Qnil,
										VALUE varg4=Qnil,VALUE varg5=Qnil) {
						int a,alen;
						if(rb_obj_is_kind_of(varg0,cQRect)) {
							 QRect* qrect;
							 qrect = (QRect *)Get_QRect(varg0);
							 a = NUM2INT(varg1);
							 alen = NUM2INT(varg2);
							 self->drawChord(*qrect,a,alen);
						} else {
							 int x,y,w,h;
							 x = NUM2INT(varg0);
							 y = NUM2INT(varg1);
							 w = NUM2INT(varg2);
							 h = NUM2INT(varg3);   
							 a = NUM2INT(varg4);
							 alen = NUM2INT(varg5);
							 self->drawChord(x,y,w,h,a,alen);
					 }
				}
		 }            


		void	drawLineSegments( const QPointArray &,
				  int index=0, int nlines=-1 );
		void	drawPolyline( const QPointArray &,
			      int index=0, int npoints=-1 );
		void	drawPolygon( const QPointArray &, bool winding=FALSE,
			     int index=0, int npoints=-1 );
		void	drawQuadBezier( const QPointArray &, int index=0 );
//    void	drawPixmap( int x, int y, const QPixmap &,
//			    int sx=0, int sy=0, int sw=-1, int sh=-1 );

		//RENAME %name(drawPixmapQPointQRect) void	drawPixmap( const QPoint &, const QPixmap &,
		//RENAME			    const QRect &sr );

		//RENAME %name(drawPixmapQPoint) void	drawPixmap( const QPoint &, const QPixmap & );

		%extend {
			 void drawPixmap(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil,
											 VALUE varg4=Qnil,VALUE varg5=Qnil,VALUE varg6=Qnil) {
						QPixmap* pixmap;
						if(rb_obj_is_kind_of(varg0,cQPoint)) {
							 QPoint* qp;
							 qp = (QPoint *)Get_QPoint(varg0);
							 pixmap = (QPixmap *)Get_QPixmap(varg1);
							 if(varg2 == Qnil) {
									self->drawPixmap(*qp,*pixmap);
							 } else {
									QRect* qrect;
									qrect = (QRect *)Get_QRect(varg2);
									self->drawPixmap(*qp,*pixmap,*qrect);
							 }
						} else {
							 int x,y,sx=0,sy=0,sw=-1,sh=-1;   
							 x = NUM2INT(varg0);
							 y = NUM2INT(varg1);
							 pixmap = (QPixmap *)Get_QPixmap(varg2);
							 if(varg3 != Qnil)
									 sx = NUM2INT(varg3);
							 if(varg4 != Qnil)
									 sy = NUM2INT(varg4);
							 if(varg5 != Qnil)
									 sw = NUM2INT(varg5);
							 if(varg6 != Qnil)
									 sh = NUM2INT(varg6);
							 self->drawPixmap(x,y,*pixmap,sx,sy,sw,sh);
						}
				 }
			}
					

//    void	drawImage( int x, int y, const QImage &,
//			   int sx=0, int sy=0, int sw=-1, int sh=-1 );

		//RENAME %name(drawImageQPointQRect) void	drawImage( const QPoint &, const QImage &,
		//RENAME			   const QRect &sr );

		//RENAME %name(drawImageQPoint) void	drawImage( const QPoint &, const QImage & );

		%extend {
			 void drawImage(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil,
											 VALUE varg4=Qnil,VALUE varg5=Qnil,VALUE varg6=Qnil) {
						QImage* image;
						if(rb_obj_is_kind_of(varg0,cQPoint)) {
							 QPoint* qp;
							 qp = (QPoint *)Get_QPoint(varg0);
							 image = (QImage *)Get_QImage(varg1);
							 if(varg2 == Qnil) {
									self->drawImage(*qp,*image);
							 } else {
									QRect* qrect;
									qrect = (QRect *)Get_QRect(varg2);
									self->drawImage(*qp,*image,*qrect);
							 }
						} else {
							 int x,y,sx=0,sy=0,sw=-1,sh=-1;   
							 x = NUM2INT(varg0);
							 y = NUM2INT(varg1);
							 image = (QImage *)Get_QImage(varg2);
							 if(varg3 != Qnil)
									 sx = NUM2INT(varg3);
							 if(varg4 != Qnil)
									 sy = NUM2INT(varg4);
							 if(varg5 != Qnil)
									 sw = NUM2INT(varg5);
							 if(varg6 != Qnil)
									 sh = NUM2INT(varg6);
							 self->drawImage(x,y,*image,sx,sy,sw,sh);
						}
				 }
			}
					


//    void	drawTiledPixmap( int x, int y, int w, int h, const QPixmap &,
//				 int sx=0, int sy=0 );

		//RENAME %name(drawTiledPixmapQRectQPoint) void	drawTiledPixmap( const QRect &, const QPixmap &,
		//RENAME				 const QPoint & );
		//RENAME %name(drawTiledPixmapQRect) void	drawTiledPixmap( const QRect &, const QPixmap & );

		%extend {
			 void drawTiledPixmap(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil,
											 VALUE varg4=Qnil,VALUE varg5=Qnil,VALUE varg6=Qnil) {
						QPixmap* pixmap;
						if(rb_obj_is_kind_of(varg0,cQRect)) {
							 QRect* qrect;
							 qrect = (QRect *)Get_QRect(varg0);
							 pixmap = (QPixmap *)Get_QPixmap(varg1);
							 if(varg2 == Qnil) {
									self->drawTiledPixmap(*qrect,*pixmap);
							 } else {
									QPoint* qp;
									qp = (QPoint *)Get_QPoint(varg2);
									self->drawTiledPixmap(*qrect,*pixmap,*qp);
							 }
						} else {
							 int x,y,w,h,sx=0,sy=0;   
							 x = NUM2INT(varg0);
							 y = NUM2INT(varg1);
							 w = NUM2INT(varg2);
							 h = NUM2INT(varg3);
							 pixmap = (QPixmap *)Get_QPixmap(varg4);
							 if(varg5 != Qnil)
									 sx = NUM2INT(varg5);
							 if(varg6 != Qnil)
									 sy = NUM2INT(varg6);
							 self->drawTiledPixmap(x,y,w,h,*pixmap,sx,sy);
						}
				 }
			}


#ifndef QT_NO_PICTURE
		void	drawPicture( const QPicture & );
#endif

//    void	fillRect( int x, int y, int w, int h, const QBrush & );
//
		//RENAME %name(fillRectQRect) void	fillRect( const QRect &, const QBrush & );

		%extend {
			 void fillRect(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil,
										 VALUE varg4=Qnil) {
						QBrush* br;
						if(rb_obj_is_kind_of(varg0,cQRect)) {
							 QRect* qrect;
							 qrect = (QRect *)Get_QRect(varg0);
							 br = (QBrush *)Get_QBrush(varg1);
							 self->fillRect(*qrect,*br);
						} else {
							 int x,y,w,h;
							 x = NUM2INT(varg0);
							 y = NUM2INT(varg1);
							 w = NUM2INT(varg2);
							 h = NUM2INT(varg3);
							 br = (QBrush *)Get_QBrush(varg4);
							 self->fillRect(x,y,w,h,*br);
						}
				 }
			}

//    void	eraseRect( int x, int y, int w, int h );

		//RENAME %name(eraseRectQRect) void	eraseRect( const QRect & );

		%extend {
			 void eraseRect(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					if(varg1 == Qnil) {
						 QRect* qrect;
						 qrect = (QRect *)Get_QRect(varg0);
						 self->eraseRect(*qrect);
					} else {
						 int x,y,w,h;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 w = NUM2INT(varg2);
						 h = NUM2INT(varg3);
						 self->eraseRect(x,y,w,h);
					}
			 }
		}


	// Text drawing functions

//    void	drawText( int x, int y, const QString &, int len = -1 );

		//RENAME %name(drawTextQPoint ) void	drawText( const QPoint &, const QString &, int len = -1 );

		//RENAME %name(drawTextXYWH ) void	drawText( int x, int y, int w, int h, int flags,
		//RENAME			  const QString&, int len = -1, QRect *br=0,
		//RENAME			  char **internal=0 );

		//RENAME %name(drawTextQRect ) void	drawText( const QRect &, int flags,
		//RENAME			  const QString&, int len = -1, QRect *br=0,
		//RENAME			  char **internal=0 );

	 %extend {
			void drawText(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil,
										VALUE varg4=Qnil,VALUE varg5=Qnil,VALUE varg6=Qnil,VALUE varg7=Qnil) {
					 QString* text;
					 int len=-1;
					 if(rb_obj_is_kind_of(varg0,cQPoint)) {
							QPoint* qp;
							qp = (QPoint *)Get_QPoint(varg0);
							text = (QString *)Get_QString(varg1);
							if(varg2 != Qnil)
								 len = NUM2INT(varg2);
							self->drawText(*qp,*text,len);
					 } else if(rb_obj_is_kind_of(varg0,cQRect)) {
							QRect* qrect;
							int flags;
							QRect* br=0;
							qrect = (QRect *)Get_QRect(varg0);
							flags = NUM2INT(varg1);
							text = (QString *)Get_QString(varg2);
							if(varg3 != Qnil)
								 len = NUM2INT(varg3);
							if(varg4 != Qnil)
								 br = (QRect *)Get_QRect(varg4);
							self->drawText(*qrect,flags,*text,len,br);
					 } else if(TYPE(varg0) == T_FIXNUM &&
										 TYPE(varg1) == T_FIXNUM &&
										 (rb_obj_is_kind_of(varg2,cQString) ||
										 TYPE(varg2) == T_STRING)) {
							int x,y;
							int len=-1;
							QString* qstr;
							x = NUM2INT(varg0);
							y = NUM2INT(varg1);
							qstr = (QString *)Get_QString(varg2);
							if(varg3 != Qnil)
								 len = NUM2INT(varg3);
							self->drawText(x,y,*qstr,len);
					} else {
							int x,y,w,h,flags;
							QRect* br=0;
							x = NUM2INT(varg0);
							y = NUM2INT(varg1);
							w = NUM2INT(varg2);
							h = NUM2INT(varg3);
							flags = NUM2INT(varg4);
							text = (QString *)Get_QString(varg5);
							if(varg6 != Qnil)
									len = NUM2INT(varg6);
							if(varg7 != Qnil)
									br = (QRect *)Get_QRect(varg7);
							self->drawText(x,y,w,h,flags,*text,len,br);
					 }
				}
		 }


		//#####    void	drawText( const QPoint &, const QString &, int flags, int rotation = 0);

	// Text drawing functions

//    QRect	boundingRect( int x, int y, int w, int h, int flags,
//			      const QString&, int len = -1, char **intern=0 );

		//RENAME %name(boundingRectQRect) QRect	boundingRect( const QRect &, int flags,
		//RENAME			      const QString&, int len = -1, char **intern=0 );

	 %extend {
			QRect boundingRect(VALUE varg0,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil,
										VALUE varg4=Qnil,VALUE varg5=Qnil,VALUE varg6=Qnil) {
					 QString* text;
					 int len=-1;
					 int flags;
					 if(rb_obj_is_kind_of(varg0,cQRect)) {
							QRect* qrect;
							qrect = (QRect *)Get_QRect(varg0);
							flags = NUM2INT(varg1);
							text = (QString *)Get_QString(varg2);
							if(varg3 != Qnil)
								 len = NUM2INT(varg3);
							return (self->boundingRect(*qrect,flags,*text,len));
					 } else {
							int x,y,w,h;
							QRect* br=0;
							x = NUM2INT(varg0);
							y = NUM2INT(varg1);
							w = NUM2INT(varg2);
							h = NUM2INT(varg3);
							flags = NUM2INT(varg4);
							text = (QString *)Get_QString(varg5);
							if(varg6 != Qnil)
									len = NUM2INT(varg6);            
							return (self->boundingRect(x,y,w,h,flags,*text,len));
					 }
				}
		 }


		int		tabStops() const;
		void	setTabStops( int );
		int	       *tabArray() const;
		void	setTabArray( int * );

		// Other functions
/*    
#if defined(_WS_WIN_)
		HDC		handle() const;
#elif defined(_WS_X11_)
		HANDLE	handle() const;
#endif
*/
		
%name(initialize_Qt)		static void initialize();
		static void cleanup();
/*
private:
		void	init();
		void	updateFont();
		void	updatePen();
		void	updateBrush();
#ifndef QT_NO_TRANSFORMATIONS
		void	updateXForm();
		void	updateInvXForm();
#endif
		void	map( int, int, int *rx, int *ry ) const;
		void	map( int, int, int, int, int *, int *, int *, int * ) const;
		void	mapInv( int, int, int *, int * ) const;
		void	mapInv( int, int, int, int, int *, int *, int *, int * ) const;
		void	drawPolyInternal( const QPointArray &, bool close=TRUE );
		void	drawWinFocusRect( int x, int y, int w, int h, bool xorPaint,
				  const QColor &penColor );

		enum { IsActive=0x01, ExtDev=0x02, IsStartingUp=0x04, NoCache=0x08,
	   VxF=0x10, WxF=0x20, ClipOn=0x40, SafePolygon=0x80, MonoDev=0x100,
	   DirtyFont=0x200, DirtyPen=0x400, DirtyBrush=0x800,
	   RGBColor=0x1000, FontMet=0x2000, FontInf=0x4000, CtorBegin=0x8000,
					 UsePrivateCx = 0x10000, VolatileDC = 0x20000 };
		uint	flags;
		bool	testf( uint b ) const { return (flags&b)!=0; }
		void	setf( uint b )	{ flags |= b; }
		void	setf( uint b, bool v );
		void	clearf( uint b )	{ flags &= (uint)(~b); }
		void	fix_neg_rect( int *x, int *y, int *w, int *h );

		QPaintDevice *pdev;
		QColor	bg_col;
		uchar	bg_mode;
		uchar	rop;
		uchar	pu;
		QPoint	bro;
		QFont	cfont;
		QPen	cpen;
		QBrush	cbrush;
		QRegion	crgn;
		int		tabstops;
		int	       *tabarray;
		int		tabarraylen;

#ifndef QT_NO_TRANSFORMATIONS
		// Transformations
		QCOORD	wx, wy, ww, wh;
		QCOORD	vx, vy, vw, vh;
		QWMatrix	wxmat;

		// Cached composition (and inverse) of transformations
		QWMatrix	xmat;
		QWMatrix	ixmat;



		double	m11() const { return xmat.m11(); }
		double      m12() const { return xmat.m12(); }
		double      m21() const { return xmat.m21(); }
		double      m22() const { return xmat.m22(); }
		double      dx() const { return xmat.dx(); }
		double      dy() const { return xmat.dy(); }
		double	im11() const { return ixmat.m11(); }
		double      im12() const { return ixmat.m12(); }
		double      im21() const { return ixmat.m21(); }
		double      im22() const { return ixmat.m22(); }
		double      idx() const { return ixmat.dx(); }
		double      idy() const { return ixmat.dy(); }

		int		txop;
		bool	txinv;
#else
    // even without transformations we still have translations
    int         xlatex;
    int         xlatey;
#endif

		void       *penRef;				// pen cache ref
		void       *brushRef;			// brush cache ref
		void       *ps_stack;
		void       *wm_stack;
		void	killPStack();

protected:
#if defined(_WS_WIN_)
		HDC		hdc;				// device context
		HPEN	hpen;				// current pen
		HBRUSH	hbrush;				// current brush
		HBITMAP	hbrushbm;			// current brush bitmap
		HFONT	hfont;				// current font
		HPALETTE	holdpal;
		void       *textmet;			// text metrics
		uint	pixmapBrush : 1;
		uint	nocolBrush  : 1;
		uint	killFont    : 1;
		void       *textMetric();
		void	nativeXForm( bool );
#elif defined(_WS_X11_)
		Display    *dpy;				// current display
		WId		hd;				// handle to drawable
		GC		gc;				// graphics context (standard)
		GC		gc_brush;			// graphics contect for brush
		QPoint	curPt;				// current point
#elif defined(_WS_MAC_)
		int penx;
		int peny;
		void * hd;
#elif defined(_WS_QWS_)
    QGfx * gfx;
#endif
		friend class QFontMetrics;
		friend class QFontInfo;
		friend void qt_format_text( const QFontMetrics& fm, int x, int y, int w, int h,
		     int tf, const QString& str, int len, QRect *brect,
		     int tabstops, int* tabarray, int tabarraylen,
		     char **internal, QPainter* painter );

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QPainter( const QPainter & );
		QPainter &operator=( const QPainter & );
#endif
*/
};


//#endif // QPAINTER_H
