/****************************************************************************
** $Id: qpopupmenu.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
 ** Definition of QPopupMenu class
**
** Created : 941128
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/


#ifndef QPOPUPMENU_H
#define QPOPUPMENU_H

#ifndef QT_H
#include "qframe.h"
#include "qmenudata.h"
#endif // QT_H


class QPopupMenu : public QFrame //, public QMenuData
{
//    Q_OBJECT
//    Q_PROPERTY( bool checkable READ isCheckable WRITE setCheckable )
public:
		QPopupMenu( QWidget *parent=0, const char *name=0 );
//   ~QPopupMenu();

		void	popup( const QPoint & pos, int indexAtPoint = 0 );// open popup
		void	updateItem( int id );

		virtual void	setCheckable( bool );
		bool	isCheckable() const;

		void	setFont( const QFont & );	// reimplemented set font
		void	show();				// reimplemented show
		void	hide();				// reimplemented hide

//    int		exec();
		//RENAME %name(execQPoint) int 	exec( const QPoint & pos, int indexAtPoint = 0 );// modal popup
		%extend {
			 int exec(VALUE varg0=Qnil,VALUE varg1=Qnil) {
					if(varg0 == Qnil) {
						 return self->exec();
					} else {
						 QPoint* qp;
						 int indexAtPoint=0;
						 qp = (QPoint *)Get_QPoint(varg0);
						 if(varg1 != Qnil)
								 indexAtPoint = NUM2INT(varg1);
						 return (self->exec(*qp,indexAtPoint));
					}
			 }
		}


		virtual void	setActiveItem( int );
		QSize	sizeHint() const;

//    int 	idAt( int index ) const { return QMenuData::idAt( index ); }
		//RENAME %name(idAtQPoint) int 	idAt( const QPoint& pos ) const;
		
		%extend {
			 int idAt(VALUE varg0)  {
					if(TYPE(varg0) == T_FIXNUM) {
						 int index;
						 index = NUM2INT(varg0);
						 return self->idAt(index);
					} else {
						 QPoint* pos;
						 pos = (QPoint *)Get_QPoint(varg0);
						 return self->idAt(*pos);
					}
			 }
		}

		bool 	customWhatsThis() const;

		int	insertTearOffHandle( int id=-1, int index=-1 );

// QMenuData methods

		uint	count() const;

		%extend {
		int insertItem(VALUE varg0, VALUE varg1=Qnil, VALUE varg2=Qnil,
		 VALUE varg3=Qnil, VALUE varg4=Qnil, VALUE varg5=Qnil, VALUE varg6=Qnil) {
		 char* member = 0;
		 QObject* qobj = 0;
		 QString* qstr = 0;
		 QIconSet* qiset = 0;
		 QPixmap* qpixmap = 0;
		 QPixmap* qpixmap2 = 0;
		 QWidget* qwidget = 0;
		 int id = -1,index = -1,accel = 0,menuid;
		 QPopupMenu* qmenu = 0;
		 QCustomMenuItem* qcmenuitem = 0;
//    int insertItem( const QString &text,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
		 if((TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQObject) || TYPE(varg1) == T_NIL)
				 && (TYPE(varg2) == T_STRING)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)) {
						qstr = (QString *)Get_QString(varg0);
						qobj = (QObject *)Get_QObject(varg1);
						member = STR2CSTR(varg2);
						if(varg3 != Qnil) accel = NUM2INT(varg3);
						if(varg4 != Qnil) id = NUM2INT(varg4);
						if(varg5 != Qnil) index = NUM2INT(varg5);
						//menuid = self->insertItem(*qstr,qobj,member,accel,id,index);
						 menuid = self->insertItem(*qstr,id,index);
						 self->setAccel(accel,menuid);
						QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg1,member);
						return menuid;
						}
//    int insertItem( const QIconSet& icon,
//                    const QString &text,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString) || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQObject) || TYPE(varg2) == T_NIL)
				 && (TYPE(varg3) == T_STRING)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)
				 && (varg6 == Qnil || TYPE(varg6) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else{
						qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qstr = (QString *)Get_QString(varg1);
				 qobj = (QObject *)Get_QObject(varg2);
				 member = STR2CSTR(varg3);
				 if(varg4 != Qnil) accel = NUM2INT(varg4);
				 if(varg5 != Qnil) id = NUM2INT(varg5);
				 if(varg6 != Qnil) index = NUM2INT(varg6);
				 if(qpixmap != 0) {
						//menuid = self->insertItem(*qpixmap,*qstr,qobj,SLOT(member),accel,id,index);
				menuid = self->insertItem(*qpixmap,*qstr,id,index);
				self->setAccel(accel,menuid);
				} else {
						 //menuid = self->insertItem(*qiset,*qstr,qobj,SLOT(member),accel,id,index);
				 menuid = self->insertItem(*qiset,*qstr,id,index);
				 self->setAccel(accel,menuid);
				 }
				 QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg2,member);
				 return menuid;
				 }
//    int insertItem( const QPixmap &pixmap,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap)  || TYPE(varg0) == T_NIL)
				 && ((rb_obj_is_kind_of(varg1,cQObject)) || TYPE(varg1) == T_NIL)
				 && (TYPE(varg2) == T_STRING)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)) {
				 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 qobj = (QObject *)Get_QObject(varg1);
				 member = STR2CSTR(varg2);
				 if(varg3 != Qnil) accel = NUM2INT(varg3);
				 if(varg4 != Qnil) id = NUM2INT(varg4);
				 if(varg5 != Qnil) index = NUM2INT(varg5);
				 //menuid = self->insertItem(*qpixmap,qobj,member,accel,id,index);
				 menuid = self->insertItem(*qpixmap,id,index);
				 self->setAccel(accel,menuid);
				 QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg1,member);
				 return menuid;
				 }
//    int insertItem( const QIconSet& icon,
//                    const QPixmap &pixmap,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPixmap)  || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQObject)  || TYPE(varg2) == T_NIL)
				 && TYPE(varg3) == T_STRING
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)
				 && (varg6 == Qnil || TYPE(varg6) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
						qpixmap2 = (QPixmap *)Get_QPixmap(varg1);
				 } else {
						qiset = (QIconSet *)Get_QIconSet(varg0);
						qpixmap = (QPixmap *)Get_QPixmap(varg1);
				 }
				 qobj = (QObject *)Get_QObject(varg2);
				 member = STR2CSTR(varg3);
				 if(varg4 != Qnil) accel = NUM2INT(varg4);
				 if(varg5 != Qnil) id = NUM2INT(varg5);
				 if(varg6 != Qnil) index = NUM2INT(varg6);
				 if(qpixmap2 != 0) self->insertItem(*qpixmap,*qpixmap,qobj,member,accel,id,index);
				 //menuid = self->insertItem(*qiset,*qpixmap,qobj,member,accel,id,index);
				 menuid = self->insertItem(*qiset,*qpixmap,id,index);
				 self->setAccel(accel,menuid);
				 QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg2,member);
				 return menuid;
				 }
//    int  insertItem( const QString &text, int id=-1, int index=-1 );
			else if((TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qstr = (QString *)Get_QString(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(*qstr,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                      const QString &text, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString) || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else { 
						qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qstr = (QString *)Get_QString(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 if(qpixmap != 0) return self->insertItem(*qpixmap,*qstr,id,index);
				 else {
						return  self->insertItem(*qiset,*qstr,id,index);
				 }
				 }
//    int insertItem( const QString &text, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
		 else if((TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPopupMenu) || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 qstr = (QString *)Get_QString(varg0);
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 return self->insertItem(*qstr,qmenu,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                    const QString &text, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString) || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQPopupMenu) || TYPE(varg2) == T_NIL)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else{ 
						qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qstr = (QString *)Get_QString(varg1);
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg2);
				 if(varg3 != Qnil) id = NUM2INT(varg3);
				 if(varg4 != Qnil) index = NUM2INT(varg4);
				 if(qpixmap != 0) return self->insertItem(*qpixmap,*qstr,qmenu,id,index);
				 else return self->insertItem(*qiset,*qstr,qmenu,id,index);
				 }
//    int insertItem( const QPixmap &pixmap, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(*qpixmap,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                    const QPixmap &pixmap, int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPixmap)  || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
						qpixmap2 = (QPixmap *)Get_QPixmap(varg1);
				 } else {
						qiset = (QIconSet *)Get_QIconSet(varg0);
						qpixmap = (QPixmap *)Get_QPixmap(varg1);
				 }
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 if(qpixmap2 != 0) self->insertItem(*qpixmap,*qpixmap2,id,index);
				 else self->insertItem(*qiset,*qpixmap,id,index);
				 }
//    int insertItem( const QPixmap &pixmap, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap)  || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPopupMenu)  || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 return self->insertItem(*qpixmap,qmenu,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                    const QPixmap &pixmap, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPixmap)  || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQPopupMenu)  || TYPE(varg2) == T_NIL)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
						qpixmap2 = (QPixmap *)Get_QPixmap(varg1);
				 } else {
						qiset = (QIconSet *)Get_QIconSet(varg0);
						qpixmap = (QPixmap *)Get_QPixmap(varg1);
				 }
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg2);
				 if(varg3 != Qnil) id = NUM2INT(varg3);
				 if(varg4 != Qnil) index = NUM2INT(varg4);
				 if(qpixmap2 != 0) return self->insertItem(*qpixmap,*qpixmap2,qmenu,id,index);
				 else return self->insertItem(*qiset,*qpixmap,qmenu,id,index);
				 }

//    int insertItem( QWidget* widget, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQWidget) || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qwidget = (QWidget *)Get_QWidget(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(qwidget,id,index);
				 }
//    int insertItem( const QIconSet& icon, QCustomMenuItem* custom, int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQCustomMenuItem)  || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else {
						 qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qcmenuitem = (QCustomMenuItem *)Get_QCustomMenuItem(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 if(qpixmap != 0) return self->insertItem(*qpixmap,qcmenuitem,id,index);
				 else return self->insertItem(*qiset,qcmenuitem,id,index);
				 }
//    int insertItem( QCustomMenuItem* custom, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQCustomMenuItem)  || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qcmenuitem = (QCustomMenuItem *)Get_QCustomMenuItem(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(qcmenuitem,id,index);
				 }
			else {
				 rb_raise(rb_eArgError, "Type error in insertItem of QPopupmenu");
				 return 0;
				 }
		return 0;
		}
 
		}
		
/*
		%name(insertItemQObject) int	insertItem( const QString &text,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );

		%name(insertItemQIconSetQObject) int	insertItem( const QIconSet& icon,
			    const QString &text,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );

		%name(insertItemQPixmapQObject) int	insertItem( const QPixmap &pixmap,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );

		%name(insertItemQIconSetQPixmapQObject) int	insertItem( const QIconSet& icon,
			    const QPixmap &pixmap,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );


//    int	insertItem( const QString &text, int id=-1, int index=-1 );
		%name(insertItemQIconSetId) int insertItem( const QIconSet& icon,
			    const QString &text, int id=-1, int index=-1 );

		%name(insertItemQPopupMenu) int insertItem( const QString &text, QPopupMenu *popup,
			    int id=-1, int index=-1 );

		%name(insertItemQIconSetQPopupMenu) int insertItem( const QIconSet& icon,
			    const QString &text, QPopupMenu *popup,
			    int id=-1, int index=-1 );

		%name(insertItemQPixmapId) int insertItem( const QPixmap &pixmap, int id=-1, int index=-1 );

		%name(insertItemQIconSetQPixmapId) int insertItem( const QIconSet& icon,
			    const QPixmap &pixmap, int id=-1, int index=-1 );

		%name(insertItemQPixmapQPopupMenu) int insertItem( const QPixmap &pixmap, QPopupMenu *popup,
			    int id=-1, int index=-1 );

		%name(insertItemQIconSetQPixmapQPopupMenu) int insertItem( const QIconSet& icon,
			    const QPixmap &pixmap, QPopupMenu *popup,
			    int id=-1, int index=-1 );

		%name(insertItemQWidgetId) int insertItem( QWidget* widget, int id=-1, int index=-1 );

		%name(insertItemQIconSetQCustomMenuItem) int insertItem( const QIconSet& icon, QCustomMenuItem* custom, int id=-1, int index=-1 );

		%name(insertQCustomMenuItemId) int insertItem( QCustomMenuItem* custom, int id=-1, int index=-1 );
*/

		int		insertSeparator( int index=-1 );

		void	removeItem( int id )		; // { removeItemAt(indexOf(id)); }
		void	removeItemAt( int index );
		void	clear();

		int		accel( int id )		const;
		void	setAccel( int key, int id );

		QIconSet    *iconSet( int id )	const;
		QString text( int id )		const;
		QPixmap    *pixmap( int id )	const;

		void setWhatsThis( int id, const QString& );
		QString whatsThis( int id ) const;

%extend {
	 void changeItem(VALUE varg0, VALUE varg1, VALUE varg2=Qnil) 
	 {
			if(TYPE(varg0) == T_FIXNUM) {
				 if(TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1, cQString) || TYPE(varg1) == T_NIL) {
						int id = NUM2INT(varg0);
						if(rb_obj_is_kind_of(varg1,cQString) || TYPE(varg1) == T_NIL) {
							 QString *str;
							 str = (QString *)Get_QString(varg1);
							 self->changeItem(id,*str);
						} else {
							 QString str = STR2CSTR(varg1);
							 self->changeItem(id,str);
						}
				 } else if((rb_obj_is_kind_of(varg1, cQPixmap) || TYPE(varg1) == T_NIL) &&
									( varg2 == Qnil)) {
						int id = NUM2INT(varg0);
						QPixmap* pix;
						pix = (QPixmap *)Get_QPixmap(varg1);
						self->changeItem(id,*pix);
				 } else if(rb_obj_is_kind_of(varg1,cQPixmap) || TYPE(varg1) == T_NIL) {
						int id = NUM2INT(varg0);            
						QPixmap* pix;
						pix = (QPixmap *)Get_QPixmap(varg1);
						if(TYPE(varg2) == T_STRING) {
							 QString str = STR2CSTR(varg2);
							 self->changeItem(id,*pix,str);
						} else {
							 QString *str;
							 str = (QString *)Get_QString(varg2);
							 self->changeItem(id,*pix,*str);
						}
				 } else {
						int id = NUM2INT(varg0);
						QIconSet* icon;
						icon = (QIconSet *)Get_QIconSet(varg1);
						if(TYPE(varg2) == T_STRING) {
							 QString str = STR2CSTR(varg2);
							 self->changeItem(id,*icon,str);
						} else {
							 QString *str;
							 str = (QString *)Get_QString(varg2);
							 self->changeItem(id,*icon,*str);
						}
				 }
			}
	 }
}
 
//    void	changeItem( int id, const QString &text );
//    %name(changeItemQPixmap) void	changeItem( int id, const QPixmap &pixmap );
//    %name(changeItemQIconSet) void	changeItem( int id, const QIconSet &icon, const QString &text );
//    %name(changeItemQIconSetQPixmap) void	changeItem( int id, const QIconSet &icon, const QPixmap &pixmap );

//    void	changeItem( const QString &text, int id ); // obsolete
//    void	changeItem( const QPixmap &pixmap, int id ); // obsolete
//    void	changeItem( const QIconSet &icon, const QString &text, int id ); // obsolete


		bool	isItemEnabled( int id ) const;
		void	setItemEnabled( int id, bool enable );

		bool	isItemChecked( int id ) const;
		void	setItemChecked( int id, bool check );

//    virtual void updateItem( int id );

		int		indexOf( int id )	const;
//    int		idAt( int index )	const;
		virtual void	setId( int index, int id );

		bool	connectItem( int id,
			     const QObject *receiver, const char* member );
		bool	disconnectItem( int id,
				const QObject *receiver, const char* member );

		bool	setItemParameter( int id, int param );
		int	itemParameter( int id ) const;

		QMenuItem  *findItem( int id )	const;
		//%name(findItemQMenuData) QMenuItem  *findItem( int id, QMenuData ** parent )	const;

/*
signals:
		void	activated( int itemId );
		void	highlighted( int itemId );
		void	activatedRedirect( int itemId );// to parent menu
		void	highlightedRedirect( int itemId );
		void	aboutToShow();

protected:
		int 	itemHeight( int ) const;
		int 	itemHeight( QMenuItem* mi ) const;
		void 	drawItem( QPainter* p, int tab, QMenuItem* mi,
		   bool act, int x, int y, int w, int h);

		void 	drawContents( QPainter * );

		void 	closeEvent( QCloseEvent *e );
		void	paintEvent( QPaintEvent * );
		void	mousePressEvent( QMouseEvent * );
		void	mouseReleaseEvent( QMouseEvent * );
		void	mouseMoveEvent( QMouseEvent * );
		void	keyPressEvent( QKeyEvent * );
		void	focusInEvent( QFocusEvent * );
		void	focusOutEvent( QFocusEvent * );
		void	timerEvent( QTimerEvent * );
		void 	styleChange( QStyle& );
		int 	columns() const;

		bool focusNextPrevChild( bool next );

private slots:
		void	subActivated( int itemId );
		void	subHighlighted( int itemId );
		void	accelActivated( int itemId );
		void	accelDestroyed();
		void	modalActivation( int );

		void	subMenuTimer();
		void     toggleTearOff();

private:
		void	menuContentsChanged();
		void	menuStateChanged();
		void	menuInsPopup( QPopupMenu * );
		void	menuDelPopup( QPopupMenu * );
		void	frameChanged();

		void	actSig( int, bool = FALSE );
		void	hilitSig( int );
		virtual void	setFirstItemActive();
		void	hideAllPopups();
		void	hidePopups();
		bool	tryMenuBar( QMouseEvent * );
		void	byeMenuBar();

		int		itemAtPos( const QPoint & ) const;
		QRect		itemGeometry( int index ); // ## protected in 3.0
		void	updateSize();
		void	updateRow( int row );
		void	updateAccel( QWidget * );
		void	enableAccel( bool );

		QMenuItem  *selfItem;
		QAccel     *autoaccel;
		int popupActive;
		int tab;
		uint accelDisabled : 1;
		uint checkable : 1;
		uint connectModalRecursionSafety : 1;
		uint tornOff : 1;
		int maxPMWidth;
		int ncols;
		bool	tryMouseEvent( QPopupMenu *, QMouseEvent * );

		friend class QMenuData;
		friend class QMenuBar;

		void connectModal(QPopupMenu* receiver, bool doConnect);

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QPopupMenu( const QPopupMenu & );
		QPopupMenu &operator=( const QPopupMenu & );
#endif
*/
};


#endif // QPOPUPMENU_H
