/****************************************************************************
** $Id: qrect.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QRect class
**
** Created : 931028
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QRECT_H
//#define QRECT_H

//#ifndef QT_H
//#include "qsize.h"
//#endif // QT_H

//#if defined(topLeft)
//#error "Macro definition of topLeft conflicts with QRect"
// don't just silently undo people's defines: #undef topLeft
//#endif

class  QRect					// rectangle class
{
public:
		%extend {
			 QRect(VALUE varg0=Qnil,VALUE varg1=Qnil,VALUE varg2=Qnil,
						 VALUE varg3=Qnil) {
					 if(varg0 == Qnil) {
							return new QRect();
					 } else if (rb_obj_is_kind_of(varg0,cQPoint)) {
							QPoint* p1;
							p1 = (QPoint *)Get_QPoint(varg0);
							if(rb_obj_is_kind_of(varg0,cQPoint)) {
								 QPoint* p2;
								 p2 = (QPoint *)Get_QPoint(varg1);
								 return new QRect(*p1,*p2);
							} else {
								 QSize* qs;
								 qs = (QSize *)Get_QSize(varg1);
								 return new QRect(*p1,*qs);
							}
					 } else if(TYPE(varg0) == T_FIXNUM &&
										 TYPE(varg1) == T_FIXNUM &&
										 TYPE(varg2) == T_FIXNUM &&
										 TYPE(varg3) == T_FIXNUM ) {
							int x,y,x2,y2;
							x = NUM2INT(varg0);
							y = NUM2INT(varg1);
							x2 = NUM2INT(varg2);
							y2 = NUM2INT(varg3);
							return new QRect(x,y,x2,y2);
					} else {
						 rb_raise(rb_eArgError,"Error in QRect constructor");
					}
			 }
		}
//    QRect()	{ x1 = y1 = 0; x2 = y2 = -1; }
//    QRect( const QPoint &topleft, const QPoint &bottomright );
//    QRect( const QPoint &topleft, const QSize &size );

//    QRect( int left, int top, int width, int height );
		
		~QRect();
		
		bool   isNull()	const;
		bool   isEmpty()	const;
		bool   isValid()	const;
		QRect  normalize()	const;

		int	   left()	const;
		int	   top()	const;
		int	   right()	const;
		int	   bottom()	const;

		QCOORD &rLeft();
		QCOORD &rTop();
		QCOORD &rRight();
		QCOORD &rBottom();
	
		int	   x()		const;
		int	   y()		const;
		void   setLeft( int pos );
		void   setTop( int pos );
		void   setRight( int pos );
		void   setBottom( int pos );
		void   setX( int x );
		void   setY( int y );

		QPoint topLeft()	 const;
		QPoint bottomRight() const;
		QPoint topRight()	 const;
		QPoint bottomLeft()	 const;
		QPoint center()	 const;

		void   rect( int *OUTPUT, int *OUTPUT, int *OUTPUT, int *OUTPUT ) const;
		void   coords( int *OUTPUT, int *OUTPUT, int *OUTPUT, int *OUTPUT ) const;

		void   moveTopLeft( const QPoint &p );
		void   moveBottomRight( const QPoint &p );
		void   moveTopRight( const QPoint &p );
		void   moveBottomLeft( const QPoint &p );
		void   moveCenter( const QPoint &p );
		void   moveBy( int dx, int dy );

		void   setRect( int x, int y, int w, int h );
		void   setCoords( int x1, int y1, int x2, int y2 );

		QSize  size()	const;
		int	   width()	const;
		int	   height()	const;
		void   setWidth( int w );
		void   setHeight( int h );
		void   setSize( const QSize &s );
/*
		QRect  operator|(const QRect &r) const;
		QRect  operator&(const QRect &r) const;
		QRect&  operator|=(const QRect &r);
		QRect&  operator&=(const QRect &r);
*/
//    bool   contains( const QPoint &p, bool proper=FALSE ) const;
		//RENAME %name(containsQRect) bool   contains( const QRect &r, bool proper=FALSE ) const;
		
		%extend {
			 bool contains(VALUE varg0,VALUE varg1=Qnil) {
					bool proper=FALSE;
					if(varg1 != Qnil)
							proper = (varg1 == Qtrue) ? TRUE:FALSE;
					if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint* p;
						 p = (QPoint *)Get_QPoint(varg0);
						 return self->contains(*p,proper);
					} else {
						 QRect* r;
						 r = (QRect *)Get_QRect(varg0);
						 return self->contains(*r,proper);
					}
			 }
		}
 
		QRect  unite( const QRect &r ) const;
		%name(intersectAsQRect) QRect  intersect( const QRect &r ) const;
		bool   intersects( const QRect &r ) const;

					

//    friend Q_EXPORT bool operator==( const QRect &, const QRect & );
//    friend Q_EXPORT bool operator!=( const QRect &, const QRect & );
/*
private:
#if defined(_OS_MAC_)
		QCOORD y1;
		QCOORD x1;
		QCOORD y2;
		QCOORD x2;
#else
		QCOORD x1;
		QCOORD y1;
		QCOORD x2;
		QCOORD y2;
#endif
*/
};
//#endif // QRECT_H
