/****************************************************************************
** $Id: qregion.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QRegion class
**
** Created : 940514
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QREGION_H
//#define QREGION_H

//#ifndef QT_H
//#include "qshared.h"
//#include "qrect.h"
//#include "qstring.h"
//#endif // QT_H


class  QRegion
{
public:
		enum RegionType { Rectangle, Ellipse };

//    QRegion();
%extend {
	 QRegion(VALUE varg0= Qnil, VALUE varg1= Qnil, VALUE varg2= Qnil, VALUE varg3= Qnil,
	 VALUE varg4= Qnil) {
			if(varg0 == Qnil) {
				 return new QRegion();
			} else if(TYPE(varg0) == T_FIXNUM) {
				 int x,y,w,h;
				 QRegion::RegionType rtype=QRegion::Rectangle;
				 x = NUM2INT(varg0);
				 y = NUM2INT(varg1);
				 w = NUM2INT(varg2);
				 h = NUM2INT(varg3);
				 if(varg4 != Qnil) rtype = (QRegion::RegionType)NUM2INT(varg4);
				 return new QRegion(x,y,w,h,rtype);
			} else if(rb_obj_is_kind_of(varg0,cQRect) || TYPE(varg0) == T_NIL) {
				 QRect* arg0;
				 QRegion::RegionType rtype=QRegion::Rectangle;
				 arg0 = (QRect *)Get_QRect(varg0);
				 if(varg1 != Qnil) rtype = (QRegion::RegionType)NUM2INT(varg1);
				 return new QRegion(*arg0,rtype);
			} else if(rb_obj_is_kind_of(varg0,cQPointArray)  || TYPE(varg0) == T_NIL) {
				 QPointArray* qp;
				 bool winding=FALSE;
				 qp = (QPointArray *)Get_QPointArray(varg0);
				 if(varg1 != Qnil) {
						if (varg1 == Qtrue) winding = TRUE;
						else winding = FALSE;
						}
				 return new QRegion(*qp,winding);
			} else if(rb_obj_is_kind_of(varg0,cQBitmap)  || TYPE(varg0) == T_NIL) {
				 QBitmap* qb;
				 qb = (QBitmap *)Get_QBitmap(varg0);
				 return new QRegion(*qb);
			} else {
				 rb_raise(rb_eArgError, "Type error in QRegion constructor");
	 }    
	 }
}


//    QRegion( int x, int y, int w, int h, RegionType rtype = Rectangle );
//    QRegion( const QRect &, RegionType = Rectangle );
//    QRegion( const QPointArray &, bool winding=FALSE );
//    QRegion( const QRegion & );
//    QRegion( const QBitmap & );
	 ~QRegion();
//    QRegion &operator=( const QRegion & );

		bool    isNull()   const;
		bool    isEmpty()  const;

//    bool    contains( const QPoint &p ) const;
		//RENAME %name(containsQRect) bool    contains( const QRect &r )	const;
		%extend {
			 bool contains(VALUE varg0) {
					if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint* p;
						 p = (QPoint *)Get_QPoint(varg0);
						 return self->contains(*p);
					} else {
						 QRect* r;
						 r = (QRect *)Get_QRect(varg0);
						 return self->contains(*r);
					}
			 }
		}

		void    translate( int dx, int dy );

		QRegion unite( const QRegion & )	const;
		QRegion intersect( const QRegion &) const;
		QRegion subtract( const QRegion & ) const;
		QRegion eor( const QRegion & )	const;

		QRect   boundingRect() const;
//    QArray<QRect> rects() const;
/*
		QRegion operator|( const QRegion & ) const;
		QRegion operator+( const QRegion & ) const;
		QRegion operator&( const QRegion & ) const;
		QRegion operator-( const QRegion & ) const;
		QRegion operator^( const QRegion & ) const;
		QRegion& operator|=( const QRegion & );
		QRegion& operator+=( const QRegion & );
		QRegion& operator&=( const QRegion & );
		QRegion& operator-=( const QRegion & );
		QRegion& operator^=( const QRegion & );

		bool    operator==( const QRegion & )  const;
		bool    operator!=( const QRegion &r ) const
			{ return !(operator==(r)); }

#if defined(_WS_WIN_)
		HRGN    handle() const { return data->rgn; }
#elif defined(_WS_X11_)
		Region  handle() const { return data->rgn; }
#elif defined(_WS_MAC_)
		void *  handle() const { return data->rgn; }
#endif

		friend Q_EXPORT QDataStream &operator<<( QDataStream &, const QRegion & );
		friend Q_EXPORT QDataStream &operator>>( QDataStream &, QRegion & );

private:
		QRegion( bool );
		QRegion copy() const;
		void    detach();
#if defined(_WS_WIN_)
		QRegion winCombine( const QRegion &, int ) const;
#endif
		void    exec( const QByteArray &, int ver = 0 );
		struct QRegionData : public QShared {
#if defined(_WS_WIN_)
	HRGN   rgn;
#elif defined(_WS_X11_)
	Region rgn;
#elif defined(_WS_MAC_)
				void * rgn;
#endif
	bool   is_null;
		} *data;
*/    
		
};


#define QRGN_SETRECT		1		// region stream commands
#define QRGN_SETELLIPSE		2		//  (these are internal)
#define QRGN_SETPTARRAY_ALT	3
#define QRGN_SETPTARRAY_WIND	4
#define QRGN_TRANSLATE		5
#define QRGN_OR			6
#define QRGN_AND		7
#define QRGN_SUB		8
#define QRGN_XOR		9
#define QRGN_RECTS	       10



//#endif // QREGION_H
