/****************************************************************************
** $Id: qscrollbar.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QScrollBar class
**
** Created : 940427
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QSCROLLBAR_H
//#define QSCROLLBAR_H

class QTimer;

//#ifndef QT_H
//#include "qwidget.h"
//#include "qrangecontrol.h"
//#include "qdrawutil.h"
//#endif // QT_H


class QScrollBar : public QWidget //, public QRangeControl
{
/*
		Q_OBJECT
		Q_PROPERTY( int minValue READ minValue WRITE setMinValue )
		Q_PROPERTY( int maxValue READ maxValue WRITE setMaxValue )
		Q_PROPERTY( int lineStep READ lineStep WRITE setLineStep )
		Q_PROPERTY( int pageStep READ pageStep WRITE setPageStep )
		Q_PROPERTY( int value READ value WRITE setValue )
		Q_PROPERTY( bool tracking READ tracking WRITE setTracking )
		Q_PROPERTY( bool draggingSlider READ draggingSlider )
		Q_PROPERTY( Orientation orientation READ orientation WRITE setOrientation )
*/	
public:

%extend {
		QScrollBar(VALUE varg0, VALUE varg1 = Qnil, VALUE varg2 = Qnil, VALUE varg3 = Qnil,
							 VALUE varg4 = Qnil, VALUE varg5 =Qnil, VALUE varg6 = Qnil,
							 VALUE varg7 = Qnil) {
		QWidget* wparent;
		char* name=0;
		Qt::Orientation ori;
		int minValue, maxValue, pageStep,lineStep, value;
		if(rb_obj_is_kind_of(varg0,cQWidget)  || TYPE(varg0) == T_NIL) {
				 wparent = (QWidget *)Get_QWidget(varg0);
				 if(varg1 != Qnil) name = STR2CSTR(varg1);
				 return new QScrollBar(wparent,name);
		} else if(TYPE(varg0) == T_FIXNUM &&
					(rb_obj_is_kind_of(varg1,cQWidget)  || TYPE(varg0) == T_NIL)) {
				 ori = (Qt::Orientation)NUM2INT(varg0);
				 wparent = (QWidget *)Get_QWidget(varg1);
				 if(varg2 != Qnil) name = STR2CSTR(varg2);
				 return new  QScrollBar(ori,wparent,name);
		} else if(TYPE(varg0) == T_FIXNUM  &&
					TYPE(varg0) == T_FIXNUM &&
					TYPE(varg1) == T_FIXNUM &&
					TYPE(varg2) == T_FIXNUM &&
					TYPE(varg3) == T_FIXNUM &&
					TYPE(varg4) == T_FIXNUM &&
					TYPE(varg5) == T_FIXNUM &&
					(rb_obj_is_kind_of(varg6,cQWidget)  || TYPE(varg6) == T_NIL)) {

				 minValue = NUM2INT(varg0);
				 maxValue = NUM2INT(varg1);
				 lineStep = NUM2INT(varg2);
				 pageStep = NUM2INT(varg3);
				 value = NUM2INT(varg4);
				 ori = (Qt::Orientation)NUM2INT(varg5);
				 wparent = (QWidget *)Get_QWidget(varg6);
				if(varg7 != Qnil) name = STR2CSTR(varg7);
				return new QScrollBar(minValue,maxValue,lineStep, pageStep,value,ori,wparent,name);
		} else {
					 rb_raise(rb_eArgError, "Type error in QScrollBar constructor");
		}
	}
}


//    QScrollBar( QWidget *parent, const char *name=0 );
//    QScrollBar( Orientation, QWidget *parent, const char *name=0 );
//    QScrollBar( int minValue, int maxValue, int LineStep, int PageStep,
//		int value, Orientation,
//		QWidget *parent, const char *name=0 );
//
		virtual void setOrientation( Orientation );
		Orientation orientation() const;
		virtual void setTracking( bool enable );
		bool	tracking() const;
		bool	draggingSlider() const;

		virtual void setPalette( const QPalette & );
		QSize	sizeHint() const;
		QSizePolicy sizePolicy() const;

		int	 minValue() const;
		int	 maxValue() const;
		void setMinValue( int );
		void setMaxValue( int );
		int	 lineStep() const;
		int	 pageStep() const;
		void setLineStep( int );
		void setPageStep( int );
		int  value() const;
		void setValue( int );

//QRangeControl public methods:
//    int		value()		const;
//    void	setValue( int );
		void	addPage();
		void	subtractPage();
		void	addLine();
		void	subtractLine();

//    int		minValue()	const;
//    int		maxValue()	const;
		void	setRange( int minValue, int maxValue );

//    int		lineStep()	const;
//    int		pageStep()	const;
		void	setSteps( int line, int page );

		int		bound( int ) const;

		
/*
signals:
		void	valueChanged( int value );
		void	sliderPressed();
		void	sliderMoved( int value );
		void	sliderReleased();
		void	nextLine();
		void	prevLine();
		void	nextPage();
		void	prevPage();

protected:
		void 	wheelEvent( QWheelEvent * );
		void	keyPressEvent( QKeyEvent * );
		void	resizeEvent( QResizeEvent * );
		void	paintEvent( QPaintEvent * );

		void	mousePressEvent( QMouseEvent * );
		void	mouseReleaseEvent( QMouseEvent * );
		void	mouseMoveEvent( QMouseEvent * );

		void	valueChange();
		void	stepChange();
		void	rangeChange();

		int		sliderStart() const;
		QRect	sliderRect() const;

		void styleChange( QStyle& );

private slots:
		void doAutoRepeat();

private:
		void init();
		void positionSliderFromValue();
		int calculateValueFromSlider() const;

		void sliderMinMax( int &, int & )		const;
		void metrics( int &, int &, int &, int& )	const;

		void startAutoRepeat();
		void stopAutoRepeat();

		QStyle::ScrollControl pointOver( const QPoint &p ) const;

		int rangeValueToSliderPos( int val ) const;
		int sliderPosToRangeValue( int  val ) const;

		void action( QStyle::ScrollControl control );

		void drawControls( uint controls, uint activeControl ) const;
		void drawControls( uint controls, uint activeControl,
				QPainter *p ) const;
		
		uint pressedControl	 : 8;
		uint track		 : 1;
		uint clickedAt	 : 1;
		uint orient		 : 1;

		int slidePrevVal;
		QCOORD sliderPos;
		QCOORD clickOffset;

		QTimer * repeater;
		void * d;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QScrollBar( const QScrollBar & );
		QScrollBar &operator=( const QScrollBar & );
#endif
*/

};

//#endif // QSCROLLBAR_H
