/****************************************************************************
** $Id: qslider.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QSlider class
**
** Created : 961019
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QSLIDER_H
//#define QSLIDER_H

//#ifndef QT_H
//#include "qwidget.h"
//#include "qrangecontrol.h"
//#endif // QT_H


class QTimer;
struct QSliderData;


class QSlider : public QWidget //, public QRangeControl
{
/*
		Q_OBJECT
		Q_ENUMS( TickSetting )
		Q_PROPERTY( int minValue READ minValue WRITE setMinValue )
		Q_PROPERTY( int maxValue READ maxValue WRITE setMaxValue )
		Q_PROPERTY( int lineStep READ lineStep WRITE setLineStep )
		Q_PROPERTY( int pageStep READ pageStep WRITE setPageStep )
		Q_PROPERTY( int value READ value WRITE setValue )
		Q_PROPERTY( bool tracking READ tracking WRITE setTracking )
		Q_PROPERTY( Orientation orientation READ orientation WRITE setOrientation )
		Q_PROPERTY( TickSetting tickmarks READ tickmarks WRITE setTickmarks )
		Q_PROPERTY( int tickInterval READ tickInterval WRITE setTickInterval )
*/	
public:
		enum TickSetting { NoMarks = 0, Above = 1, Left = Above,
		       Below = 2, Right = Below, Both = 3 };
%extend {
		QSlider(VALUE varg0, VALUE varg1 = Qnil, VALUE varg2 = Qnil, VALUE varg3 = Qnil,
							 VALUE varg4 = Qnil, VALUE varg5 =Qnil, VALUE varg6 = Qnil) {
		QWidget* wparent;
		char* name=0;
		Qt::Orientation ori;
		int minValue, maxValue, pageStep, value;
		if(rb_obj_is_kind_of(varg0,cQWidget) || TYPE(varg0) == T_NIL) {
				 wparent = (QWidget *)Get_QWidget(varg0);
				 if(varg1 != Qnil) name = STR2CSTR(varg1);
				 return new QSlider(wparent,name);
		} else if(TYPE(varg0) == T_FIXNUM &&
					(rb_obj_is_kind_of(varg1,cQWidget)  || TYPE(varg1) == T_NIL)) {
				 ori = (Qt::Orientation)NUM2INT(varg0);
				 wparent = (QWidget *)Get_QWidget(varg1);
				 if(varg2 != Qnil) name = STR2CSTR(varg2);
				 return new  QSlider(ori,wparent,name);
		} else if(TYPE(varg0) == T_FIXNUM  &&
					TYPE(varg0) == T_FIXNUM &&
					TYPE(varg1) == T_FIXNUM &&
					TYPE(varg2) == T_FIXNUM &&
					TYPE(varg3) == T_FIXNUM &&
					TYPE(varg4) == T_FIXNUM &&
					(rb_obj_is_kind_of(varg5,cQWidget)  || TYPE(varg5) == T_NIL)) {

				 minValue = NUM2INT(varg0);
				 maxValue = NUM2INT(varg1);
				 pageStep = NUM2INT(varg2);
				 value = NUM2INT(varg3);
				 ori = (Qt::Orientation)NUM2INT(varg4);
				 wparent = (QWidget *)Get_QWidget(varg5);
				if(varg6 != Qnil) name = STR2CSTR(varg6);
				return new QSlider(minValue,maxValue,pageStep,value,ori,wparent,name);
		} else {
					 rb_raise(rb_eArgError, "Type error in QSlider constructor");
		}
	}
}
//    QSlider( QWidget *parent, const char *name=0 );
//    QSlider( Orientation, QWidget *parent, const char *name=0 );
//    QSlider( int minValue, int maxValue, int pageStep, int value, Orientation,
//	     QWidget *parent, const char *name=0 );

		virtual void	setOrientation( Orientation );
		Orientation orientation() const;
		virtual void	setTracking( bool enable );
		bool	tracking() const;
		virtual void 	setPalette( const QPalette & );
		QRect	sliderRect() const;
		QSize	sizeHint() const;
		QSizePolicy sizePolicy() const;
		QSize	minimumSizeHint() const;

		virtual void setTickmarks( TickSetting );
		TickSetting tickmarks() const { return ticks; }

		virtual void setTickInterval( int );
		int 	tickInterval() const { return tickInt; }

		int	 minValue() const;
		int	 maxValue() const;
		void setMinValue( int );
		void setMaxValue( int );
		int	 lineStep() const;
		int	 pageStep() const;
		void setLineStep( int );
		void setPageStep( int );
		int  value() const;

//public slots:
		virtual void	setValue( int );
		void	addStep();
		void	subtractStep();
		
//QRangeControl public methods:
//    int		value()		const;
//    void	setValue( int );
		void	addPage();
		void	subtractPage();
		void	addLine();
		void	subtractLine();

//    int		minValue()	const;
//    int		maxValue()	const;
		void	setRange( int minValue, int maxValue );

//    int		lineStep()	const;
//    int		pageStep()	const;
		void	setSteps( int line, int page );

		int		bound( int ) const;

/*
signals:
		void	valueChanged( int value );
		void	sliderPressed();
		void	sliderMoved( int value );
		void	sliderReleased();

protected:
		void	resizeEvent( QResizeEvent * );
		void	paintEvent( QPaintEvent * );

		void	keyPressEvent( QKeyEvent * );
		void	mousePressEvent( QMouseEvent * );
		void	mouseReleaseEvent( QMouseEvent * );
		void	mouseMoveEvent( QMouseEvent * );
		void	wheelEvent( QWheelEvent * );
		void	focusInEvent( QFocusEvent *e );
		void	focusOutEvent( QFocusEvent *e );

		void updateMask();
		void styleChange( QStyle& );

		void	valueChange();
		void	rangeChange();

		virtual void paintSlider( QPainter *, const QColorGroup&, const QRect & );
		void	drawTicks( QPainter *, const QColorGroup&, int, int, int=1 ) const;

		void	drawWinGroove( QPainter *,  QCOORD );
		void	drawTicks( QPainter *,  int, int, int=1 ) const;

		virtual int	thickness() const;


private slots:
		void	repeatTimeout();

private:
		enum State { Idle, Dragging, TimingUp, TimingDown };

		void	init();
		int		positionFromValue( int ) const;
		int		valueFromPosition( int ) const;
		void	moveSlider( int );
		void	reallyMoveSlider( int );
		void	resetState();
		int		slideLength() const;
		int		available() const;
		int		goodPart( const QPoint& ) const;
		void	initTicks();

		QSliderData *extra;
		QTimer	*timer;
		QCOORD	sliderPos;
		int		sliderVal;
		QCOORD	clickOffset;
		State	state;
		bool	track;
		QCOORD	tickOffset;
		TickSetting	ticks;
		int		tickInt;
		Orientation orient;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QSlider( const QSlider & );
		QSlider &operator=( const QSlider & );
#endif
*/
};


//#endif // QSLIDER_H
