/****************************************************************************
** $Id: qstring.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of the QString class, and related Unicode
** functions.
**
** Created : 920609
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QSTRING_H
//#define QSTRING_H

//#ifndef QT_H
//#include "qcstring.h"
//#endif // QT_H


/*****************************************************************************
	QString class
 *****************************************************************************/

class QRegExp;
class QString;
class QCharRef;

class QChar {
public:
/*
		QChar() { rw = 0; cl = 0; }
		QChar( char c ) { rw = 0; cl = (uchar)c; }
		QChar( uchar c ) { rw = 0; cl = c; }
		QChar( uchar c, uchar r ) { rw = r; cl = c; }
		QChar( const QChar& c ) { rw = c.rw; cl = c.cl; }
		QChar( ushort rc ) { rw = (uchar)((rc>>8)&0xff); cl = (uchar)(rc&0xff); }
		QChar( short rc ) { rw = (uchar)((rc>>8)&0xff); cl = (uchar)(rc&0xff); }
		QChar( uint rc ) { rw = (uchar)((rc>>8)&0xff); cl = (uchar)(rc&0xff); }
		QChar( int rc ) { rw = (uchar)((rc>>8)&0xff); cl = (uchar)(rc&0xff); }
*/
//    QChar(int rc);
		QChar( ushort c);
		~QChar();

		static  const QChar null;            // 0000
		static  const QChar replacement;     // FFFD
		static  const QChar byteOrderMark;     // FEFF
		static  const QChar byteOrderSwapped;     // FFFE

		// Unicode information

		enum Category
		{
	NoCategory,

	Mark_NonSpacing,	  //   Mn
	Mark_SpacingCombining,	  //   Mc
	Mark_Enclosing,		  //   Me

	Number_DecimalDigit,	  //   Nd
	Number_Letter,		  //   Nl
	Number_Other,		  //   No

	Separator_Space,	  //   Zs
	Separator_Line,		  //   Zl
	Separator_Paragraph,	  //   Zp

	Other_Control,		  //   Cc
	Other_Format,		  //   Cf
	Other_Surrogate,	  //   Cs
	Other_PrivateUse,	  //   Co
	Other_NotAssigned,	  //   Cn

	Letter_Uppercase,	  //   Lu
	Letter_Lowercase,	  //   Ll
	Letter_Titlecase,	  //   Lt
	Letter_Modifier,	  //   Lm
	Letter_Other,		  //   Lo

	Punctuation_Connector,	  //   Pc
	Punctuation_Dask,	  //   Pd
	Punctuation_Open,	  //   Ps
	Punctuation_Close,	  //   Pe
	Punctuation_InitialQuote, //   Pi
	Punctuation_FinalQuote,	  //   Pf
	Punctuation_Other,	  //   Po

	Symbol_Math,		  //   Sm
	Symbol_Currency,	  //   Sc
	Symbol_Modifier,	  //   Sk
	Symbol_Other		  //   So
		};

		enum Direction
		{
	DirL, DirR, DirEN, DirES, DirET, DirAN, DirCS, DirB, DirS, DirWS, DirON,
	DirLRE, DirLRO, DirAL, DirRLE, DirRLO, DirPDF, DirNSM, DirBN
		};

		enum Decomposition
		{
				Single, Canonical, Font, NoBreak, Initial, Medial,
				Final, Isolated, Circle, Super, Sub, Vertical,
				Wide, Narrow, Small, Square, Compat, Fraction
		};

		enum Joining
		{
	OtherJoining, Dual, Right, Center
		};

		// ****** WHEN ADDING FUNCTIONS, CONSIDER ADDING TO QCharRef TOO

		int digitValue() const;
		QChar lower() const;
		QChar upper() const;

		Category category() const;
		Direction direction() const;
		Joining joining() const;
		bool mirrored() const;
		QChar mirroredChar() const;
		QString decomposition() const;
		Decomposition decompositionTag() const;

		char latin1() const ; // { return rw ? 0 : cl; }
		ushort unicode() const ; // { return (rw << 8) | cl; }
#ifndef QT_NO_CAST_ASCII
		// like all ifdef'd code this is undocumented
//    operator char() const ; //{ return latin1(); }
#endif

		bool isNull() const ; //{ return unicode()==0; }
		bool isPrint() const;
		bool isPunct() const;
		bool isSpace() const;
		bool isMark() const;
		bool isLetter() const;
		bool isNumber() const;
		bool isLetterOrNumber() const;
		bool isDigit() const;

//    uchar& cell() ;// { return cl; }
//    uchar& row() ; //{ return rw; }
		uchar cell() const ; //{ return cl; }
		uchar row() const ; //{ return rw; }

		static bool networkOrdered() ; //{ return (int)net_ordered == 1; }

//    friend inline int operator==( char ch, QChar c );
//    friend inline int operator==( QChar c, char ch );
//    friend inline int operator==( QChar c1, QChar c2 );
//    friend inline int operator!=( QChar c1, QChar c2 );
//    friend inline int operator!=( char ch, QChar c );
//    friend inline int operator!=( QChar c, char ch );
//    friend inline int operator<=( QChar c, char ch );
//    friend inline int operator<=( char ch, QChar c );
//    friend inline int operator<=( QChar c1, QChar c2 );
/*
private:
#if defined(_WS_X11_) || defined(_OS_WIN32_BYTESWAP_)
		// XChar2b on X11, ushort on _OS_WIN32_BYTESWAP_
		uchar rw;
		uchar cl;
		enum { net_ordered = 1 };
#else
		// ushort on _OS_WIN32_
		uchar cl;
		uchar rw;
		enum { net_ordered = 0 };
#endif
*/
};

/*
// internal
struct QStringData : public QShared {
		QStringData() :
	unicode(0), ascii(0), len(0), maxl(0), dirtyascii(0) { ref(); }
		QStringData(QChar *u, uint l, uint m) :
	unicode(u), ascii(0), len(l), maxl(m), dirtyascii(0) { }
		~QStringData() { if ( unicode ) delete[] ((char*)unicode);
										 if ( ascii ) delete[] ascii; }
		void deleteSelf();
		QChar *unicode;
		char *ascii;
		uint len;
		uint maxl:30;
		uint dirtyascii:1;
};
*/

class QString
{
public:
%extend {
			QString (VALUE w=Qnil) {
			if(TYPE(w) == T_NIL) {
				 return new QString();
			}
			else if(TYPE(w) == T_STRING) {
				 return new QString(STR2CSTR(w));
			}
			else if(TYPE(w) == T_DATA) {
				 if (rb_obj_is_kind_of(w,cQString)) {
						QString* temp;
						temp = (QString *)Get_QString(w);
						return new QString(*temp);
				 } else if (rb_obj_is_kind_of(w,cQChar)) {
						QChar* temp;
						temp = (QChar *)Get_QChar(w);
						return new QString(*temp);
				 } else if (rb_obj_is_kind_of(w,cQCString)) {
						QCString* temp;
						temp = (QCString *)Get_QCString(w);
						return new QString(*temp);
				 } else {   
				 rb_raise(rb_eArgError, "QString or QChar object expected");
				 }
			}
		 else {
				 rb_raise(rb_eArgError, "Type error in QString constructor");
			}
	};
	
	const char* to_str() {
			if(!(self->isNull())) return (const char*)(*self);
			else return "";
	};
	static QString fromQCString(QCString & cstr) {
	QString qstr;
	qstr = cstr;
	return qstr;
	};
}

//    QString();					// make null string
//    QString( QChar );				// one-char string
//    QString( const QString & );			// impl-shared copy
//    QString( const QByteArray& );		// deep copy
//    QString( const QChar* unicode, uint length ); // deep copy
//#ifndef QT_NO_CAST_ASCII
//    QString( const char *str );			// deep copy
//#endif
		~QString();

//    QString    &operator=( const QString & );	// impl-shared copy
//#ifndef QT_NO_CAST_ASCII
//    QString    &operator=( const char * );	// deep copy
//#endif
//    QString    &operator=( const QCString& );	// deep copy
//    QString    &operator=( QChar c );
//    QString    &operator=( char c );

		//static const QString null;  //QString::null causes seg. fault in ruby?

		bool	isNull()	const;
		bool	isEmpty()	const;
		uint	length()	const;
		void	truncate( uint pos );
		void	fill( QChar c, int len = -1 );

		QString	copy()	const;

		//QString arg(long a, int fieldwidth=0, int base=10) const;
		//QString arg(ulong a, int fieldwidth=0, int base=10) const;
//    QString arg(int a, int fieldwidth=0, int base=10) const;
		//QString arg(uint a, int fieldwidth=0, int base=10) const;
		//QString arg(short a, int fieldwidth=0, int base=10) const;
		//QString arg(ushort a, int fieldwidth=0, int base=10) const;
		//RENAME %name(argChar) QString arg(char a, int fieldwidth=0) const;
		//RENAME %name(argQChar) QString arg(QChar a, int fieldwidth=0) const;
		//RENAME %name(argQString) QString arg(const QString& a, int fieldwidth=0) const;
		//RENAME %name(argDouble) QString arg(double a, int fieldwidth=0, char fmt='g', int prec=-1) const;
		%extend {
			 QString arg(VALUE varg0,VALUE varg1=Qnil, VALUE varg2=Qnil) {
					int fieldwidth=0;
					int base=10;
					if(varg1 != Qnil) 
							fieldwidth = NUM2INT(varg1);
					if(TYPE(varg0) == T_FIXNUM) {
						 int a;
						 a = NUM2INT(varg0);
						 if(varg2 != Qnil)
								 base = NUM2INT(varg2);
						 return self->arg(a,fieldwidth,base);
					} else if(TYPE(varg0) == T_STRING) {
						 char* a;
						 a = STR2CSTR(varg0);
						 return self->arg(a,fieldwidth);
					} else if(rb_obj_is_kind_of(varg0,cQString)) {
						 QString* a;
						 a = (QString *)Get_QString(varg0);
						 return self->arg(*a,fieldwidth);
					} else if(TYPE(varg0) == T_FLOAT) {
						 double a;    
						 char fmt='g';
						 int prec=-1;     
						 a = NUM2DBL(varg0);
						 if(varg1 != Qnil) {
								char* s;
								s = STR2CSTR(varg1);
								if(s[0] != 0)
									 fmt = s[0];
						 }
						 if(varg2 != Qnil)
								 prec = NUM2INT(varg2);
						 return self->arg(a,fieldwidth,fmt,prec);
					} else if(rb_obj_is_kind_of(varg0,cQChar)) {
						 QChar* a;
						 a = (QChar *)Get_QChar(varg0);
						 return self->arg(*a,fieldwidth);
					} else {
						 rb_raise(rb_eArgError,"Error in arg() argment");
					}
			 }
		}
						 

//    QString    &sprintf( const char* format,...);

//#if defined(_CC_GNU_)
//	__attribute__ ((format (printf, 2, 3)))
//#endif
	;

		//RENAME %name(findQChar) int		find( QChar c, int index=0, bool cs=TRUE ) const;
//    int		find( char c, int index=0, bool cs=TRUE ) const;
		//RENAME %name(findQString) int		find( const QString &str, int index=0, bool cs=TRUE ) const;
		//RENAME %name(findQRegExp) int		find( const QRegExp &, int index=0 ) const;
#ifndef QT_NO_CAST_ASCII
		//RENAME %name(findString) int		find( const char* str, int index=0 ) const;
#endif
		%extend {
			 int find(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					 int index=0;
					 bool cs=TRUE;
					 if(rb_obj_is_kind_of(varg0,cQString) ||
							TYPE(varg0) == T_STRING) {
							QString* qstr;
							qstr = (QString *)Get_QString(varg0);
							if(varg1 != Qnil)
									index = NUM2INT(varg1);
							if(varg2 != Qnil) 
									cs = (varg2 == Qtrue) ? TRUE:FALSE;
							return self->find(*qstr,index,cs);
					 } else if(rb_obj_is_kind_of(varg0,cQChar)) {
							QChar* c;
							c = (QChar *)Get_QChar(varg0);
							if(varg1 != Qnil)
									index = NUM2INT(varg1);
							if(varg2 != Qnil) 
									cs = (varg2 == Qtrue) ? TRUE:FALSE;
							return self->find(*c,index,cs);              
					 } else if(rb_obj_is_kind_of(varg0,cQRegExp)) {
							QRegExp* reg;
							reg = (QRegExp *)Get_QRegExp(varg0);
							int index=0;
							if(varg1 != Qnil)
								 index = NUM2INT(varg1);
							return self->find(*reg,index);
					 } else {
							rb_raise(rb_eArgError,"Error in find() argments");
					 }
				}
		 }  

		//RENAME %name(findRevQChar) int		findRev( QChar c, int index=-1, bool cs=TRUE) const;
//    int		findRev( char c, int index=-1, bool cs=TRUE) const;
		//RENAME %name(findRevQString) int		findRev( const QString &str, int index=-1, bool cs=TRUE) const;
		//RENAME %name(findRevQRegExp) int		findRev( const QRegExp &, int index=-1 ) const;
#ifndef QT_NO_CAST_ASCII
		//RENAME %name(findRevString) int		findRev( const char* str, int index=-1 ) const;
#endif
		%extend {
			 int findRev(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					 int index=0;
					 bool cs=TRUE;
					 if(rb_obj_is_kind_of(varg0,cQString) ||
							TYPE(varg0) == T_STRING) {
							QString* qstr;
							qstr = (QString *)Get_QString(varg0);
							if(varg1 != Qnil)
									index = NUM2INT(varg1);
							if(varg2 != Qnil) 
									cs = (varg2 == Qtrue) ? TRUE:FALSE;
							return self->findRev(*qstr,index,cs);
					 } else if(rb_obj_is_kind_of(varg0,cQChar)) {
							QChar* c;
							c = (QChar *)Get_QChar(varg0);
							if(varg1 != Qnil)
									index = NUM2INT(varg1);
							if(varg2 != Qnil) 
									cs = (varg2 == Qtrue) ? TRUE:FALSE;
							return self->findRev(*c,index,cs);              
					 } else if(rb_obj_is_kind_of(varg0,cQRegExp)) {
							QRegExp* reg;
							reg = (QRegExp *)Get_QRegExp(varg0);
							int index=0;
							if(varg1 != Qnil)
								 index = NUM2INT(varg1);
							return self->findRev(*reg,index);
					 } else {
							rb_raise(rb_eArgError,"Error in find() argments");
					 }
				}
		 }  


		//RENAME %name(containsQChar) int		contains( QChar c, bool cs=TRUE ) const;
//    int		contains( char c, bool cs=TRUE ) const ;
//		    { return contains(QChar(c), cs); }
#ifndef QT_NO_CAST_ASCII
		//RENAME %name(containsString) int		contains( const char* str, bool cs=TRUE ) const;
#endif
		//RENAME %name(containsQString) int		contains( const QString &str, bool cs=TRUE ) const;
		//RENAME %name(containsQRegExp) int		contains( const QRegExp & ) const;
		%extend {
			 int contains(VALUE varg0,VALUE varg1=Qnil) {
					 bool cs=TRUE;
					 if(rb_obj_is_kind_of(varg0,cQString) ||
							TYPE(varg0) == T_STRING) {
							QString* qstr;
							qstr = (QString *)Get_QString(varg0);
							if(varg1 != Qnil) 
									cs = (varg1 == Qtrue) ? TRUE:FALSE;
							return self->contains(*qstr,cs);
					 } else if(rb_obj_is_kind_of(varg0,cQChar)) {
							QChar* c;
							c = (QChar *)Get_QChar(varg0);
							if(varg1 != Qnil) 
									cs = (varg1 == Qtrue) ? TRUE:FALSE;
							return self->contains(*c,cs);              
					 } else if(rb_obj_is_kind_of(varg0,cQRegExp)) {
							QRegExp* reg;
							reg = (QRegExp *)Get_QRegExp(varg0);
							return self->contains(*reg);
					 } else {
							rb_raise(rb_eArgError,"Error in contains() argments");
					 }
				}
		 }  


		QString	left( uint len )  const;
		QString	right( uint len ) const;
		QString	mid( uint index, uint len=0xffffffff) const;

		QString	leftJustify( uint width, QChar fill=blankChar,bool trunc=FALSE)const;
		QString	rightJustify( uint width, QChar fill=blankChar,bool trunc=FALSE)const;

		QString	lower() const;
		QString	upper() const;

		QString	stripWhiteSpace()	const;
		QString	simplifyWhiteSpace()	const;

		//RENAME %name(insertQString) QString    &insert( uint index, const QString & );
		//QString    &insert( uint index, const QChar*, uint len );
		//RENAME %name(insertQChar) QString    &insert( uint index, QChar );
//    QString    &insert( uint index, char c ); // { return insert(index,QChar(c)); }
		%extend {
			 QString& insert(VALUE varg0,VALUE varg1=Qnil) {
					uint index;
					index = NUM2INT(varg0);
					if(rb_obj_is_kind_of(varg0,cQString) ||
						 TYPE(varg0) == T_STRING) {
							QString* qstr;
							qstr = (QString *)Get_QString(varg0); 
							return self->insert(index,*qstr);
					} else if(rb_obj_is_kind_of(varg0,cQChar)) {
						 QChar* qc;
						 qc = (QChar *)Get_QChar(varg0);
						 return self->insert(index,*qc);
					} else {
						 rb_raise(rb_eArgError,"Error in insert() argments");
					}
			 }
		}
							

		//RENAME %name(appendChar)QString    &append( char );
		QString    &append( const QString & );

		//RENAME %name(prependChar) QString    &prepend( char );
		QString    &prepend( const QString & );

		QString    &remove( uint index, uint len );
//    QString    &replace( uint index, uint len, const QString & );
		//QString    &replace( uint index, uint len, const QChar*, uint clen );
		//RENAME %name(replaceQRegExp) QString    &replace( const QRegExp &, const QString & );
		%extend {
			 QString& replace(VALUE varg0,VALUE varg1,VALUE varg2=Qnil) {
					if(varg2 == Qnil) {
						 QRegExp* qre;
						 QString* qstr;
						 qre = (QRegExp *)Get_QRegExp(varg0);
						 qstr = (QString *)Get_QString(varg1);
						 return self->replace(*qre,*qstr);
					 } else {
							uint index;
							uint len;
							QString* qstr;
							index = NUM2INT(varg0);
							len = NUM2INT(varg1);
							qstr = (QString *)Get_QString(varg2);
							return self->replace(index,len,*qstr);
					 }
				}
		 }

		short	toShort( bool *OUTPUT=0, int base=10 )	const;
		ushort	toUShort( bool *OUTPUT=0, int base=10 )	const;
		int		toInt( bool *OUTPUT=0, int base=10 )	const;
		uint	toUInt( bool *OUTPUT=0, int base=10 )	const;
		long	toLong( bool *OUTPUT=0, int base=10 )	const;
		ulong	toULong( bool *OUTPUT=0, int base=10 )	const;
		float	toFloat( bool *OUTPUT=0 )	const;
		double	toDouble( bool *OUTPUT=0 )	const;

		//QString    &setNum( short, int base=10 );
		//QString    &setNum( ushort, int base=10 );
//    QString    &setNum( int, int base=10 );
		//QString    &setNum( uint, int base=10 );
		//QString    &setNum( long, int base=10 );
		//QString    &setNum( ulong, int base=10 );
		//QString    &setNum( float, char f='g', int prec=6 );
		//RENAME %name(setNumDouble) QString    &setNum( double, char f='g', int prec=6 );
		%extend {
			 QString& setNum(VALUE varg0,VALUE varg1=Qnil) {

					if(TYPE(varg0) == T_FIXNUM) {
						 int a;
						 int base=10;
						 if(varg1 != Qnil)
								base = NUM2INT(varg1);             
						 a = NUM2INT(varg0);
						 return self->setNum(a,base);
					} else if(TYPE(varg0) == T_FLOAT) {
						 double a;
						 char f='g';
						 int prec=6;
						 a = NUM2DBL(varg0);
						 if(varg1 != Qnil) { 
								 char* s = STR2CSTR(varg1);
								 if(s[0] != 0)
										f = s[0];
						 }                 
						 return self->setNum(a,f,prec);
					} else {
						 rb_raise(rb_eArgError,"Error in setNum() argments");
					}
			 }
		}

		//static QString number( long, int base=10 );
		//static QString number( ulong, int base=10);
//    static QString number( int, int base=10 );
		//static QString number( uint, int base=10);
		//RENAME %name(numberDouble) static QString number( double, char f='g', int prec=6 );
		%extend {
			 static QString number(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					if(TYPE(varg0) == T_FIXNUM) {
						 int a,base=10;
						 a = NUM2INT(varg0);
						 if(varg1 !=Qnil) 
								 base = NUM2INT(varg1);
						 return QString::number(a,base);
					} else if(TYPE(varg0) == T_FLOAT) {
						 double a;
						 char f='g';
						 char* s;
						 int prec=6;
						 a = NUM2DBL(varg0);
						 if(varg1 != Qnil) {
								s = STR2CSTR(varg1);
								f = s[0];
						 }
						 if(varg2 != Qnil)
								 prec = NUM2INT(varg2);
						 return QString::number(a,f,prec);
					} else {
						 rb_raise(rb_eArgError,"ArgError in number()");
					}
			 }
		}
								

		void	setExpand( uint index, QChar c );

//    QString    &operator+=( const QString &str );
//    QString    &operator+=( QChar c );
//    QString    &operator+=( char c );

		// Your compiler is smart enough to use the const one if it can.
		QChar at( uint i ) const ;
//	{ return i<d->len ? d->unicode[i] : QChar::null; }

//    QChar operator[]( int i ) const ; // { return at((uint)i); }
//    QCharRef operator[]( int i );
        //%rename(__getitem__) QChar operator[](int);
	%extend {
		QChar __getitem__(int index) {
			return (*self)[index];
		}
		QChar __setitem__(int index, QChar  value) {
			return (*self)[index]=value;
		}
	}
		%name(atAsQCharRef) QCharRef at( uint i );
//    QCharRef operator[]( int i );

		QChar constref(uint i) const ;
//	{ return at(i); }
		QChar& ref(uint i) ;
//	{ // Optimized for easy-inlining by simple compilers.
//	    if (d->count!=1 || i>=d->len)
//		subat(i);
//	    d->dirtyascii=1;
//	    return d->unicode[i];
//	}

		const QChar* unicode() const  ; //{ return d->unicode; }
		const char* ascii() const;
		const char* latin1() const;
		static QString fromLatin1(const char*, int len=-1);
		QCString utf8() const;
		static QString fromUtf8(const char*, int len=-1);
		QCString local8Bit() const;
		static QString fromLocal8Bit(const char*, int len=-1);
//    bool operator!() const;
//#ifndef QT_NO_ASCII_CAST
//    operator const char *() const ; // { return latin1(); }
//#endif

		QString &setUnicode( const QChar* unicode, uint len );
		QString &setUnicodeCodes( const ushort* unicode_as_ushorts, uint len );
		QString &setLatin1( const char*, int len=-1 );

		int compare( const QString& s ) const;
		%name(compareQString) static int compare( const QString& s1, const QString& s2 ) ;
//	{ return s1.compare(s2); }
			 
//    friend Q_EXPORT QDataStream &operator>>( QDataStream &, QString & );

		// new functions for BiDi
		void compose();
		QChar::Direction basicDirection();
		QString visual(int index = 0, int len = -1);

#ifndef QT_NO_COMPAT
		const char* data() const { return latin1(); }
#endif

/*
private:
		QString( int size, bool dummy );		// allocate size incl. \0

		void deref();
		void real_detach();
		void setLength( uint pos );
		void subat( uint );
		bool findArg(int& pos, int& len) const;

		static QChar* asciiToUnicode( const char*, uint * len, uint maxlen=(uint)-1 );
		static QChar* asciiToUnicode( const QByteArray&, uint * len );
		static char* unicodeToAscii( const QChar*, uint len );

		QStringData *d;
		static QStringData* shared_null;
		static QStringData* makeSharedNull();

		friend class QConstString;
		QString(QStringData* dd, bool dum) : d(dd) { }
*/
};

class QCharRef {
//    friend class QString;
		QString& s;
		uint p;
		QCharRef(QString* str, uint pos) ; // : s(*str), p(pos) { }

public:
		// Most QChar operations repeated here...

		// all this is not documented: We just say "like QChar" and let it be.
//#if 1
		ushort unicode() const ; //{ return s.constref(p).unicode(); }
		char latin1() const ; //{ return s.constref(p).latin1(); }

		// An operator= for each QChar cast constructor...
//    QCharRef operator=(char c ) ; //{ s.ref(p)=c; return *this; }
//    QCharRef operator=(uchar c ) ; //{ s.ref(p)=c; return *this; }
//    QCharRef operator=(QChar c ) ; //{ s.ref(p)=c; return *this; }
//    QCharRef operator=(const QCharRef& c ) { s.ref(p)=c.unicode(); return *this; }
//    QCharRef operator=(ushort rc ) { s.ref(p)=rc; return *this; }
//    QCharRef operator=(short rc ) { s.ref(p)=rc; return *this; }
//    QCharRef operator=(uint rc ) { s.ref(p)=rc; return *this; }
//    QCharRef operator=(int rc ) { s.ref(p)=rc; return *this; }

//    operator QChar () const ; //{ return s.constref(p); }

		// each function...
		bool isNull() const ; //{ return unicode()==0; }
		bool isPrint() const ; //{ return s.constref(p).isPrint(); }
		bool isPunct() const ; //{ return s.constref(p).isPunct(); }
		bool isSpace() const ; //{ return s.constref(p).isSpace(); }
		bool isMark() const ; //{ return s.constref(p).isMark(); }
		bool isLetter() const ; //{ return s.constref(p).isLetter(); }
		bool isNumber() const ; //{ return s.constref(p).isNumber(); }
		bool isLetterOrNumber() ; //{ return s.constref(p).isLetterOrNumber(); }
		bool isDigit() const ; //{ return s.constref(p).isDigit(); }

		int digitValue() const ; //{ return s.constref(p).digitValue(); }
		QChar lower() ; //{ return s.constref(p).lower(); }
		QChar upper() ; //{ return s.constref(p).upper(); }

		QChar::Category category() const ;// { return s.constref(p).category(); }
		QChar::Direction direction() const ;// { return s.constref(p).direction(); }
		QChar::Joining joining() const ; //{ return s.constref(p).joining(); }
		bool mirrored() const ; //{ return s.constref(p).mirrored(); }
		QChar mirroredChar() const ; //{ return s.constref(p).mirroredChar(); }
		QString decomposition() const ; //{ return s.constref(p).decomposition(); }
		QChar::Decomposition decompositionTag() const ; //{ return s.constref(p).decompositionTag(); }

		// Not the non-const ones of these.
		uchar cell() const ; //{ return s.constref(p).cell(); }
		uchar row() const ; //{ return s.constref(p).row(); }
//#endif
};
/*
inline QCharRef QString::at( uint i ) { return QCharRef(this,i); }
inline QCharRef QString::operator[]( int i ) { return at((uint)i); }


class Q_EXPORT QConstString : private QString {
public:
		QConstString( QChar* unicode, uint length );
		~QConstString();
		const QString& string() const { return *this; }
};
*/

/*****************************************************************************
	QString stream functions
 *****************************************************************************/

//Q_EXPORT QDataStream &operator<<( QDataStream &, const QString & );
//Q_EXPORT QDataStream &operator>>( QDataStream &, QString & );

//#endif // QSTRING_H
