/****************************************************************************
** $Id: qstrlist.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of QStrList, QStrIList and QStrListIterator classes
**
** Created : 920730
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QSTRLIST_H
//#define QSTRLIST_H

//#ifndef QT_H
//#include "qstring.h"
//#include "qlist.h"
//#include "qdatastream.h"
//#endif // QT_H


//#if defined(Q_TEMPLATEDLL)
//template class Q_EXPORT QList<char>;
//template class Q_EXPORT QListIterator<char>;
//#endif

//typedef QList<char>		QStrListBase;
//typedef QListIterator<char>	QStrListIterator;
class QStrListBase
{
public:

		uint  count()   const		{ return QGList::count(); }
		bool  isEmpty() const		{ return QGList::count() == 0; }
		bool  insert( uint i, const char *d){ return QGList::insertAt(i,(QCollection::Item)d); }
		void  inSort( const char *d )	{ QGList::inSort((QCollection::Item)d); }
		void  prepend( const char *d )	{ QGList::insertAt(0,(QCollection::Item)d); }
		void  append( const char *d )	{ QGList::append((QCollection::Item)d); }
		//RENAME %name(removeInt) bool  remove( uint i )		{ return QGList::removeAt(i); }
//    bool  remove()			{ return QGList::remove((QCollection::Item)0); }
		//RENAME %name(removeChar) bool  remove( const char *d )	{ return QGList::remove((QCollection::Item)d); }
		%extend {
			 bool remove(VALUE varg0=Qnil) {
					if(varg0 == Qnil) {
						 return self->remove();
					} else if(TYPE(varg0) == T_FIXNUM) {
						 uint i;
						 i = NUM2INT(varg0);
						 return self->remove(i);
					} else if(TYPE(varg0) == T_STRING) {
						 char* d;
						 d = STR2CSTR(varg0);
						 return self->remove(d);
					} else {
						 rb_raise(rb_eArgError,"ArgError in remove()"); 
					}
			 }
		}

		bool  removeRef( const char *d )	{ return QGList::removeRef((QCollection::Item)d); }
//    void  removeNode( QLNode *n )	{ QGList::removeNode(n); }
		bool  removeFirst()			{ return QGList::removeFirst(); }
		bool  removeLast()			{ return QGList::removeLast(); }
		//RENAME %name(takeInt) char *take( uint i )		{ return (char *)QGList::takeAt(i); }
//    char *take()			{ return (char *)QGList::take(); }
		%extend {
			 char* take(VALUE varg0=Qnil) {
					if(varg0 == Qnil) {
						 return self->take();
					} else {
						 uint i;
						 i = NUM2INT(varg0);
						 return self->take(i);
					}
			 }
		}

//    char *takeNode( QLNode *n )		{ return (char *)QGList::takeNode(n); }
		void  clear()			{ QGList::clear(); }
		void  sort()			{ QGList::sort(); }
		int	  find( const char *d )		{ return QGList::find((QCollection::Item)d); }
		int	  findNext( const char *d )	{ return QGList::find((QCollection::Item)d,FALSE); }
		int	  findRef( const char *d )	{ return QGList::findRef((QCollection::Item)d); }
		int	  findNextRef( const char *d ){ return QGList::findRef((QCollection::Item)d,FALSE);}
		uint  contains( const char *d ) const { return QGList::contains((QCollection::Item)d); }
		uint  containsRef( const char *d ) const
					{ return QGList::containsRef((QCollection::Item)d); }
		char *at( uint i )			{ return (char *)QGList::at(i); }
//    int	  at() const			{ return QGList::at(); }
		char *current()  const		{ return (char *)QGList::get(); }
//    QLNode *currentNode()  const	{ return QGList::currentNode(); }
		char *getFirst() const		{ return (char *)QGList::cfirst(); }
		char *getLast()  const		{ return (char *)QGList::clast(); }
		char *first()			{ return (char *)QGList::first(); }
		char *last()			{ return (char *)QGList::last(); }
		char *next()			{ return (char *)QGList::next(); }
		char *prev()			{ return (char *)QGList::prev(); }
//    void  toVector( QGVector *vec )const{ QGList::toVector(vec); }
	 
	 };
class QStrListIterator {};


class QStrList : public QStrListBase
{
public:
		QStrList( bool deepCopies=TRUE ) { dc = deepCopies; del_item = deepCopies; }
//    QStrList( const QStrList & );
	 ~QStrList()			{ clear(); }
//    QStrList& operator=( const QStrList & );
/*
private:
		Item newItem( Item d ) { return dc ? qstrdup( (const char*)d ) : d; }
		void deleteItem( Item d ) { if ( del_item ) delete[] (char*)d; }
		int compareItems( Item s1, Item s2 ) { return strcmp((const char*)s1,
							 (const char*)s2); }
		QDataStream &read( QDataStream &s, Item &d )
				{ s >> (char *&)d; return s; }
		QDataStream &write( QDataStream &s, Item d ) const
				{ return s << (const char *)d; }
		bool  dc;
*/
};


class  QStrIList : public QStrList	// case insensitive string list
{
public:
		QStrIList( bool deepCopies=TRUE ) : QStrList( deepCopies ) {}
	 ~QStrIList()			{ clear(); }
/*
private:
		int	  compareItems( Item s1, Item s2 )
				{ return stricmp((const char*)s1,
						 (const char*)s2); }
*/
};




//#endif // QSTRLIST_H
