/****************************************************************************
** $Id: qtoolbutton.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
 ** Definition of a buttom customized for tool bar use
**
** Created : 979899
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QTOOLBUTTON_H
#define QTOOLBUTTON_H

#ifndef QT_H
#include "qbutton.h"
#include "qstring.h"
#include "qpixmap.h"
#include "qiconset.h"
#endif // QT_H


class QToolButtonPrivate;
class QToolBar;
class QStyle;

class QToolButton: public QButton
{
//    Q_OBJECT
/*
		Q_PROPERTY( QIconSet onIconSet READ onIconSet WRITE setOnIconSet )
		Q_PROPERTY( QIconSet offIconSet READ offIconSet WRITE setOffIconSet )
		Q_PROPERTY( bool usesBigPixmap READ usesBigPixmap WRITE setUsesBigPixmap )
		Q_PROPERTY( bool usesTextLabel READ usesTextLabel WRITE setUsesTextLabel )
		Q_PROPERTY( QString textLabel READ textLabel WRITE setTextLabel )
		Q_PROPERTY( int popupDelay READ popupDelay WRITE setPopupDelay )
		Q_PROPERTY( bool autoRaise READ autoRaise WRITE setAutoRaise )

		Q_OVERRIDE( bool on WRITE setOn )
*/
public:
	 %extend {
	 QToolButton(VALUE varg0, VALUE varg1=Qnil, VALUE varg2=Qnil,
			VALUE varg3=Qnil, VALUE varg4=Qnil, VALUE varg5=Qnil, VALUE varg6=Qnil) {
			if (rb_obj_is_kind_of(varg0,cQWidget) || TYPE(varg0) == T_NIL)  {
						if(varg1 == Qnil) {
							 QWidget* qw;
							 qw = (QWidget *)Get_QWidget(varg0);
							 return new QToolButton(qw);
						} else if(TYPE(varg1) == T_STRING) {
								QWidget* qw;
								char* cstr;
								qw = (QWidget *)Get_QWidget(varg0);
								cstr = STR2CSTR(varg1);
								return new QToolButton(qw, cstr);
						 } else {
						 rb_raise(rb_eArgError,"STRING expected in 2nd arg in QToolButton.new");
								return 0;
						 }
				} else if(TYPE(varg0) == T_FIXNUM) {
					 QToolBar::ArrowType at;
					 QWidget* qw;
					 if(rb_obj_is_kind_of(varg1,cQWidget)  || TYPE(varg1) == T_NIL ) {
								 if(varg2 ==Qnil) {
											at = (QToolBar::ArrowType)NUM2INT(varg0);
											qw = (QWidget *)Get_QWidget(varg1);
											return new QToolButton(at,qw);
									} else if(TYPE(varg2) == T_STRING) {
											char* cstr;
											cstr = STR2CSTR(varg2);
											return new QToolButton(at,qw,cstr);
									} else {
											rb_raise(rb_eArgError,"STRING expected in 3rd arg in QToolButton.new");
									}
						} else {
								 rb_raise(rb_eArgError,"QWidget expected in 2nd arg in QToolButton.new");
									return 0;
						}
				} else if(rb_obj_is_kind_of(varg0,cQPixmap)  || TYPE(varg0) == T_NIL) {
						QPixmap* qpm;
						qpm = (QPixmap *)Get_QPixmap(varg0);
						QString qstr = STR2CSTR(varg1);
						QString qstr2 = STR2CSTR(varg2);
						QObject * qobj;
						qobj = (QObject *)Get_QObject(varg3);
						const char* slot = STR2CSTR(varg4);
						QToolBar* qtlb;
						qtlb = (QToolBar *)Get_QToolBar(varg5);
						char* cstr = "";

						if(varg6 !=Qnil) cstr = STR2CSTR(varg6);
						QToolButton* qtbutton;
						qtbutton = new QToolButton(*qpm,qstr,qstr2,(QObject*)0,"",
															 qtlb,cstr);
						QRObject::connect_rslot(qtbutton,SIGNAL(clicked()),varg3,(char*)slot);
						return qtbutton;
				} else if(rb_obj_is_kind_of(varg0,cQIconSet)  || TYPE(varg0) == T_NIL) {
					 QIconSet* s;
					 s = (QIconSet *)Get_QIconSet(varg0);
					 QString qstr = STR2CSTR(varg1);
					 QString qstr2 = STR2CSTR(varg2);
					 QObject *qobj;
					 qobj = (QObject *)Get_QObject(varg3);
					 const char* slot = STR2CSTR(varg4);
					 QToolBar* qtlb;
					 qtlb = (QToolBar *)Get_QToolBar(varg5);
					 char* cstr = "";
					 if(varg6 != Qnil) cstr = STR2CSTR(varg6);
					 QToolButton* qtbutton;
					 qtbutton = new QToolButton(*s,qstr,qstr2,(QObject*)0,"",qtlb,cstr);
					 QRObject::connect_rslot(qtbutton,SIGNAL(clicked()),varg3,(char*)slot);
					 return qtbutton;
			 } else {
				rb_raise(rb_eArgError, "QPixmap object expected");
				 return 0;
			 }
		}
}

//    QToolButton( QWidget * parent, const char *name = 0 );
//    QToolButton( const QPixmap & pm, const QString &textLabel, //### fjern 3.0
//		 const QString& grouptext,
//		 QObject * receiver, const char* slot,
//		 QToolBar * parent, const char* name = 0 );
//    QToolButton( const QIconSet& s, const QString &textLabel,
//		 const QString& grouptext,
//		 QObject * receiver, const char* slot,
//		 QToolBar * parent, const char* name = 0 );
//    QToolButton( ArrowType type, QWidget *parent, const char *name = 0 );
//    ~QToolButton();

		QSize sizeHint() const;
		QSizePolicy sizePolicy() const;

		void setOnIconSet( const QIconSet& );
		void setOffIconSet( const QIconSet& );
		QIconSet onIconSet() const;
		QIconSet offIconSet( ) const;
		virtual void setIconSet( const QIconSet &, bool on = FALSE );
		QIconSet iconSet( bool on = FALSE) const;

		bool usesBigPixmap() const { return ubp; }
		bool usesTextLabel() const { return utl; }
		QString textLabel() const { return tl; }

		void setPopup( QPopupMenu* popup );
		QPopupMenu* popup() const;

		void setPopupDelay( int delay );
		int popupDelay() const;

		void setAutoRaise( bool enable );
		bool autoRaise() const;

//public slots:
		virtual void setUsesBigPixmap( bool enable );
		virtual void setUsesTextLabel( bool enable );
		//RENAME %name(setTextLabelQStringBool) virtual void setTextLabel( const QString &, bool );
		%extend {
			 void setTextLabel(const QString& qstr,VALUE varg1=Qnil) {
					if(varg1 == Qnil){
						 self->setTextLabel(qstr);
					} else {
						 bool fl;
						 fl = (varg1 == Qtrue) ? TRUE:FALSE;
						 self->setTextLabel(qstr,fl);
					}
			 }
		}

		virtual void setToggleButton( bool enable ); //### fjern virtual 3.0

		virtual void setOn( bool enable ); //### fjern virtual 3.0
		void toggle();
//    void setTextLabel( const QString & );
/*
protected:
		void drawButton( QPainter * );
		void drawButtonLabel( QPainter * );

		void enterEvent( QEvent * );
		void leaveEvent( QEvent * );
		void moveEvent( QMoveEvent * );

		bool uses3D() const;

private slots:
		void popupTimerDone();
		void popupPressed();

private:
		void init();

		QPixmap bp;
		int bpID;
		QPixmap sp;
		int spID;

		QString tl;

		QToolButtonPrivate * d;
		QIconSet * s, *son;

		uint utl: 1;
		uint ubp: 1;
		uint hasArrow : 1;

		friend class QStyle;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QToolButton( const QToolButton & );
		QToolButton& operator=( const QToolButton & );
#endif
*/
};


#endif
