/****************************************************************************
** $Id: qtooltip.i,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
**
** Definition of Tool Tips (or Balloon Help) for any widget or rectangle
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QTOOLTIP_H
//#define QTOOLTIP_H

//#ifndef QT_H
//#include "qwidget.h"
//#include "qtimer.h"
//#endif // QT_H


class QTipManager;
class QLabel;
class QIconViewToolTip;

class QToolTipGroup: public QObject
{
//    Q_OBJECT
/*
		Q_PROPERTY( bool delay READ delay WRITE setDelay )
		Q_PROPERTY( bool enabled READ enabled WRITE setEnabled )
*/

public:
		QToolTipGroup( QObject *parent, const char *name = 0 );
//   ~QToolTipGroup();

		bool delay() const;
		bool enabled() const;

//public slots:
		void setDelay( bool );
		void setEnabled( bool );

/*
signals:
		void showTip( const QString &);
		void removeTip();

private:
		uint del:1;
		uint ena:1;

		friend class QTipManager;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QToolTipGroup( const QToolTipGroup & );
		QToolTipGroup& operator=( const QToolTipGroup & );
#endif
*/
};


class QToolTip: public Qt
{

public:
//    QToolTip( QWidget *, QToolTipGroup * qttg = 0 );

//    static void add( QWidget *, const QString &);
		//RENAME %name(addQToolTipGroup) static void add( QWidget *, const QString &,
		//RENAME		     QToolTipGroup *, const QString& );
//    static void remove( QWidget * );

		//RENAME %name(addQRect) static void add( QWidget *, const QRect &, const QString &);
		//RENAME %name(addQRectQToolTipGroup) static void add( QWidget *, const QRect &, const QString &,
		//RENAME    		     QToolTipGroup *, const QString& );
		//RENAME %name(removeQRect) static void remove( QWidget *, const QRect & );
		%extend {
			 static void add(QWidget* wd, VALUE varg1, VALUE varg2=Qnil,
											 VALUE varg3=Qnil,VALUE varg4=Qnil) {
							if(TYPE(varg1) == T_STRING || 
								 rb_obj_is_kind_of(varg1,cQString)) {
										QString* qstr;
										qstr = (QString *)Get_QString(varg1);
										if(varg2 == Qnil) {
											 QToolTip::add(wd,*qstr);
										} else {
											 QToolTipGroup* tg;
											 QString* qstr2;
											 tg = (QToolTipGroup *)Get_QToolTipGroup(varg2);
											 qstr2 = (QString *)Get_QString(varg3);
											 QToolTip::add(wd,*qstr,tg,*qstr2);
										}
							 } else if(rb_obj_is_kind_of(varg1,cQRect)) {
										QRect* qrect;
										QString* qstr;
										qrect = (QRect *)Get_QRect(varg1);
										qstr = (QString *)Get_QString(varg2);
										if(varg3 == Qnil) {
											 QToolTip::add(wd,*qrect,*qstr);
										} else {
											 QToolTipGroup* tg;
											 QString* qstr2;
											 tg = (QToolTipGroup *)Get_QToolTipGroup(varg3);
											 qstr2 = (QString *)Get_QString(varg4);
											 QToolTip::add(wd,*qrect,*qstr,tg,*qstr2);
										}
								 } else {
										rb_raise(rb_eArgError,"Error in add() argments");
								 }
							}
					 static void remove(QWidget* wd,VALUE varg1=Qnil) {
							if(varg1 == Qnil) {
								 QToolTip::remove(wd);
							} else {
								 QRect* qrect;
								 qrect = (QRect *)Get_QRect(varg1);
								 QToolTip::remove(wd,*qrect);
							}
					 }
				}
													


		static void hide();

		static QFont    font();
		static void	    setFont( const QFont & );
		static QPalette palette();
		static void	    setPalette( const QPalette & );

		static void	    setEnabled( bool );
		static bool	    enabled();

/*
protected:
		virtual void maybeTip( const QPoint & ) = 0;
		void    tip( const QRect &, const QString &);
		void    tip( const QRect &, const QString& , const QString &);
		void    clear();
*/
/*
public:
		QWidget	  *parentWidget() const ; //{ return p; }
		QToolTipGroup *group()	  const ; //{ return g; }
*/
/*
private:
		void    tip( const QRect &, const QRect &, const QString &);
		QWidget	    *p;
		QToolTipGroup   *g;
		static QFont    *ttFont;
		static QPalette *ttPalette;

%name(initialize_Qt)		static void initialize();
		static void cleanup();

		friend class QTipManager;
		friend class QIconViewToolTip;
*/
};


//#endif // QTOOLTIP_H
