/***************************************************************************
                    rsignal.h  -  description
                           -------------------
  begin                : Sat Aug 18 13:58:52 JST 2001
  copyright            : (C) 2001 by Nobuyuki Horie
  email                : horie@smail.u-shizuoka-ken.ac.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * $Id: rsignal.h,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
 * Purpose: 
 * Author:  
 */

#ifndef _RSignal_h
#define _RSignal_h
//#define RSHIFT(x,y) ((x)>>y)
//#include "qrobject.h"
#include <ruby.h>
#ifdef NT
  #include "canceldefs.h"
#endif
#include <qobject.h>
#include <qlist.h>
#include <qstring.h>
#include "rslot.h"

class RSignal : public QObject
/**
*/
	{
	Q_OBJECT
	private:
//	QList<RSlot> RSlots;
//	QObject* qobj;
//	const char* qtslot;
//	VALUE r_rec;
//	const char* rubyslot;
	enum {NOARG, INTARG, BOOLARG, DBLARG, TXTARG, OBJARG, QSTRARG} arg;
	protected:
	public:
	RSignal();
	RSignal(const char* str);
	virtual ~RSignal();
	int type() { return arg;}
	void connect(const QObject* qobj, const char* qslot);
	void connect(VALUE ruby_rec, char* ruby_slot);
	void connect_rsignal(RSignal & rsignal);
	void connect_qsignal(const QObject* qobj, const char* qsignal);
	bool connectItem(QAccel* accel, int id);
	bool disconnectItem(QAccel* accel, int id);
	void send();
	void sendWith(VALUE argobj);
	void send_int(int argint);
	void send_bool(bool flag);
	void send_txt(const char* argtxt);
	void send_object(VALUE argobj);
	void send_double(double argdbl);
	void send_qstr(QString* argqstr);
	void reconnect();	
	void disconnect();
	signals:
	void rsignal();
	void rsignal(int);
	void rsignal(double);
	void rsignal(bool);
	void rsignal(const char*);
	void rsignal(VALUE);
	void rsignal(const QString &);
	private slots:
	void transQString(const QString &);
	};

#endif

