/***************************************************************************
                    rslot.h  -  description
                           -------------------
  begin                : Sat Aug 18 13:58:52 JST 2001
  copyright            : (C) 2001 by Nobuyuki Horie
  email                : horie@smail.u-shizuoka-ken.ac.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * $Id: rslot.h,v 1.1.1.1 2001/07/28 06:12:26 horie Exp $
 * Purpose: 
 * Author:  
 */

#ifndef _RSlot_h
#define _RSlot_h

//#include "qrobject.h"
#include <ruby.h>
#ifdef NT
  #include "canceldefs.h"
#endif
#include <qobject.h>
#include <qdatetime.h>
#include <qaccel.h>
#include <qevent.h>
#include <qlistbox.h>
#include <qlistview.h>



class RSlot : public QObject
/**
*/
	{
	Q_OBJECT
 	public:
 	enum Argtype {NOARG, DBLARG, INTARG, BOOLARG, TXTARG, OBJARG,
 	              QRECTARG, QSIZEARG, QDATEARG, QCOLORARG,
 	              QMENUARG, QDROPEVENTARG,
 	              QLISTBOXITEMARG,QLISTVIEWITEMARG,
 	              QLISTBOXITEMQPOINTARG,QLISTVIEWITEMQPOINTINTARG,
 	              QICONVIEWITEMARG};	

	private:
	//const QObject* qt_obj;
	//const char* qt_signal;
	protected:
	VALUE ruby_obj;
	QString ruby_slot;
	Argtype arg;
	RSlot();  //disable default constructor
	RSlot(VALUE robj,const char* rmember,Argtype slot_type=NOARG);
	public:
	
	virtual ~RSlot();
	
	bool find(QObject* qtobj, const char* qtsignal, VALUE robj, const char* rmethod);
	virtual const char* qslot() = 0;
	virtual Argtype type() {return arg;}
	//void	connect();
	//void    disconnect();
	//bool    disconnectItem(QAccel* accel, int id);
	};
	

/**
*/
class RSlotVoid : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotVoid(VALUE robj, const char* rmember);
	RSlotVoid(QAccel* accel, int id, VALUE robject, const char* rbslot);    
	~RSlotVoid();
	const char* qslot();
	bool disconnectItem(QAccel* accel, int id );	

	public slots:
	void rslot();	
	};


/**
*/
class RSlotInt : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotInt(VALUE robj, const char* rmember);
	~RSlotInt();
	const char* qslot();

	public slots:
	void rslot(int);
	};
/**
*/
class RSlotDouble : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotDouble(VALUE robj, const char* rmember);
	~RSlotDouble();
	const char* qslot();

	public slots:
	void rslot(double);
};

/**
*/
class RSlotStr : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotStr(VALUE robj, const char* rmember);
	~RSlotStr();
	const char* qslot();

	public slots:
	void rslot(const char*);
	};
/**
*/
class RSlotQStr : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotQStr(VALUE robj, const char* rmember);
	~RSlotQStr();
	const char* qslot();

	public slots:
	void rslot(const QString &);
	};

/**
*/
class RSlotRObj : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotRObj(VALUE robj, const char* rmember);
	~RSlotRObj();
	const char* qslot();

	public slots:
	void rslot(VALUE);
	};

/**
*/
class RSlotQRect : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotQRect(VALUE robj, const char* rmember);
	~RSlotQRect();
	const char* qslot();

	public slots:
	void rslot(const QRect&);

	};

/**
*/
class RSlotQSize : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotQSize(VALUE robj, const char* rmember);
	~RSlotQSize();
	const char* qslot();

	public slots:
	void rslot(const QSize&);

	};

/**
*/
class RSlotQColor : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotQColor(VALUE robj, const char* rmember);
	~RSlotQColor();
	const char* qslot();

	public slots:
	void rslot(const QColor&);

	};

/**
*/class RSlotBool : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotBool(VALUE robj, const char* rmember);
	~RSlotBool();
	const char* qslot();

	public slots:
	void rslot(bool);

	};

/**
*/
class RSlotQDate : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotQDate(VALUE robj, const char* rmember);
	~RSlotQDate();
	const char* qslot();
	public slots:
	void rslot(QDate);


	};
	
/**
*/
class RMenuRSlot : public RSlot
	{
	Q_OBJECT
	private:
	int menuId;
	bool argInt;
	protected:
	public:
	RMenuRSlot(int menuid, VALUE robj, char* rmember);
	~RMenuRSlot();
	const char* qslot();
	public slots:
	void rslot(int);
	void rslot();
	};

/**
*/
class RSlotQListViewItem : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotQListViewItem(VALUE robj, const char* rmember);
	~RSlotQListViewItem();
	const char* qslot();

	public slots:
	void rslot(QListViewItem *);
	};

/**
*/
class RSlotQListViewItemQPointInt : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotQListViewItemQPointInt(VALUE robj, const char* rmember);
	~RSlotQListViewItemQPointInt();
	const char* qslot();

	public slots:
	void rslot(QListViewItem *,const QPoint&, int);
	};

/**
*/
class RSlotQListBoxItem : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotQListBoxItem(VALUE robj, const char* rmember);
	~RSlotQListBoxItem();
	const char* qslot();

	public slots:
	void rslot(QListBoxItem *);
	};

/**
*/
class RSlotQListBoxItemQPoint : public RSlot
	{
	Q_OBJECT
	private:
	protected:
	public:
	RSlotQListBoxItemQPoint(VALUE robj, const char* rmember);
	~RSlotQListBoxItemQPoint();
	const char* qslot();

	public slots:
	void rslot(QListBoxItem *,const QPoint&);
	};



#endif

