/**********************************************************************
** $Id: qt/src/canvas/qcanvas.h   2.2.2   edited 2000-08-28 $
**
** Definition of QCanvas classes
**
** Created : 991211
**
** Copyright (C) 1999-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the canvas module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition licenses may use this
** file in accordance with the Qt Commercial License Agreement provided
** with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

//#ifndef QCANVAS_H
//#define QCANVAS_H

//#ifndef QT_H
//#include <qbitmap.h>
//#include <qwidget.h>
//#include <qscrollview.h>
//#include <qlist.h>
//#include <qptrdict.h>
//#endif // QT_H

//#ifndef QT_NO_CANVAS


class QCanvasSprite;
class QCanvasPolygonalItem;
class QCanvasRectangle;
class QCanvasPolygon;
class QCanvasEllipse;
class QCanvasText;
class QCanvasLine;
class QCanvasChunk;
class QCanvas;
class QCanvasData;
class QCanvasItem;
class QCanvasView;
class QCanvasPixmap;


//#if defined(Q_TEMPLATEDLL)
// MOC_SKIP_BEGIN
//template class Q_EXPORT QList< QCanvasItem >;
//template class Q_EXPORT QList< QCanvasView >;
//template class Q_EXPORT QValueList< QCanvasItem* >;
// MOC_SKIP_END
//#endif

//#define QValueList<QCanvasItem*>  QValueList_QCanvasItem
class QValueListIterator_QCanvasItem {
   public:
   %extend {
   VALUE incr() {
   (*self)++;
   //return *self;
   return Data_Wrap_Struct(cQValueListIterator_QCanvasItem.klass,0,0,self);
   };
   VALUE decr() {
   (*self)--;
   //return *self;
   return Data_Wrap_Struct(cQValueListIterator_QCanvasItem.klass,0,0,self);   
   };
  }
};

class QCanvasItem_p {};

class QCanvasItemList : public QValueList_QCanvasItem {
public:
    void sort();
    void drawUnique( QPainter& painter );
    %extend {
    VALUE asArray() {
    unsigned int c = self->count();
    VALUE ar = rb_ary_new2(c);
    for(unsigned int i=0;i<c;i++) {
       VALUE qci = Data_Wrap_Struct(cQCanvasItem.klass,0,0,((*self)[i]));
       rb_ary_push(ar,qci);
    }
    return ar;
    };
    VALUE at(int i) {
    VALUE qci;
    qci = Data_Wrap_Struct(cQCanvasItem.klass,0,0,((*self)[i]));
    return qci;
    };
 }
// QValueList methods
    QValueListIterator_QCanvasItem begin();
    QValueListIterator_QCanvasItem end();
    QValueListIterator_QCanvasItem fromLast();
    bool isEmpty() const;
    QValueListIterator_QCanvasItem insert( QValueListIterator_QCanvasItem it, const QCanvasItem_p & x );
    QValueListIterator_QCanvasItem append( const QCanvasItem_p & x );
    QValueListIterator_QCanvasItem prepend( const QCanvasItem_p & x );
//RENAME    %name(removeIt) QValueListIterator_QCanvasItem remove(QValueListIterator_QCanvasItem it);
//    void remove( const QCanvasItem_p & x );

    %extend {
       VALUE remove(VALUE varg0) {
          if(rb_obj_is_kind_of(varg0,cQCanvasItem_p)) {
             QCanvasItem_p* qip;
             qip = (QCanvasItem_p *)Get_QCanvasItem_p(varg0);
             self->remove(*qip);
             return Qnil;
          } else {
             QValueListIterator_QCanvasItem* qvit;
             QValueListIterator_QCanvasItem* result;
             VALUE vresult;
             result = new QValueListIterator_QCanvasItem(self->remove(*qvit));
             CHECK_PTR(result);
             vresult = Wrap_QValueListIterator_QCanvasItem(
                      cQValueListIterator_QCanvasItem,result);
             return vresult;
          }
       } 
    }
       
    QCanvasItem_p & first();
    QCanvasItem_p & last();
    //QCanvasItem at( uint i );
//    QValueListIterator_QCanvasItem find ( const  QCanvasItem_p & x );
//RENAME    %name(findIt) QValueListIterator_QCanvasItem find ( QValueListIterator_QCanvasItem it, const  QCanvasItem_p &  x );

    %extend {
      QValueListIterator_QCanvasItem find (VALUE varg0,VALUE varg1=Qnil) {
         if(varg1 == Qnil) {
            QCanvasItem_p* qip;
            qip = (QCanvasItem_p *)Get_QCanvasItem_p(varg0);
            return self->find(*qip);
         } else {
            QValueListIterator_QCanvasItem* it;
            QCanvasItem_p* x;
            it = (QValueListIterator_QCanvasItem *)Get_QValueListIterator_QCanvasItem(varg0);
            x = (QCanvasItem_p *)Get_QCanvasItem_p(varg1);
            return self->find(*it,*x);
         }
      }
   }
             

    int findIndex( const QCanvasItem_p & x );
    uint contains( const QCanvasItem_p & x ) const;
    uint count() const;
    void clear();
};


class QCanvasItemExtra;

class QCanvasItem : public Qt
{
public:
    QCanvasItem(QCanvas* canvas);
    //virtual ~QCanvasItem();

    double x() const
	{ return myx; }
    double y() const
	{ return myy; }
    double z() const
	{ return myz; } // (depth)

    virtual void moveBy(double dx, double dy);
    void move(double x, double y);
    void setX(double a) { move(a,y()); }
    void setY(double a) { move(x(),a); }
    void setZ(double a) { myz=a; changeChunks(); }

    bool animated() const;
    virtual void setAnimated(bool y);
    virtual void setVelocity( double vx, double vy);
    void setXVelocity( double vx ) { setVelocity(vx,yVelocity()); }
    void setYVelocity( double vy ) { setVelocity(xVelocity(),vy); }
    double xVelocity() const;
    double yVelocity() const;
    virtual void advance(int stage);

    virtual bool collidesWith( const QCanvasItem* ) const=0;

    QCanvasItemList collisions(bool exact /* NO DEFAULT */ ) const;

    virtual void setCanvas(QCanvas*);

    virtual void draw(QPainter&)=0;

    void show();
    void hide();

    virtual void setVisible(bool yes);
    bool visible() const
	{ return (bool)vis; }
    virtual void setSelected(bool yes);
    bool selected() const
	{ return (bool)sel; }
    virtual void setEnabled(bool yes);
    bool enabled() const
	{ return (bool)ena; }
    virtual void setActive(bool yes);
    bool active() const
	{ return (bool)act; }

    virtual int rtti() const;

    virtual QRect boundingRect() const=0;
    virtual QRect boundingRectAdvanced() const;

    QCanvas* canvas() const
	{ return cnv; }

private:
    // For //friendly sublasses...

    //friend class QCanvasPolygonalItem;
    //friend class QCanvasSprite;
    //friend class QCanvasRectangle;
    //friend class QCanvasPolygon;
    //friend class QCanvasEllipse;
    //friend class QCanvasText;
    //friend class QCanvasLine;

    virtual QPointArray chunks() const;
    virtual void addToChunks();
    virtual void removeFromChunks();
    virtual void changeChunks();
    virtual bool collidesWith(   const QCanvasSprite*,
				 const QCanvasPolygonalItem*,
				 const QCanvasRectangle*,
				 const QCanvasEllipse*,
				 const QCanvasText* ) const=0;
    // End of //friend stuff

    QCanvas* cnv;
    static QCanvas* current_canvas;
    double myx,myy,myz;
    QCanvasItemExtra *ext;
    QCanvasItemExtra& extra();
    uint ani:1;
    uint vis:1;
    uint sel:1;
    uint ena:1;
    uint act:1;

};


class QCanvas : public QObject
{
    //Q_OBJECT
public:
    %extend {
    QCanvas(VALUE varg0=0, VALUE varg1=0, VALUE varg2=0,
            VALUE varg3=0, VALUE varg4=0) {
    if(varg0 == 0) {
       return new QCanvas();
    } else if(TYPE(varg0) == T_FIXNUM) {
       int w,h;
       w = NUM2INT(varg0);
       h = NUM2INT(varg1);
       return new QCanvas(w,h);
    } else if(rb_obj_is_kind_of(varg0,cQObject)) {
       QObject* parent;
       char* name=0;
       parent = (QObject *)Get_QObject(varg0);
       if(varg1 != 0) name = STR2CSTR(varg1);
       return new QCanvas(parent,name);
    } else if(rb_obj_is_kind_of(varg0,cQPixmap)) {
       QPixmap* p;
       int h,v,tilewidth, tileheight;
       p = (QPixmap *)Get_QPixmap(varg0);
       h = NUM2INT(varg1);
       v = NUM2INT(varg2);
       tilewidth = NUM2INT(varg3);
       tileheight = NUM2INT(varg4);
       return new QCanvas(*p,h,v,tilewidth,tileheight);
    } else {
       rb_raise(rb_eArgError, "Tyep error in QCanvas constructor");
       return 0;
    }
 }
 }
 
 
    //QCanvas( QObject* parent = 0, const char* name = 0 );
    //QCanvas(int w, int h);
    //QCanvas( QPixmap p, int h, int v, int tilewidth, int tileheight );
    
    //virtual ~QCanvas();

    virtual void setTiles( QPixmap tiles, int h, int v,
			   int tilewidth, int tileheight );
    virtual void setBackgroundPixmap( const QPixmap& p );
    QPixmap backgroundPixmap() const;

    virtual void setBackgroundColor( const QColor& c );
    QColor backgroundColor() const;

    virtual void setTile( int x, int y, int tilenum );
    int tile( int x, int y ) const
	{ return grid[x+y*htiles]; }

    int tilesHorizontally() const
	{ return htiles; }
    int tilesVertically() const
	{ return vtiles; }

    int tileWidth() const
	{ return tilew; }
    int tileHeight() const
	{ return tileh; }

    virtual void resize(int width, int height);
    int width() const
	{ return awidth; }
    int height() const
	{ return aheight; }
    QSize size() const
	{ return QSize(awidth,aheight); }
//    bool onCanvas( int x, int y ) const
//	{ return x>=0 && y>=0 && x<awidth && y<aheight; }
//RENAME    %name(onCanvasQPoint) bool onCanvas( const QPoint& p ) const
//RENAME	{ return onCanvas(p.x(),p.y()); }
    %extend {
       bool onCanvas(VALUE varg0,VALUE varg1=Qnil) {
          if(varg1 == Qnil) {
             QPoint* p;
             p = (QPoint *)Get_QPoint(varg0);
             return self->onCanvas(*p);
          } else {
             int x,y;
             x = NUM2INT(varg0);
             y = NUM2INT(varg1);
             return self->onCanvas(x,y);
          }
       }
    }
          	
	
//    bool validChunk( int x, int y ) const
//	{ return x>=0 && y>=0 && x<chwidth && y<chheight; }
//RENAME    %name(validChunkQPoint) bool validChunk( const QPoint& p ) const
//	{ return validChunk(p.x(),p.y()); }
    %extend {
       bool validChunk(VALUE varg0,VALUE varg1=Qnil) {
          if(varg1 == Qnil) {
             QPoint* p;
             p = (QPoint *)Get_QPoint(varg0);
             return self->validChunk(*p);
          } else {
             int x,y;
             x = NUM2INT(varg0);
             y = NUM2INT(varg1);
             return self->validChunk(x,y);
          }
       }
    }
 
    int chunkSize() const
	{ return chunksize; }
    virtual void retune(int chunksize, int maxclusters=100);

    bool sameChunk(int x1, int y1, int x2, int y2) const
	{ return x1/chunksize==x2/chunksize && y1/chunksize==y2/chunksize; }
    virtual void setChangedChunk(int i, int j);
    virtual void setChangedChunkContaining(int x, int y);
    virtual void setAllChanged();
    virtual void setChanged(const QRect& inarea);

    // These call setChangedChunk.
    void addItemToChunk(QCanvasItem*, int i, int j);
    void removeItemFromChunk(QCanvasItem*, int i, int j);
    void addItemToChunkContaining(QCanvasItem*, int x, int y);
    void removeItemFromChunkContaining(QCanvasItem*, int x, int y);

    QCanvasItemList allItems();
//    QCanvasItemList collisions( const QPoint&) const;
//RENAME    %name(collisionsQRect) QCanvasItemList collisions( const QRect&) const;
//RENAME    %name(collisionsQPointArray) QCanvasItemList collisions( const QPointArray& pa, const QCanvasItem* item,
//RENAME				bool exact) const;
    %extend {
       QCanvasItemList collisions(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
          if(rb_obj_is_kind_of(varg0,cQPoint)) {
             QPoint* p;
             p = (QPoint *)Get_QPoint(varg0);
             return self->collisions(*p);
          } else if(rb_obj_is_kind_of(varg0,cQRect)) {
             QRect* r;
             r = (QRect *)Get_QRect(varg0);
             return self->collisions(*r);
          } else {
             QPointArray* pa;
             QCanvasItem* item;
             bool exact;
             pa = (QPointArray *)Get_QPointArray(varg0);
             item = (QCanvasItem *)Get_QCanvasItem(varg1);
             exact = (varg2 == Qtrue) ? TRUE:FALSE;
             return self->collisions(*pa,item,exact);
          }
       }
    }

    // These are for QCanvasView to call
    virtual void addView(QCanvasView*);
    virtual void removeView(QCanvasView*);
    void drawArea(const QRect&, QPainter* p=0, bool double_buffer=TRUE);

    // These are for QCanvasItem to call
    virtual void addItem(QCanvasItem*);
    virtual void addAnimation(QCanvasItem*);
    virtual void removeItem(QCanvasItem*);
    virtual void removeAnimation(QCanvasItem*);

    virtual void setAdvancePeriod(int ms);
    virtual void setUpdatePeriod(int ms);

    virtual void setDoubleBuffering(bool y);
/*
signals:
    void resized();
*/
public:  // slot
    virtual void advance();
    virtual void update();

protected:
    virtual void drawBackground(QPainter&, const QRect& area);
    virtual void drawForeground(QPainter&, const QRect& area);

private:
    void init(int w, int h, int chunksze=16, int maxclust=100);

    QCanvasChunk& chunk(int i, int j) const;
    QCanvasChunk& chunkContaining(int x, int y) const;

    void drawChanges(const QRect& inarea);

    QPixmap offscr;
    int awidth,aheight;
    int chunksize;
    int maxclusters;
    int chwidth,chheight;
    QCanvasChunk* chunks;

    QCanvasData* d;

    void initTiles(QPixmap p, int h, int v, int tilewidth, int tileheight);
    ushort *grid;
    ushort htiles;
    ushort vtiles;
    ushort tilew;
    ushort tileh;
    bool oneone;
    QPixmap pm;
    QTimer* update_timer;
    QColor bgcolor;
    bool debug_redraw_areas;
    bool dblbuf;

    //friend void qt_unview(QCanvas* c);

};

class QCanvasView : public QScrollView
{
    //Q_OBJECT
public:
    QCanvasView(QCanvas* viewing=0, QWidget* parent=0, const char* name=0, WFlags f=wfDefault);
    //~QCanvasView();

    QCanvas* canvas() const
	{ return viewing; }
    void setCanvas(QCanvas* v);

protected:
    void drawContents( QPainter*, int cx, int cy, int cw, int ch );
    QSize sizeHint() const;

private:
    QCanvas* viewing;
    //friend void qt_unview(QCanvas* c);
/*
private slots:
    void cMoving(int,int);
    void updateContentsSize();
*/
};


class QCanvasPixmap : public QPixmap
{
public:
    %extend {
       QCanvasPixmap(VALUE varg0, VALUE varg1=0) {
       if(rb_obj_is_kind_of(varg0,cQString) ||
           TYPE(varg0) == T_STRING) {
           QString* qdatafilename;
           char* datafilename;
           if(TYPE(varg0) == T_STRING) {
              datafilename = STR2CSTR(varg0);
           } else {
              qdatafilename = (QString *)Get_QString(varg0);
              datafilename = (char*)(const char*)*qdatafilename;
           }
        return new QCanvasPixmap(datafilename);
        } else if(rb_obj_is_kind_of(varg0,cQImage)) {
           QImage* image;
           image = (QImage *)Get_QImage(varg0);
           return new QCanvasPixmap(*image);
        } else if(rb_obj_is_kind_of(varg0,cQPixmap)) {
           QPixmap* qpix;
           QPoint* hotspot;
            qpix = (QPixmap *)Get_QPixmap(varg0);
           hotspot = (QPoint *)Get_QPoint(varg1);
           return new QCanvasPixmap(*qpix, *hotspot);
        }  else {
           rb_raise(rb_eArgError,"Type Error in QCanvasPixmap constructor");
           return 0;
        }
     }
  }

         
    //QCanvasPixmap(const QString& datafilename);
    //QCanvasPixmap(const QImage& image);
    //QCanvasPixmap(const QPixmap&, QPoint hotspot);
    //~QCanvasPixmap();

    int offsetX() const
	{ return hotx; }
    int offsetY() const
	{ return hoty; }
    void setOffset(int x, int y) { hotx = x; hoty = y; }

private:
    void init(const QImage&);
    void init(const QPixmap& pixmap, int hx, int hy);

    //friend class QCanvasSprite;
    //friend class QCanvasPixmapArray;
    //friend bool qt_testCollision(const QCanvasSprite* s1, const QCanvasSprite* s2);

    int hotx,hoty;

    QImage* collision_mask;

};


class QCanvasPixmapArray
{
public:
    %extend {
       QCanvasPixmapArray(VALUE varg0=0, VALUE varg1=0, VALUE varg2=0) {
        if(varg0 == 0) {
           return new QCanvasPixmapArray();
        } else if(rb_obj_is_kind_of(varg0,cQString) ||
           TYPE(varg0) == T_STRING) {
           QString* qdatafilenamepattern;
           char* datafilenamepattern;
           if(TYPE(varg0) == T_STRING) {
              datafilenamepattern = STR2CSTR(varg0);
           } else {
              qdatafilenamepattern = (QString *)Get_QString(varg0);
              datafilenamepattern = (char*)(const char*)*qdatafilenamepattern;
           }
           int framecount=0;
           if(varg1 != 0) {
              framecount = NUM2INT(varg1);
              }
           return new QCanvasPixmapArray(datafilenamepattern,framecount);
        } else if(TYPE(varg0) == T_ARRAY) {
        QList<QPixmap> pixlist;
        QList<QPoint> pointlist;
        int size = RARRAY(varg0)->len;
        for(int i = 0;i<size;i++) {
           QPixmap* pixmap;
           pixmap = (QPixmap *)Get_QPixmap(RARRAY(varg0)->ptr[i]);
           pixlist.append(pixmap);
           }
        size = RARRAY(varg1)->len;
        for(int i1 = 0;i1<size;i1++) {
           QPoint* point;
           point = (QPoint *)Get_QPoint(RARRAY(varg1)->ptr[i1]);
           pointlist.append(point);
           }
        return new QCanvasPixmapArray(pixlist,pointlist);
        } else {
        rb_raise(rb_eArgError,"Type error in QCanvasPixmapArray constructor");
        }
     }
  }  
  //  QCanvasPixmapArray();
  //  QCanvasPixmapArray(const QString& datafilenamepattern, int framecount=0);
  //  QCanvasPixmapArray(QList<QPixmap>, QList<QPoint> hotspots);
    %extend {
   int check() {
      return !(*self);
   }
   }
    //~QCanvasPixmapArray();

    bool readPixmaps(const QString& datafilenamepattern, int framecount=0);
    bool readCollisionMasks(const QString& filenamepattern);

    //int operator!(); // Failure check.


    QCanvasPixmap* image(int i) const
	{ return img[i]; }
    void setImage(int i, QCanvasPixmap* p);
    uint count() const
	{ return (uint)framecount; }

private:
    bool readPixmaps(const QString& datafilenamepattern, int framecount, bool maskonly);

    void reset();
    int framecount;
    QCanvasPixmap** img;

};


class QCanvasSprite : public QCanvasItem
{
public:
    QCanvasSprite(QCanvasPixmapArray* array, QCanvas* canvas);

    void setSequence(QCanvasPixmapArray* seq);

    //virtual ~QCanvasSprite();

//    void move(double x, double y);
//RENAME    %name(moveXYFrame) virtual void move(double x, double y, int frame);
    %extend {
       void move(VALUE varg0,VALUE varg1,VALUE varg2=Qnil) {
          double x,y;
          x = NUM2DBL(varg0);
          y = NUM2DBL(varg1);
          if(varg2 == Qnil) {
             self->move(x,y);
          } else {
             int frame;
             frame = NUM2INT(varg2);
             self->move(x,y,frame);
          }
       }
    }
       
    void setFrame(int);
    int frame() const
	{ return frm; }
    int frameCount() const
	{ return images->count(); }

    virtual int rtti() const;

    bool collidesWith( const QCanvasItem* ) const;

    QRect boundingRect() const;

protected:
    void draw(QPainter& painter);

    int width() const;
    int height() const;

    int absX() const;
    int absY() const;
    int absX2() const;
    int absY2() const;

    int absX(int nx) const;
    int absY(int ny) const;
    int absX2(int nx) const;
    int absY2(int ny) const;
    QCanvasPixmap* image() const
	{ return images->image(frm); }
    virtual QCanvasPixmap* imageAdvanced() const;
    QCanvasPixmap* image(int f) const
	{ return images->image(f); }

private:
    void addToChunks();
    void removeFromChunks();
    void changeChunks();

    int frm;
    bool collidesWith( const QCanvasSprite*,
		       const QCanvasPolygonalItem*,
		       const QCanvasRectangle*,
		       const QCanvasEllipse*,
		       const QCanvasText* ) const;

    //friend bool qt_testCollision( const QCanvasSprite* s1, 
//				  const QCanvasSprite* s2 );

    QCanvasPixmapArray* images;

};

class QPolygonalProcessor;

class QCanvasPolygonalItem : public QCanvasItem
{
public:
    QCanvasPolygonalItem(QCanvas* canvas);
    //virtual ~QCanvasPolygonalItem();

    bool collidesWith( const QCanvasItem* ) const;

    virtual void setPen(QPen p);
    virtual void setBrush(QBrush b);

    QPen pen() const
	{ return pn; }
    QBrush brush() const
	{ return br; }

    //virtual QPointArray areaPoints() const=0;
    virtual QPointArray areaPointsAdvanced() const;
    QRect boundingRect() const;

    int rtti() const;

protected:
    void draw(QPainter &);
    virtual void drawShape(QPainter &) = 0;

    bool winding() const;
    void setWinding(bool);

private:
    void scanPolygon( const QPointArray& pa, int winding,
		      QPolygonalProcessor& process ) const;
    QPointArray chunks() const;

    bool collidesWith( const QCanvasSprite*,
		       const QCanvasPolygonalItem*,
		       const QCanvasRectangle*,
		       const QCanvasEllipse*,
		       const QCanvasText* ) const;

    QBrush br;
    QPen pn;
    uint wind:1;

};


class QCanvasRectangle : public QCanvasPolygonalItem
{
public:
    %extend {
       QCanvasRectangle(VALUE varg0, VALUE varg1=0, VALUE varg2=0,
                        VALUE varg3=0, VALUE varg4=0) {
      if(TYPE(varg0) == T_FIXNUM) {
          int x,y,width,height;
          QCanvas* canvas;
          x = NUM2INT(varg0);
          y = NUM2INT(varg1);
          width = NUM2INT(varg2);
          height = NUM2INT(varg3);
          canvas = (QCanvas *)Get_QCanvas(varg4);
          return new QCanvasRectangle(x,y,width,height,canvas);
       } else if(rb_obj_is_kind_of(varg0,cQCanvas)) {
          QCanvas* canvas;
          canvas = (QCanvas *)Get_QCanvas(varg0);
          return new QCanvasRectangle(canvas);
       } else if(rb_obj_is_kind_of(varg0,cQRect)) {
          QRect* qrect;
          QCanvas* canvas;
           qrect = (QRect *)Get_QRect(varg0);
           canvas = (QCanvas *)Get_QCanvas(varg1);
          return new QCanvasRectangle(*qrect, canvas);
       } else {
          rb_raise(rb_eArgError,"Type error in QCanvasRectangle constructor");
       }
    }
 }
    //QCanvasRectangle(QCanvas* canvas);
    //QCanvasRectangle(const QRect&, QCanvas* canvas);
    //QCanvasRectangle(int x, int y, int width, int height, QCanvas* canvas);

    //~QCanvasRectangle();

    int width() const;
    int height() const;
    void setSize(int w, int h);
    QSize size() const
	{ return QSize(w,h); }
    QPointArray areaPoints() const;
    QRect rect() const
	{ return QRect(int(x()),int(y()),w,h); }

    bool collidesWith( const QCanvasItem* ) const;

    int rtti() const;



protected:
    void drawShape(QPainter &);
    QPointArray chunks() const;

private:
    bool collidesWith(   const QCanvasSprite*,
			 const QCanvasPolygonalItem*,
			 const QCanvasRectangle*,
			 const QCanvasEllipse*,
			 const QCanvasText* ) const;

    int w, h;

};


class QCanvasPolygon : public QCanvasPolygonalItem
{
public:
    QCanvasPolygon(QCanvas* canvas);
    //~QCanvasPolygon();
    void setPoints(QPointArray);
    QPointArray points() const;
    void moveBy(double dx, double dy);

    QPointArray areaPoints() const;
    int rtti() const;

protected:
    void drawShape(QPainter &);
    QPointArray poly;

};


class QCanvasLine : public QCanvasPolygonalItem
{
public:
    QCanvasLine(QCanvas* canvas);
    //~QCanvasLine();
    void setPoints(int x1, int y1, int x2, int y2);

    QPoint startPoint() const
	{ return QPoint(x1,y1); }
    QPoint endPoint() const
	{ return QPoint(x2,y2); }

    int rtti() const;

    void setPen(QPen p);

protected:
    void drawShape(QPainter &);
    QPointArray areaPoints() const;

private:
    int x1,y1,x2,y2;

};


class QCanvasEllipse : public QCanvasPolygonalItem
{

public:
    %extend {
       QCanvasEllipse(VALUE varg0, VALUE varg1=0, VALUE varg2=0,
                        VALUE varg3=0, VALUE varg4=0) {
       if(rb_obj_is_kind_of(varg0,cQCanvas)) {
          QCanvas* canvas;
          canvas = (QCanvas *)Get_QCanvas(varg0);
          return new QCanvasEllipse(canvas);
       } else if(rb_obj_is_kind_of(varg2,cQCanvas)) {
          int width,height;
          QCanvas* canvas;
          width = NUM2INT(varg0);
          height = NUM2INT(varg1);
           canvas = (QCanvas *)Get_QCanvas(varg2);
          return new QCanvasEllipse(width,height, canvas);
       } else if(rb_obj_is_kind_of(varg4,cQCanvas)) {
          int x,y,startangle,angle;
          QCanvas* canvas;
          x = NUM2INT(varg0);
          y = NUM2INT(varg1);
          startangle = NUM2INT(varg2);
          angle = NUM2INT(varg3);
          canvas = (QCanvas *)Get_QCanvas(varg4);
          return new QCanvasEllipse(x,y,startangle,angle,canvas);
       } else {
          rb_raise(rb_eArgError,"Type error in QCanvasEllipse constructor");
       }
    }
 }

    //QCanvasEllipse( QCanvas* canvas );
    //QCanvasEllipse( int width, int height, QCanvas* canvas );
    //QCanvasEllipse( int width, int height, int startangle, int angle,
//		    QCanvas* canvas );

    //~QCanvasEllipse();

    int width() const;
    int height() const;
    void setSize(int w, int h);
    void setAngles(int start, int length);
    int angleStart() const
	{ return a1; }
    int angleLength() const
	{ return a2; }
    QPointArray areaPoints() const;

    bool collidesWith( const QCanvasItem* ) const;

    int rtti() const;

protected:
    void drawShape(QPainter &);

private:
    bool collidesWith( const QCanvasSprite*,
		       const QCanvasPolygonalItem*,
		       const QCanvasRectangle*,
		       const QCanvasEllipse*,
		       const QCanvasText* ) const;
    int w, h;
    int a1, a2;

};


class QCanvasTextExtra;

class QCanvasText : public QCanvasItem
{
public:
    %extend {
       QCanvasText(VALUE varg0, VALUE varg1=0, VALUE varg2=0) {
       if(rb_obj_is_kind_of(varg0,cQCanvas)) {
          QCanvas* canvas;
          canvas = (QCanvas *)Get_QCanvas(varg0);
          return new QCanvasText(canvas);
       } else if(rb_obj_is_kind_of(varg1,cQCanvas)) {
          QString* text;
          QCanvas* canvas;
           text = (QString *)Get_QString(varg0);
           canvas = (QCanvas *)Get_QCanvas(varg1);
          return new QCanvasText(*text, canvas);
       } else if(rb_obj_is_kind_of(varg2,cQCanvas)) {
          QString* text;
          QFont* font;
          QCanvas* canvas;
           text = (QString *)Get_QString(varg0);
           font = (QFont *)Get_QFont(varg1);
          canvas = (QCanvas *)Get_QCanvas(varg2);
          return new QCanvasText(*text,*font,canvas);
       } else {
          rb_raise(rb_eArgError,"Type error in QCanvasText constructor");
       }
    }
 }

    //QCanvasText(QCanvas* canvas);
    //QCanvasText(const QString&, QCanvas* canvas);
    //QCanvasText(const QString&, QFont, QCanvas* canvas);

    //virtual ~QCanvasText();

    void setText( const QString& );
    void setFont( const QFont& );
    void setColor( const QColor& );
    QString text() const;
    QFont font() const;
    QColor color() const;

    void moveBy(double dx, double dy);

    int textFlags() const
	{ return flags; }
    void setTextFlags(int);

    QRect boundingRect() const;

    bool collidesWith( const QCanvasItem* ) const;

    virtual int rtti() const;

protected:
    virtual void draw(QPainter&);

private:
    void addToChunks();
    void removeFromChunks();
    void changeChunks();

    void setRect();
    QRect brect;
    QString txt;
    int flags;
    QFont fnt;
    QColor col;
    QCanvasTextExtra* extra;

    bool collidesWith(   const QCanvasSprite*,
			 const QCanvasPolygonalItem*,
			 const QCanvasRectangle*,
			 const QCanvasEllipse*,
			 const QCanvasText* ) const;

};


//#endif // QT_NO_CANVAS

//#endif // QCANVAS_H
