/***************************************************************************
                    qxmlrubyhandler.cpp  -  description
                           -------------------
  begin                : Sat Aug 18 14:06:26 JST 2001
  copyright            : (C) 2001 by Nobuyuki Horie
  email                : horie@smail.u-shizuoka-ken.ac.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * $Id: TemplateDialog.cc,v 1.9 1999/03/09 09:50:48 gerd Exp $
 * Purpose: 
 * Author:  
 */

#include "qxmlrubyhandler.h"


QXmlRubyHandler::QXmlRubyHandler():
ruby_obj(Qnil)
{}
QXmlRubyHandler::~QXmlRubyHandler()
{}
void QXmlRubyHandler::setSelf(VALUE rb_obj)
{
   ruby_obj = rb_obj;
}
/**
*/
void QXmlRubyHandler::setDocumentLocator( QXmlLocator* locator)
{
	
}
bool  QXmlRubyHandler::startDocument()
{
//qDebug("startDocument called in C++");
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"startDocument")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("startDocument"),0,0);
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing
   return TRUE;
   }      
}
bool  QXmlRubyHandler::endDocument()
{
//qDebug("endDocument called in C++");
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"endDocument")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("endDocument"),0,0);
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::startPrefixMapping( const QString& prefix, const QString& uri )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"startPrefixMapping")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("startPrefixMapping"),
         2,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&prefix)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&uri)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::endPrefixMapping( const QString& prefix )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"endPrefixMapping")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("endPrefixMapping"),
   1,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&prefix)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::startElement( const QString& namespaceURI, const QString& localName, const QString& qName, const QXmlAttributes& atts )
{
//qDebug("startElement called in C++");
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"startElement")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("startElement"),
   4,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&namespaceURI)),
   (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&localName)),
   (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&qName)),
   (Data_Wrap_Struct(cQXmlAttributes.klass,0,0,(QXmlAttributes*)&atts)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::endElement( const QString& namespaceURI, const QString& localName, const QString& qName )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"endElement")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("endElement"),
         3,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&namespaceURI)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&localName)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&qName)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::characters( const QString& ch )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"characters")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("characters"),
         1,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&ch)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::ignorableWhitespace( const QString& ch )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"ignorableWhitespace")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("ignorableWhitespace"),
         1,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&ch)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::processingInstruction( const QString& target, const QString& data )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"processingInstruction")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("processingInstruction"),
         2,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&target)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&data)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::skippedEntity( const QString& name )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"skippedEntry")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("skippedEntry"),
         1,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&name)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::warning( const QXmlParseException& exception )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"warning")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("warning"),
         1,(Data_Wrap_Struct(cQXmlParseException.klass,0,0,(QXmlParseException*)&exception)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::error( const QXmlParseException& exception )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"error")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("error"),
         1,(Data_Wrap_Struct(cQXmlParseException.klass,0,0,(QXmlParseException*)&exception)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::fatalError( const QXmlParseException& exception )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"fatalError")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("fatalError"),
         1,(Data_Wrap_Struct(cQXmlParseException.klass,0,0,(QXmlParseException*)&exception)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::notationDecl( const QString& name, const QString& publicId, const QString& systemId )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"notationDecl")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("notationDecl"),
         3,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&name)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&publicId)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&systemId)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::unparsedEntityDecl( const QString& name, const QString& publicId, const QString& systemId, const QString& notationName )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"unparsedEntityDecl")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("unparsedEntityDecl"),
         3,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&name)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&publicId)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&systemId)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&notationName)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::resolveEntity( const QString& publicId, const QString& systemId, QXmlInputSource* ret )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"resolveEntity")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("resolveEntity"),
         3,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&publicId)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&systemId)),
         (Data_Wrap_Struct(cQXmlInputSource.klass,0,0,ret)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::startDTD( const QString& name, const QString& publicId, const QString& systemId )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"startDTD")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("startDTD"),
         3,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&name)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&publicId)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&systemId)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::endDTD()
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"endDTD")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("endDTD"),0,0);
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

//    bool  QXmlRubyHandler::startEntity( const QString& name );
//    bool  QXmlRubyHandler::endEntity( const QString& name );
bool  QXmlRubyHandler::startCDATA()
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"startCDATA")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("startCDATA"),0,0);
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::endCDATA()
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"endCDATA")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("endCDATA"),0,0);
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::comment( const QString& ch )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"comment")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("comment"),
         1,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&ch)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}


bool  QXmlRubyHandler::attributeDecl( const QString& eName, const QString& aName, const QString& type, const QString& valueDefault, const QString& value )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"attributeDecl")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("attributeDecl"),
         4,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&eName)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&aName)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&valueDefault)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&value)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::internalEntityDecl( const QString& name, const QString& value )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"internalEntityDecl")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("internalEntityDecl"),
         2,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&name)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&value)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

bool  QXmlRubyHandler::externalEntityDecl( const QString& name, const QString& publicId, const QString& systemId )
{
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"externalEntityDecl")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("externalEntityDecl"),
         3,(Data_Wrap_Struct(cQString.klass,0,0,(QString*)&name)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&publicId)),
         (Data_Wrap_Struct(cQString.klass,0,0,(QString*)&systemId)));
   return ((result == Qtrue) ? TRUE:FALSE);
   } else {
   //do nothing.
   return TRUE;
   }      
}

QString  QXmlRubyHandler::errorString()
{
   QString* cresult;
   if(ruby_obj != Qnil && ruby_respondTo(ruby_obj,"errorString")) {
   VALUE result = rb_funcall(ruby_obj,rb_intern("errorString"),0,0);
   cresult = (QString *)Get_QString(result);
   return *cresult;
   } else {
   //do nothing.
   QString error("Default Error String(QXmlRubyHandler)");
   return error;
   }      
}

