/***************************************************************************
                    qxmlrubyhandler.h  -  description
                           -------------------
  begin                : Sat Aug 18 14:06:27 JST 2001
  copyright            : (C) 2001 by Nobuyuki Horie
  email                : horie@smail.u-shizuoka-ken.ac.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * $Id: TemplateDialog.cc,v 1.9 1999/03/09 09:50:48 gerd Exp $
 * Purpose: 
 * Author:  
 */

#ifndef _QXmlRubyHandler_h
#define _QXmlRubyHandler_h

#include "qrbfunction.h"
#include <ruby.h>
#include <qxml.h>
#ifndef WIN32
  #include "swig_class_qte.h"
#endif
#include "swig_class_qtexml.h"



class QXmlRubyHandler : public QXmlDefaultHandler
/**
*/
{
   public:
    QXmlRubyHandler();
    virtual ~QXmlRubyHandler();
    void setSelf(VALUE rb_obj);
    VALUE to_ruby_obj() {return ruby_obj;};

    void setDocumentLocator( QXmlLocator* locator );
    bool startDocument();
    bool endDocument();
    bool startPrefixMapping( const QString& prefix, const QString& uri );
    bool endPrefixMapping( const QString& prefix );
    bool startElement( const QString& namespaceURI, const QString& localName, const QString& qName, const QXmlAttributes& atts );
    bool endElement( const QString& namespaceURI, const QString& localName, const QString& qName );
    bool characters( const QString& ch );
    bool ignorableWhitespace( const QString& ch );
    bool processingInstruction( const QString& target, const QString& data );
    bool skippedEntity( const QString& name );

    bool warning( const QXmlParseException& exception );
    bool error( const QXmlParseException& exception );
    bool fatalError( const QXmlParseException& exception );

    bool notationDecl( const QString& name, const QString& publicId, const QString& systemId );
    bool unparsedEntityDecl( const QString& name, const QString& publicId, const QString& systemId, const QString& notationName );

    bool resolveEntity( const QString& publicId, const QString& systemId, QXmlInputSource* ret );

    bool startDTD( const QString& name, const QString& publicId, const QString& systemId );
    bool endDTD();
//    bool startEntity( const QString& name );
//    bool endEntity( const QString& name );
    bool startCDATA();
    bool endCDATA();
    bool comment( const QString& ch );

    bool attributeDecl( const QString& eName, const QString& aName, const QString& type, const QString& valueDefault, const QString& value );
    bool internalEntityDecl( const QString& name, const QString& value );
    bool externalEntityDecl( const QString& name, const QString& publicId, const QString& systemId );

    QString errorString();
private:
protected:
    VALUE ruby_obj;
public:
};

#endif

