
if i = ARGV.index(/\A--rbconfig=/) then
  file = $'
  ARGV.delete_at(i)
  require file
else
  require 'rbconfig'
end


class ConfigTable

  c = ::Config::CONFIG

  rubypath = c['bindir'] + '/' + c['ruby_install_name']

  major = c['MAJOR'].to_i
  minor = c['MINOR'].to_i
  teeny = c['TEENY'].to_i
  version = "#{major}.#{minor}"

  # ruby version >= 3.0.2 ?
  newpath_p = ((major >= 2) or
               ((major == 1) and
                ((minor >= 5) or
                 ((minor == 4) and (teeny >= 4)))))
  
  if c['rubylibdir'] then
    # V > 1.6.3
    stdruby    = c['rubylibdir'] .sub( c['prefix'], '$prefix' )
    siteruby   = c['sitelibdir'] .sub( c['prefix'], '$prefix' )
    sodir      = c['sitearchdir'].sub( c['prefix'], '$prefix' )
  elsif newpath_p then
    # 1.4.4 <= V <= 1.6.3
    stdruby    = "$prefix/lib/ruby/#{version}"
    siteruby   = c['sitedir'].sub( c['prefix'], '$prefix' ) + '/' + version
    sodir      = "$site-ruby/#{c['arch']}"
  else
    # V < 1.4.4
    stdruby    = "$prefix/lib/ruby/#{version}"
    siteruby   = "$prefix/lib/ruby/#{version}/site_ruby"
    sodir      = "$site-ruby/#{c['arch']}"
  end

  DESCRIPTER = [
    [ 'prefix',    [ c['prefix'],
                     'path',
                     'path prefix' ] ],
    [ 'std-ruby',  [ stdruby,
                     'path',
                     'the directory for standard ruby libraries' ] ],
    [ 'site-ruby', [ siteruby,
                     'path',
                     'the directory for non-standard ruby libraries' ] ],
    [ 'bin-dir',   [ '$prefix/bin',
                     'path',
                     'the directory for commands' ] ],
    [ 'rb-dir',    [ '$site-ruby',
                     'path',
                     'the directory for ruby scripts' ] ],
    [ 'so-dir',    [ sodir,
                     'path',
                     'the directory for ruby extentions' ] ],
    [ 'data-dir',  [ '$prefix/share',
                     'path',
                     'the directory for shared data' ] ],
    [ 'ruby-path', [ rubypath,
                     'path',
                     'path to set to #! line' ] ],
    [ 'ruby-prog', [ rubypath,
                     'path',
                     'the ruby program using for installation' ] ],
    [ 'make-prog', [ 'make',
                     'name',
                     'the make program to compile ruby extentions' ] ],
  ]

  def self.each_name( &block )
    keys().each( &block )
  end

  def self.keys
    DESCRIPTER.collect {|k,*dummy| k }
  end


  SAVE_FILE = 'config.save'

  def self.create
    c = new()
    c.init
    c
  end

  def self.load
    c = new()
    File.file? SAVE_FILE or
            raise InstallError, "#{File.basename $0} config first"
    File.foreach( SAVE_FILE ) do |line|
      k, v = line.split( '=', 2 )
      c.noproc_set k, v.strip
    end
    c
  end

  def initialize
    @table = {}
  end

  def init
    DESCRIPTER.each do |k, (default, vname, desc, default2)|
      @table[k] = default
    end
  end

  def save
    File.open( SAVE_FILE, 'w' ) do |f|
      @table.each do |k, v|
        f.printf "%s=%s\n", k, v if v
      end
    end
  end

  def []=( k, v )
    d = DESCRIPTER.assoc(k) or
            raise InstallError, "unknown config option #{k}"
    if d[1][1] == 'path' and v[0,1] != '$' then
      @table[k] = File.expand_path(v)
    else
      @table[k] = v
    end
  end
    
  def []( key )
    @table[key] and @table[key].sub( %r_\$([^/]+)_ ) { self[$1] }
  end

  def noproc_set( key, val )
    @table[key] = val
  end

  def noproc_get( key )
    @table[key]
  end

end

