
module FileOperations

  def isdir( dn )
    mkdir_p dn
    dn
  end

  def mkdir_p( dname )
    $stderr.puts "mkdir -p #{dname}" if verbose?
    return if no_harm?

    # does not check '/'... it's too abnormal case
    dirs = dname.split(%r_(?=/)_)
    if /\A[a-z]:\z/i === dirs[0] then
      disk = dirs.shift
      dirs[0] = disk + dirs[0]
    end
    dirs.each_index do |idx|
      path = dirs[0..idx].join('')
      Dir.mkdir path unless dir? path
    end
  end

  def rm_f( fname )
    $stderr.puts "rm -f #{fname}" if verbose?
    return if no_harm?

    if File.exist? fname or File.symlink? fname then
      File.chmod 0777, fname
      File.unlink fname
    end
  end

  def rm_rf( dn )
    $stderr.puts "rm -rf #{dn}" if verbose?
    return if no_harm?

    Dir.chdir dn
    Dir.foreach('.') do |fn|
      next if fn == '.'
      next if fn == '..'
      if dir? fn then
        verbose_off {
          rm_rf fn
        }
      else
        verbose_off {
          rm_f fn
        }
      end
    end
    Dir.chdir '..'
    Dir.rmdir dn
  end

  def mv( src, dest )
    rm_f dest
    begin
      File.link src, dest
    rescue
      File.open( dest, 'wb' ) {|w|
          File.open(src, 'rb') {|r| w.write r.read }
      }
      File.chmod File.stat(src).mode, dest
    end
    rm_f src
  end

  def install( from, to, mode )
    $stderr.puts "install #{from} #{to}" if verbose?
    return if no_harm?

    if dir? to then
      to = to + '/' + File.basename(from)
    end
    str = nil
    File.open( from, 'rb' ) {|f| str = f.read }
    if diff? str, to then
      verbose_off {
        rm_f to if File.exist? to
      }
      File.open( to, 'wb' ) {|f| f.write str }
      File.chmod mode, to

      File.open( objdir + '/InstalledFiles', 'a' ) {|f| f.puts to }
    end
  end

  def diff?( orig, comp )
    return true unless File.exist? comp
    s2 = nil
    File.open( comp, 'rb' ) {|f| s2 = f.read }
    orig != s2
  end

  def command( str )
    $stderr.puts str if verbose?
    system str or raise RuntimeError, "'system #{str}' failed"
  end

  def ruby( str )
    command config('ruby-prog') + ' ' + str
  end

  def dir?( dname )
    # for corrupted windows stat()
    File.directory?( (dname[-1,1] == '/') ? dname : dname + '/' )
  end

  def all_files( dname )
    Dir.open( dname ) {|d|
      return d.find_all {|n| File.file? "#{dname}/#{n}" }
    }
  end

  def all_dirs( dname )
    Dir.open( dname ) {|d|
      return d.find_all {|n| dir? "#{dname}/#{n}" } - %w(. ..)
    }
  end

end

