
ConfigTable::DESCRIPTER.concat [

  [ 'with',     [ '',
                  'name,name...',
                  'package names that you want to install',
                  'ALL' ] ],
  [ 'without',  [ '',
                  'name,name...',
                  'package names that you do not want to install',
                  'NONE' ] ]
]


class PackageManager < ToplevelInstaller

  def print_usage( f )
    super
    f.puts 'Inluded packages:'
    f.puts '  ' + packages.sort.join(' ')
    f.puts
  end

  #
  # tasks
  #

  def exectask( task )
    load_installers
    init_selection
    super
  end

  def exec_config
    each_selected_installers {|inst| inst.exec_config }
    @config.save
  end

  def exec_setup
    each_selected_installers {|inst| inst.exec_setup }
  end

  def exec_install
    each_selected_installers {|inst| inst.exec_install }
  end

  def exec_clean
    each_selected_installers {|inst| inst.exec_clean }
  end

  #
  # packages
  #

  def packages
    packs = all_dirs(srcdir + '/packages')
    packs.empty? and raise InstallError, 'no package available'
    packs.sort!
  end

  def load_installers
    @installers = {}
    packages.each do |dir|
      @installers[dir] = Installer.new( @config, @options,
                                        srcdir + '/packages/' + dir,
                                        'packages/' + dir )
    end
  end

  def init_selection
    with    = extract_sel( config('with') )
    without = extract_sel( config('without') )

    @selected = @installers.keys.find_all {|name|
        (with.empty? or with.include? name) and
        not without.include? name
    }
	@selected.sort
  end

  def extract_sel( list )
    a = list.split(',')
    a.each do |name|
      @installers.key? name or raise InstallError, "no such package: #{name}"
    end
    a
  end

  def each_selected_installers
    dive_into( 'packages' ) {
      @selected.each do |name|
        dive_into( 'packages/' + name ) {
          yield @installers[name]
        }
      end
    }
  end

=begin
  def init_selection
    with    = extract_dirs( config('with') )
    without = extract_dirs( config('without') )

    packs = packages()
    [ [with,    with_pack    = [], with_dir    = []],
      [without, without_pack = [], without_dir = []] ].each do |orig, pack, dir|
      orig.each do |i|
        if    packs.include? i then pack.push i
        elsif dir? i           then dir.push i
        else
          raise InstallError, "no such package or directory '#{i}'"
        end
      end
    end

    @installers.delete_if {|name, inst|
        not is_included? name, with_pack, without_pack   \
                            and
        inst.descripter.keys.delete_if {|d|
                not is_included? d, with_dir, without_dir }.empty?
    }
    @installers.each do |name, inst|
      if is_included? name, with_pack, without_pack then
        inst.descripter.delete_if {|k,v| without_dir.include? k }
      else
        inst.descripter.delete_if {|k,v| not with_dir.include? k }
      end
    end
  end

  def extract_dirs( s )
    ret = []
    s.split(',').each do |i|
      if /[\*\?]/ === i then
        tmp = Dir.glob(i)
        tmp.delete_if {|d| not dir? d }
        if tmp.empty? then
          tmp.push i   # causes error
        else
          ret.concat tmp
        end
      else
        ret.push i
      end
    end

    ret
  end

  def is_included?( name, with, without )
    if with.empty? then
      not without.include? name
    else
      with.include? name
    end
  end

  def install_dir?( dir )
    true
  end
=end

end

