=begin
/****************************************************************
**
** Implementation CannonField class, Qt tutorial 11
**
****************************************************************/
=end

include Math

class  CannonField < QWidget
attr_reader:angleChanged
attr_reader:forceChanged

def initialize ( parent, name )
    super( parent, name )
    @angleChanged = RSignal.new("int")
    @forceChanged = RSignal.new("int")
    @ang = 45
    @f = 0
    @timerCount = 0
    @autoShootTimer = QTimer.new(self,"movement handler")
    connect( @autoShootTimer,QSIGNAL("timeout()"), self,"moveShot")
    @shoot_ang =0
    @shoot_f =0
    setPalette( QPalette.new( QColor.new( 250, 250, 200,QColor::Rgb) ) )
    @barrelRect = QRect.new(33, -4, 15, 8)

    catchEvent
end


def setAngle( degrees )

    if ( degrees < 5 )
	degrees = 5
    elsif ( degrees > 70 )
	degrees = 70
    end
    if ( @ang == degrees )
	return
    end
    @ang = degrees
    repaint()
    @angleChanged.sendWith( @ang )
end

def setForce( newton)
    if ( newton < 0 )
	newton = 0
    elsif ( @f == newton )
	return
    end
    @f = newton
    @forceChanged.sendWith( @f )
end

def shoot
    if ( @autoShootTimer.isActive() )
	return
    end
    @timerCount = 0
    @shoot_ang = @ang
    @shoot_f = @f
    @autoShootTimer.start( 50 )
end

def moveShot
    r = QRegion.new(shotRect().x(),shotRect().y(),shotRect().width(),shotRect().height())
    @timerCount = @timerCount + 1

    shotR = shotRect()
    if ( shotR.x() > width() || shotR.y() > height() )
	@autoShootTimer.stop()
    else
	r = r.unite( QRegion.new( shotR.x(),shotR.y(),shotR.width(),shotR.height() ) )
    end
    repaint( r )
end

def paintEvent( e )
    updateR = e.rect()
    if(@p.nil?)
      @p = QPainter.new
    end
    @p.begin(self)
    if ( updateR.intersects( cannonRect() ) )
	paintCannon( @p )
    end
    if ( @autoShootTimer.isActive() &&
	 updateR.intersects( shotRect() ) )
	paintShot( @p )
    end
    @p.end
end

def paintShot( p )
    p.setBrush( Qt::black )
    p.setPen( Qt::NoPen )
    p.drawRect( shotRect() )
end

def paintCannon(p)
    cr = cannonRect()
    pix = QPixmap.new(cr.size())
    pix.fill(self,cr.topLeft())

    if(@tmp.nil?)
      @tmp = QPainter.new
    end
    @tmp.begin(pix)
    @tmp.setBrush( Qt::blue )
    @tmp.setPen( Qt::NoPen )

    @tmp.translate( 0, pix.height() - 1 )
    @tmp.drawPie( QRect.new(-35, -35, 70, 70), 0, 90*16 )
    @tmp.rotate( -@ang )
    @tmp.drawRect( QRect.new(33, -4, 15, 8) )
    @tmp.end()

    p.drawPixmap(cr.topLeft(),pix)
end

def cannonRect
    r = QRect.new(0,0,50,50)
    r.moveBottomLeft(rect().bottomLeft())
    r
end

def shotRect
     gravity = 4

     time      = @timerCount / 4.0
     velocity  = @shoot_f
     radians   = @shoot_ang*3.14159265/180

     velx      = velocity*cos( radians )
     vely      = velocity*sin( radians )
     x0        = ( @barrelRect.right()  + 5 )*cos(radians)
     y0        = ( @barrelRect.right()  + 5 )*sin(radians)
     x         = x0 + velx*time
     y         = y0 + vely*time - 0.5*gravity*time*time

    r = QRect.new( 0, 0, 6, 6 )
    r.moveCenter( QPoint.new( x.round, height() - 1 - y.round ) )
    r
end


def sizePolicy()
    QSizePolicy.new( QSizePolicy::Expanding, QSizePolicy::Expanding )
end

end
