=begin
/****************************************************************
**
** Implementation of GameBoard class, Qt tutorial 14
**
****************************************************************/
=end


class GameBoard < QWidget
def initialize( parent=nil, name="" )
        super( parent, name )
    @quit = QPushButton.new( "Quit", self, "quit" )
    @quit.setFont( QFont.new( "Times", 18, QFont::Bold ) )

    connect( @quit, QSIGNAL("clicked()"), QApplication::qApp, QSLOT("quit()") )

    @angle = LCDRange.new( self, "angle" )
    @angle.setText("Angle")
    @angle.setRange( 5, 70 )

    @force = LCDRange.new( self, "force")
    @force.setText("Force")
    @force.setRange(10,50)
    box = QVBox.new(self,"cannonFrame")
    box.setFrameStyle(QFrame::WinPanel | QFrame::Sunken)

    @cannonField= CannonField.new( box, "cannonField" )

    connect( @angle.valueChanged, @cannonField, "setAngle" )
    connect( @cannonField.angleChanged,  @angle, "setValue" )

    connect( @force.valueChanged, @cannonField, "setForce" )
    connect( @cannonField.forceChanged, @force, "setValue")


    connect( @cannonField.hit(), self, "hit" )
    connect( @cannonField.missed(), self, "missed" )

    @shoot = QPushButton.new( "&Shoot", self, "shoot" )
    @shoot.setFont( QFont.new( "Times", 18, QFont::Bold ) )

    connect( @shoot, QSIGNAL("clicked()"), self,"fire")
    connect( @cannonField.canShoot,@shoot,QSLOT("setEnabled(bool)") )


    @restart = QPushButton.new( "&New Game", self, "newgame" )
    @restart.setFont( QFont.new( "Times", 18, QFont::Bold ) )

    connect( @restart, QSIGNAL("clicked()"), self, "newGame" )

    @hits = QLCDNumber.new( 2, self, "hits" )
    @shotsLeft = QLCDNumber.new( 2, self, "shotsleft" )
    @hitsL = QLabel.new( "HITS", self, "hitsLabel" )
    @shotsLeftL = QLabel.new( "SHOTS LEFT", self, "shotsleftLabel" )

    @accel = QAccel.new( self )
#    accel.connectItem( accel.insertItem( Key_Enter ),self, SLOT(fire()) )
#    accel.connectItem( accel.insertItem( Key_Return ),self, SLOT(fire()) )
    @accel.connectItem( @accel.insertItem( Key_Enter ),@shoot, QSIGNAL("clicked()"))
    @accel.connectItem( @accel.insertItem( Key_Return ),@shoot,QSIGNAL("clicked()"))

    @accel.connectItem( @accel.insertItem( CTRL+Key_Q ),QApplication::qApp, QSLOT("quit()") )

    grid = QGridLayout.new( self, 2, 2, 10 )
    grid.addWidget( @quit, 0, 0 )
    grid.addWidget( box, 1, 1 )
    grid.setColStretch( 1, 10 )

    leftBox = QVBoxLayout.new
    grid.addLayout( leftBox, 1, 0 )
    leftBox.addWidget( @angle )
    leftBox.addWidget( @force )

    topBox = QHBoxLayout.new
    grid.addLayout( topBox, 0, 1 )
    topBox.addWidget( @shoot )
    topBox.addWidget( @hits )
    topBox.addWidget( @hitsL )
    topBox.addWidget( @shotsLeft )
    topBox.addWidget( @shotsLeftL )
    topBox.addStretch( 1 )
    topBox.addWidget( @restart )

    @angle.setValue( 60 )
    @force.setValue( 25 )
    @angle.setFocus()

    newGame()
end


def fire

    if ( @cannonField.gameOver() || @cannonField.isShooting() )
	return
    end
    @shotsLeft.display( @shotsLeft.intValue() - 1 )
    @cannonField.shoot()
end


def hit

    @hits.display( @hits.intValue() + 1 )
    if ( @shotsLeft.intValue() == 0 )
	@cannonField.setGameOver()
    else
	@cannonField.newTarget()
    end
end


def missed()

    if ( @shotsLeft.intValue() == 0 )
	@cannonField.setGameOver()
    end
end


def newGame

    @shotsLeft.display( 15 )
    @hits.display( 0 )
    @cannonField.restartGame()
    @cannonField.newTarget()
end

end
