=begin
/****************************************************************
**
** Implementation CannonField class, Qt tutorial 8
**
****************************************************************/
=end


class  CannonField < QWidget
attr_reader:angleChanged

def initialize ( parent, name )
    super( parent, name )
    @angleChanged = RSignal.new("int")
    @ang = 45
    setPalette( QPalette.new( QColor.new( 250, 250, 200,QColor::Rgb) ) )
    catchEvent
end


def setAngle( degrees )

    if ( degrees < 5 )
	degrees = 5
    elsif ( degrees > 70 )
	degrees = 70
    end
    if ( @ang == degrees )
	return
    end
    @ang = degrees
    repaint()
    @angleChanged.sendWith( @ang )
end


def paintEvent( ev )
    if (@p.nil?)
      @p = QPainter.new
    end
    @p.begin(self)
    @p.setBrush( Qt::blue )
    @p.setPen( Qt::NoPen )

    @p.translate( 0, rect().bottom() )
    @p.drawPie( QRect.new(-35, -35, 70, 70), 0, 90*16 )
    @p.rotate( -@ang )
    @p.drawRect( QRect.new(33, -4, 15, 8) )
    @p.end
end


def sizePolicy()
    QSizePolicy.new( QSizePolicy::Expanding, QSizePolicy::Expanding )
end

end
