#!/usr/bin/env ruby
require "qte"
include Qte
require "qpe"
include Qpe
require "qtexml"
include Qtexml

class StructureParser < QXmlRubyHandler

def initialize
   super
   setSelf(self)
   @indent = 1

end

def startDocument
    @indent = 1
    TRUE
end

def startElement(qstr1,qstr2,qName,qattr)
   print "#{\" \" * @indent}#{qName.to_str}\n"
   @indent += 1
   TRUE
end

def endElement(qstr1, qstr2,qstr3)
   @indent -= 1
   TRUE
end

end

a = QPEApplication.new([$0]+ARGV)
for i in 0..(ARGV.size - 1)
   handler = StructureParser.new
   if ARGV.size == 0
      p "usage: ruby sax.rb <xmlfile.xml>..."
   end
p ARGV[i] + "is parsing..."
   xmlFile = File.new(ARGV[i],"r")
   source = QXmlInputSource.new
   source.setData(xmlFile.read)
   reader = QXmlSimpleReader.new
   reader.setContentHandler( handler)
   reader.parse(source)
end
exit (0)

