=begin
/****************************************************************
**
** Qt tutorial 7
**
****************************************************************/
=end

require "qte"
include Qte
require "qpe"
include Qpe

require "lcdrange.rb"


class MyWidget < QVBox

def initialize ( parent=nil, name="" )
    super(parent, name )

    quit = QPushButton.new( "Quit", self, "quit" )
    quit.setFont( QFont.new( "Times", 18, QFont::Bold ) )

    connect( quit, QSIGNAL("clicked()"), QPEApplication::qApp, "quit()" )

    grid = QGrid.new( 4, self )
    previous = nil
    for r in 0..3 #( int r = 0  r < 4  r++ )
	for c in 0..3 #( int c = 0  c < 4  c++ )
	    lr = LCDRange.new( grid )
	    if ( !previous.nil? )
		connect(lr.valueChanged, previous, "setValue" )
                 end
	    previous = lr
	end
    end
end

end

    a = QPEApplication.new( [$0]+ARGV )

    w = MyWidget.new
    a.showMainWidget( w )
    a.exec()

