#!/usr/bin/env ruby

require 'fileutils'

DESTDIR='/opt/QtPalmtop'
WORKDIR='temp'

def mk_control(version)
  FileUtils::mkdir_p(File::join(WORKDIR, 'CONTROL'))
  control = Hash.new
  File::open(File::join(WORKDIR, 'CONTROL/control'), 'w') do | outf |
    File::open('control.in') do | inf |
      inf.each do | l |
	l.chomp!
	l.gsub!(/%%VERSION%%/, version)
	s = l.split(/: /)
	control[s[0]] = s[1]
	outf.print "#{l}\n"
      end
    end
  end

  return control['Package'] + '_' + control['Version'] + '_' + 
    control['Architecture'] + '.ipk'
end

def mk_data
  Dir::glob('../packages/*/InstalledFiles').each do | installed |
    File::open(installed) do |fp|
      fp.each do | src |
	src.chomp!
	src.gsub!(%r|/./|, '/')
	
	m = /#{DESTDIR}/.match(src)
	dest = File::join(WORKDIR, m[0] + m.post_match)
	
	dir = %r|^.*/|.match(dest)[0]
	
	if %r|/CVS/| !~ src then
	  FileUtils::mkdir_p(dir)
	  FileUtils::cp(src, dest)
	end
      end
    end
  end
end

if File::directory?(WORKDIR)
  FileUtils::rm_r(WORKDIR)
end

mk_data
ipkname = mk_control(ARGV[0])

system('ipkg-build', WORKDIR)
