class QGArray {
// Qt Internal class
};

class QArrayVALUE :public QGArray {
public:
	 //QArray ();
	 %extend {
			 QArrayVALUE (VALUE varg0=Qnil) {
					if(varg0 == Qnil) {
						 return new QArray<VALUE>;
					} else if(TYPE(varg0) == T_FIXNUM) {
						 int size;
						 size = NUM2INT(varg0);
						 QArray<VALUE>* ary;
						 ary = new QArray<VALUE>;
						 ary->resize(size);
						 return ary;
					} else {
						 rb_raise(rb_eArgError,"Error in QArry constructor");
					}
			 }
		}
	 //QArray ( int size ) ;
	 //QArray ( const QArray<type> & a );
	 ~QArrayVALUE () ;
	 //QArray<type>& operator= ( const QArray<type> & a );
	 VALUE* data () const;
	 uint nrefs () const ;
	 uint size () const ;
	 uint count() const;
	 bool isEmpty () const ;
	 bool isNull () const ;
	 bool resize ( uint size ) ;
	 bool truncate ( uint pos ) ;
	 bool fill ( const VALUE & v, int size = -1 ) ;
	 virtual void detach () ;
	 QArrayVALUE copy () const ;
	 //QArray<type>& assign ( const QArray<type> & a ) ;
	 QArrayVALUE & assign ( const VALUE * data, uint size ) ;
	 //QArray<type> & duplicate ( const QArray<type> & a ) ;
	 QArrayVALUE& duplicate ( const VALUE * data, uint size );
	 QArrayVALUE& setRawData ( const VALUE * data, uint size );
	 void resetRawData ( const VALUE * data, uint size ) ;
	 int find ( const VALUE & v, uint index=0 ) const ;
	 int contains ( const VALUE & v ) const ;
	 void sort ();
	 int bsearch ( const VALUE & v ) const;
	 //type& operator[] ( int index ) const;
	//VLUE & operator[] (int index) const;
	 //%rename(__getitem__) operator[](int);
	 %extend{
	   VALUE & set (int index, VALUE & data) const {
	     return (*self)[index] = data;
	     }
	   VALUE & __getitem__(int index) {
	     return (*self)[index];
	     }
	   VALUE & __setitem__(int index, VALUE & value) {
	     return (*self)[index] = value;
	     }
	 }
	 VALUE & at ( uint index ) const ;
};

//class QArray : public QGArray {
class QArrayChar : public QGArray {
public:
   //QArray ();
   %extend {
       QArrayChar (VALUE varg0=Qnil) {
          if(varg0 == Qnil) {
             return new QArray<char>;
          } else if(TYPE(varg0) == T_FIXNUM) {
             int size;
             size = NUM2INT(varg0);
             QArray<char>* ary;
             ary = new QArray<char>;
             ary->resize(size);
             return ary;
          } else {
             rb_raise(rb_eArgError,"Error in QCharArry constructor");
          }
       }
    }
   //QArray ( int size ) ;
   //QArray ( const QArray<type> & a );
   ~QArrayChar () ;
   //QArray<type>& operator= ( const QArray<type> & a );
   char* data () const;
   uint nrefs () const ;
   uint size () const ;
   uint count() const;
   bool isEmpty () const ;
   bool isNull () const ;
   bool resize ( uint size ) ;
   bool truncate ( uint pos ) ;
   bool fill ( const char & v, int size = -1 ) ;
   virtual void detach () ;
   //QArray<type> copy () const ;
   //QArray<type>& assign ( const QArray<type> & a ) ;
   //QArray<type>& assign ( const type * data, uint size ) ;
   //QArray<type>& duplicate ( const QArray<type> & a ) ;
   //QArray<type>& duplicate ( const type * data, uint size );
   //QArray<type>& setRawData ( const type * data, uint size );
   void resetRawData ( const char * data, uint size ) ;
   int find ( const char & v, uint index=0 ) const ;
   int contains ( const char & v ) const ;
   void sort (); 
   int bsearch ( const char & v ) const;
   //type& operator[] ( int index ) const
   //char & operator[] (int index) const;
   //%rename(__getitem__) operator[](int);
   %extend{
	   char & set (int index, char & data) const {
	     return (*self)[index] = data;
	     }
	char & __getitem__(int index) {
	  return (*self)[index];
	}
	 char & __setitem__(int index, char & value) {
	   return (*self)[index] = value;
	      }
	    }
   char & at ( uint index ) const ;
};

class QByteArray : public QArrayChar {
public:
   //QByteArray();
   %extend {
       QByteArray (VALUE varg0=Qnil) {
          if(varg0 == Qnil) {
             return new QByteArray();
          } else if(TYPE(varg0) == T_FIXNUM) {
             int size;
             size = NUM2INT(varg0);
             return new QByteArray(size);
          } else {
             rb_raise(rb_eArgError,"Error in QByteArray constructor");
          }
       }
    }

   virtual ~QByteArray();
   //QByteArray(int size);
   char* data () const ;
   uint nrefs () const ;
   uint size () const ;
   bool isEmpty () const ;
   bool isNull () const ;
   bool resize ( uint size ) ;
   bool truncate ( uint pos ) ;
   bool fill ( const char & d, int size=-1 );
   virtual void detach ();
   QByteArray copy () const ;
   QByteArray& assign ( const QByteArray & a ) ;
   //QByteArray& assign ( const char * a, uint n ) ;
   QByteArray& duplicate ( const QByteArray & a ) ;
   //QByteArray& duplicate ( const char * a, uint n ) ;
   QByteArray& setRawData ( const char * a, uint n );
   void resetRawData ( const char * a, uint n );
   int find ( const char & d, uint i=zero_uint ) const ;
   int contains ( const char & d ) const;
   void sort () ;
   int bsearch ( const char & d ) const;
   //char & operator[](int index) const;
   //%rename(__getitem__) operator[](int);
   %extend {
	   char & set (int index, char & data) const {
	     return (*self)[index] = data;
	     }
	     char & __getitem__(int index) {
	       return (*self)[index];
	     }
	     char & __setitem__(int index, char & value) {
	   return (*self)[index] = value;
	     }
	 }

   char& at ( uint i ) const ;
   %extend {
      const char * toChar() const {
         return (const char *)(*self);
      }
   }
   
};

class QBitArray : public QByteArray {
public:
   //QBitArray();
   //QBitArray(uint size);
   %extend {
       QBitArray (VALUE varg0=Qnil) {
          if(varg0 == Qnil) {
             return new QBitArray();
          } else if(TYPE(varg0) == T_FIXNUM) {
             int size;
             size = NUM2INT(varg0);
             return new QBitArray(size);
          } else {
             rb_raise(rb_eArgError,"Error in QBitArray constructor");
          }
       }
    }
   
   virtual ~QBitArray();
   uint size () const ;
   bool resize ( uint size ) ;
   bool fill ( bool v, int size = -1 ) ;
   virtual void detach () ;
   QBitArray copy () const ;
   bool testBit ( uint index ) const ;
//   void setBit ( uint index ) ;
   void setBit ( uint index, bool value );
   void clearBit ( uint index );
   bool toggleBit ( uint index ) ;
   %extend{
	   bool set (int index, bool data) const {
	     self->setBit(index, data);
             return data;
	     }
	 }
   bool at ( uint index ) const ;
};

class QPointArray  : public QArrayVALUE {
//: public QArray {
public:
  // QPointArray(size);
   //QPointArray () ;
   %extend {
       QPointArray (VALUE varg0=Qnil) {
          if(varg0 == Qnil) {
             return new QPointArray();
          } else if(TYPE(varg0) == T_FIXNUM) {
             int size;
             size = NUM2INT(varg0);
             return new QPointArray(size);
          } else {
             rb_raise(rb_eArgError,"Error in QPointArray constructor");
          }
       }
    }

    virtual ~QPointArray();
//   QPointArray( int size ) : QArray<QPoint>( size ) {}
//   QPointArray( const QPointArray &a ) : QArray<QPoint>( a ) {}
//   QPointArray( const QRect &r, bool closed=FALSE );
//   QPointArray( int nPoints, const QCOORD *points );

//   QPointArray  &operator=( const QPointArray &a )
//        { return (QPointArray&)assign( a ); }

//   QPointArray copy() const
//        { QPointArray tmp; return *((QPointArray*)&tmp.duplicate(*this)); }

    void    translate( int dx, int dy );
    QRect   boundingRect() const;

//    void    point( uint i, int *OUTPUT=0, int *OUTPUT=0 ) const;
    //RENAME %name(pointQPoint) QPoint  point( uint i ) const;
    %extend {
       VALUE point(uint i,VALUE varg0=Qnil,VALUE varg1=Qnil) {
          if(varg0 == Qnil) {
             QPoint* result;
             VALUE vresult;
             result = new QPoint(self->point(i));
             CHECK_PTR(result);
             vresult = Wrap_QPoint(cQPoint,result);
             return vresult;
          } else {
             int rx,ry;
             self->point(i,&rx,&ry);
             VALUE vresult;
             output_helper(vresult,INT2NUM(rx));
             output_helper(vresult,INT2NUM(ry));
             return vresult;
          }
       }
    }
    
//    void    setPoint( uint i, int x, int y );
    //RENAME %name(setPointQPoint) void    setPoint( uint i, const QPoint &p );
    %extend {
       void setPoint(VALUE varg0,VALUE varg1,VALUE varg2=Qnil) {
          if(varg2 == Qnil) {
             uint ui;
             QPoint *qp;
             ui = NUM2UINT(varg0);
             qp = (QPoint *)Get_QPoint(varg1);
             self->setPoint(ui,*qp);
          } else {
             uint ui;
             int x,y;
             ui = NUM2UINT(varg0);
             x = NUM2INT(varg1);
             y = NUM2INT(varg2);
             self->setPoint(ui,x,y);
          }
       }
    }
    bool    setPoints( int nPoints, const QCOORD *points );
//    bool    setPoints( int nPoints, int firstx, int firsty, ... );
    bool    putPoints( int index, int nPoints, const QCOORD *points );
//    bool    putPoints( int index, int nPoints, int firstx, int firsty, ... );

    void    makeArc( int x, int y, int w, int h, int a1, int a2 );
    void    makeEllipse( int x, int y, int w, int h );
    //RENAME %name(makeArcQWMatrix) void    makeArc( int x, int y, int w, int h, int a1, int a2,
    //RENAME                     const QWMatrix& );
#if 0
    %extend {
       void makeArc(VALUE vx,VALUE vy,VALUE vw,VALUE vh,VALUE va1,VALUE va2,VALUE vqwm=Qnil) {
           int x,y,w,h,a1,a2;
              x = NUM2INT(vx);
              y = NUM2INT(vy);
              w = NUM2INT(vw);
              h = NUM2INT(vh);
              a1 = NUM2INT(va1);
              a2 = NUM2INT(va2);           
           if(vqwm == Qnil) {
              self->makeArc(x,y,w,h,a1,a2);
           } else {
              QWMatrix* qwm;
              qwm = (QWMatrix *)Get_QWMatrix(vqwm);
              self->makeArc(x,y,w,h,a1,a2,*qwm);
           }
        }
     }
#endif                 
    QPointArray quadBezier() const;

    void*  shortPoints( int index = 0, int nPoints = -1 ) const;
    static void cleanBuffers();
    //QPoint & operator[](int) const;
    //%rename(__getitem__) operator[](int);
    %extend{
	   QPoint& set (int index, QPoint & data) const {
	     return (*self)[index] = data;
	     }
	     QPoint & __getitem__(int index) {
	       return (*self)[index];
	   }
	     QPoint & __setitem__(int index, QPoint & value) {
	   return (*self)[index] = value;
	     }
	 }
   QPoint & at ( uint index ) const ;
// Methods from QArray
   uint size () const; 
   bool isEmpty () const; 
   bool isNull () const ;
   bool resize ( uint size );  
};
