/****************************************************************************
** $Id: qcursor.i,v 1.1.1.1 2002/12/22 14:20:01 taka-hr Exp $
**
** Definition of QCursor class
**
** Created : 940219
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

#ifndef QCURSOR_H
#define QCURSOR_H

#ifndef QT_H
#include "qpoint.h"
#include "qshared.h"
#include "qnamespace.h"
#endif // QT_H


struct QCursorData;				// internal cursor data


class QCursor				// cursor class
{
public:
%extend {
	 QCursor(VALUE arg1=Qnil, VALUE arg2 = Qnil, VALUE arg3 = Qnil, VALUE arg4 = Qnil)
	 {
		int carg3,carg4;

		if (arg3 == Qnil)
				carg3 = -1;
		else
				carg3 = FIX2INT(arg3);
		if (arg4 == Qnil)
				carg4 = -1;
		else
				carg4 = FIX2INT(arg4);
		if (arg1 == Qnil) {
				return new QCursor();

		} else if (TYPE(arg1) == T_FIXNUM) {
				return new QCursor(FIX2INT(arg1));
		} else if (rb_obj_is_kind_of(arg1,cQBitmap) || TYPE(arg1) == T_NIL) {
				QBitmap* bm1;
				QBitmap* bm2;
				bm1 = (QBitmap*)Get_QBitmap(arg1);
				bm2 = (QBitmap*)Get_QBitmap(arg2);
				return new QCursor(*bm1,*bm2,carg3,carg4);
		} else if (rb_obj_is_kind_of(arg1,cQPixmap) || TYPE(arg1) == T_NIL) {
				QPixmap* pix1;
				int x = -1;
				int y = -1;
				pix1 = (QPixmap*)Get_QPixmap(arg1);
				if(arg2 != Qnil) x = NUM2INT(arg2);
				if(arg3 != Qnil) y = NUM2INT(arg3);
				return new QCursor(*pix1,x,y);
		} else {
				rb_raise(rb_eArgError, "Type Error in QCursor constructor.");
		}
	 }
}

//    QCursor();					// create default arrow cursor
//    QCursor( int shape );
//    QCursor( const QBitmap &bitmap, const QBitmap &mask,
//	     int hotX=-1, int hotY=-1 );
//    QCursor( const QPixmap &pixmap,
//	     int hotX=-1, int hotY=-1 );
//    QCursor( const QCursor & );
	 ~QCursor();
//    QCursor &operator=( const QCursor & );

		int		  shape()   const;
		void	  setShape( int );

		const QBitmap *bitmap() const;
		const QBitmap *mask()   const;
		QPoint	  hotSpot() const;

#if defined(_WS_WIN_)
//    HCURSOR	  handle()  const;
#elif defined(_WS_X11_)
//    HANDLE	  handle()  const;
#elif defined(_WS_MAC_)
//    void * handle() const;
#endif

		static QPoint pos();
//    static void	  setPos( int x, int y );
		//RENAME %name(setPosQPoint) static void	  setPos( const QPoint & );
		%extend {
			 static void setPos(VALUE varg0,VALUE varg1=Qnil) {
					if(varg1 == Qnil) {
						 QPoint* qp;
						 qp = (QPoint*)Get_QPoint(varg0);
						 QCursor::setPos(*qp);
					} else {
						 int x,y;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 QCursor::setPos(x,y);
					}
			 }
		}

%name(initialize_Qt)		static void	  initialize();
		static void	  cleanup();
/*
private:
		void	  setBitmap( const QBitmap &bitmap, const QBitmap &mask,
				 int hotX, int hotY );
		void	  update() const;
		QCursorData	 *data;
		QCursor	 *find_cur(int);
*/
};



/*****************************************************************************
	Cursor shape identifiers (correspond to global cursor objects)
 *****************************************************************************/

// ############ Should be moved to QNamespace in 3.0!!!!!!
enum QCursorShape {
		ArrowCursor, UpArrowCursor, CrossCursor, WaitCursor, IbeamCursor,
		SizeVerCursor, SizeHorCursor, SizeBDiagCursor, SizeFDiagCursor,
		SizeAllCursor, BlankCursor, SplitVCursor, SplitHCursor, PointingHandCursor,
		ForbiddenCursor, LastCursor = ForbiddenCursor, BitmapCursor=24 };


/*****************************************************************************
	QCursor stream functions
 *****************************************************************************/

//Q_EXPORT QDataStream &operator<<( QDataStream &, const QCursor & );
//Q_EXPORT QDataStream &operator>>( QDataStream &, QCursor & );


#endif // QCURSOR_H
