/****************************************************************************
** $Id: qglobal.i,v 1.1.1.1 2002/12/22 14:20:03 taka-hr Exp $
**
** Global type declarations and definitions
**
** Created : 920529
**
** Copyright (C) 1992-2001 Trolltech AS.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
//#ifndef QGLOBAL_H
//#define QGLOBAL_H


#define QT_VERSION	231
#define QT_VERSION_STR	"2.3.1"


//
// The operating system, must be one of: (_OS_x_)
//
//   MAC	- Macintosh
//   MSDOS	- MS-DOS and Windows
//   OS2	- OS/2
//   OS2EMX	- XFree86 on OS/2 (not PM)
//   WIN32	- Win32 (Windows 95/98 and Windows NT)
//   SUN	- SunOS
//   SOLARIS	- Sun Solaris
//   HPUX	- HP-UX
//   ULTRIX	- DEC Ultrix
//   LINUX	- Linux
//   FREEBSD	- FreeBSD
//   NETBSD	- NetBSD
//   OPENBSD    - OpenBSD
//   IRIX	- SGI Irix
//   OSF	- OSF Unix
//   BSDI	- BSDI Unix
//   SCO	- SCO of some sort
//   AIX	- AIX Unix
//   UNIXWARE	- SCO UnixWare
//   GNU	- GNU Hurd
//   DGUX	- DG Unix
//   DYNIX	- Dynix
//   UNIX	- Any UNIX bsd/sysv system
//

#if defined(macintosh)
#define _OS_MAC_
#elif defined(MSDOS) || defined(_MSDOS) || defined(__MSDOS__)
#define _OS_MSDOS_
#elif defined(OS2) || defined(_OS2) || defined(__OS2__)
#if defined(__EMX__)
#define _OS_OS2EMX_
#else
#define _OS_OS2_
#endif
#elif defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
#define _OS_WIN32_
#elif defined(__MWERKS__) && defined(__INTEL__)
#define _OS_WIN32_
#elif defined(sun) || defined(__sun) || defined(__sun__)
#if defined(__SVR4)
#define _OS_SOLARIS_
#else
#define _OS_SUN_
#endif
#elif defined(hpux) || defined(__hpux) || defined(__hpux__)
#define _OS_HPUX_
#elif defined(ultrix) || defined(__ultrix) || defined(__ultrix__)
#define _OS_ULTRIX_
#elif defined(sinix)
#define _OS_RELIANT_
#elif defined(linux) || defined(__linux) || defined(__linux__)
#define _OS_LINUX_
#elif defined(__FreeBSD__)
#define _OS_FREEBSD_
#elif defined(__NetBSD__)
#define _OS_NETBSD_
#elif defined(__OpenBSD__)
#define _OS_OPENBSD_
#elif defined(sgi) || defined(__sgi)
#define _OS_IRIX_
#elif defined(__osf__)
#define _OS_OSF_
#elif defined(bsdi) || defined(__bsdi__)
#define _OS_BSDI_
#elif defined(_AIX)
#define _OS_AIX_
#elif defined(__Lynx__)
#define _OS_LYNXOS_
#elif defined(_UNIXWARE)
#define _OS_UNIXWARE_
#elif defined(__GNU__)
#define _OS_GNU_
#elif defined(DGUX)
#define _OS_DGUX_
#elif defined(__QNX__)
#define _OS_QNX_
#elif defined(_SCO_DS) || defined(M_UNIX) || defined(M_XENIX)
#define _OS_SCO_
#elif defined(sco) || defined(_UNIXWARE7)
#define _OS_UNIXWARE7_
#elif !defined(_SCO_DS) && defined(__USLC__) && defined(__SCO_VERSION__)
#define _OS_UNIXWARE7_
#elif defined(_SEQUENT_)
#define _OS_DYNIX_
#else
#error "Qt has not been ported to this OS - talk to qt-bugs@trolltech.com"
#endif

#if defined(_OS_MAC_) || defined(_OS_MSDOS_) || defined(_OS_OS2_) || defined(_OS_WIN32_)
#undef	_OS_UNIX_
#elif !defined(_OS_UNIX_)
#define _OS_UNIX_
// QT_CLEAN_NAMESPACE is not defined by default; it would break too
// much code.
#if !defined(QT_CLEAN_NAMESPACE) && !defined(UNIX)
// ### remove 3.0
#define UNIX
#endif
#endif


//
// The window system, must be one of: (_WS_x_)
//
//   QWS	- Qt/Embedded
//   WIN32	- Windows
//   X11	- X Window System
//   MAC	- unsupported
//   PM		- unsupported
//   WIN16	- unsupported
//

#if defined(_OS_MAC_)
#define _WS_MAC_
#define Q_WS_MAC
#elif defined(_OS_MSDOS_)
#define _WS_WIN16_
#error "Qt requires Win32 and does not work with Windows 3.x"
#elif defined(_WIN32_X11_)
#define _WS_X11_
#define Q_WS_X11
#elif defined(_OS_WIN32_)
#define _WS_WIN32_
#define Q_WS_WIN32
#elif defined(_OS_OS2_)
#error "Qt does not work with OS/2 Presentation Manager or Workplace Shell"
#elif defined(_OS_UNIX_)
#ifdef QWS
#define _WS_QWS_
#define Q_WS_QWS
#else
#define _WS_X11_
#define Q_WS_X11
#endif
#endif

#if defined(_WS_WIN16_) || defined(_WS_WIN32_)
#define _WS_WIN_
#define Q_WS_WIN
#endif



typedef unsigned char	uchar;
typedef unsigned short	ushort;
typedef unsigned	uint;
typedef unsigned long	ulong;
typedef char	       *pchar;
typedef uchar	       *puchar;
typedef const char     *pcchar;


//
// Constant bool values
//

//#ifndef TRUE
//const bool FALSE = 0;
//const bool TRUE = !0;
//#endif


//
// Utility macros and inline functions
//

#define QMAX(a,b)	((a) > (b) ? (a) : (b))
#define QMIN(a,b)	((a) < (b) ? (a) : (b))
#define QABS(a)		((a) >= 0  ? (a) : -(a))
#if !defined(QT_CLEAN_NAMESPACE)
typedef signed char	INT8;			// 8 bit signed
typedef unsigned char	UINT8;			// 8 bit unsigned
typedef short		INT16;			// 16 bit signed
typedef unsigned short	UINT16;			// 16 bit unsigned
typedef int		INT32;			// 32 bit signed
typedef unsigned int	UINT32;			// 32 bit unsigned
#endif

typedef signed char	Q_INT8;			// 8 bit signed
typedef unsigned char	Q_UINT8;		// 8 bit unsigned
typedef short		Q_INT16;		// 16 bit signed
typedef unsigned short	Q_UINT16;		// 16 bit unsigned
typedef int		Q_INT32;		// 32 bit signed
typedef unsigned int	Q_UINT32;		// 32 bit unsigned


//
// Data stream functions is provided by many classes (defined in qdatastream.h)
//

class QDataStream;


//
// System information
//

 const char *qVersion();
 //bool qSysInfo( int *wordSize, bool *bigEndian );
   bool qSysInfo( int *OUTPUT, bool *OUTPUT );


//
// Debugging and error handling
//

#if !defined(NO_CHECK)
#define CHECK_STATE				// check state of objects etc.
#define CHECK_RANGE				// check range of indexes etc.
#define CHECK_NULL				// check null pointers
#define CHECK_MATH				// check math functions
#endif

//#if !defined(NO_DEBUG) && !defined(DEBUG)
//#define DEBUG					// display debug messages
//#endif

//
// Avoid some particularly useless warnings from some stupid compilers.
// To get ALL C++ compiler warnings, define CC_WARNINGS or comment out
// the line "#define NO_WARNINGS"
//
/*
#if !defined(CC_WARNINGS)
#define NO_WARNINGS
#endif
#if defined(NO_WARNINGS)
#if defined(_CC_MSVC_)
#pragma warning(disable: 4244)
#pragma warning(disable: 4275)
#pragma warning(disable: 4514)
#pragma warning(disable: 4800)
#elif defined(_CC_BOR_)
#pragma option -w-inl
#pragma option -w-aus
#pragma warn -inl
#pragma warn -pia
#pragma warn -ccc
#pragma warn -rch
#pragma warn -sig
#elif defined(_CC_MWERKS_)
#pragma warn_possunwant off
#endif
#endif // NO_WARNINGS
*/
//
// Avoid dead code
//

//#if defined(_CC_EDG_) || defined(_CC_WAT_)
//#define Q_NO_DEAD_CODE
//#endif


enum QtMsgType { QtDebugMsg, QtWarningMsg, QtFatalMsg };

typedef void (*msg_handler)(QtMsgType, const char *);


//void qDebug( const char *, ... )       // print debug message
