/****************************************************************************
** $Id: qlayout.i,v 1.1.1.1 2002/12/22 14:20:06 taka-hr Exp $
**
** Definition of layout classes
**
** Created : 960416
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QLAYOUT_H
//#define QLAYOUT_H

//#ifndef QT_H
//#include "qabstractlayout.h"
//#endif // QT_H

class QLayoutArray;
class QLayoutBox;

//#if 0
//Q_OBJECT
//#endif

class QGridLayout : public QLayout
{
//    Q_OBJECT
public:
%extend {
		QGridLayout( VALUE vparent, VALUE varg1 =Qnil, VALUE varg2 =Qnil,
								 VALUE varg3 =Qnil, VALUE varg4 =Qnil, VALUE varg5 =Qnil) {
				QWidget* wparent = 0;
				QLayout* lparent = 0;
				int nRows = 1;
				int nCols = 1;
				int border = 0;
				int space = -1;
				char* name = 0;
				
				if(rb_obj_is_kind_of(vparent,cQWidget)  || TYPE(vparent) == T_NIL) {
					 wparent = (QWidget *)Get_QWidget(vparent);
					 if(varg1 !=Qnil) nRows = NUM2INT(varg1);
					 if(varg2 !=Qnil) nCols = NUM2INT(varg2);
					 if(varg3 !=Qnil) border = NUM2INT(varg3);
					 if(varg4 !=Qnil) space = NUM2INT(varg4);
					 if(varg5 !=Qnil) name = STR2CSTR(varg5);
					 return new QGridLayout(wparent,nRows,nCols,border,space,name);
				} else if(rb_obj_is_kind_of(vparent,cQLayout)  || TYPE(vparent) == T_NIL) {
					 lparent = (QLayout *)Get_QLayout(vparent);
					 if(varg1 !=Qnil) nRows = NUM2INT(varg1);
					 if(varg2 !=Qnil) nCols = NUM2INT(varg2);
					 if(varg3 !=Qnil) space = NUM2INT(varg3);
					 if(varg4 !=Qnil) name = STR2CSTR(varg4);
					 return new QGridLayout(lparent,nRows,nCols,space,name);
					 
				} else if(vparent == Qnil) {
					 wparent = 0;
					 if(varg1 !=Qnil) nRows = NUM2INT(varg1);
					 if(varg2 !=Qnil) nCols = NUM2INT(varg2);
					 if(varg3 !=Qnil) border = NUM2INT(varg3);
					 if(varg4 !=Qnil) space = NUM2INT(varg4);
					 if(varg5 !=Qnil) name = STR2CSTR(varg5);
					 return new QGridLayout(wparent,nRows,nCols,border,space,name);

			 } else {
					 rb_raise(rb_eArgError, "Type error in QGridLayout constructor");
				}
		 }
} 
//    QGridLayout( QWidget *parent, int nRows = 1, int nCols = 1, int border=0,
//		 int space = -1, const char *name=0 );
//    QGridLayout( int nRows = 1, int nCols = 1, int space = -1,
//		 const char *name=0 );
//    QGridLayout( QLayout *parentLayout, int nRows = 1, int nCols = 1,
//		 int space = -1, const char *name=0 );
		//~QGridLayout();

		QSize sizeHint() const;
		QSize minimumSize() const;
		QSize maximumSize() const;

		virtual void setRowStretch( int row, int stretch );
		virtual void setColStretch( int col, int stretch );
		int rowStretch( int row ) const;
		int colStretch( int col ) const;

		int numRows() const;
		int numCols() const;
		QRect cellGeometry( int row, int col ) const;

		bool hasHeightForWidth() const;
		int heightForWidth( int ) const;


		QSizePolicy::ExpandData expanding() const;
		void invalidate();

//    void addItem( QLayoutItem * );
		//RENAME %name(addItemRowCol) void addItem( QLayoutItem *item, int row=0, int col=0 );
		%extend {
			 void addItem(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					QLayoutItem* qli;
					qli = (QLayoutItem *)Get_QLayoutItem(varg0);
					if(varg1 == Qnil) {
						 self->addItem(qli);
					} else {
						 int row,col;
						 row = NUM2INT(varg1);
						 col = NUM2INT(varg2);
						 self->addItem(qli,row,col);
					}
			 }
		}   
					

		void addMultiCell( QLayoutItem *, int fromRow, int toRow,
			       int fromCol, int toCol, int align = 0 );
		//void setAlignment( QWidget* );

		void addWidget( QWidget *, int row, int col, int align = 0 );
		void addMultiCellWidget( QWidget *, int fromRow, int toRow,
			       int fromCol, int toCol, int align = 0 );
		void addLayout( QLayout *layout, int row, int col);
		void addMultiCellLayout( QLayout *layout, int fromRow, int toRow,
														 int fromCol, int toCol, int align = 0 );

		void addRowSpacing( int row, int minsize );
		void addColSpacing( int col, int minsize );
		void expand( int rows, int cols );

		enum Corner { TopLeft, TopRight, BottomLeft, BottomRight };
		
		void setOrigin( QGridLayout::Corner cor);
		
		QLayoutIterator iterator();
		void setGeometry( const QRect& );


/*
protected:
		bool findWidget( QWidget* w, int *r, int *c );
		void add( QLayoutItem*, int row, int col );
private:
		void init( int rows, int cols );
		QLayoutArray *array;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QGridLayout( const QGridLayout & );
		QGridLayout &operator=( const QGridLayout & );
#endif
*/
};


class QBoxLayoutData;

class QBoxLayout : public QLayout
{
//    Q_OBJECT
public:
		enum Direction { LeftToRight, RightToLeft, TopToBottom, BottomToTop,
		     Down = TopToBottom, Up = BottomToTop };
%extend {
		QBoxLayout( VALUE vparent, VALUE varg1, VALUE varg2 =Qnil,
								 VALUE varg3 =Qnil, VALUE varg4 =Qnil) {
				QWidget* wparent = 0;
				QLayout* lparent = 0;
				QBoxLayout::Direction direction;
				int border = 0;
				int space = -1;
				char* name = 0;
				
				if(rb_obj_is_kind_of(vparent,cQWidget) || TYPE(vparent) == T_NIL ) {
					 wparent = (QWidget *)Get_QWidget(vparent);
					 if(TYPE(varg1) != T_FIXNUM) rb_raise(rb_eArgError, "Type error in QBoxLayout constructor");
					 direction = (QBoxLayout::Direction)NUM2INT(varg1);
					 if(varg2 !=Qnil) border = NUM2INT(varg2);
					 if(varg3 !=Qnil) space = NUM2INT(varg3);
					 if(varg4 !=Qnil) name = STR2CSTR(varg4);
					 return new QBoxLayout(wparent,direction,border,space,name);
				} else if(rb_obj_is_kind_of(vparent,cQLayout)  || TYPE(vparent) == T_NIL) {
					 lparent = (QLayout *)Get_QLayout(vparent);
					 if(TYPE(varg1) != T_FIXNUM) rb_raise(rb_eArgError, "Type error in QBoxLayout constructor");
					 direction = (QBoxLayout::Direction)NUM2INT(varg1);
					 if(varg2 !=Qnil) space = NUM2INT(varg2);
					 if(varg3 !=Qnil) name = STR2CSTR(varg3);
					 return new QBoxLayout(lparent,direction,space,name);
					 
				} else {
					 rb_raise(rb_eArgError, "Type error in QBoxLayout constructor");
				}
		 }
} 

//    QBoxLayout( QWidget *parent, Direction, int border=0,
//		int space = -1, const char *name=0 );

//    QBoxLayout( QLayout *parentLayout, Direction, int space = -1,
//		const char *name=0 );

//    QBoxLayout(	Direction, int space = -1,
//		const char *name=0 );

		//~QBoxLayout();

		void addItem( QLayoutItem * );

		Direction direction() const { return dir; }
		void setDirection( QBoxLayout::Direction direction);

		void addSpacing( int size );
		void addStretch( int stretch = 0 );
		void addWidget( QWidget *, int stretch = 0, int alignment = 0 );
		void addLayout( QLayout *layout, int stretch = 0 );
		void addStrut( int );

		void insertSpacing( int index, int size );
		void insertStretch( int index, int stretch = 0 );
		void insertWidget( int index, QWidget *widget, int stretch = 0,
		       int alignment = 0 );
		void insertLayout( int index, QLayout *layout, int stretch = 0 );


//    bool setStretchFactor( QWidget*, int stretch );
		//RENAME %name(setStretchFactorQLayout) bool setStretchFactor( QLayout *l, int stretch );
		%extend {
			 bool setStretchFactor(VALUE varg0,VALUE varg1) {
					int stretch;
					stretch = NUM2INT(varg1);
					if(rb_obj_is_kind_of(varg0,cQWidget)) {
						 QWidget* wd;
						 wd = (QWidget *)Get_QWidget(varg0);
						 return self->setStretchFactor(wd,stretch);
					} else if(rb_obj_is_kind_of(varg0,cQLayout)) {
						 QLayout* ql;
						 ql = (QLayout *)Get_QLayout(varg0);
						 return self->setStretchFactor(ql,stretch);
					} else {
						 rb_raise(rb_eArgError,"Error in setStretchFactor() argments");
					}
			 }
		}

		QSize sizeHint() const;
		QSize minimumSize() const;
		QSize maximumSize() const;

		bool hasHeightForWidth() const;
		int heightForWidth( int ) const;

		QSizePolicy::ExpandData expanding() const;
		void invalidate();
		QLayoutIterator iterator();
		void setGeometry( const QRect& );

		int findWidget( QWidget* w );
/*
protected:
		void insertItem( int index, QLayoutItem * );

private:
		void setupGeom();
		int calcHfw( int );
		QBoxLayoutData *data;
		Direction dir;
private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QBoxLayout( const QBoxLayout & );
		QBoxLayout &operator=( const QBoxLayout & );
#endif
*/
};


class QHBoxLayout : public QBoxLayout
{
//    Q_OBJECT
public:
//const char* name () const; //dummy for swig
%extend {
		QHBoxLayout( VALUE vparent =Qnil, VALUE varg1 =Qnil, VALUE varg2 =Qnil,
								 VALUE varg3 =Qnil) {
				QWidget* wparent = 0;
				QLayout* lparent = 0;
				int border = 0;
				int space = -1;
				char* name = 0;
				if(vparent ==Qnil) {
					 return new QHBoxLayout();
				} 
				if(rb_obj_is_kind_of(vparent,cQWidget) || TYPE(vparent) == T_NIL ) {
					 wparent = (QWidget *)Get_QWidget(vparent);
					 if(varg1 !=Qnil) border = NUM2INT(varg1);
					 if(varg2 !=Qnil) space = NUM2INT(varg2);
					 if(varg3 !=Qnil) name = STR2CSTR(varg3);
					 return new QHBoxLayout(wparent,border,space,name);
				} else if(rb_obj_is_kind_of(vparent,cQLayout)  || TYPE(vparent) == T_NIL) {
					 lparent = (QLayout *)Get_QLayout(vparent);
					 if(varg1 !=Qnil) space = NUM2INT(varg1);
					 if(varg2 !=Qnil) name = STR2CSTR(varg2);
					 return new QHBoxLayout(lparent,space,name);
					 
				} else if (TYPE(vparent) == T_FIXNUM) {
					 space = NUM2INT(vparent);
					 if(varg1 !=Qnil) name = STR2CSTR(varg1);
					 return new QHBoxLayout(space,name);

				} else {
					 rb_raise(rb_eArgError, "Type error in QHBoxLayout constructor");
				}
		 }
} 

//    QHBoxLayout( QWidget *parent, int border=0,
//		int space = -1, const char *name=0 );
//    QHBoxLayout( QLayout *parentLayout,
//		 int space = -1, const char *name=0 );
//    QHBoxLayout( int space = -1, const char *name=0 );

		//~QHBoxLayout();

};



class QVBoxLayout : public QBoxLayout
{
//    Q_OBJECT
public:
//const char* name () const; // dummy for swig
%extend {
		QVBoxLayout( VALUE vparent =Qnil, VALUE varg1 =Qnil, VALUE varg2 =Qnil,
								 VALUE varg3 =Qnil) {
				QWidget* wparent = 0;
				QLayout* lparent = 0;
				int border = 0;
				int space = -1;
				char* name = 0;
				if(vparent ==Qnil) {
					 return new QVBoxLayout();
				} 
				if(rb_obj_is_kind_of(vparent,cQWidget)  || TYPE(vparent) == T_NIL) {
					 wparent = (QWidget *)Get_QWidget(vparent);
					 if(varg1 !=Qnil) border = NUM2INT(varg1);
					 if(varg2 !=Qnil) space = NUM2INT(varg2);
					 if(varg3 !=Qnil) name = STR2CSTR(varg3);
					 return new QVBoxLayout(wparent,border,space,name);
				} else if(rb_obj_is_kind_of(vparent,cQLayout)  || TYPE(vparent) == T_NIL) {
					 lparent = (QLayout *)Get_QLayout(vparent);
					 if(varg1 !=Qnil) space = NUM2INT(varg1);
					 if(varg2 !=Qnil) name = STR2CSTR(varg2);
					 return new QVBoxLayout(lparent,space,name);

				} else if (TYPE(vparent) == T_FIXNUM) {
					 space = NUM2INT(vparent);
					 if(varg1 !=Qnil) name = STR2CSTR(varg1);
					 return new QVBoxLayout(space,name);

				} else {
					 rb_raise(rb_eArgError, "Type error in QVBoxLayout constructor");
				}
		 }
} 


//    QVBoxLayout( QWidget *parent, int border=0,
//		int space = -1, const char *name=0 );
//    QVBoxLayout( QLayout *parentLayout,
//		 int space = -1, const char *name=0 );
//    QVBoxLayout( int space = -1, const char *name=0 );

		//~QVBoxLayout();

};




//#endif // QLAYOUT_H
